/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.commons.rest.util.ResourceCollection;
import com.sas.svcs.admin.backup.rest.RBUtils;
import com.sas.svcs.admin.backup.rest.ServiceAccessControlUtil;
import com.sas.svcs.admin.backup.rest.model.BackupErrorData;
import com.sas.svcs.admin.backup.rest.model.BackupErrorDetailsData;
import com.sas.svcs.admin.backup.rest.model.BackupRecoveryHistoryData;
import com.sas.svcs.admin.backup.rest.model.BackupResultData;
import com.sas.svcs.admin.backup.rest.model.OperationHistoryData;
import com.sas.svcs.admin.backup.rest.model.OperationStatusData;
import com.sas.svcs.admin.backup.rest.model.RecoveryDetailData;
import com.sas.svcs.admin.backup.rest.model.RecoveryHistoryData;
import com.sas.svcs.admin.backup.rest.model.RecoveryOptionsMapper;
import com.sas.svcs.backup.client.BackupDetails;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.OperationDetails;
import com.sas.svcs.backup.client.RecoveryDetails;
import com.sas.svcs.backup.client.RecoveryOptions;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorEntry;
import com.sas.svcs.backup.common.definitions.BackupErrorLogger;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.text.Message;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;

@Controller
public class RecoveryController {
    private BackupService backupService;
    @Autowired
    @Qualifier(value="BackupErrorXmlLogger")
    BackupErrorLogger backupErrorXmlLogger;
    @Autowired
    RBUtils rbUtils;
    @Autowired
    ServiceAccessControlUtil accessControlUtil;

    @Autowired
    public void setBackupService(@Qualifier(value="BackupService") BackupService backupService) {
        this.backupService = backupService;
    }

    @RequestMapping(value={"/rest/restores"}, method={RequestMethod.POST}, produces={"application/vnd.sas.admin.restore+json", "application/vnd.sas.admin.restore+xml"}, consumes={"application/vnd.sas.admin.restore.request+json", "application/vnd.sas.admin.restore.request+xml"})
    public ResponseEntity<?> recover(@RequestBody RecoveryOptionsMapper options, @RequestParam String backupId) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        RecoveryOptions opts = options.getRecoveryOptions();
        String name = opts.getRecvoerySlugName();
        BackupServiceResult backupServiceResult = null;
        RecoveryDetails rcvryDetails = null;
        BackupServiceResult recoveryResult = null;
        BackupDetails bkdetails = null;
        try {
            BackupServiceResult rcvryResult = null;
            if (name != null && !name.equals("")) {
                rcvryResult = this.backupService.getRecoveryBySlugName(name);
                if (rcvryResult != null && rcvryResult.getActualResult() != null) {
                    return new ResponseEntity((Object)new BackupErrorData(409, this.rbUtils.getPropertyValueFromRB("RecoveryController.existing.slugname.for.recovery.txt"), "RecoveryController.existing.slugname.for.recovery.txt", this.rbUtils.getPropertyValueFromRB("RecoveryController.provide.nonexisting.recovery.name.txt"), "RecoveryController.provide.nonexisting.recovery.name.txt"), (MultiValueMap)responseHeaders, HttpStatus.CONFLICT);
                }
                if (this.validateOperationName(name)) {
                    opts.setRecvoerySlugName(name);
                } else {
                    return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.operation.name.invalid.txt"), "BackupController.operation.name.invalid.txt", this.rbUtils.getPropertyValueFromRB("BackupController.check.the.valid.operation.name.format.txt"), "BackupController.check.the.valid.operation.name.format.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
                }
            }
            if (backupId == null) {
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("RecoveryController.backupid.missing.txt"), "RecoveryController.backupid.missing.txt", this.rbUtils.getPropertyValueFromRB("RecoveryController.check.the.valid.backupid.txt"), "RecoveryController.check.the.valid.operation.backupid.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
            }
            backupServiceResult = this.backupService.getBackupByName(backupId);
            BackupDetails backupDetails = bkdetails = backupServiceResult == null ? null : (BackupDetails)backupServiceResult.getActualResult();
            if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (bkdetails == null) {
                return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("RecoveryController.no.backup.found.txt"), "RecoveryController.no.backup.found.txt", this.rbUtils.getPropertyValueFromRB("RecoveryController.submit.valid.backup.name.txt"), "RecoveryController.submit.valid.backup.name.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
            }
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                errorEntry.setOperationType("recover");
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("RecoveryController.internal.server.error.fmt"), (Object)e.getMessage()), "RecoveryController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("RecoveryController.find.detail.cause.in.logs.txt"), "RecoveryController.find.detail.cause.in.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (opts == null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("RecoveryController.invalid.recovery.options.txt"), "RecoveryController.invalid.recovery.options.txt", this.rbUtils.getPropertyValueFromRB("RecoveryController.recheck.recovery.options.txt"), "RecoveryController.recheck.recovery.options.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        try {
            recoveryResult = this.backupService.recover(bkdetails, opts);
            rcvryDetails = recoveryResult == null ? null : (RecoveryDetails)recoveryResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("RecoveryController.internal.server.error.fmt"), (Object)e.getMessage()), "RecoveryController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("RecoveryController.find.detail.cause.in.logs.txt"), "RecoveryController.find.detail.cause.in.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity(new BackupResultData(recoveryResult, new RecoveryDetailData((OperationDetails)rcvryDetails)), (MultiValueMap)responseHeaders, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/rest/restores/jobs/{id}"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.restore.job+json", "application/vnd.sas.admin.restore.job+xml", "application/vnd.sas.admin.restore+json", "application/vnd.sas.admin.restore+xml"})
    public ResponseEntity<?> getStatusById(@PathVariable(value="id") String id) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getRestoresStatus(id, "Name");
    }

    @RequestMapping(value={"/rest/restores/jobs"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.restore.job+json", "application/vnd.sas.admin.restore.job+xml", "application/vnd.sas.admin.restore+json", "application/vnd.sas.admin.restore+xml"})
    public ResponseEntity<?> getStatusByName(@RequestParam(value="name") String name) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getRestoresStatus(name, "Slug");
    }

    private ResponseEntity<?> getRestoresStatus(String restoreId, String identifier) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        OperationDetails.OperationStatus status = null;
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getStatus(restoreId, "Recovery", identifier);
            status = backupServiceResult == null ? null : (OperationDetails.OperationStatus)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (status == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.no.operation.found.txt"), "BackupController.no.operation.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.please.check.operation.details.txt"), "BackupController.please.check.operation.details.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        OperationStatusData statusData = new OperationStatusData(restoreId, status);
        Links links = new Links();
        Link link = null;
        if (identifier.equals("Slug")) {
            link = new Link("get", "self", "/restores?name=" + restoreId);
            link.setType("application/vnd.sas.admin.restore");
        } else {
            link = new Link("get", "self", "/restores/" + restoreId);
            link.setType("application/vnd.sas.admin.restore");
        }
        links.add(link);
        statusData.setLinks(links.getLinks());
        if (status != OperationDetails.OperationStatus.INPROGRESS) {
            responseHeaders.add("accept", "vnd.sas.admin.restore+json");
            responseHeaders.add("location", links.get(0).getHref());
            return new ResponseEntity((Object)statusData, (MultiValueMap)responseHeaders, HttpStatus.SEE_OTHER);
        }
        responseHeaders.add("Content-Location", "/restores/jobs/" + restoreId);
        return new ResponseEntity((Object)statusData, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/restores"}, method={RequestMethod.GET}, produces={"application/vnd.sas.collection+xml", "application/vnd.sas.collection+json"})
    public ResponseEntity<?> getAllRestores(@RequestParam(value="start", required=false) Integer start, @RequestParam(value="limit", required=false) Integer limit) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        responseHeaders.add("Cache-Control", "no-cache, no-store");
        List his = null;
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getAllHistory();
            his = backupServiceResult == null ? null : (List)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getCause()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (his == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.history.file.not.found.txt"), "BackupController.history.file.not.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.history.file.not.found.check.backup.ws.dir.txt"), "BackupController.history.file.not.found.check.backup.ws.dir.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        if (start == null) {
            start = 1;
            if (limit == null) {
                limit = his.size();
            }
        } else if (limit == null) {
            limit = 10;
        }
        if (limit > his.size()) {
            limit = his.size();
        }
        LinkedList<OperationDetails> recoveryHistory = new LinkedList<OperationDetails>();
        for (int i = 0; i < his.size(); ++i) {
            OperationDetails detail = (OperationDetails)his.get(i);
            if (!detail.getType().equals("Recovery".toString())) continue;
            recoveryHistory.add(detail);
        }
        if (start < 1 || recoveryHistory.size() > 0 && start > recoveryHistory.size()) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.history.invalid.start.index.txt"), "BackupController.history.invalid.start.index.txt", this.rbUtils.getPropertyValueFromRB("BackupController.history.please.check.invalid.start.index.txt"), "BackupController.history.please.check.invalid.start.index.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        if (recoveryHistory.size() > 0 && limit < 1) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupController.history.invalid.limit.txt"), "BackupController.history.invalid.limit.txt", this.rbUtils.getPropertyValueFromRB("BackupController.history.please.check.invalid.limit.value.txt"), "BackupController.history.please.check.invalid.limit.value.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        LinkedList<OperationHistoryData> history = null;
        history = new LinkedList<OperationHistoryData>();
        int cnt = 0;
        for (int i = start.intValue(); cnt < limit && i <= recoveryHistory.size(); ++i) {
            OperationDetails detail = (OperationDetails)recoveryHistory.get(i - 1);
            if (!detail.getType().equals("Recovery".toString())) continue;
            history.add(new RecoveryHistoryData(detail));
            ++cnt;
        }
        BackupRecoveryHistoryData bckrcvHistoryData = new BackupRecoveryHistoryData(history);
        Links links = null;
        if (recoveryHistory.size() > 0) {
            if (limit > recoveryHistory.size()) {
                limit = recoveryHistory.size();
            }
            links = this.getPaginationLinks(start, limit, "/restores", recoveryHistory.size() + 1);
        } else {
            links = new Links();
            links.setLinks(new ArrayList());
        }
        Link restoreLink = new Link(HttpMethod.POST.name(), "start restore", "/restores");
        restoreLink.setType("application/vnd.sas.admin.backup.request");
        links.add(restoreLink);
        bckrcvHistoryData.setLinks(links.getLinks());
        ResourceCollection coll = new ResourceCollection(history, Long.valueOf(start.intValue()), limit, Long.valueOf(history.size()), links, "application/vnd.sas.admin.restore+json", "RecoveryHistory");
        return new ResponseEntity((Object)coll, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/restores/{id}"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.restore+json", "application/vnd.sas.admin.restore+xml"})
    public ResponseEntity<?> getDetailsById(@PathVariable(value="id") String id) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getBackupDetails(id, "Name");
    }

    @RequestMapping(value={"/rest/restores"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.restore+json", "application/vnd.sas.admin.restore+xml"})
    public ResponseEntity<?> getDetails(@RequestParam(value="name") String name) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        return this.getBackupDetails(name, "Slug");
    }

    private ResponseEntity<?> getBackupDetails(String restoreId, String identifier) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        OperationDetails backupRecoveryDetails = null;
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getDetails(restoreId, "Recovery", identifier);
            backupRecoveryDetails = backupServiceResult == null ? null : (OperationDetails)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (backupRecoveryDetails == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupController.no.operation.found.txt"), "BackupController.no.operation.found.txt", this.rbUtils.getPropertyValueFromRB("BackupController.please.check.operation.details.txt"), "BackupController.please.check.operation.details.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        return new ResponseEntity((Object)new RecoveryDetailData(backupRecoveryDetails), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private Links getPaginationLinks(int start, int limit, String uri, int collectionSize) {
        int firstStart;
        int prevStart;
        Links links = new Links();
        Link link = null;
        int nextStart = start + limit;
        int templimit = 10;
        if (nextStart < collectionSize) {
            templimit = nextStart + limit < collectionSize ? limit : collectionSize - nextStart;
            String nextUri = uri + "?start=" + nextStart + "&limit=" + templimit;
            link = new Link("get", "next", nextUri);
            link.setType("application/vnd.sas.collection");
            links.add(link);
        }
        if ((prevStart = start - limit) >= 1) {
            templimit = prevStart + limit < collectionSize ? limit : collectionSize - prevStart;
            String prevUri = uri + "?start=" + prevStart + "&limit=" + templimit;
            link = new Link("get", "prev", prevUri);
            link.setType("application/vnd.sas.collection");
            links.add(link);
        }
        templimit = (firstStart = 1) + limit <= collectionSize ? limit : collectionSize - firstStart;
        String firstUri = uri + "?start=1&limit=" + templimit;
        link = new Link("get", "first", firstUri);
        link.setType("application/vnd.sas.collection");
        links.add(link);
        int lasstStart = collectionSize - limit;
        templimit = lasstStart + limit <= collectionSize ? limit : collectionSize - lasstStart;
        String lastUri = uri + "?start=" + lasstStart + "&limit=" + templimit;
        link = new Link("get", "last", lastUri);
        link.setType("application/vnd.sas.collection");
        links.add(link);
        return links;
    }

    private boolean validateOperationName(String name) {
        SimpleDateFormat df = new SimpleDateFormat("yyyy-MM-dd'T'HH_mm_ssZ");
        boolean isValidOperationName = !name.contains(":");
        try {
            df.parse(name);
            isValidOperationName = false;
        }
        catch (ParseException e) {
            isValidOperationName = true;
        }
        return isValidOperationName;
    }
}

