/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.admin.backup.rest;

import com.sas.commons.rest.links.Link;
import com.sas.commons.rest.links.Links;
import com.sas.commons.rest.util.ResourceCollection;
import com.sas.svcs.admin.backup.rest.BackupSourceValidator;
import com.sas.svcs.admin.backup.rest.RBUtils;
import com.sas.svcs.admin.backup.rest.RestServiceBeanConverter;
import com.sas.svcs.admin.backup.rest.ServiceAccessControlUtil;
import com.sas.svcs.admin.backup.rest.ValidatorFactory;
import com.sas.svcs.admin.backup.rest.model.BackupErrorData;
import com.sas.svcs.admin.backup.rest.model.BackupErrorDetailsData;
import com.sas.svcs.admin.backup.rest.model.ConfigurableServerProxyData;
import com.sas.svcs.admin.backup.rest.model.ConfigurableServerProxyLinksData;
import com.sas.svcs.admin.backup.rest.model.CustomDirsSourceConfig;
import com.sas.svcs.admin.backup.rest.model.Directory;
import com.sas.svcs.admin.backup.rest.model.HostSpecificCustomDirList;
import com.sas.svcs.admin.backup.rest.model.SASTierData;
import com.sas.svcs.admin.backup.rest.model.SASTiersData;
import com.sas.svcs.admin.backup.rest.model.UserBackupConfigData;
import com.sas.svcs.admin.backup.rest.model.UserSourceConfigData;
import com.sas.svcs.backup.client.BackupConfiguration;
import com.sas.svcs.backup.client.BackupService;
import com.sas.svcs.backup.client.BackupServiceResult;
import com.sas.svcs.backup.client.BackupSourceConfig;
import com.sas.svcs.backup.client.ConfigurableServerProxy;
import com.sas.svcs.backup.client.DirectoryDetails;
import com.sas.svcs.backup.client.SASTierProxy;
import com.sas.svcs.backup.client.SASTiers;
import com.sas.svcs.backup.client.UserBackupConfiguration;
import com.sas.svcs.backup.client.UserSourceConfiguration;
import com.sas.svcs.backup.common.definitions.BackupErrorDetails;
import com.sas.svcs.backup.common.definitions.BackupErrorEntry;
import com.sas.svcs.backup.common.definitions.BackupErrorLogger;
import com.sas.svcs.backup.common.definitions.BackupException;
import com.sas.svcs.backup.dao.ConfigBeanConverter;
import com.sas.text.Message;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.validator.EmailValidator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Controller;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
public class BackupConfigController {
    private static final Logger logger = LogManager.getLogger(BackupConfigController.class);
    private BackupService backupService;
    @Autowired
    @Qualifier(value="RestServiceBeanConverter")
    RestServiceBeanConverter converter;
    @Autowired
    private ValidatorFactory factory;
    @Autowired
    private ConfigBeanConverter configBeanConverter;
    @Autowired
    @Qualifier(value="BackupErrorXmlLogger")
    private BackupErrorLogger backupErrorXmlLogger;
    @Autowired
    RBUtils rbUtils;
    @Autowired
    ServiceAccessControlUtil accessControlUtil;

    @Autowired
    public void setBackupService(@Qualifier(value="BackupService") BackupService backupService) {
        this.backupService = backupService;
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}"}, method={RequestMethod.PUT}, produces={"application/vnd.sas.admin.backup.configuration+json", "application/vnd.sas.admin.backup.configuration+xml"}, consumes={"application/vnd.sas.admin.backup.configuration+json", "application/vnd.sas.admin.backup.configuration+xml"})
    public ResponseEntity<?> setUserConfig(@RequestBody UserBackupConfigData configuration, @PathVariable String configurationid) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        BackupConfiguration updatedConfig = null;
        try {
            BackupConfiguration existingConfig;
            BackupServiceResult getConfigResult = this.backupService.getBackupConfiguration();
            if (getConfigResult != null && getConfigResult.getErrorDetails() != null) {
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(getConfigResult.getErrorDetails());
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            BackupConfiguration backupConfiguration = existingConfig = getConfigResult == null ? null : (BackupConfiguration)getConfigResult.getActualResult();
            if (configuration != null) {
                UserBackupConfiguration bkConfig;
                BackupConfiguration backupConfiguration2;
                BackupServiceResult setConfigResult;
                if (configuration.getEmailToList() == null) {
                    configuration.setEmailToList(existingConfig.getEmailToList());
                } else if (!this.isValid(configuration.getEmailToList())) {
                    return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.email.txt"), "BackupConfigController.invalid.email.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.email.txt"), "BackupConfigController.check.for.valid.email.txt"), HttpStatus.BAD_REQUEST);
                }
                if (configuration.getDaysToRetainBackup() < 0) {
                    return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.daysToRetainbkup.txt"), "BackupConfigController.invalid.daysToRetainbkup.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.daysToRetainbkup.txt"), "BackupConfigController.check.for.valid.daysToRetainbkup.txt"), HttpStatus.BAD_REQUEST);
                }
                if (configuration.getDaysToRetainBackup() == 0) {
                    configuration.setDaysToRetainBackup(existingConfig.getDaysToRetainBackups());
                }
                if (configuration.getVaultLocation() == null) {
                    configuration.setVaultLocation(existingConfig.getVaultLocation());
                }
                if (configuration.scheduledBackupsAllowed == null) {
                    configuration.setScheduledBackupsAllowed(existingConfig.isScheduledBackupsAllowed());
                }
                BackupConfiguration backupConfiguration3 = updatedConfig = (setConfigResult = this.backupService.setBackupConfiguration(backupConfiguration2 = this.configBeanConverter.userConfigToBackupConfig(bkConfig = this.converter.getServiceObjectUserBackupConfig(configuration)))) == null ? null : (BackupConfiguration)setConfigResult.getActualResult();
                if (setConfigResult != null && setConfigResult.getErrorDetails() != null) {
                    BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(setConfigResult.getErrorDetails());
                    return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
                }
                if (updatedConfig == null) {
                    return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.backup.configuration.not.found.txt"), "BackupConfigController.backup.configuration.not.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
                }
            }
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        UserBackupConfiguration updatedRestConfiguration = this.configBeanConverter.BackupConfigTouserConfig(updatedConfig);
        configuration = this.converter.getRestObjectUserBackupConfig(updatedRestConfiguration, configurationid);
        Links links = new Links();
        Link link = new Link(HttpMethod.GET.name(), "self", "/configurations/" + configurationid);
        link.setType("application/vnd.sas.admin.backup.configuration");
        links.add(link);
        if (!links.getLinks().isEmpty()) {
            configuration.setLinks(links.getLinks());
        }
        return new ResponseEntity((Object)configuration, (MultiValueMap)responseHeaders, HttpStatus.NO_CONTENT);
    }

    private boolean isValid(String[] emails) {
        boolean result = true;
        for (String email : emails) {
            if (email.equals("")) continue;
            EmailValidator emailValidator = EmailValidator.getInstance();
            result = emailValidator.isValid(email);
        }
        return result;
    }

    @RequestMapping(value={"/rest/configurations"}, method={RequestMethod.GET}, produces={"application/vnd.sas.collection+json", "application/vnd.sas.collection+xml"})
    @ResponseBody
    public ResponseEntity<?> getAllConfiguratons(@RequestParam(value="start", required=false) Integer start, @RequestParam(value="limit", required=false) Integer limit) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        responseHeaders.add("Cache-Control", "no-cache, no-store");
        UserBackupConfigData defaultConfig = null;
        if (this.getUserConfig("default").getBody() instanceof UserBackupConfigData) {
            defaultConfig = (UserBackupConfigData)this.getUserConfig("default").getBody();
        }
        ArrayList<UserBackupConfigData> configurations = new ArrayList<UserBackupConfigData>();
        if (defaultConfig != null) {
            configurations.add(defaultConfig);
        }
        if (start == null) {
            start = 1;
            if (limit == null) {
                limit = configurations.size();
            }
        } else if (limit == null) {
            limit = 10;
        }
        Links links = null;
        if (configurations.size() > 0) {
            if (limit > configurations.size()) {
                limit = configurations.size();
            }
            links = this.getPaginationLinks(start, limit, "/configurations", configurations.size() + 1);
        }
        ResourceCollection coll = new ResourceCollection(configurations, Long.valueOf(start.intValue()), limit, Long.valueOf(configurations.size()), links, "application/vnd.sas.admin.backup.configuration", "Configurations");
        return new ResponseEntity((Object)coll, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup.configuration+json", "application/vnd.sas.admin.backup.configuration+xml"})
    @ResponseBody
    public ResponseEntity<?> getUserConfig(@PathVariable String configurationid) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        ArrayList lstSrcConfig = new ArrayList();
        List tiersList = null;
        UserBackupConfiguration bkConfig = null;
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getUserConfiguration();
            bkConfig = backupServiceResult == null ? null : (UserBackupConfiguration)backupServiceResult.getActualResult();
            BackupServiceResult tiersResult = this.backupService.getSASTiers();
            if (tiersResult != null) {
                tiersList = tiersResult.getActualResult() == null ? null : ((SASTiers)tiersResult.getActualResult()).getSasTiers();
            }
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (bkConfig == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.backup.configuration.not.found.txt"), "BackupConfigController.backup.configuration.not.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        if (tiersList == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.tier.not.found.txt"), "BackupConfigController.tier.not.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.not.found.txt"), "BackupConfigController.check.not.found.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        UserBackupConfigData configuration = this.converter.getRestObjectUserBackupConfig(bkConfig, configurationid);
        SASTiersData tiersData = new SASTiersData();
        List<SASTierData> tiersDataList = this.converter.getRestTierConfigObject(tiersList, configurationid);
        tiersData.setSasTiers(tiersDataList);
        configuration.setTierConfiguration(tiersData);
        Links links = new Links();
        Link link = new Link(HttpMethod.GET.name(), "self", "/configurations/" + configurationid);
        link.setType("application/vnd.sas.admin.backup.configuration");
        links.add(link);
        link = new Link(HttpMethod.PUT.name(), "update", "/configurations/" + configurationid);
        link.setType("application/vnd.sas.admin.backup.configuration");
        links.add(link);
        link = new Link(HttpMethod.GET.name(), "get sastier", "/configurations/" + configurationid + "/configdirectories/" + BackupSourceConfig.BackupSource.SASTIER.getDisplayName());
        link.setType("application/vnd.sas.admin.backup.configuration.sastiers");
        links.add(link);
        link = new Link(HttpMethod.POST.name(), "start backup", "/backups/jobs");
        link.setType("application/vnd.sas.admin.backup.job");
        links.add(link);
        if (!links.getLinks().isEmpty()) {
            configuration.setLinks(links.getLinks());
        }
        return new ResponseEntity((Object)configuration, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}/{sourcetype}/{id:.+}"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup.configuration.configdirectories+json", "application/vnd.sas.admin.backup.configuration.configdirectories+xml", "application/vnd.sas.admin.backup.configuration.metadataserver+json", "application/vnd.sas.admin.backup.configuration.metadataserver+xml", "application/vnd.sas.admin.backup.configuration.contentserver+json", "application/vnd.sas.admin.backup.configuration.contentserver+xml", "application/vnd.sas.admin.backup.configuration.database+json", "application/vnd.sas.admin.backup.configuration.database+xml", "application/vnd.sas.admin.backup.configuration.customdirectories+json", "application/vnd.sas.admin.backup.configuration.customdirectories+xml"})
    public ResponseEntity<?> getUserConfigurableServer(@PathVariable String configurationid, @RequestParam(value="start", required=false) Integer start, @RequestParam(value="limit", required=false) Integer limit, @PathVariable String id, @PathVariable String sourcetype) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (sourcetype != null) {
            BackupSourceConfig.BackupSource[] sourceValues;
            boolean found = false;
            for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
                if (!source.getDisplayName().equalsIgnoreCase(sourcetype.toUpperCase())) continue;
                found = true;
                sourcetype = source.name();
            }
            if (!found) {
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
            }
        } else {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (BackupSourceConfig.BackupSource.valueOf((String)sourcetype) == null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        ConfigurableServerProxy configurableServerProxy = null;
        BackupServiceResult backupServiceResult = null;
        UserSourceConfiguration userConfigProxy = null;
        try {
            backupServiceResult = this.backupService.getUserSoureceConfiguration(BackupSourceConfig.BackupSource.valueOf((String)sourcetype));
            UserSourceConfiguration userSourceConfiguration = userConfigProxy = backupServiceResult == null ? null : (UserSourceConfiguration)backupServiceResult.getActualResult();
            if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (userConfigProxy == null) {
                return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.no.source.config.found.txt"), "BackupConfigController.no.source.config.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
            }
            List lstConfigServer = userConfigProxy.getConfigurableServers();
            if (lstConfigServer != null && lstConfigServer.size() > 0) {
                for (ConfigurableServerProxy proxy : lstConfigServer) {
                    if (!proxy.getId().equalsIgnoreCase(id)) continue;
                    configurableServerProxy = proxy;
                }
            }
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (configurableServerProxy == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.no.source.config.found.txt"), "BackupConfigController.no.source.config.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        ConfigurableServerProxyLinksData proxyDataItem = null;
        try {
            proxyDataItem = this.converter.getRestConfigurableServerLinkObject(configurableServerProxy, configurationid, sourcetype, true);
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((Object)proxyDataItem, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}/{sourcetype}/{id:.+}"}, method={RequestMethod.PUT}, consumes={"application/vnd.sas.admin.backup.configuration.configdirectories+json", "application/vnd.sas.admin.backup.configuration.configdirectories+xml", "application/vnd.sas.admin.backup.configuration.metadataserver+json", "application/vnd.sas.admin.backup.configuration.metadataserver+xml", "application/vnd.sas.admin.backup.configuration.contentserver+json", "application/vnd.sas.admin.backup.configuration.contentserver+xml", "application/vnd.sas.admin.backup.configuration.database+json", "application/vnd.sas.admin.backup.configuration.database+xml", "application/vnd.sas.admin.backup.configuration.customdirectories+json", "application/vnd.sas.admin.backup.configuration.customdirectories+xml"})
    public ResponseEntity<?> updateUserConfigurableServer(@RequestBody ConfigurableServerProxyData serverinstances, @PathVariable String configurationid, @PathVariable String id, @PathVariable String sourcetype) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (sourcetype != null) {
            BackupSourceConfig.BackupSource[] sourceValues;
            boolean found = false;
            for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
                if (!source.getDisplayName().equalsIgnoreCase(sourcetype.toUpperCase())) continue;
                found = true;
                sourcetype = source.name();
            }
            if (!found) {
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
            }
        } else {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (BackupSourceConfig.BackupSource.valueOf((String)sourcetype) == null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        serverinstances.setId(id);
        BackupSourceValidator validator = this.factory.getValidator(sourcetype);
        BackupErrorData error = validator.validatePut(serverinstances);
        if (error != null) {
            return new ResponseEntity((Object)error, (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        try {
            BackupServiceResult getbackupServiceResult = this.backupService.getUserSoureceConfiguration(BackupSourceConfig.BackupSource.valueOf((String)sourcetype));
            UserSourceConfiguration userConfigProxy = getbackupServiceResult == null ? null : (UserSourceConfiguration)getbackupServiceResult.getActualResult();
            UserSourceConfiguration updatedConfigProxy = new UserSourceConfiguration();
            List lstServiceProxy = userConfigProxy.getConfigurableServers();
            ArrayList<ConfigurableServerProxy> lstDummyServiceProxy = new ArrayList<ConfigurableServerProxy>(lstServiceProxy.size());
            for (ConfigurableServerProxy serviceProxy : lstServiceProxy) {
                if (serviceProxy.getId().equalsIgnoreCase(serverinstances.getId())) {
                    if (serverinstances.getConfigurablePath() != null && !BackupSourceConfig.BackupSource.valueOf((String)sourcetype).equals((Object)BackupSourceConfig.BackupSource.CONFIGDIR)) {
                        serviceProxy.setConfigurablePath(serverinstances.getConfigurablePath());
                    }
                    if (serverinstances.getSasTierId() != null && !BackupSourceConfig.BackupSource.valueOf((String)sourcetype).equals((Object)BackupSourceConfig.BackupSource.CONFIGDIR)) {
                        serviceProxy.setSasTierId(serverinstances.getSasTierId());
                    }
                    if (serverinstances.getFilter() != null) {
                        serviceProxy.setFilter(this.converter.getServiceObjectFilter(serverinstances.getFilter()));
                    }
                    if (serverinstances.getUseroptions() != null) {
                        serviceProxy.setUseroptions(this.converter.getServiceObjectOptions(serverinstances.getUseroptions()));
                    }
                    if (serverinstances.isIncluded() != null) {
                        serviceProxy.setIncluded(serverinstances.isIncluded());
                    }
                }
                lstDummyServiceProxy.add(serviceProxy);
            }
            updatedConfigProxy.setConfigurableServers(lstDummyServiceProxy);
            BackupServiceResult backupServiceResult = this.backupService.setUserSourceConfiguration(updatedConfigProxy, BackupSourceConfig.BackupSource.valueOf((String)sourcetype));
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getCause()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}/{sourcetype}"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup.configuration.configdirectories+json", "application/vnd.sas.admin.backup.configuration.configdirectories+xml", "application/vnd.sas.admin.backup.configuration.metadataserver+json", "application/vnd.sas.admin.backup.configuration.metadataserver+xml", "application/vnd.sas.admin.backup.configuration.contentserver+json", "application/vnd.sas.admin.backup.configuration.contentserver+xml", "application/vnd.sas.admin.backup.configuration.database+json", "application/vnd.sas.admin.backup.configuration.database+xml", "application/vnd.sas.admin.backup.configuration.customdirectories+json", "application/vnd.sas.admin.backup.configuration.customdirectories+xml"})
    public ResponseEntity<?> getUserSourceConfig(@PathVariable String configurationid, @PathVariable String sourcetype) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        responseHeaders.add("Cache-Control", "no-cache, no-store");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (sourcetype != null) {
            BackupSourceConfig.BackupSource[] sourceValues;
            boolean found = false;
            for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
                if (!source.getDisplayName().equalsIgnoreCase(sourcetype.toUpperCase())) continue;
                found = true;
                sourcetype = source.name();
            }
            if (!found) {
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
            }
        } else {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (BackupSourceConfig.BackupSource.valueOf((String)sourcetype) == null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        BackupServiceResult backupServiceResult = null;
        UserSourceConfiguration userConfigProxy = null;
        try {
            backupServiceResult = this.backupService.displaySoureceConfiguration(BackupSourceConfig.BackupSource.valueOf((String)sourcetype));
            userConfigProxy = backupServiceResult == null ? null : (UserSourceConfiguration)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (userConfigProxy == null) {
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.no.source.config.found.txt"), "BackupConfigController.no.source.config.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        UserSourceConfigData userConfigData = null;
        try {
            userConfigData = this.converter.getRestUserConfigObject(userConfigProxy, configurationid, sourcetype, true);
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((Object)userConfigData, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}/{sourcetype}"}, method={RequestMethod.POST}, consumes={"application/vnd.sas.admin.backup.configuration.metadataserver+json", "application/vnd.sas.admin.backup.configuration.metadataserver+xml", "application/vnd.sas.admin.backup.configuration.contentserver+json", "application/vnd.sas.admin.backup.configuration.contentserver+xml", "application/vnd.sas.admin.backup.configuration.database+json", "application/vnd.sas.admin.backup.configuration.database+xml", "application/vnd.sas.admin.backup.configuration.customdirectories+json", "application/vnd.sas.admin.backup.configuration.customdirectories+xml"})
    public ResponseEntity<?> setUserSourceConfig(@RequestBody ConfigurableServerProxyData serverinstances, @PathVariable String configurationid, @PathVariable String sourcetype) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (serverinstances.getId() != null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.unwanted.id.txt"), "BackupConfigController.unwanted.id.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.unwanted.id.txt"), "BackupConfigController.check.unwanted.id.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        if (sourcetype != null) {
            BackupSourceConfig.BackupSource[] sourceValues;
            boolean found = false;
            for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
                if (!source.getDisplayName().equalsIgnoreCase(sourcetype.toUpperCase())) continue;
                found = true;
                sourcetype = source.name();
            }
            if (!found) {
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
            }
        } else {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (BackupSourceConfig.BackupSource.valueOf((String)sourcetype) == null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        BackupSourceValidator validator = this.factory.getValidator(sourcetype);
        BackupErrorData error = validator.validatePost(serverinstances);
        if (error != null) {
            return new ResponseEntity((Object)error, (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        UserSourceConfigData restdata = null;
        try {
            List lstPresentProxy;
            BackupServiceResult backupServiceResult = this.backupService.getUserSoureceConfiguration(BackupSourceConfig.BackupSource.valueOf((String)sourcetype));
            UserSourceConfiguration userConfigProxy = backupServiceResult == null ? null : (UserSourceConfiguration)backupServiceResult.getActualResult();
            UserSourceConfiguration postConfiguration = new UserSourceConfiguration();
            ArrayList<ConfigurableServerProxy> lstProxy = new ArrayList<ConfigurableServerProxy>();
            if (userConfigProxy != null && (lstPresentProxy = userConfigProxy.getConfigurableServers()) != null && lstPresentProxy.size() > 0) {
                for (ConfigurableServerProxy proxy : lstPresentProxy) {
                    lstProxy.add(proxy);
                }
            }
            ConfigurableServerProxy userConfig = this.converter.getServiceConfigurableServerObject(serverinstances);
            int objectId = 0;
            if (userConfig.getId() == null) {
                objectId = this.converter.getIdForNewServer(userConfigProxy);
            }
            userConfig.setId(String.valueOf(objectId));
            lstProxy.add(userConfig);
            postConfiguration.setConfigurableServers(lstProxy);
            BackupServiceResult postbackupServiceResult = this.backupService.setUserSourceConfiguration(postConfiguration, BackupSourceConfig.BackupSource.valueOf((String)sourcetype));
            restdata = this.converter.getRestUserConfigObject(postConfiguration, configurationid, sourcetype, true);
        }
        catch (BackupException e) {
            return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((Object)restdata, (MultiValueMap)responseHeaders, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}/sastiers/{tierid}"}, method={RequestMethod.PUT}, produces={"application/vnd.sas.admin.backup.configuration.sastiers+json", "application/vnd.sas.admin.backup.configuration.sastiers+xml"}, consumes={"application/vnd.sas.admin.backup.configuration.sastiers+json", "application/vnd.sas.admin.backup.configuration.sastiers+xml"})
    public ResponseEntity<?> updateSASTier(@RequestBody SASTierData tierData, @PathVariable String configurationid, @PathVariable String tierid) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        try {
            SASTiers sasTier;
            BackupServiceResult tiersResult = this.backupService.getSASTiers();
            SASTiers sASTiers = sasTier = tiersResult != null ? (SASTiers)tiersResult.getActualResult() : null;
            if (sasTier == null) {
                return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.no.source.config.found.txt"), "BackupConfigController.no.source.config.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
            }
            List currentTiers = sasTier.getSasTiers();
            SASTiers dummyTier = new SASTiers();
            ArrayList<SASTierProxy> tempTiersList = new ArrayList<SASTierProxy>(currentTiers.size());
            for (SASTierProxy tierproxy : currentTiers) {
                if (tierproxy.getTierName().equalsIgnoreCase(tierid)) {
                    if (tierData.getTierDisplayName() != null && tierData.getTierDisplayName().length() > 0) {
                        tierproxy.setTierDisplayName(tierData.getTierDisplayName());
                    }
                    if (tierData.isIncluded() != null) {
                        tierproxy.setIncluded(tierData.isIncluded());
                    }
                }
                tempTiersList.add(tierproxy);
            }
            if (tempTiersList != null && tempTiersList.size() > 0) {
                dummyTier.setSasTiers(tempTiersList);
            }
            BackupServiceResult backupServiceResult = this.backupService.setSASTiers(dummyTier);
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupController.internal.server.error.fmt"), (Object)e.getCause()), "BackupController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupController.find.detail.cause.in.mid.tier.log.txt"), "BackupController.find.detail.cause.in.mid.tier.log.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.NO_CONTENT);
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}/sastiers/{tierid}"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup.configuration.sastiers+json", "application/vnd.sas.admin.backup.configuration.sastiers+xml"})
    public ResponseEntity<?> getSASTier(@PathVariable String configurationid, @PathVariable String tierid) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        responseHeaders.add("Cache-Control", "no-cache, no-store");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        try {
            SASTierProxy tier;
            BackupServiceResult tiersResult = this.backupService.getSASTier(tierid);
            SASTierProxy sASTierProxy = tier = tiersResult != null ? (SASTierProxy)tiersResult.getActualResult() : null;
            if (tier != null) {
                SASTierData tierData = this.converter.getDataObject(tier);
                Links links = new Links();
                Link link = new Link(HttpMethod.GET.name(), "self", "/configurations/" + configurationid + "/sastiers/" + tier.getTierName());
                link.setType("application/vnd.sas.admin.backup.configuration.sastiers");
                links.add(link);
                link = new Link(HttpMethod.PUT.name(), "update", "/configurations/" + configurationid + "/sastiers/" + tierid);
                link.setType("application/vnd.sas.admin.backup.configuration.sastiers");
                tierData.setLinks(links);
                return new ResponseEntity((Object)tierData, (MultiValueMap)responseHeaders, HttpStatus.OK);
            }
            return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.tier.txt"), "BackupConfigController.invalid.tier.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.invalid.tier.txt"), "BackupConfigController.check.invalid.tier.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}/sastiers"}, method={RequestMethod.GET}, produces={"application/vnd.sas.admin.backup.configuration.sastiers+json", "application/vnd.sas.admin.backup.configuration.sastiers+xml"})
    public ResponseEntity<?> getSASTiers(@PathVariable String configurationid) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        SASTiersData tiersData = null;
        try {
            List tiersList;
            BackupServiceResult tiersResult = this.backupService.getSASTiers();
            List list = tiersList = tiersResult != null ? ((SASTiers)tiersResult.getActualResult()).getSasTiers() : null;
            if (tiersList == null) {
                return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.tier.not.found.txt"), "BackupConfigController.tier.not.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.not.found.txt"), "BackupConfigController.check.not.found.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
            }
            tiersData = new SASTiersData();
            List<SASTierData> tiersDataList = this.converter.getRestTierConfigObject(tiersList, configurationid);
            tiersData.setSasTiers(tiersDataList);
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        return new ResponseEntity((Object)tiersData, (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private ResponseEntity<?> getCustomDirs() {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        Map customDirsMap = null;
        BackupServiceResult backupServiceResult = null;
        try {
            backupServiceResult = this.backupService.getCustomDirs();
            customDirsMap = backupServiceResult == null ? null : (Map)backupServiceResult.getActualResult();
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
        if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
            BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
            return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        if (customDirsMap == null) {
            return new ResponseEntity((Object)new CustomDirsSourceConfig(new ArrayList<HostSpecificCustomDirList>()), (MultiValueMap)responseHeaders, HttpStatus.OK);
        }
        ArrayList<HostSpecificCustomDirList> customDirsList = new ArrayList<HostSpecificCustomDirList>();
        Set hosts = customDirsMap.keySet();
        for (String host : hosts) {
            HostSpecificCustomDirList hostCustomDirs = new HostSpecificCustomDirList(host);
            List dirPaths = (List)customDirsMap.get(host);
            if (dirPaths != null && !dirPaths.isEmpty()) {
                ArrayList<Directory> directories = new ArrayList<Directory>();
                for (DirectoryDetails dirP : dirPaths) {
                    directories.add(new Directory(dirP.getId(), dirP.getDirectoryPath()));
                }
                hostCustomDirs.setDirectories(directories);
            }
            customDirsList.add(hostCustomDirs);
        }
        return new ResponseEntity((Object)new CustomDirsSourceConfig(customDirsList), (MultiValueMap)responseHeaders, HttpStatus.OK);
    }

    private ResponseEntity<?> setCustomDirs(CustomDirsSourceConfig customDirsList) {
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        HashMap customDirsMap = new HashMap();
        Collection<HostSpecificCustomDirList> customDirs = customDirsList.getCustomDirectories();
        try {
            BackupServiceResult result = this.backupService.getCustomDirs();
            Map configuedCustomDirs = (Map)result.getActualResult();
            Set configuredHosts = configuedCustomDirs.keySet();
            for (HostSpecificCustomDirList hostSpecificCustomDirList : customDirs) {
                ArrayList<Directory> tempDirList = new ArrayList<Directory>(hostSpecificCustomDirList.getDirectories());
                if (tempDirList == null || tempDirList.isEmpty()) continue;
                for (Directory dir : tempDirList) {
                    for (String configredHost : configuredHosts) {
                        List dirsForHost = (List)configuedCustomDirs.get(configredHost);
                        for (DirectoryDetails dirDetails : dirsForHost) {
                            if (!dirDetails.getId().equals(dir.getId())) continue;
                            return new ResponseEntity((Object)new BackupErrorData(409, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.duplicate.id.for.customdir.fmt"), (Object)dir.getId()), "BackupConfigController.duplicate.id.for.customdir.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.provide.unique.id.for.customdir.txt"), "BackupConfigController.provide.unique.id.for.customdir.txt"), HttpStatus.CONFLICT);
                        }
                    }
                }
            }
        }
        catch (BackupException e1) {
            e1.printStackTrace();
        }
        for (HostSpecificCustomDirList hostCustomDirs : customDirs) {
            ArrayList<Directory> tempDirList = new ArrayList<Directory>(hostCustomDirs.getDirectories());
            if (tempDirList == null || tempDirList.isEmpty()) continue;
            ArrayList<DirectoryDetails> dirPaths = new ArrayList<DirectoryDetails>();
            for (Directory dir : tempDirList) {
                if (dir.getDirectoryPath() != null && !dir.getDirectoryPath().equals("")) {
                    DirectoryDetails dirDetails = new DirectoryDetails(dir.getId(), dir.getDirectoryPath());
                    dirPaths.add(dirDetails);
                    continue;
                }
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.dirpath.missing.txt"), "BackupConfigController.dirpath.missing.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.epmty.dirpath.txt"), "BackupConfigController.check.for.epmty.dirpath.txt"), HttpStatus.BAD_REQUEST);
            }
            String string = hostCustomDirs.getHostName();
            if (string != null && !string.equals("")) {
                InetAddress address = null;
                try {
                    address = InetAddress.getByName(string);
                    logger.debug("Inet address for " + string + " is " + address);
                }
                catch (UnknownHostException unknownHost) {
                    return new ResponseEntity((Object)new BackupErrorData(400, "Invalid hostname.", "BackupConfigController.hostName.missing.txt", "Please provide a valid hostname in requestbody.", "BackupConfigController.check.for.epmty.hostname.txt"), HttpStatus.BAD_REQUEST);
                }
                customDirsMap.put(string, dirPaths);
                continue;
            }
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.hostName.missing.txt"), "BackupConfigController.hostName.missing.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.epmty.hostname.txt"), "BackupConfigController.check.for.epmty.hostname.txt"), HttpStatus.BAD_REQUEST);
        }
        BackupServiceResult backupServiceResult = null;
        try {
            boolean added;
            backupServiceResult = this.backupService.addCustomDirs(customDirsMap);
            boolean bl = added = backupServiceResult == null ? false : (Boolean)backupServiceResult.getActualResult();
            if (backupServiceResult != null && backupServiceResult.getErrorDetails() != null) {
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(backupServiceResult.getErrorDetails());
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (added) {
                return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.NO_CONTENT);
            }
            return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.NOT_MODIFIED);
        }
        catch (BackupException e) {
            try {
                BackupErrorDetails backupError = new BackupErrorDetails();
                BackupErrorEntry errorEntry = this.backupErrorXmlLogger.getErrorEntry(e);
                backupError.addBackupErrorEntry(errorEntry);
                BackupErrorDetailsData backupErrorDetailsData = new BackupErrorDetailsData(backupError);
                return new ResponseEntity((Object)backupErrorDetailsData, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            catch (Throwable t) {
                return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
        }
    }

    @RequestMapping(value={"/rest/configurations/{configurationid}/{sourcetype}/{id}"}, method={RequestMethod.DELETE})
    public ResponseEntity<?> deleteServerInstance(@PathVariable String configurationid, @PathVariable String sourcetype, @PathVariable(value="id") String id) {
        if (!this.accessControlUtil.isUserAuthorizedForRequest()) {
            return this.accessControlUtil.getBackupErrorForForbiddenAccessForRESTApi();
        }
        HttpHeaders responseHeaders = new HttpHeaders();
        responseHeaders.add("Content-Encoding", "UTF-8");
        if (!configurationid.equalsIgnoreCase("default")) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.configID.txt"), "BackupConfigController.check.for.configID.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.invalid.configID.txt"), "BackupConfigController.invalid.configID.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (sourcetype != null) {
            BackupSourceConfig.BackupSource[] sourceValues;
            boolean found = false;
            for (BackupSourceConfig.BackupSource source : sourceValues = BackupSourceConfig.BackupSource.values()) {
                if (!source.getDisplayName().equalsIgnoreCase(sourcetype.toUpperCase())) continue;
                found = true;
                sourcetype = source.name();
            }
            if (!found) {
                return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
            }
        } else {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        if (BackupSourceConfig.BackupSource.valueOf((String)sourcetype) == null) {
            return new ResponseEntity((Object)new BackupErrorData(400, this.rbUtils.getPropertyValueFromRB("BackupConfigControllerinvalid.sourcetype.txt"), "BackupConfigControllerinvalid.sourcetype.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.BAD_REQUEST);
        }
        BackupSourceValidator validator = this.factory.getValidator(sourcetype);
        BackupErrorData error = validator.validateDelete(id);
        if (error != null) {
            return new ResponseEntity((Object)error, (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
        }
        try {
            UserSourceConfiguration userConfigProxy;
            BackupServiceResult getbackupServiceResult = this.backupService.getUserSoureceConfiguration(BackupSourceConfig.BackupSource.valueOf((String)sourcetype));
            UserSourceConfiguration userSourceConfiguration = userConfigProxy = getbackupServiceResult == null ? null : (UserSourceConfiguration)getbackupServiceResult.getActualResult();
            if (getbackupServiceResult != null && getbackupServiceResult.getErrorDetails() != null) {
                BackupErrorDetailsData errorMapper = new BackupErrorDetailsData(getbackupServiceResult.getErrorDetails());
                return new ResponseEntity((Object)errorMapper, (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
            }
            if (userConfigProxy == null) {
                return new ResponseEntity((Object)new BackupErrorData(404, this.rbUtils.getPropertyValueFromRB("BackupConfigController.no.source.config.found.txt"), "BackupConfigController.no.source.config.found.txt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.check.for.valid.sourcetype.txt"), "BackupConfigController.check.for.valid.sourcetype.txt"), (MultiValueMap)responseHeaders, HttpStatus.NOT_FOUND);
            }
            UserSourceConfiguration deletedConfigProxy = new UserSourceConfiguration();
            ArrayList<ConfigurableServerProxy> lstDummyServiceProxy = null;
            List lstServiceProxy = userConfigProxy.getConfigurableServers();
            lstDummyServiceProxy = new ArrayList<ConfigurableServerProxy>(lstServiceProxy.size());
            for (ConfigurableServerProxy serviceProxy : lstServiceProxy) {
                if (serviceProxy.getId().equalsIgnoreCase(id)) continue;
                lstDummyServiceProxy.add(serviceProxy);
            }
            deletedConfigProxy.setConfigurableServers(lstDummyServiceProxy);
            BackupServiceResult backupServiceResult = this.backupService.setUserSourceConfiguration(deletedConfigProxy, BackupSourceConfig.BackupSource.valueOf((String)sourcetype));
        }
        catch (BackupException e) {
            return new ResponseEntity((Object)new BackupErrorData(500, Message.format((String)this.rbUtils.getPropertyValueFromRB("BackupConfigController.internal.server.error.fmt"), (Object)e.getMessage()), "BackupConfigController.internal.server.error.fmt", this.rbUtils.getPropertyValueFromRB("BackupConfigController.find.detail.cause.in.midtier.logs.txt"), "BackupConfigController.find.detail.cause.in.midtier.logs.txt"), (MultiValueMap)responseHeaders, HttpStatus.INTERNAL_SERVER_ERROR);
        }
        return new ResponseEntity((MultiValueMap)responseHeaders, HttpStatus.NO_CONTENT);
    }

    private Links getPaginationLinks(int start, int limit, String uri, int collectionSize) {
        int firstStart;
        int prevStart;
        Links links = new Links();
        Link link = null;
        int nextStart = start + limit;
        int templimit = 10;
        if (nextStart < collectionSize) {
            templimit = nextStart + limit < collectionSize ? limit : collectionSize - nextStart;
            String nextUri = uri + "?start=" + nextStart + "&limit=" + templimit;
            link = new Link("get", "next", nextUri);
            links.add(link);
        }
        if ((prevStart = start - limit) >= 1) {
            templimit = prevStart + limit < collectionSize ? limit : collectionSize - prevStart;
            String prevUri = uri + "?start=" + prevStart + "&limit=" + templimit;
            link = new Link("get", "prev", prevUri);
            links.add(link);
        }
        templimit = (firstStart = 1) + limit <= collectionSize ? limit : collectionSize - firstStart;
        String firstUri = uri + "?start=1&limit=" + templimit;
        link = new Link("get", "first", firstUri);
        links.add(link);
        int lasstStart = collectionSize - limit;
        templimit = lasstStart + limit <= collectionSize ? limit : collectionSize - lasstStart;
        String lastUri = uri + "?start=" + lasstStart + "&limit=" + templimit;
        link = new Link("get", "last", lastUri);
        links.add(link);
        return links;
    }
}

