/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.JFVariableEvaluatorBean;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;

public class JFVariableEvaluatorDialog
extends JDialog {
    static final String PRODUCT_TITLE = JFResourceBundle.getString("VariableEvaluatorDialog$TITLE");
    boolean m_editable = true;
    JFJob m_jobDef = null;
    boolean m_isOKPressed = false;
    boolean m_isJFAdmin = false;
    private JButton cancelButton;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JFVariableEvaluatorBean jobDefinitionBean;
    private JButton okButton;
    private JButton resetButton;

    public JFVariableEvaluatorDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.okButton);
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.setJFAdmin(this.m_isJFAdmin);
        }
        this.m_editable = true;
        this.setEditable(this.m_editable);
        this.m_jobDef = null;
    }

    public JFJob createNewJob(String string) {
        this.m_editable = true;
        this.setEditable(this.m_editable);
        this.jobDefinitionBean.reset(string);
        this.m_jobDef = null;
        this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Create_variable_evaluator"));
        this.pack();
        this.show();
        return this.m_jobDef;
    }

    public boolean openJob(JFJob jFJob, boolean bl) {
        if (jFJob == null || this.jobDefinitionBean == null) {
            return false;
        }
        this.m_editable = bl;
        this.m_jobDef = jFJob;
        if (bl) {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Edit_variable_evaluator"));
        } else {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("View_variable_evaluator"));
        }
        this.setEditable(bl);
        this.jobDefinitionBean.setJobDefinition(jFJob);
        this.m_isOKPressed = false;
        this.pack();
        this.show();
        if (bl && this.m_isOKPressed) {
            this.copyExtraAttributes(this.m_jobDef, jFJob);
            return !jFJob.equals(this.m_jobDef);
        }
        return false;
    }

    public void reset() {
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.reset();
        }
    }

    void copyExtraAttributes(JFJob jFJob, JFJob jFJob2) {
        if (jFJob == null || jFJob2 == null) {
            return;
        }
        jFJob2.setAttribute("ImplementRefer", jFJob.getAttribute("ImplementRefer"));
        jFJob2.setAttribute("Name", jFJob.getAttribute("Name"));
        jFJob2.setAttribute("ImplementType", jFJob.getAttribute("ImplementType"));
        jFJob2.setAttribute("SearchKey", jFJob.getAttribute("SearchKey"));
        jFJob2.setAttribute("Overridable", jFJob.getAttribute("Overridable"));
        jFJob2.setAttribute("Visible", jFJob.getAttribute("Visible"));
        jFJob2.setAttribute("PositionX", jFJob.getAttribute("PositionX"));
        jFJob2.setAttribute("PositionY", jFJob.getAttribute("PositionY"));
    }

    public void setJFAdmin(boolean bl) {
        this.m_isJFAdmin = bl;
        if (this.jobDefinitionBean != null) {
            this.jobDefinitionBean.setJFAdmin(this.m_isJFAdmin);
        }
    }

    private void setEditable(boolean bl) {
        if (bl) {
            this.jobDefinitionBean.setEditable(true);
            this.cancelButton.setVisible(true);
            this.resetButton.setVisible(true);
        } else {
            this.jobDefinitionBean.setEditable(false);
            this.cancelButton.setVisible(false);
            this.resetButton.setVisible(false);
        }
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.jPanel2 = new JPanel();
        this.jobDefinitionBean = new JFVariableEvaluatorBean();
        this.setTitle(JFResourceBundle.getString("Job_Definition_Window_New_Job_"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFVariableEvaluatorDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createLineBorder(new Color(0, 0, 0)));
        this.okButton.setText(JFResourceBundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableEvaluatorDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.cancelButton.setVerifyInputWhenFocusTarget(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableEvaluatorDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.resetButton.setText(JFResourceBundle.getString("Reset"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFVariableEvaluatorDialog.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.resetButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.jPanel2.add(this.jobDefinitionBean);
        this.getContentPane().add((Component)this.jPanel2, "Center");
        this.pack();
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.jobDefinitionBean.reset();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.m_isOKPressed = true;
        if (this.jobDefinitionBean == null || !this.m_editable) {
            this.setVisible(false);
            return;
        }
        try {
            if (this.m_jobDef != null) {
                this.m_jobDef = (JFJob)this.m_jobDef.clone();
                this.jobDefinitionBean.updateDefinition();
            } else {
                this.m_jobDef = this.jobDefinitionBean.getJobDefinition();
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            JFUtility.showAppException(this, exception);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.m_isOKPressed = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new JFVariableEvaluatorDialog((Frame)new JFrame(), true).show();
    }
}

