/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFUserGroup;
import com.platform.LSFJobFlow.ui.JFJobScriptDefinitionBean;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Color;
import java.awt.Component;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.List;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.border.LineBorder;

public class JFJobScriptDefinitionDialog
extends JDialog {
    static final String PRODUCT_TITLE = JFResourceBundle.getString("JobScriptDefinitionDialog$TITLE");
    boolean m_editable = true;
    boolean m_isJobArray = false;
    JFJob m_jobDef = null;
    JFJobArray m_jobArrayDef = null;
    boolean m_isOKPressed = false;
    boolean m_isJFAdmin = false;
    private List<JFUserGroup> m_lsfUserGroups = null;
    private JFJobScriptDefinitionBean jobScriptDefinitionBean;
    private JPanel jPanel1;
    private JButton okButton;
    private JButton cancelButton;
    private JButton resetButton;

    public JFJobScriptDefinitionDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        if (this.jobScriptDefinitionBean != null) {
            this.jobScriptDefinitionBean.setJFAdmin(this.m_isJFAdmin);
        }
        this.m_editable = true;
        this.setEditable(this.m_editable);
        this.m_isJobArray = false;
        this.m_jobDef = null;
        this.m_jobArrayDef = null;
        this.getRootPane().setDefaultButton(this.okButton);
    }

    public void refresh() {
        if (this.jobScriptDefinitionBean != null) {
            this.jobScriptDefinitionBean.populate();
        }
    }

    public JFJob createNewJob(String string) {
        this.m_isJobArray = false;
        this.m_editable = true;
        this.jobScriptDefinitionBean.setJobArrayFlag(this.m_isJobArray);
        this.jobScriptDefinitionBean.reset(string);
        this.setEditable(true);
        this.m_jobDef = null;
        this.m_jobArrayDef = null;
        this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Create_job"));
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        return this.m_jobDef;
    }

    public JFJobArray createNewJobArray(String string) {
        this.m_isJobArray = true;
        this.m_editable = true;
        this.jobScriptDefinitionBean.setJobArrayFlag(true);
        this.jobScriptDefinitionBean.reset(string);
        this.setEditable(true);
        this.m_jobDef = null;
        this.m_jobArrayDef = null;
        this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Create_job_array"));
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        return this.m_jobArrayDef;
    }

    public boolean openJob(JFJob jFJob, boolean bl) {
        if (jFJob == null || this.jobScriptDefinitionBean == null) {
            return false;
        }
        this.m_editable = bl;
        this.m_isJobArray = false;
        this.m_jobArrayDef = null;
        this.m_jobDef = jFJob;
        if (bl) {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Edit_job"));
        } else {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("View_job"));
        }
        this.setEditable(bl);
        this.jobScriptDefinitionBean.setJobDefinition(jFJob);
        this.m_isOKPressed = false;
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        if (bl && this.m_isOKPressed) {
            this.copyExtraAttributes(this.m_jobDef, jFJob);
            return !jFJob.equals(this.m_jobDef);
        }
        return false;
    }

    public boolean openJobArray(JFJobArray jFJobArray, boolean bl) {
        if (jFJobArray == null || this.jobScriptDefinitionBean == null) {
            return false;
        }
        this.m_editable = bl;
        this.m_isJobArray = true;
        this.m_jobArrayDef = jFJobArray;
        this.m_jobDef = null;
        if (bl) {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("Edit_job_array"));
        } else {
            this.setTitle(PRODUCT_TITLE + " - " + JFResourceBundle.getString("View_job_array"));
        }
        this.setEditable(bl);
        this.jobScriptDefinitionBean.setJobArrayDefinition(jFJobArray);
        this.m_isOKPressed = false;
        if (!JFUtility.isLinux()) {
            this.pack();
        }
        this.show();
        if (bl && this.m_isOKPressed) {
            this.copyExtraAttributes(this.m_jobArrayDef.getJobDefinition(), jFJobArray.getJobDefinition());
            return !jFJobArray.equals(this.m_jobArrayDef);
        }
        return false;
    }

    public void reset() {
        if (this.jobScriptDefinitionBean != null) {
            this.jobScriptDefinitionBean.reset();
        }
    }

    void copyExtraAttributes(JFJob jFJob, JFJob jFJob2) {
        if (jFJob == null || jFJob2 == null) {
            return;
        }
        jFJob2.setAttribute("ImplementRefer", jFJob.getAttribute("ImplementRefer"));
        jFJob2.setAttribute("Name", jFJob.getAttribute("Name"));
        jFJob2.setAttribute("ImplementType", jFJob.getAttribute("ImplementType"));
        jFJob2.setAttribute("SearchKey", jFJob.getAttribute("SearchKey"));
        jFJob2.setAttribute("Overridable", jFJob.getAttribute("Overridable"));
        jFJob2.setAttribute("Visible", jFJob.getAttribute("Visible"));
        jFJob2.setAttribute("PositionX", jFJob.getAttribute("PositionX"));
        jFJob2.setAttribute("PositionY", jFJob.getAttribute("PositionY"));
    }

    public void setJFAdmin(boolean bl) {
        this.m_isJFAdmin = bl;
        if (this.jobScriptDefinitionBean != null) {
            this.jobScriptDefinitionBean.setJFAdmin(this.m_isJFAdmin);
        }
    }

    public void setLSFUserGroups(List<JFUserGroup> list) {
        this.m_lsfUserGroups = list;
        if (this.jobScriptDefinitionBean != null) {
            this.jobScriptDefinitionBean.setLSFUserGroups(this.m_lsfUserGroups);
        }
    }

    public void setMainFlowOwner(String string) {
        this.jobScriptDefinitionBean.setMainFlowOwner(string);
    }

    private void setEditable(boolean bl) {
        if (bl) {
            this.jobScriptDefinitionBean.setEditable(true);
            this.cancelButton.setVisible(true);
            this.resetButton.setVisible(true);
        } else {
            this.jobScriptDefinitionBean.setEditable(false);
            this.cancelButton.setVisible(false);
            this.resetButton.setVisible(false);
        }
        this.getRootPane().setDefaultButton(this.okButton);
    }

    private void initComponents() {
        this.jobScriptDefinitionBean = new JFJobScriptDefinitionBean();
        this.jPanel1 = new JPanel();
        this.okButton = new JButton();
        this.cancelButton = new JButton();
        this.resetButton = new JButton();
        this.setTitle(JFResourceBundle.getString("JobDefinitionDialog$TITLE_NEWJOB"));
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFJobScriptDefinitionDialog.this.closeDialog(windowEvent);
            }
        });
        this.getContentPane().add((Component)this.jobScriptDefinitionBean, "Center");
        this.jPanel1.setBorder(new LineBorder(Color.black));
        this.okButton.setText(JFResourceBundle.getString("OK"));
        this.okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobScriptDefinitionDialog.this.okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.okButton);
        this.cancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.cancelButton.setVerifyInputWhenFocusTarget(false);
        this.cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobScriptDefinitionDialog.this.cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.cancelButton);
        this.resetButton.setText(JFResourceBundle.getString("Reset"));
        this.resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFJobScriptDefinitionDialog.this.resetButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.resetButton);
        this.getContentPane().add((Component)this.jPanel1, "South");
        this.pack();
    }

    private void resetButtonActionPerformed(ActionEvent actionEvent) {
        this.jobScriptDefinitionBean.reset();
    }

    private void okButtonActionPerformed(ActionEvent actionEvent) {
        this.m_isOKPressed = true;
        if (this.jobScriptDefinitionBean == null || !this.m_editable) {
            this.setVisible(false);
            return;
        }
        try {
            if (this.m_isJobArray) {
                if (this.m_jobArrayDef != null) {
                    this.m_jobArrayDef = (JFJobArray)this.m_jobArrayDef.clone();
                    this.jobScriptDefinitionBean.updateDefinition();
                } else {
                    this.m_jobArrayDef = this.jobScriptDefinitionBean.getJobArrayDefinition();
                }
            } else if (this.m_jobDef != null) {
                this.m_jobDef = (JFJob)this.m_jobDef.clone();
                this.jobScriptDefinitionBean.updateDefinition();
            } else {
                this.m_jobDef = this.jobScriptDefinitionBean.getJobDefinition();
            }
            this.setVisible(false);
            this.dispose();
        }
        catch (Exception exception) {
            JFUtility.showAppException(this, exception);
        }
    }

    private void cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.m_isOKPressed = false;
        this.setVisible(false);
        this.dispose();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.m_isOKPressed = false;
        this.setVisible(false);
        this.dispose();
    }

    public void setJobOwner(String string) {
        if (this.jobScriptDefinitionBean != null) {
            this.jobScriptDefinitionBean.setJobOwner(string);
        }
    }

    public static void main(String[] stringArray) {
        new JFJobScriptDefinitionDialog((Frame)new JFrame(), true).show();
    }
}

