/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFExampleResourceBundle;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.File;
import java.util.Enumeration;
import javax.swing.BorderFactory;
import javax.swing.DefaultListModel;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class JFJobFlowExampleExplorer
extends JDialog
implements ListSelectionListener,
ActionListener {
    static final String EXAMPLE_FILE_SUFFIX = ".xml";
    static final String EXAMPLE_OPEN_BUTTON_CMD = "OPEN";
    static final String EXAMPLE_CANCEL_BUTTON_CMD = "CANCEL";
    public static final int CANCEL_OPTION = 1;
    public static final int APPROVE_OPTION = 0;
    public static final int ERROR_OPTION = -1;
    private JSplitPane splitPanel;
    private JList nameList;
    private JTextArea descriptionArea;
    private JButton openButton;
    private JButton cancelButton;
    private JPanel descriptionPanel;
    private JPanel buttonPanel;
    private JDialog dialog = null;
    private String selectedExample = null;
    private int returnValue = -1;
    private String exampleDir = "";

    public JFJobFlowExampleExplorer() {
        this.initComponents();
        String string = System.getProperty("JS_HOME");
        String string2 = System.getProperty("JS_VERSION");
        if (string == null || string2 == null) {
            return;
        }
        this.exampleDir = string + File.separator + string2 + File.separator + "examples" + File.separator + "flowdefs";
    }

    @Override
    public void valueChanged(ListSelectionEvent listSelectionEvent) {
        JList jList = (JList)listSelectionEvent.getSource();
        int n = jList.getSelectedIndex();
        if (n == -1) {
            return;
        }
        String string = JFExampleResourceBundle.getDescriptionString(n);
        if (string != null) {
            this.descriptionArea.setText(string);
            this.descriptionArea.setCaretPosition(0);
        }
    }

    public int showOpenDialog(Component component) throws HeadlessException {
        this.dialog = this.createDialog(component);
        this.dialog.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFJobFlowExampleExplorer.this.returnValue = 1;
            }
        });
        this.returnValue = -1;
        this.dialog.show();
        this.dialog.removeAll();
        this.dialog.dispose();
        this.dialog = null;
        return this.returnValue;
    }

    public String getSelectedExample() {
        return this.selectedExample;
    }

    private JDialog createDialog(Component component) throws HeadlessException {
        JDialog jDialog = component instanceof Frame ? new JDialog((Frame)component, JFResourceBundle.getString("JFJobFlowExampleExplorer$TITLE_dialog"), true) : new JDialog((Dialog)component, JFResourceBundle.getString("JFJobFlowExampleExplorer$TITLE_dialog"), true);
        jDialog.setComponentOrientation(this.getComponentOrientation());
        jDialog.setResizable(true);
        Container container = jDialog.getContentPane();
        container.setLayout(new BorderLayout());
        container.add((Component)this.splitPanel, "Center");
        container.add((Component)this.buttonPanel, "South");
        jDialog.pack();
        jDialog.setLocationRelativeTo(component);
        return jDialog;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        if (EXAMPLE_OPEN_BUTTON_CMD.equals(actionEvent.getActionCommand())) {
            int n = this.nameList.getSelectedIndex();
            if (n == -1) {
                return;
            }
            String string = JFExampleResourceBundle.getExampleName(n);
            if (string == null) {
                return;
            }
            this.selectedExample = this.exampleDir + File.separator + string + EXAMPLE_FILE_SUFFIX;
            this.returnValue = 0;
        } else if (EXAMPLE_CANCEL_BUTTON_CMD.equals(actionEvent.getActionCommand())) {
            this.returnValue = 1;
        }
        if (this.dialog != null) {
            this.dialog.setVisible(false);
        }
    }

    private void initComponents() {
        Object object;
        this.descriptionArea = new JTextArea();
        Font font = UIManager.getFont("JLabel.font");
        this.descriptionArea.setFont(font);
        this.descriptionArea.setEditable(false);
        this.descriptionArea.setOpaque(false);
        this.descriptionArea.setLineWrap(true);
        this.descriptionArea.setWrapStyleWord(true);
        JScrollPane jScrollPane = new JScrollPane(this.descriptionArea, 20, 31);
        this.descriptionPanel = new JPanel();
        jScrollPane.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("JFJobFlowExampleExplorer$MSG_descriptionPanel")));
        DefaultListModel<String> defaultListModel = new DefaultListModel<String>();
        Enumeration<String> enumeration = JFExampleResourceBundle.getExampleNames();
        while (enumeration.hasMoreElements()) {
            object = enumeration.nextElement();
            String string = JFExampleResourceBundle.getTitleString((String)object);
            defaultListModel.addElement(string);
        }
        this.nameList = new JList(defaultListModel);
        this.nameList.setFont(this.nameList.getFont().deriveFont(0));
        this.nameList.setSelectionMode(0);
        this.nameList.addListSelectionListener(this);
        this.nameList.setSelectedIndex(0);
        object = new JScrollPane(this.nameList, 20, 30);
        ((JComponent)object).setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("JFJobFlowExampleExplorer$MSG_nameListPanel")));
        this.splitPanel = new JSplitPane(0, (Component)object, jScrollPane);
        this.splitPanel.setResizeWeight(0.4);
        this.splitPanel.setBorder(BorderFactory.createEtchedBorder(1));
        this.splitPanel.setPreferredSize(new Dimension(660, 440));
        this.cancelButton = new JButton(JFResourceBundle.getString("JFJobFlowExampleExplorer$MSG_cancelButton"));
        this.cancelButton.setActionCommand(EXAMPLE_CANCEL_BUTTON_CMD);
        this.cancelButton.addActionListener(this);
        this.openButton = new JButton(JFResourceBundle.getString("JFJobFlowExampleExplorer$MSG_openButton"));
        this.openButton.setActionCommand(EXAMPLE_OPEN_BUTTON_CMD);
        this.openButton.addActionListener(this);
        this.getRootPane().setDefaultButton(this.openButton);
        this.buttonPanel = new JPanel();
        this.buttonPanel.setBorder(BorderFactory.createEmptyBorder(0, 10, 10, 10));
        this.buttonPanel.add(this.openButton);
        this.buttonPanel.add(this.cancelButton);
    }
}

