/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowDefinitionManager;
import com.platform.LSFJobFlow.api.JFFlowVersion;
import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFTable;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.Collections;
import java.util.Comparator;
import java.util.Vector;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.table.DefaultTableModel;

public class JFFlowVersionDialog
extends JDialog {
    public static final int VERSION_UNDEFINED_MODE = -1;
    public static final int VERSION_MAINFLOW_DEF_MODE = 0;
    public static final int VERSION_MAINFLOW_INST_MODE = 1;
    public static final int VERSION_SUBFLOW_DEF_MODE = 2;
    public static final int VERSION_SUBFLOW_INST_MODE = 3;
    private String m_flowName = null;
    private Object[][] m_tableContents;
    private String[] m_tableHeader = new String[]{JFResourceBundle.getString("COLUM_TITLE_Version"), JFResourceBundle.getString("COLUM_TITLE_SubmissionUser"), JFResourceBundle.getString("COLUM_TITLE_SubmissionTime"), JFResourceBundle.getString("COLUM_TITLE_Comments")};
    private static final int TOOLTIP_WIDTH = 60;
    private MyTableModel m_tableModel;
    private ColumnSorter m_columnSorter;
    private boolean bVersionHistoryPanel = false;
    private static final int VERSION_INDEX = 0;
    private static final int SUBMISSION_USER_INDEX = 1;
    private static final int SUBMISSION_TIME_INDEX = 2;
    private static final int COMMENTS_INDEX = 3;
    private static final String DEFAULT_VERSION = JFResourceBundle.getString("Default_Version");
    private static final String CURRENT_VERSION = JFResourceBundle.getString("Current_Version");
    private static final String LATEST_VERSION = JFResourceBundle.getString("Latest_Version");
    private static final String VERSION_UNAVAIL = JFResourceBundle.getString("Unavailable");
    private String m_defaultVersion = VERSION_UNAVAIL;
    private String m_currentVersion = VERSION_UNAVAIL;
    private String m_latestVersion = VERSION_UNAVAIL;
    private String m_updateType = "Default";
    private String m_newUpdateType = "Default";
    private String m_fullName = null;
    private int m_mode = -1;
    private boolean m_dirty = false;
    private boolean m_updateNow = false;
    private JPanel jPanel1;
    private JButton m_ApplyButton;
    private JButton m_CancelButton;
    private JButton m_OKButton;
    private JButton m_RefreshButton;
    private JButton m_SetVersionButton;
    private JRadioButton m_autoUpdateRadioButton;
    private JLabel m_verLabel1;
    private JLabel m_verLabel2;
    private JCheckBox m_manualUpdateCheckBox;
    private JRadioButton m_manualUpdateRadioButton;
    private JPanel m_subflowType;
    private ButtonGroup m_subflowTypeButtonGroup;
    private JPanel m_version;
    private JScrollPane m_versionHistory;
    private JButton m_viewHistoryButton;
    private JFTable m_table;

    public JFFlowVersionDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
    }

    public JFFlowVersionDialog(Frame frame, boolean bl, String string, int n) {
        super(frame, bl);
        this.initComponents();
        this.m_tableModel = new MyTableModel(this.m_tableContents, this.m_tableHeader);
        this.m_table.setModel(this.m_tableModel);
        this.m_versionHistory.setViewportView(this.m_table);
        this.m_columnSorter = new ColumnSorter(0);
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JFFlowVersionDialog.this.m_tableMouseClicked(mouseEvent);
            }
        });
        this.m_flowName = string;
        this.m_mode = n;
        switch (n) {
            case 0: {
                String string2 = JFResourceBundle.getString("FlowDiagramBean$TITLE_flowVersionWin");
                string2 = string2 + " ";
                string2 = string2 + this.m_flowName;
                this.setTitle(string2);
                this.m_subflowType.setVisible(false);
                this.m_versionHistory.setVisible(false);
                this.m_ApplyButton.setVisible(false);
                this.m_CancelButton.setVisible(false);
                this.m_SetVersionButton.setVisible(true);
                this.m_SetVersionButton.setEnabled(false);
                this.refresh();
                break;
            }
            case 1: {
                String string3 = JFResourceBundle.getString("FlowDiagramBean$TITLE_flowVersionWin");
                string3 = string3 + " ";
                string3 = string3 + this.m_flowName;
                this.setTitle(string3);
                this.m_subflowType.setVisible(false);
                this.m_versionHistory.setVisible(false);
                this.m_ApplyButton.setVisible(false);
                this.m_CancelButton.setVisible(false);
                this.m_SetVersionButton.setVisible(false);
                this.m_verLabel2.setVisible(false);
                this.refresh();
                break;
            }
            case 2: {
                String string4 = JFResourceBundle.getString("FlowDiagramBean$TITLE_flowVersionWin");
                string4 = string4 + " ";
                string4 = string4 + this.m_flowName;
                this.setTitle(string4);
                this.m_subflowType.setVisible(true);
                this.m_versionHistory.setVisible(false);
                this.m_ApplyButton.setVisible(true);
                this.m_CancelButton.setVisible(false);
                this.m_autoUpdateRadioButton.setEnabled(true);
                this.m_manualUpdateRadioButton.setEnabled(true);
                this.m_manualUpdateCheckBox.setEnabled(true);
                this.m_SetVersionButton.setVisible(false);
                this.refresh();
                break;
            }
            case 3: {
                String string5 = JFResourceBundle.getString("FlowDiagramBean$TITLE_flowVersionWin");
                string5 = string5 + " ";
                string5 = string5 + this.m_flowName;
                this.setTitle(string5);
                this.m_subflowType.setVisible(false);
                this.m_versionHistory.setVisible(false);
                this.m_ApplyButton.setVisible(false);
                this.m_CancelButton.setVisible(false);
                this.m_autoUpdateRadioButton.setEnabled(false);
                this.m_manualUpdateRadioButton.setEnabled(false);
                this.m_manualUpdateCheckBox.setEnabled(false);
                this.m_SetVersionButton.setVisible(false);
                this.m_verLabel2.setVisible(false);
                this.refresh();
                break;
            }
        }
        this.pack();
    }

    public void setCurrentVersion(String string) {
        this.m_currentVersion = string;
        this.refresh();
    }

    public String getCurrentVersion() {
        return this.m_currentVersion;
    }

    public void setFullName(String string) {
        this.m_fullName = string;
    }

    public void setUpdateType(String string) {
        if (string == null || string.length() <= 0) {
            return;
        }
        this.m_newUpdateType = this.m_updateType = string;
        this.refresh();
    }

    public String getUpdateType() {
        return this.m_newUpdateType;
    }

    private void refresh() {
        JFFlowVersion[] jFFlowVersionArray = null;
        try {
            JFFlowDefinitionManager jFFlowDefinitionManager = new JFFlowDefinitionManager();
            jFFlowVersionArray = jFFlowDefinitionManager.getFlowVersionHistory(this.m_flowName);
            JFFlow jFFlow = jFFlowDefinitionManager.getFlow(this.m_flowName);
            int n = this.m_flowName.indexOf(58);
            String string = n <= 0 ? "-" : this.m_flowName.substring(0, n);
            String string2 = "1.0";
            if (jFFlowVersionArray != null && jFFlowVersionArray.length > 0) {
                this.m_tableContents = new Object[jFFlowVersionArray.length][this.m_tableHeader.length];
                JFFlowVersion jFFlowVersion = new JFFlowVersion("0.1");
                for (int i = 0; i < jFFlowVersionArray.length; ++i) {
                    this.m_tableContents[i][0] = jFFlowVersionArray[i].getVersion();
                    JFUser jFUser = jFFlowVersionArray[i].getSubmissionUser();
                    this.m_tableContents[i][1] = jFUser == null ? string : jFUser.toJSUserName();
                    this.m_tableContents[i][2] = jFFlowVersionArray[i].getSubmissionTime().getTimeString();
                    this.m_tableContents[i][3] = jFFlowVersionArray[i].getComments();
                    if (jFFlowVersionArray[i].compareTo(jFFlowVersion) != 1) continue;
                    jFFlowVersion = jFFlowVersionArray[i];
                    string2 = (String)this.m_tableContents[i][0];
                }
                this.m_tableModel.setDataVector(this.m_tableContents, this.m_tableHeader);
                Collections.sort(this.m_tableModel.getDataVector(), this.m_columnSorter);
                this.m_tableModel.fireTableDataChanged();
            }
            switch (this.m_mode) {
                case 0: {
                    this.m_defaultVersion = jFFlow.getFlowVersion().getVersion();
                    this.m_latestVersion = string2;
                    this.m_verLabel1.setText(DEFAULT_VERSION + " " + this.m_defaultVersion);
                    this.m_verLabel2.setText(LATEST_VERSION + " " + this.m_latestVersion);
                    break;
                }
                case 2: {
                    if (this.m_updateType.equals("Automatic")) {
                        this.m_currentVersion = this.m_defaultVersion;
                    } else if (this.m_updateNow) {
                        this.m_currentVersion = this.m_defaultVersion;
                    }
                    this.m_defaultVersion = jFFlow.getFlowVersion().getVersion();
                    this.m_verLabel1.setText(CURRENT_VERSION + " " + this.m_currentVersion);
                    this.m_verLabel2.setText(DEFAULT_VERSION + " " + this.m_defaultVersion);
                    break;
                }
                case 1: 
                case 3: {
                    this.m_verLabel1.setText(CURRENT_VERSION + " " + this.m_currentVersion);
                    this.m_verLabel2.setText("");
                    break;
                }
            }
        }
        catch (Exception exception) {
            JFUtility.showAppException(this, exception);
        }
        this.m_updateNow = false;
        this.m_SetVersionButton.setEnabled(false);
        if (this.m_updateType.equals("Automatic")) {
            this.m_autoUpdateRadioButton.setSelected(true);
            this.m_manualUpdateRadioButton.setSelected(false);
            this.m_manualUpdateCheckBox.setSelected(false);
            this.m_manualUpdateCheckBox.setEnabled(false);
        } else {
            this.m_autoUpdateRadioButton.setSelected(false);
            this.m_manualUpdateRadioButton.setSelected(true);
            this.m_manualUpdateCheckBox.setEnabled(true);
        }
        if (this.m_dirty) {
            this.m_ApplyButton.setEnabled(true);
        } else {
            this.m_ApplyButton.setEnabled(false);
        }
    }

    private void initComponents() {
        this.m_subflowTypeButtonGroup = new ButtonGroup();
        this.m_version = new JPanel();
        this.m_verLabel1 = new JLabel();
        this.m_verLabel2 = new JLabel();
        this.m_viewHistoryButton = new JButton();
        this.m_RefreshButton = new JButton();
        this.m_versionHistory = new JScrollPane();
        this.m_table = new JFTable(){

            @Override
            public String getToolTipText(MouseEvent mouseEvent) {
                Point point = mouseEvent.getPoint();
                int n = this.rowAtPoint(point);
                int n2 = this.columnAtPoint(point);
                if (n == -1 || n2 != 2) {
                    return null;
                }
                Object object = JFFlowVersionDialog.this.m_table.getValueAt(n, n2);
                if (object == null || object.toString() == null) {
                    return null;
                }
                String string = object.toString().replaceAll("\r\n", "\n");
                String[] stringArray = string.split("\n");
                String string2 = "";
                for (int i = 0; i < stringArray.length; ++i) {
                    if (stringArray[i].length() == 0) continue;
                    if (stringArray[i].length() <= 60) {
                        if (i != 0) {
                            string2 = string2 + "<br>";
                        }
                        string2 = string2 + stringArray[i];
                        continue;
                    }
                    int n3 = stringArray[i].length() / 60;
                    if (n3 * 60 < stringArray[i].length()) {
                        ++n3;
                    }
                    for (int j = 0; j < n3; ++j) {
                        if (i != 0 || i == 0 && j != 0) {
                            string2 = string2 + "<br>";
                        }
                        string2 = string2 + stringArray[i].substring(j * 60, (j + 1) * 60 < stringArray[i].length() ? (j + 1) * 60 : stringArray[i].length());
                    }
                }
                if (string2.length() == 0) {
                    return null;
                }
                return "<html>" + string2 + "</html>";
            }
        };
        this.jPanel1 = new JPanel();
        this.m_SetVersionButton = new JButton();
        this.m_ApplyButton = new JButton();
        this.m_OKButton = new JButton();
        this.m_CancelButton = new JButton();
        this.m_subflowType = new JPanel();
        this.m_manualUpdateRadioButton = new JRadioButton();
        this.m_autoUpdateRadioButton = new JRadioButton();
        this.m_manualUpdateCheckBox = new JCheckBox();
        this.setDefaultCloseOperation(2);
        this.setTitle("");
        this.getContentPane().setLayout(new GridBagLayout());
        this.m_version.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Version...")));
        this.m_version.setMinimumSize(new Dimension(500, 120));
        this.m_version.setPreferredSize(new Dimension(500, 120));
        this.m_viewHistoryButton.setText(JFResourceBundle.getString("View_History"));
        this.m_viewHistoryButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionDialog.this.m_viewHistoryButtonActionPerformed(actionEvent);
            }
        });
        this.m_RefreshButton.setText(JFResourceBundle.getString("Refresh_version"));
        this.m_RefreshButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionDialog.this.m_RefreshButtonActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout = new GroupLayout(this.m_version);
        this.m_version.setLayout(groupLayout);
        groupLayout.setHorizontalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.m_verLabel1).addComponent(this.m_verLabel2).addGroup(groupLayout.createSequentialGroup().addComponent(this.m_RefreshButton).addGap(0).addComponent(this.m_viewHistoryButton))).addContainerGap(306, Short.MAX_VALUE)));
        groupLayout.setVerticalGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout.createSequentialGroup().addContainerGap().addComponent(this.m_verLabel1, -2, 14, -2).addGap(0).addComponent(this.m_verLabel2, -2, 22, -2).addGap(0, 0, Short.MAX_VALUE).addGroup(groupLayout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.m_viewHistoryButton, -2, 23, -2).addComponent(this.m_RefreshButton)).addContainerGap()));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.m_version, gridBagConstraints);
        this.m_versionHistory.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Version_History...")));
        this.m_versionHistory.setMinimumSize(new Dimension(500, 300));
        this.m_versionHistory.setPreferredSize(new Dimension(500, 300));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.m_versionHistory, gridBagConstraints);
        this.m_SetVersionButton.setText(JFResourceBundle.getString("Set_Default_Version"));
        this.m_SetVersionButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionDialog.this.m_SetVersionButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.m_SetVersionButton);
        this.m_ApplyButton.setText(JFResourceBundle.getString("Apply"));
        this.jPanel1.add(this.m_ApplyButton);
        this.m_ApplyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionDialog.this.m_ApplyButtonActionPerformed(actionEvent);
            }
        });
        this.m_OKButton.setText(JFResourceBundle.getString("Close"));
        this.m_OKButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionDialog.this.m_OKButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel1.add(this.m_OKButton);
        this.m_CancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.jPanel1.add(this.m_CancelButton);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 1;
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints);
        this.m_subflowType.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("Update_version...")));
        this.m_subflowType.setMinimumSize(new Dimension(500, 120));
        this.m_subflowType.setPreferredSize(new Dimension(500, 120));
        this.m_manualUpdateRadioButton.setText(JFResourceBundle.getString("Manual_update"));
        this.m_subflowTypeButtonGroup.add(this.m_manualUpdateRadioButton);
        this.m_manualUpdateRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_manualUpdateRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_manualUpdateRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionDialog.this.m_manualUpdateActionPerformed(actionEvent);
            }
        });
        this.m_autoUpdateRadioButton.setText(JFResourceBundle.getString("Automatic_update"));
        this.m_subflowTypeButtonGroup.add(this.m_autoUpdateRadioButton);
        this.m_autoUpdateRadioButton.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_autoUpdateRadioButton.setMargin(new Insets(0, 0, 0, 0));
        this.m_autoUpdateRadioButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionDialog.this.m_autoUpdateActionPerformed(actionEvent);
            }
        });
        this.m_manualUpdateCheckBox.setText(JFResourceBundle.getString("Update_now"));
        this.m_manualUpdateCheckBox.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 0));
        this.m_manualUpdateCheckBox.setEnabled(false);
        this.m_manualUpdateCheckBox.setMargin(new Insets(0, 0, 0, 0));
        this.m_manualUpdateCheckBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowVersionDialog.this.m_manualUpdateCheckBoxActionPerformed(actionEvent);
            }
        });
        GroupLayout groupLayout2 = new GroupLayout(this.m_subflowType);
        this.m_subflowType.setLayout(groupLayout2);
        groupLayout2.setHorizontalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.m_autoUpdateRadioButton, -2, 298, -2)).addGroup(groupLayout2.createSequentialGroup().addGap(26, 26, 26).addComponent(this.m_manualUpdateCheckBox)).addGroup(groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.m_manualUpdateRadioButton, -2, 325, -2))).addContainerGap(149, Short.MAX_VALUE)));
        groupLayout2.setVerticalGroup(groupLayout2.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, groupLayout2.createSequentialGroup().addContainerGap().addComponent(this.m_autoUpdateRadioButton).addGap(0, 14, Short.MAX_VALUE).addComponent(this.m_manualUpdateRadioButton).addGap(0).addComponent(this.m_manualUpdateCheckBox, -2, 29, -2)));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        this.getContentPane().add((Component)this.m_subflowType, gridBagConstraints);
        this.pack();
    }

    private void m_manualUpdateActionPerformed(ActionEvent actionEvent) {
        if (this.m_newUpdateType != "Manual") {
            this.m_dirty = true;
            this.m_newUpdateType = "Manual";
            this.m_manualUpdateCheckBox.setEnabled(true);
            this.m_ApplyButton.setEnabled(true);
        }
    }

    private void m_autoUpdateActionPerformed(ActionEvent actionEvent) {
        if (this.m_newUpdateType != "Automatic") {
            this.m_dirty = true;
            this.m_newUpdateType = "Automatic";
            this.m_manualUpdateCheckBox.setEnabled(false);
            this.m_ApplyButton.setEnabled(true);
        }
    }

    private void m_manualUpdateCheckBoxActionPerformed(ActionEvent actionEvent) {
        this.m_dirty = true;
        this.m_updateNow = this.m_manualUpdateCheckBox.isSelected();
        this.m_ApplyButton.setEnabled(true);
    }

    private void m_OKButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void m_RefreshButtonActionPerformed(ActionEvent actionEvent) {
        this.refresh();
    }

    private void m_viewHistoryButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.bVersionHistoryPanel) {
            this.bVersionHistoryPanel = true;
            this.m_versionHistory.setVisible(true);
            this.m_viewHistoryButton.setText(JFResourceBundle.getString("View_History_expand"));
            this.pack();
        } else {
            this.bVersionHistoryPanel = false;
            this.m_versionHistory.setVisible(false);
            this.m_viewHistoryButton.setText(JFResourceBundle.getString("View_History"));
            this.pack();
        }
    }

    private void m_tableMouseClicked(MouseEvent mouseEvent) {
        if (this.m_table.getRowCount() > 1) {
            this.m_SetVersionButton.setEnabled(true);
        }
    }

    private void m_SetVersionButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.m_table.getSelectedRow();
        if (n == -1) {
            return;
        }
        try {
            JFFlowDefinitionManager jFFlowDefinitionManager = new JFFlowDefinitionManager();
            String string = (String)this.m_table.getValueAt(n, 0);
            jFFlowDefinitionManager.setDefaultVersionForFlow(this.m_flowName, string);
        }
        catch (Exception exception) {
            JFUtility.showAppException(this, exception);
        }
        this.refresh();
    }

    private void m_ApplyButtonActionPerformed(ActionEvent actionEvent) {
        if (!this.m_dirty) {
            return;
        }
        this.m_dirty = false;
        try {
            JFFlowDefinitionManager jFFlowDefinitionManager = new JFFlowDefinitionManager();
            jFFlowDefinitionManager.setUpdateType(this.m_fullName, this.m_flowName, this.m_newUpdateType, this.m_updateNow);
            this.m_updateType = this.m_newUpdateType;
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JFUtility.showAppException(this, exception);
        }
        this.refresh();
    }

    public static void main(String[] stringArray) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new JFFlowVersionDialog((Frame)new JFrame(), true).setVisible(true);
            }
        });
    }

    private class ColumnSorter
    implements Comparator {
        int colIndex;

        ColumnSorter(int n) {
            this.colIndex = n;
        }

        public int compare(Object object, Object object2) {
            JFFlowVersion jFFlowVersion;
            JFFlowVersion jFFlowVersion2;
            Vector vector = (Vector)object;
            Vector vector2 = (Vector)object2;
            Object e = vector.get(this.colIndex);
            Object e2 = vector2.get(this.colIndex);
            if (!(e instanceof String) || ((String)e).length() == 0) {
                jFFlowVersion2 = null;
            }
            if (!(e2 instanceof String) || ((String)e2).length() == 0) {
                jFFlowVersion = null;
            }
            try {
                jFFlowVersion2 = new JFFlowVersion((String)e);
            }
            catch (Exception exception) {
                jFFlowVersion2 = null;
            }
            try {
                jFFlowVersion = new JFFlowVersion((String)e2);
            }
            catch (Exception exception) {
                jFFlowVersion = null;
            }
            if (jFFlowVersion2 == null && jFFlowVersion == null) {
                return 0;
            }
            if (jFFlowVersion2 == null) {
                return 1;
            }
            if (jFFlowVersion == null) {
                return -1;
            }
            try {
                return jFFlowVersion2.compareTo(jFFlowVersion);
            }
            catch (Exception exception) {
                return 0;
            }
        }
    }

    private class MyTableModel
    extends DefaultTableModel {
        public MyTableModel(Object[][] objectArray, Object[] objectArray2) {
            super(objectArray, objectArray2);
        }

        @Override
        public boolean isCellEditable(int n, int n2) {
            return false;
        }
    }
}

