/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFFlowArrayInstance;
import com.platform.LSFJobFlow.api.JFFlowInstance;
import com.platform.LSFJobFlow.api.JFFlowManager;
import com.platform.LSFJobFlow.ui.FlowDiagram;
import com.platform.LSFJobFlow.ui.JFFlowArrayIndexTableModel;
import com.platform.LSFJobFlow.ui.JFHistoryConvertor;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import com.platform.LSFJobFlow.ui.TableSorter;
import com.platform.LSFJobFlow.ui.TextAreaDialog;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.ResourceBundle;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;

public class JFFlowArrayIndexDialog
extends JDialog {
    private TableSorter m_sorter = new TableSorter(new JFFlowArrayIndexTableModel());
    private JFFlowInstance m_curElement = null;
    private JFFlowArrayInstance m_fai = null;
    private static final int ColIndex = 0;
    private JPanel btnPanel;
    private JButton m_closeButton;
    private JButton m_historyButton;
    private JButton m_runtimeButton;
    private JTable m_table;
    private JButton m_viewButton;
    private JScrollPane tablePanel;

    public JFFlowArrayIndexDialog(Frame frame, boolean bl) {
        super(frame, bl);
        this.initComponents();
        this.m_table.setSelectionMode(0);
        this.m_table.getTableHeader().setReorderingAllowed(false);
        this.m_table.getColumnModel().getColumn(0).setPreferredWidth(40);
        this.m_table.getColumnModel().getColumn(1).setPreferredWidth(70);
        this.m_table.getColumnModel().getColumn(2).setPreferredWidth(200);
        this.m_table.getColumnModel().getColumn(3).setPreferredWidth(200);
        this.m_table.getColumnModel().getColumn(4).setPreferredWidth(60);
        this.getRootPane().setDefaultButton(this.m_viewButton);
        this.m_sorter.addMouseListenerToHeaderInTable(this.m_table);
    }

    private void initComponents() {
        this.btnPanel = new JPanel();
        this.m_viewButton = new JButton();
        this.m_runtimeButton = new JButton();
        this.m_historyButton = new JButton();
        this.m_closeButton = new JButton();
        this.tablePanel = new JScrollPane();
        this.m_table = new JTable();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFFlowArrayIndexDialog.this.closeDialog(windowEvent);
            }
        });
        this.btnPanel.setMinimumSize(new Dimension(450, 33));
        this.btnPanel.setPreferredSize(new Dimension(570, 33));
        this.m_viewButton.setText(JFResourceBundle.getString("View_Flow"));
        this.m_viewButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowArrayIndexDialog.this.m_viewButtonActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.m_viewButton);
        this.m_runtimeButton.setText(ResourceBundle.getBundle("guiSharedResource").getString("Runtime_Attributes"));
        this.m_runtimeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowArrayIndexDialog.this.m_runtimeButtonActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.m_runtimeButton);
        this.m_historyButton.setText(ResourceBundle.getBundle("guiSharedResource").getString("View_History"));
        this.m_historyButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowArrayIndexDialog.this.m_historyButtonActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.m_historyButton);
        this.m_closeButton.setText(JFResourceBundle.getString("Close"));
        this.m_closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFlowArrayIndexDialog.this.m_closeButtonActionPerformed(actionEvent);
            }
        });
        this.btnPanel.add(this.m_closeButton);
        this.getContentPane().add((Component)this.btnPanel, "South");
        this.tablePanel.setMinimumSize(new Dimension(450, 50));
        this.tablePanel.setPreferredSize(new Dimension(570, 400));
        this.m_table.setModel(this.m_sorter);
        this.m_table.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                JFFlowArrayIndexDialog.this.m_tableMouseClicked(mouseEvent);
            }
        });
        this.tablePanel.setViewportView(this.m_table);
        this.getContentPane().add((Component)this.tablePanel, "Center");
        this.pack();
    }

    private void m_historyButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.m_table.getSelectedRow();
        if (n == -1) {
            return;
        }
        int n2 = (Integer)this.m_sorter.getValueAt(n, 0);
        String string = this.m_fai.getName() + "(" + n2 + ")";
        String string2 = "SELECT * FROM FLOW WHERE FLOWNAME=" + string;
        Cursor cursor = this.getCursor();
        this.setCursor(Cursor.getPredefinedCursor(3));
        String string3 = null;
        try {
            string3 = JFHistoryConvertor.getHistoryText(string2);
        }
        catch (Exception exception) {
            this.setCursor(cursor);
            JFUtility.showAppException(this, exception);
            return;
        }
        this.setCursor(cursor);
        if (string3 == null || string3.length() <= 0) {
            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("FlowDiagramBean$ERR_nullHisotoryInfo"));
            return;
        }
        JFrame jFrame = (JFrame)this.getParent();
        TextAreaDialog textAreaDialog = new TextAreaDialog((Frame)jFrame, true);
        textAreaDialog.setTitle(JFResourceBundle.getString("FlowDiagramBean$TITLE_viewHistory"));
        textAreaDialog.setText(string3);
        textAreaDialog.setSize(700, 500);
        textAreaDialog.setLocationRelativeTo(jFrame);
        textAreaDialog.setVisible(true);
    }

    private void m_runtimeButtonActionPerformed(ActionEvent actionEvent) {
        Object object;
        int n = this.m_table.getSelectedRow();
        if (n == -1) {
            return;
        }
        try {
            object = new JFFlowManager();
            int n2 = (Integer)this.m_sorter.getValueAt(n, 0);
            this.m_curElement = object.getFlowArrayElementInstance(this.m_fai, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JFUtility.showAppException(this, exception);
        }
        object = new FlowDiagram(this.m_curElement);
        JFrame jFrame = (JFrame)this.getParent();
        TextAreaDialog textAreaDialog = new TextAreaDialog((Frame)jFrame, true);
        textAreaDialog.setTitle(JFResourceBundle.getString("FlowDiagramBean$TITLE_viewRuntime"));
        String string = ((FlowDiagram)object).getRuntimeAttributesStr();
        string = JFUtility.substituteVariables(string, this.m_curElement.getLocalVariables(), null);
        textAreaDialog.setText(string);
        textAreaDialog.setLocationRelativeTo(jFrame);
        textAreaDialog.setVisible(true);
    }

    private void m_tableMouseClicked(MouseEvent mouseEvent) {
        if (mouseEvent.getClickCount() == 2) {
            this.m_viewButtonActionPerformed(null);
        }
    }

    private void m_closeButtonActionPerformed(ActionEvent actionEvent) {
        this.m_curElement = null;
        this.setVisible(false);
        this.dispose();
    }

    private void m_viewButtonActionPerformed(ActionEvent actionEvent) {
        int n = this.m_table.getSelectedRow();
        if (n == -1) {
            return;
        }
        try {
            JFFlowManager jFFlowManager = new JFFlowManager();
            int n2 = (Integer)this.m_sorter.getValueAt(n, 0);
            this.m_curElement = jFFlowManager.getFlowArrayElementInstance(this.m_fai, n2);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            JFUtility.showAppException(this, exception);
        }
        this.setVisible(false);
        this.dispose();
    }

    public void open(JFFlowArrayInstance jFFlowArrayInstance) {
        this.m_fai = jFFlowArrayInstance;
        this.setTitle(JFResourceBundle.getString("Flow_Array_Elements_") + " " + jFFlowArrayInstance.getName());
        this.m_sorter.setModel(new JFFlowArrayIndexTableModel(jFFlowArrayInstance));
        this.m_table.revalidate();
        this.m_table.repaint();
        if (this.m_table.getRowCount() > 1) {
            this.m_table.clearSelection();
            this.m_table.addRowSelectionInterval(0, 0);
        }
        this.m_sorter.sortByColumn(0, true);
        this.setVisible(true);
    }

    public JFFlowInstance getSelectedElement() {
        return this.m_curElement;
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.m_curElement = null;
        this.setVisible(false);
        this.dispose();
    }

    public void disableViewChart(boolean bl) {
        this.m_viewButton.setEnabled(false);
    }

    public static void main(String[] stringArray) {
        new JFFlowArrayIndexDialog((Frame)new JFrame(), true).show();
    }
}

