/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;

public class JFFileTransferDialog
extends JDialog {
    private String m_fileTransferStr;
    private ButtonGroup m_buttonGroup;
    private JPanel jPanel1;
    private JLabel jLabel1;
    private JTextField m_localFLD;
    private JLabel jLabel2;
    private JTextField m_remoteFLD;
    private JPanel jPanel2;
    private JRadioButton m_copyToRemoteSelector;
    private JRadioButton m_copyToLocalSelector;
    private JRadioButton m_appendToLocalSelector;
    private JPanel jPanel3;
    private JButton m_okButton;
    private JButton m_cancelButton;
    private JButton m_resetButton;

    public JFFileTransferDialog(Frame frame, String string) {
        super(frame, true);
        this.initComponents();
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.setTitle(JFResourceBundle.getString("JFFileTransferDialog$TITLE"));
        if (string != null && string.length() > 0) {
            int n = string.length();
            int n2 = -1;
            n2 = string.indexOf(62);
            if (n2 > 0 && n2 < n - 1) {
                this.m_copyToRemoteSelector.setSelected(true);
                this.m_localFLD.setText(string.substring(0, n2).trim());
                this.m_remoteFLD.setText(string.substring(n2 + 1, n).trim());
            } else {
                n2 = string.indexOf(60);
                if (n2 > 0 && n2 < n - 1) {
                    this.m_copyToLocalSelector.setSelected(true);
                    this.m_localFLD.setText(string.substring(0, n2).trim());
                    this.m_remoteFLD.setText(string.substring(n2 + 1, n).trim());
                } else {
                    n2 = string.indexOf("<<");
                    if (n2 > 0 && n2 < n - 1) {
                        this.m_appendToLocalSelector.setSelected(true);
                        this.m_remoteFLD.setText(string.substring(0, n2).trim());
                        this.m_remoteFLD.setText(string.substring(n2 + 1, n).trim());
                    }
                }
            }
        }
    }

    public String getFileTransferString() {
        return this.m_fileTransferStr;
    }

    private void initComponents() {
        this.m_buttonGroup = new ButtonGroup();
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.m_localFLD = new JTextField();
        this.jLabel2 = new JLabel();
        this.m_remoteFLD = new JTextField();
        this.jPanel2 = new JPanel();
        this.m_copyToRemoteSelector = new JRadioButton();
        this.m_copyToLocalSelector = new JRadioButton();
        this.m_appendToLocalSelector = new JRadioButton();
        this.jPanel3 = new JPanel();
        this.m_okButton = new JButton();
        this.m_cancelButton = new JButton();
        this.m_resetButton = new JButton();
        this.getContentPane().setLayout(new GridBagLayout());
        this.setResizable(false);
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFFileTransferDialog.this.closeDialog(windowEvent);
            }
        });
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(new TitledBorder(JFResourceBundle.getString("File_Location")));
        this.jLabel1.setText(JFResourceBundle.getString("Local_path_including_name_"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel1, gridBagConstraints);
        this.m_localFLD.setColumns(30);
        this.m_localFLD.setText(" ");
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_localFLD, gridBagConstraints);
        this.jLabel2.setText(JFResourceBundle.getString("File_on_execution_host_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.jLabel2, gridBagConstraints);
        this.m_remoteFLD.setColumns(30);
        this.m_remoteFLD.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFileTransferDialog.this.m_remoteFLDActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_remoteFLD, gridBagConstraints);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        this.getContentPane().add((Component)this.jPanel1, gridBagConstraints2);
        this.jPanel2.setLayout(new GridBagLayout());
        this.jPanel2.setBorder(new TitledBorder(JFResourceBundle.getString("Operation")));
        this.m_copyToRemoteSelector.setSelected(true);
        this.m_copyToRemoteSelector.setText(JFResourceBundle.getString("Copy_file_to_remote_host_before_running_job"));
        this.m_buttonGroup.add(this.m_copyToRemoteSelector);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.m_copyToRemoteSelector, gridBagConstraints3);
        this.m_copyToLocalSelector.setText(JFResourceBundle.getString("Copy_file_to_local_location_after_running_job"));
        this.m_buttonGroup.add(this.m_copyToLocalSelector);
        this.m_copyToLocalSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFileTransferDialog.this.m_copyToLocalSelectorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 1;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.m_copyToLocalSelector, gridBagConstraints3);
        this.m_appendToLocalSelector.setText(JFResourceBundle.getString("Append_file_to_local_location_after_running_job"));
        this.m_buttonGroup.add(this.m_appendToLocalSelector);
        gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(5, 5, 5, 5);
        this.jPanel2.add((Component)this.m_appendToLocalSelector, gridBagConstraints3);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        gridBagConstraints2.fill = 2;
        this.getContentPane().add((Component)this.jPanel2, gridBagConstraints2);
        this.m_okButton.setText(JFResourceBundle.getString("OK"));
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFileTransferDialog.this.m_okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.m_okButton);
        this.m_cancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFileTransferDialog.this.m_cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.m_cancelButton);
        this.m_resetButton.setText(JFResourceBundle.getString("Reset"));
        this.m_resetButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFFileTransferDialog.this.m_resetButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel3.add(this.m_resetButton);
        gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 2;
        gridBagConstraints2.fill = 2;
        this.getContentPane().add((Component)this.jPanel3, gridBagConstraints2);
        this.pack();
    }

    private void m_cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.m_fileTransferStr = null;
        this.setVisible(false);
        this.dispose();
    }

    private void m_okButtonActionPerformed(ActionEvent actionEvent) {
        String string = this.m_localFLD.getText();
        if (string == null || string.length() <= 0) {
            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("JFFileTransferEditor$ERR_noLocalPath"));
            return;
        }
        String string2 = this.m_remoteFLD.getText();
        if (string2 == null || string2.length() <= 0) {
            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("JFFileTransferEditor$ERR_noExecPath"));
            return;
        }
        String string3 = null;
        if (this.m_copyToRemoteSelector.isSelected()) {
            string3 = " > ";
        } else if (this.m_copyToLocalSelector.isSelected()) {
            string3 = " < ";
        } else if (this.m_appendToLocalSelector.isSelected()) {
            string3 = " << ";
        }
        this.m_fileTransferStr = string + string3 + string2;
        this.setVisible(false);
        this.dispose();
    }

    private void m_resetButtonActionPerformed(ActionEvent actionEvent) {
        this.m_localFLD.setText("");
        this.m_remoteFLD.setText("");
        this.m_copyToRemoteSelector.setSelected(true);
    }

    private void m_copyToLocalSelectorActionPerformed(ActionEvent actionEvent) {
    }

    private void m_remoteFLDActionPerformed(ActionEvent actionEvent) {
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    public static void main(String[] stringArray) {
        new JFFileTransferDialog((Frame)new JFrame(), JFResourceBundle.getString("local__remote")).show();
    }
}

