/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFCommon;
import com.platform.LSFJobFlow.api.JFEvent;
import com.platform.LSFJobFlow.api.JFFlow;
import com.platform.LSFJobFlow.api.JFFlowArray;
import com.platform.LSFJobFlow.api.JFFlowArrayEvent;
import com.platform.LSFJobFlow.api.JFFlowArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFFlowEvent;
import com.platform.LSFJobFlow.api.JFFlowExceptionEvent;
import com.platform.LSFJobFlow.api.JFHandler;
import com.platform.LSFJobFlow.api.JFJob;
import com.platform.LSFJobFlow.api.JFJobArray;
import com.platform.LSFJobFlow.api.JFJobArrayEvent;
import com.platform.LSFJobFlow.api.JFJobArrayExceptionEvent;
import com.platform.LSFJobFlow.api.JFJobEvent;
import com.platform.LSFJobFlow.api.JFJobExceptionEvent;
import com.platform.LSFJobFlow.ui.Debug;
import com.platform.LSFJobFlow.ui.JFAlarmDefinitionBean;
import com.platform.LSFJobFlow.ui.JFResourceBundle;
import com.platform.LSFJobFlow.ui.JFUtility;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.HashMap;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.DefaultComboBoxModel;
import javax.swing.InputVerifier;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class JFExceptionHandlerDialog
extends JDialog {
    private static final int JOB_TYPE = 0;
    private static final int ARRAY_TYPE = 1;
    private static final int FLOW_TYPE = 2;
    private static final int FLOWARRAY_TYPE = 3;
    public static final String KILL_ACTION = JFResourceBundle.getString("Kill");
    public static final String RERUN_ACTION = JFResourceBundle.getString("Rerun");
    public static final String ALARM_ACTION = JFResourceBundle.getString("Alarm");
    private static String[] s_op1 = new String[]{JFResourceBundle.getString("Greater_than"), JFResourceBundle.getString("Greater_than_or_equal_to"), JFResourceBundle.getString("Equal_to")};
    private static String[] s_op2 = new String[]{JFResourceBundle.getString("Greater_than"), JFResourceBundle.getString("Greater_than_or_equal_to"), JFResourceBundle.getString("Equal_to"), JFResourceBundle.getString("Less_than"), JFResourceBundle.getString("Less_than_or_equal_to"), JFResourceBundle.getString("Not_equal_to")};
    private static String[] s_op_trans = new String[]{">", ">=", "==", "<", "<=", "!="};
    private static String[] s_jobTypes = new String[]{JFResourceBundle.getString("Runs_more_than..."), JFResourceBundle.getString("Runs_less_than..."), JFResourceBundle.getString("Job_ends_with_exit_code...")};
    private static String[] s_arrayTypes = new String[]{JFResourceBundle.getString("Runs_more_than..."), JFResourceBundle.getString("Runs_less_than..."), JFResourceBundle.getString("The_sum_of_the_exit_codes_of_all_jobs_is..."), JFResourceBundle.getString("Number_of_unsuccessful_jobs_is...")};
    private static String[] s_flowTypes = new String[]{JFResourceBundle.getString("Runs_more_than..."), JFResourceBundle.getString("Runs_less_than..."), JFResourceBundle.getString("The_flow_has_exit_code..."), JFResourceBundle.getString("Number_of_unsuccessful_jobs_is..."), JFResourceBundle.getString("A_work_item_has_exit_code...")};
    private static String[] s_flowTypesShort = new String[]{JFResourceBundle.getString("Runs_more_than..."), JFResourceBundle.getString("Runs_less_than..."), JFResourceBundle.getString("The_flow_has_exit_code..."), JFResourceBundle.getString("Number_of_unsuccessful_jobs_is...")};
    private static String[] s_flowArrayTypes = new String[]{JFResourceBundle.getString("Runs_more_than..."), JFResourceBundle.getString("Runs_less_than..."), JFResourceBundle.getString("The_flow_has_exit_code..."), JFResourceBundle.getString("Number_of_unsuccessful_jobs_is...")};
    private int m_curType = 0;
    private DefaultComboBoxModel m_typeModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel m_opModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel m_actionModel = new DefaultComboBoxModel();
    private DefaultComboBoxModel m_workItemModel = new DefaultComboBoxModel();
    private Map m_workItems = null;
    private boolean m_editable = true;
    private JFHandler m_handler = null;
    private Object m_source = null;
    private int m_value = 0;
    private int[] m_values = null;
    private JFJob m_objAlarmJob;
    private ButtonGroup buttonGroup1;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JLabel m_actionLabel;
    private JComboBox m_actionSelector;
    private JFAlarmDefinitionBean m_alarmDefBean;
    private JButton m_cancelButton;
    private JTextField m_delayEdit;
    private JLabel m_delayLabel;
    private JLabel m_exceptionLabel;
    private JTextField m_minutesFLD;
    private JLabel m_minutesLabel;
    private JLabel m_minutesLabel2;
    private JTextField m_numberRerunFLD;
    private JLabel m_numberRerunLabel;
    private JButton m_okButton;
    private JComboBox m_operatorSelector;
    private JComboBox m_typeSelector;
    private JTextField m_valueFLD;
    private JLabel m_workItemExitCodeLabel;
    private JLabel m_workItemLabel;
    private JComboBox m_workItemSelector;

    public JFExceptionHandlerDialog(Dialog dialog, boolean bl, Object object) throws IllegalArgumentException {
        super(dialog, bl);
        this.initComponents();
        this.setInputAccessibleInfo();
        this.getRootPane().setDefaultButton(this.m_okButton);
        this.m_editable = true;
        this.m_source = object;
        this.reset(this.m_source);
        this.setTitle(JFResourceBundle.getString("JFExceptionHandlerDialog$TITLE"));
        this.setResizable(false);
    }

    public JFHandler createNewHandler() {
        this.m_editable = true;
        this.setEditable(this.m_editable);
        this.reset(this.m_source);
        this.pack();
        this.show();
        return this.m_handler;
    }

    public JFHandler openHandler(JFHandler jFHandler, boolean bl) {
        if (jFHandler == null) {
            return null;
        }
        this.m_objAlarmJob = jFHandler.getAlarmJob();
        this.m_alarmDefBean.setEditable(bl);
        this.m_alarmDefBean.setJobDefinition(this.m_objAlarmJob);
        int n = jFHandler.getAction();
        JFEvent jFEvent = jFHandler.getEvent();
        int n2 = jFHandler.getDelay();
        int n3 = jFHandler.getNumberRerun();
        int n4 = 0;
        int n5 = -1;
        int n6 = -1;
        String string = "";
        String string2 = "";
        String string3 = this.getWorkItemName(jFEvent);
        if (string3 != null) {
            n5 = 4;
            if (jFEvent instanceof JFJobEvent) {
                JFJobEvent jFJobEvent = (JFJobEvent)jFEvent;
                n6 = this.findOPIndex(jFJobEvent.getComparisonOp());
                string = JFCommon.integerArrayToString((int[])jFJobEvent.getComparisonValues());
            } else if (jFEvent instanceof JFJobArrayEvent) {
                JFJobArrayEvent jFJobArrayEvent = (JFJobArrayEvent)jFEvent;
                n6 = this.findOPIndex(jFJobArrayEvent.getComparisonOp());
                string = String.valueOf(jFJobArrayEvent.getComparisonValue());
            } else if (jFEvent instanceof JFFlowEvent) {
                JFFlowEvent jFFlowEvent = (JFFlowEvent)jFEvent;
                n6 = this.findOPIndex(jFFlowEvent.getComparisonOp());
                string = String.valueOf(jFFlowEvent.getComparisonValue());
            } else if (jFEvent instanceof JFFlowArrayEvent) {
                JFFlowArrayEvent jFFlowArrayEvent = (JFFlowArrayEvent)jFEvent;
                n6 = this.findOPIndex(jFFlowArrayEvent.getComparisonOp());
                string = String.valueOf(jFFlowArrayEvent.getComparisonValue());
            }
            this.m_workItemModel.setSelectedItem(string3);
        } else if (jFEvent instanceof JFJobEvent) {
            n5 = 2;
            n6 = this.findOPIndex(((JFJobEvent)jFEvent).getComparisonOp());
            string = JFCommon.integerArrayToString((int[])((JFJobEvent)jFEvent).getComparisonValues());
        } else if (jFEvent instanceof JFJobExceptionEvent) {
            n4 = ((JFJobExceptionEvent)jFEvent).getEventType();
            if (n4 == 3) {
                n5 = 0;
            } else if (n4 == 4) {
                n5 = 1;
            }
            string2 = String.valueOf(((JFJobExceptionEvent)jFEvent).getValue());
        } else if (jFEvent instanceof JFJobArrayEvent) {
            n4 = ((JFJobArrayEvent)jFEvent).getEventType();
            if (n4 == 2) {
                n5 = 2;
            } else if (n4 == 11) {
                n5 = 3;
            } else if (n4 == 10) {
                n5 = 4;
            }
            n6 = this.findOPIndex(((JFJobArrayEvent)jFEvent).getComparisonOp());
            string = String.valueOf(((JFJobArrayEvent)jFEvent).getComparisonValue());
        } else if (jFEvent instanceof JFJobArrayExceptionEvent) {
            n4 = ((JFJobArrayExceptionEvent)jFEvent).getEventType();
            if (n4 == 3) {
                n5 = 0;
            } else if (n4 == 4) {
                n5 = 1;
            }
            string2 = String.valueOf(((JFJobArrayExceptionEvent)jFEvent).getValue());
        } else if (jFEvent instanceof JFFlowEvent) {
            n4 = ((JFFlowEvent)jFEvent).getEventType();
            if (n4 == 2) {
                n5 = 2;
            } else if (n4 == 11) {
                n5 = 3;
            } else if (n4 == 10) {
                n5 = 4;
            }
            n6 = this.findOPIndex(((JFFlowEvent)jFEvent).getComparisonOp());
            string = String.valueOf(((JFFlowEvent)jFEvent).getComparisonValue());
        } else if (jFEvent instanceof JFFlowExceptionEvent) {
            n4 = ((JFFlowExceptionEvent)jFEvent).getEventType();
            if (n4 == 3) {
                n5 = 0;
            } else if (n4 == 4) {
                n5 = 1;
            }
            string2 = String.valueOf(((JFFlowExceptionEvent)jFEvent).getValue());
        } else if (jFEvent instanceof JFFlowArrayEvent) {
            n4 = ((JFFlowArrayEvent)jFEvent).getEventType();
            if (n4 == 2) {
                n5 = 2;
            } else if (n4 == 11) {
                n5 = 3;
            } else if (n4 == 10) {
                n5 = 4;
            }
            n6 = this.findOPIndex(((JFFlowArrayEvent)jFEvent).getComparisonOp());
            string = String.valueOf(((JFFlowArrayEvent)jFEvent).getComparisonValue());
        } else if (jFEvent instanceof JFFlowArrayExceptionEvent) {
            n4 = ((JFFlowArrayExceptionEvent)jFEvent).getEventType();
            if (n4 == 3) {
                n5 = 0;
            } else if (n4 == 4) {
                n5 = 1;
            }
            string2 = String.valueOf(((JFFlowArrayExceptionEvent)jFEvent).getValue());
        }
        if (n5 >= 0) {
            this.m_typeSelector.setSelectedIndex(n5);
        }
        this.m_editable = bl;
        this.setEditable(this.m_editable);
        if (n6 >= 0) {
            this.m_operatorSelector.setSelectedIndex(n6);
        }
        this.m_valueFLD.setText(string);
        this.m_minutesFLD.setText(string2);
        this.m_actionSelector.setSelectedIndex(0);
        this.m_delayEdit.setText(String.valueOf(n2));
        this.m_numberRerunFLD.setText(String.valueOf(n3));
        if (n == 0) {
            this.m_delayLabel.setVisible(false);
            this.m_minutesLabel2.setVisible(false);
            this.m_delayEdit.setVisible(false);
            this.m_numberRerunFLD.setVisible(false);
            this.m_numberRerunLabel.setVisible(false);
            this.m_alarmDefBean.setVisible(false);
        } else if (n == 1) {
            this.m_delayLabel.setVisible(true);
            this.m_minutesLabel2.setVisible(true);
            this.m_delayEdit.setVisible(true);
            this.m_numberRerunFLD.setVisible(true);
            this.m_numberRerunLabel.setVisible(true);
            this.m_alarmDefBean.setVisible(false);
        } else if (n == 2) {
            this.m_actionSelector.setSelectedIndex(1);
            this.m_alarmDefBean.setVisible(true);
            this.m_delayLabel.setVisible(false);
            this.m_minutesLabel2.setVisible(false);
            this.m_delayEdit.setVisible(false);
            this.m_numberRerunFLD.setVisible(false);
            this.m_numberRerunLabel.setVisible(false);
        }
        this.pack();
        this.show();
        return this.m_handler;
    }

    private String getWorkItemName(JFEvent jFEvent) {
        if (!(this.m_source instanceof JFFlow)) {
            return null;
        }
        if (jFEvent instanceof JFJobEvent) {
            return ((JFJobEvent)jFEvent).getJobName();
        }
        if (jFEvent instanceof JFJobArrayEvent) {
            return ((JFJobArrayEvent)jFEvent).getJobArrayName();
        }
        if (jFEvent instanceof JFFlowEvent) {
            if ((JFFlow)this.m_source == ((JFFlowEvent)jFEvent).getEventFlow()) {
                return null;
            }
            String string = ((JFFlow)this.m_source).getName();
            String string2 = JFUtility.getShortInstanceName(((JFFlowEvent)jFEvent).getFlowName());
            if (string.indexOf(58) == -1) {
                return string2;
            }
            if (string.equals(((JFFlowEvent)jFEvent).getAbsoluteFullFlowName())) {
                return null;
            }
            return string2;
        }
        if (jFEvent instanceof JFFlowArrayEvent) {
            return ((JFFlowArrayEvent)jFEvent).getFlowArrayName();
        }
        return null;
    }

    public void setEditable(boolean bl) {
        this.m_editable = bl;
        this.m_typeSelector.setEnabled(bl);
        this.m_typeSelector.setOpaque(bl);
        this.m_operatorSelector.setEnabled(bl);
        this.m_operatorSelector.setOpaque(bl);
        this.m_valueFLD.setEnabled(bl);
        this.m_valueFLD.setEditable(bl);
        this.m_valueFLD.setOpaque(bl);
        this.m_minutesFLD.setEnabled(bl);
        this.m_minutesFLD.setEditable(bl);
        this.m_minutesFLD.setOpaque(bl);
        this.m_actionSelector.setEditable(false);
        this.m_actionSelector.setEnabled(bl);
        this.m_actionSelector.setOpaque(bl);
        this.m_delayEdit.setEditable(bl);
        this.m_delayEdit.setEnabled(bl);
        this.m_delayEdit.setOpaque(bl);
        this.m_numberRerunFLD.setEditable(bl);
        this.m_numberRerunFLD.setEnabled(bl);
        this.m_numberRerunFLD.setOpaque(bl);
        this.m_workItemSelector.setEditable(bl);
        this.m_workItemSelector.setEnabled(bl);
        this.m_workItemSelector.setOpaque(bl);
        this.m_cancelButton.setVisible(bl);
        if (this.m_alarmDefBean != null) {
            this.m_alarmDefBean.setEditable(bl);
        }
    }

    private boolean validateField() {
        Object v;
        int n;
        if (this.m_valueFLD.isVisible()) {
            try {
                if (this.m_source instanceof JFJob) {
                    this.m_values = JFCommon.stringToIntegerArray((String)this.m_valueFLD.getText());
                } else {
                    this.m_value = Integer.parseInt(this.m_valueFLD.getText());
                }
            }
            catch (Exception exception) {
                JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_RequireNumber"));
                this.m_valueFLD.requestFocus();
                return false;
            }
        }
        if (this.m_minutesFLD.isVisible()) {
            try {
                this.m_value = Integer.parseInt(this.m_minutesFLD.getText());
                if (this.m_value <= 0) {
                    this.showAppErrorMsg("Minute field value should be greater than zero.");
                    return false;
                }
            }
            catch (Exception exception) {
                this.showAppErrorMsg(JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_RequireNumber"));
                this.m_minutesFLD.requestFocus();
                return false;
            }
        }
        if (this.m_delayEdit.isVisible()) {
            try {
                n = Integer.parseInt(this.m_delayEdit.getText());
            }
            catch (Exception exception) {
                this.showAppErrorMsg(JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_RequireNumber"));
                this.m_delayEdit.requestFocus();
                return false;
            }
            if (n < 1) {
                this.showAppErrorMsg(JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_DelayNonNeg"));
                this.m_delayEdit.requestFocus();
                return false;
            }
        }
        if (this.m_numberRerunFLD.isVisible()) {
            try {
                n = Integer.parseInt(this.m_numberRerunFLD.getText());
            }
            catch (Exception exception) {
                this.showAppErrorMsg(JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_RequireNumber"));
                this.m_numberRerunFLD.requestFocus();
                return false;
            }
            if (n < 1 || n > 50) {
                this.showAppErrorMsg(JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_NumRerunInvalid"));
                this.m_numberRerunFLD.requestFocus();
                return false;
            }
        }
        if (this.m_workItemSelector.isVisible() && (v = this.m_workItems.get(this.m_workItemSelector.getSelectedItem())) == null) {
            JFUtility.showAppErrorMsg(this, JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_InvalidWorkItem"));
            return false;
        }
        return true;
    }

    private void reset(Object object) throws IllegalArgumentException {
        if (object instanceof JFJobArray) {
            this.resetModel(this.m_typeModel, s_arrayTypes);
            this.m_curType = 1;
        } else if (object instanceof JFFlow) {
            this.m_curType = 2;
            this.resetModelFlowType((JFFlow)object);
        } else if (object instanceof JFJob) {
            this.resetModel(this.m_typeModel, s_jobTypes);
            this.m_curType = 0;
        } else if (object instanceof JFFlowArray) {
            this.m_curType = 3;
            this.resetModel(this.m_typeModel, s_flowArrayTypes);
        } else {
            throw new IllegalArgumentException();
        }
        this.m_typeSelector.setSelectedIndex(0);
        this.m_delayEdit.setText("1");
        this.m_numberRerunFLD.setText(String.valueOf(30));
        this.actionAgainstTypeSelector();
        if (this.m_alarmDefBean != null) {
            this.m_alarmDefBean.reset();
        }
    }

    private void resetModelFlowType(JFFlow jFFlow) {
        if (jFFlow == null) {
            this.resetModel(this.m_typeModel, s_flowTypesShort);
            return;
        }
        this.m_workItems = new HashMap();
        JFJob[] jFJobArray = jFFlow.getJobs();
        for (int i = 0; i < jFJobArray.length; ++i) {
            String string = jFJobArray[i].getExecutionType();
            if (string == null || !string.equals("lsf") && !string.equals("script") && !string.equals("oracle") && !string.equals("zos")) continue;
            this.m_workItems.put(jFJobArray[i].getName(), jFJobArray[i]);
        }
        JFJobArray[] jFJobArrayArray = jFFlow.getJobArrays();
        for (int i = 0; i < jFJobArrayArray.length; ++i) {
            this.m_workItems.put(jFJobArrayArray[i].getName(), jFJobArrayArray[i]);
        }
        JFFlow[] jFFlowArray = jFFlow.getFlows();
        for (int i = 0; i < jFFlowArray.length; ++i) {
            this.m_workItems.put(jFFlowArray[i].getName(), jFFlowArray[i]);
        }
        Set set = this.m_workItems.keySet();
        String[] stringArray = new String[set.size()];
        set.toArray(stringArray);
        if (stringArray.length == 0) {
            this.resetModel(this.m_typeModel, s_flowTypesShort);
        } else {
            this.resetModel(this.m_typeModel, s_flowTypes);
            this.resetModel(this.m_workItemModel, stringArray);
        }
    }

    private void resetModel(DefaultComboBoxModel defaultComboBoxModel, String[] stringArray) {
        if (defaultComboBoxModel == null) {
            return;
        }
        defaultComboBoxModel.removeAllElements();
        if (stringArray == null) {
            return;
        }
        for (int i = 0; i < stringArray.length; ++i) {
            defaultComboBoxModel.addElement(stringArray[i]);
        }
    }

    private int findOPIndex(String string) {
        if (string == null) {
            return 0;
        }
        int n = 0;
        for (int i = 0; i < s_op_trans.length; ++i) {
            if (!s_op_trans[i].equals(string)) continue;
            n = i;
            break;
        }
        return n;
    }

    private void actionAgainstTypeSelector() {
        int n = this.m_typeSelector.getSelectedIndex();
        switch (n) {
            case 0: {
                this.m_operatorSelector.setVisible(false);
                this.m_valueFLD.setVisible(false);
                this.m_minutesFLD.setVisible(true);
                this.m_minutesFLD.setText("");
                this.m_minutesFLD.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_minutesMaxFLD"));
                this.m_minutesLabel.setVisible(true);
                if (this.m_editable) {
                    this.m_minutesFLD.requestFocus();
                }
                this.m_actionModel.removeAllElements();
                this.m_actionModel.addElement(KILL_ACTION);
                this.m_actionModel.addElement(ALARM_ACTION);
                this.m_delayEdit.setVisible(false);
                this.m_delayLabel.setVisible(false);
                this.m_minutesLabel2.setVisible(false);
                this.m_numberRerunFLD.setVisible(false);
                this.m_numberRerunLabel.setVisible(false);
                this.m_workItemLabel.setVisible(false);
                this.m_workItemSelector.setVisible(false);
                this.m_workItemExitCodeLabel.setVisible(false);
                break;
            }
            case 1: {
                this.m_operatorSelector.setVisible(false);
                this.m_valueFLD.setVisible(false);
                this.m_minutesFLD.setVisible(true);
                this.m_minutesFLD.setText("");
                this.m_minutesFLD.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_minutesMinFLD"));
                this.m_minutesLabel.setVisible(true);
                if (this.m_editable) {
                    this.m_minutesFLD.requestFocus();
                }
                this.m_actionModel.removeAllElements();
                this.m_actionModel.addElement(RERUN_ACTION);
                this.m_actionModel.addElement(ALARM_ACTION);
                this.m_delayEdit.setVisible(true);
                this.m_delayLabel.setVisible(true);
                this.m_minutesLabel2.setVisible(true);
                this.m_numberRerunFLD.setVisible(true);
                this.m_numberRerunLabel.setVisible(true);
                this.m_workItemLabel.setVisible(false);
                this.m_workItemSelector.setVisible(false);
                this.m_workItemExitCodeLabel.setVisible(false);
                break;
            }
            case 2: {
                this.m_operatorSelector.setVisible(true);
                this.m_operatorSelector.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_valueGreaterEqualLessrFLD"));
                this.m_valueFLD.setVisible(true);
                this.m_valueFLD.setText("");
                if (this.m_source instanceof JFJob) {
                    this.m_valueFLD.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_exitCodeFLD"));
                } else {
                    this.m_valueFLD.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_valueExitCodeFLD"));
                }
                this.m_minutesFLD.setVisible(false);
                this.m_minutesLabel.setVisible(false);
                if (this.m_editable) {
                    this.m_valueFLD.requestFocus();
                }
                this.resetModel(this.m_opModel, s_op2);
                this.m_actionModel.removeAllElements();
                this.m_actionModel.addElement(RERUN_ACTION);
                this.m_actionModel.addElement(ALARM_ACTION);
                this.m_delayEdit.setVisible(true);
                this.m_delayLabel.setVisible(true);
                this.m_minutesLabel2.setVisible(true);
                this.m_numberRerunFLD.setVisible(true);
                this.m_numberRerunLabel.setVisible(true);
                this.m_workItemLabel.setVisible(false);
                this.m_workItemSelector.setVisible(false);
                this.m_workItemExitCodeLabel.setVisible(false);
                break;
            }
            case 3: {
                this.m_operatorSelector.setVisible(true);
                this.m_operatorSelector.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_valueGreaterEqualLessrFLD"));
                this.m_valueFLD.setVisible(true);
                this.m_valueFLD.setText("");
                this.m_valueFLD.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_valueNumUnsuccessfulFLD"));
                this.m_minutesFLD.setVisible(false);
                this.m_minutesLabel.setVisible(false);
                if (this.m_editable) {
                    this.m_valueFLD.requestFocus();
                }
                this.resetModel(this.m_opModel, s_op1);
                this.m_actionModel.removeAllElements();
                this.m_actionModel.addElement(KILL_ACTION);
                this.m_actionModel.addElement(ALARM_ACTION);
                this.m_delayEdit.setVisible(false);
                this.m_delayLabel.setVisible(false);
                this.m_minutesLabel2.setVisible(false);
                this.m_numberRerunFLD.setVisible(false);
                this.m_numberRerunLabel.setVisible(false);
                this.m_workItemLabel.setVisible(false);
                this.m_workItemSelector.setVisible(false);
                this.m_workItemExitCodeLabel.setVisible(false);
                break;
            }
            case 4: {
                this.m_workItemLabel.setVisible(true);
                this.m_workItemSelector.setVisible(true);
                this.m_workItemSelector.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_workItemSelectorFLD"));
                this.m_workItemExitCodeLabel.setVisible(true);
                this.m_operatorSelector.setVisible(true);
                this.m_operatorSelector.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_valueGreaterEqualLessrFLD"));
                this.m_valueFLD.setVisible(true);
                this.m_valueFLD.setText("");
                this.m_valueFLD.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_valueExitCodeFLD"));
                this.m_minutesFLD.setVisible(false);
                this.m_minutesLabel.setVisible(false);
                if (this.m_editable) {
                    this.m_valueFLD.requestFocus();
                }
                this.resetModel(this.m_opModel, s_op2);
                this.m_actionModel.removeAllElements();
                this.m_actionModel.addElement(RERUN_ACTION);
                this.m_delayEdit.setVisible(true);
                this.m_delayLabel.setVisible(true);
                this.m_minutesLabel2.setVisible(true);
                this.m_numberRerunFLD.setVisible(true);
                this.m_numberRerunLabel.setVisible(true);
                break;
            }
        }
        this.pack();
    }

    private void showAppErrorMsg(String string) {
        JFUtility.showAppErrorMsg(this, string);
    }

    private void setInputAccessibleInfo() {
        this.m_exceptionLabel.setLabelFor(this.m_typeSelector);
        this.m_typeSelector.getAccessibleContext().setAccessibleName(this.m_exceptionLabel.getText());
        this.m_operatorSelector.getAccessibleContext().setAccessibleName(this.m_workItemExitCodeLabel.getText());
        this.m_workItemExitCodeLabel.setLabelFor(this.m_valueFLD);
        this.m_valueFLD.getAccessibleContext().setAccessibleName(this.m_workItemExitCodeLabel.getText());
        this.m_workItemLabel.setLabelFor(this.m_minutesFLD);
        this.m_minutesFLD.getAccessibleContext().setAccessibleName(this.m_workItemLabel.getText());
        this.m_actionLabel.setLabelFor(this.m_actionSelector);
        this.m_actionSelector.getAccessibleContext().setAccessibleName(this.m_actionLabel.getText());
        this.m_delayLabel.setLabelFor(this.m_delayEdit);
        this.m_delayEdit.getAccessibleContext().setAccessibleName(this.m_delayLabel.getText());
        this.m_numberRerunLabel.setLabelFor(this.m_numberRerunFLD);
        this.m_numberRerunFLD.getAccessibleContext().setAccessibleName(this.m_numberRerunLabel.getText());
        this.m_workItemLabel.setLabelFor(this.m_workItemSelector);
        this.m_workItemSelector.getAccessibleContext().setAccessibleName(this.m_workItemLabel.getText());
    }

    public static void main(String[] stringArray) {
        Dialog dialog = new Dialog(new Frame());
        new JFExceptionHandlerDialog(dialog, true, new JFFlow("J1")).show();
    }

    private void initComponents() {
        this.buttonGroup1 = new ButtonGroup();
        this.jPanel2 = new JPanel();
        this.m_okButton = new JButton();
        this.m_cancelButton = new JButton();
        this.jPanel1 = new JPanel();
        this.m_typeSelector = new JComboBox(this.m_typeModel);
        this.m_actionLabel = new JLabel();
        this.m_actionSelector = new JComboBox(this.m_actionModel);
        this.m_exceptionLabel = new JLabel();
        this.m_minutesFLD = new JTextField();
        this.m_minutesLabel = new JLabel();
        this.m_valueFLD = new JTextField();
        this.m_operatorSelector = new JComboBox(this.m_opModel);
        this.m_delayLabel = new JLabel();
        this.m_delayEdit = new JTextField();
        this.m_minutesLabel2 = new JLabel();
        this.m_workItemLabel = new JLabel();
        this.m_workItemSelector = new JComboBox(this.m_workItemModel);
        this.m_workItemExitCodeLabel = new JLabel();
        this.m_alarmDefBean = new JFAlarmDefinitionBean();
        this.m_numberRerunFLD = new JTextField();
        this.m_numberRerunLabel = new JLabel();
        this.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                JFExceptionHandlerDialog.this.closeDialog(windowEvent);
            }
        });
        this.m_okButton.setText(JFResourceBundle.getString("OK"));
        this.m_okButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFExceptionHandlerDialog.this.m_okButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.m_okButton);
        this.m_cancelButton.setText(JFResourceBundle.getString("Cancel"));
        this.m_cancelButton.setVerifyInputWhenFocusTarget(false);
        this.m_cancelButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFExceptionHandlerDialog.this.m_cancelButtonActionPerformed(actionEvent);
            }
        });
        this.jPanel2.add(this.m_cancelButton);
        this.getContentPane().add((Component)this.jPanel2, "South");
        this.jPanel1.setLayout(new GridBagLayout());
        this.jPanel1.setBorder(BorderFactory.createTitledBorder(JFResourceBundle.getString("ExceptionHandlerDefinition$TITLE")));
        this.m_typeSelector.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_typeSelector"));
        this.m_typeSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFExceptionHandlerDialog.this.m_typeSelectorActionPerformed(actionEvent);
            }
        });
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_typeSelector, gridBagConstraints);
        this.m_actionLabel.setLabelFor(this.m_actionSelector);
        this.m_actionLabel.setText(JFResourceBundle.getString("Action_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_actionLabel, gridBagConstraints);
        this.m_actionSelector.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_actionSelector"));
        this.m_actionSelector.setMinimumSize(new Dimension(130, 26));
        this.m_actionSelector.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                JFExceptionHandlerDialog.this.m_actionSelectorActionPerformed(actionEvent);
            }
        });
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.anchor = 11;
        gridBagConstraints.insets = new Insets(2, 5, 2, 5);
        this.jPanel1.add((Component)this.m_actionSelector, gridBagConstraints);
        this.m_exceptionLabel.setLabelFor(this.m_typeSelector);
        this.m_exceptionLabel.setText(JFResourceBundle.getString("Exception_type_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_exceptionLabel, gridBagConstraints);
        this.m_minutesFLD.setMinimumSize(new Dimension(130, 21));
        this.m_minutesFLD.setPreferredSize(new Dimension(130, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_minutesFLD, gridBagConstraints);
        this.m_minutesLabel.setText(JFResourceBundle.getString("minutes"));
        this.m_minutesLabel.setMaximumSize(new Dimension(55, 21));
        this.m_minutesLabel.setMinimumSize(new Dimension(55, 21));
        this.m_minutesLabel.setPreferredSize(new Dimension(55, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_minutesLabel, gridBagConstraints);
        this.m_valueFLD.setColumns(5);
        this.m_valueFLD.setMinimumSize(new Dimension(55, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_valueFLD, gridBagConstraints);
        this.m_operatorSelector.setMinimumSize(new Dimension(130, 26));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_operatorSelector, gridBagConstraints);
        this.m_delayLabel.setLabelFor(this.m_delayEdit);
        this.m_delayLabel.setText(JFResourceBundle.getString("After_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_delayLabel, gridBagConstraints);
        this.m_delayEdit.setMinimumSize(new Dimension(130, 21));
        this.m_delayEdit.setPreferredSize(new Dimension(130, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_delayEdit, gridBagConstraints);
        this.m_minutesLabel2.setText(JFResourceBundle.getString("minutes"));
        this.m_minutesLabel2.setMaximumSize(new Dimension(55, 21));
        this.m_minutesLabel2.setMinimumSize(new Dimension(55, 21));
        this.m_minutesLabel2.setPreferredSize(new Dimension(55, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 2;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_minutesLabel2, gridBagConstraints);
        this.m_workItemLabel.setLabelFor(this.m_workItemSelector);
        this.m_workItemLabel.setText(JFResourceBundle.getString("Work_item_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_workItemLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_workItemSelector, gridBagConstraints);
        this.m_workItemExitCodeLabel.setLabelFor(this.m_operatorSelector);
        this.m_workItemExitCodeLabel.setText(JFResourceBundle.getString("Has_exit_code_"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_workItemExitCodeLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 3;
        gridBagConstraints.fill = 2;
        this.jPanel1.add((Component)this.m_alarmDefBean, gridBagConstraints);
        this.m_numberRerunFLD.setMinimumSize(new Dimension(80, 21));
        this.m_numberRerunFLD.setPreferredSize(new Dimension(80, 21));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_numberRerunFLD, gridBagConstraints);
        this.m_numberRerunLabel.setLabelFor(this.m_numberRerunFLD);
        this.m_numberRerunLabel.setText(ResourceBundle.getBundle("guiSharedResource").getString("ExceptionHandlerDialog$NumberRerunLable"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(5, 5, 5, 5);
        this.jPanel1.add((Component)this.m_numberRerunLabel, gridBagConstraints);
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.pack();
    }

    private void m_actionSelectorActionPerformed(ActionEvent actionEvent) {
        int n = this.m_actionSelector.getSelectedIndex();
        String string = (String)this.m_actionSelector.getItemAt(0);
        String string2 = (String)this.m_actionSelector.getSelectedItem();
        if (string2 != null) {
            if (string2.equals(ALARM_ACTION)) {
                if (string != null && string.equals(RERUN_ACTION)) {
                    this.m_delayLabel.setVisible(false);
                    this.m_minutesLabel2.setVisible(false);
                    this.m_delayEdit.setVisible(false);
                    this.m_numberRerunFLD.setVisible(false);
                    this.m_numberRerunLabel.setVisible(false);
                }
                this.m_alarmDefBean.setVisible(true);
            } else {
                if (string != null && string.equals(RERUN_ACTION)) {
                    this.m_delayLabel.setVisible(true);
                    this.m_minutesLabel2.setVisible(true);
                    this.m_delayEdit.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_actionRerunMinutesFLD"));
                    this.m_delayEdit.setVisible(true);
                    this.m_numberRerunFLD.setToolTipText(JFResourceBundle.getString("ExceptionHandlerDialog$TIP_actionNumberRerunFLD"));
                    this.m_numberRerunFLD.setVisible(true);
                    this.m_numberRerunLabel.setVisible(true);
                }
                this.m_alarmDefBean.setVisible(false);
            }
            this.pack();
        }
    }

    private void m_okButtonActionPerformed(ActionEvent actionEvent) {
        if (this.m_editable) {
            if (!this.validateField()) {
                return;
            }
            int n = this.m_typeSelector.getSelectedIndex();
            int n2 = 0;
            int n3 = 1;
            int n4 = 30;
            JFJobExceptionEvent jFJobExceptionEvent = null;
            String string = null;
            String string2 = (String)this.m_actionSelector.getSelectedItem();
            if (string2.equals(KILL_ACTION)) {
                n2 = 0;
            } else if (string2.equals(RERUN_ACTION)) {
                n2 = 1;
            } else if (string2.equals(ALARM_ACTION)) {
                n2 = 2;
                try {
                    this.m_objAlarmJob = this.m_alarmDefBean.getJobDefinition();
                }
                catch (Exception exception) {
                    JFUtility.showAppException(this, exception);
                    return;
                }
            }
            if (this.m_operatorSelector.isVisible()) {
                string = s_op_trans[this.m_operatorSelector.getSelectedIndex()];
            }
            try {
                switch (n) {
                    case 0: {
                        if (this.m_source instanceof JFJob) {
                            jFJobExceptionEvent = new JFJobExceptionEvent((JFJob)this.m_source, 3, this.m_value);
                            break;
                        }
                        if (this.m_source instanceof JFJobArray) {
                            jFJobExceptionEvent = new JFJobArrayExceptionEvent((JFJobArray)this.m_source, 3, this.m_value);
                            break;
                        }
                        if (this.m_source instanceof JFFlow) {
                            jFJobExceptionEvent = new JFFlowExceptionEvent((JFFlow)this.m_source, 3, this.m_value);
                            break;
                        }
                        if (!(this.m_source instanceof JFFlowArray)) break;
                        jFJobExceptionEvent = new JFFlowArrayExceptionEvent((JFFlowArray)this.m_source, 3, this.m_value);
                        break;
                    }
                    case 1: {
                        if (this.m_source instanceof JFJob) {
                            jFJobExceptionEvent = new JFJobExceptionEvent((JFJob)this.m_source, 4, this.m_value);
                            break;
                        }
                        if (this.m_source instanceof JFJobArray) {
                            jFJobExceptionEvent = new JFJobArrayExceptionEvent((JFJobArray)this.m_source, 4, this.m_value);
                            break;
                        }
                        if (this.m_source instanceof JFFlow) {
                            jFJobExceptionEvent = new JFFlowExceptionEvent((JFFlow)this.m_source, 4, this.m_value);
                            break;
                        }
                        if (!(this.m_source instanceof JFFlowArray)) break;
                        jFJobExceptionEvent = new JFFlowArrayExceptionEvent((JFFlowArray)this.m_source, 4, this.m_value);
                        break;
                    }
                    case 2: {
                        if (this.m_source instanceof JFJob) {
                            jFJobExceptionEvent = new JFJobEvent((JFJob)this.m_source, string, this.m_values);
                            break;
                        }
                        if (this.m_source instanceof JFJobArray) {
                            jFJobExceptionEvent = new JFJobArrayEvent((JFJobArray)this.m_source, 2, string, this.m_value);
                            break;
                        }
                        if (this.m_source instanceof JFFlow) {
                            jFJobExceptionEvent = new JFFlowEvent((JFFlow)this.m_source, 2, string, this.m_value);
                            break;
                        }
                        if (!(this.m_source instanceof JFFlowArray)) break;
                        jFJobExceptionEvent = new JFFlowArrayEvent((JFFlowArray)this.m_source, 2, string, this.m_value);
                        break;
                    }
                    case 3: {
                        if (this.m_source instanceof JFJobArray) {
                            jFJobExceptionEvent = new JFJobArrayEvent((JFJobArray)this.m_source, 11, string, this.m_value);
                            break;
                        }
                        if (this.m_source instanceof JFFlow) {
                            jFJobExceptionEvent = new JFFlowEvent((JFFlow)this.m_source, 11, string, this.m_value);
                            break;
                        }
                        if (!(this.m_source instanceof JFFlowArray)) break;
                        jFJobExceptionEvent = new JFFlowArrayEvent((JFFlowArray)this.m_source, 11, string, this.m_value);
                        break;
                    }
                    case 4: {
                        Object object;
                        if (!(this.m_source instanceof JFFlow) || (object = this.m_workItemSelector.getSelectedItem()) == null) break;
                        Object v = this.m_workItems.get(object);
                        if (v instanceof JFJob) {
                            jFJobExceptionEvent = new JFJobEvent((JFJob)v, string, this.m_value);
                            break;
                        }
                        if (v instanceof JFJobArray) {
                            jFJobExceptionEvent = new JFJobArrayEvent((JFJobArray)v, 2, string, this.m_value);
                            break;
                        }
                        if (v instanceof JFFlow) {
                            jFJobExceptionEvent = new JFFlowEvent((JFFlow)v, 2, string, this.m_value);
                            break;
                        }
                        if (v instanceof JFFlowArray) {
                            jFJobExceptionEvent = new JFFlowArrayEvent((JFFlowArray)v, 2, string, this.m_value);
                        }
                        break;
                    }
                }
            }
            catch (Exception exception) {
                JFUtility.showAppErrorMsg(this, exception.getMessage());
                Debug.printStackTrace(exception);
                return;
            }
            try {
                n3 = Integer.valueOf(this.m_delayEdit.getText());
            }
            catch (Exception exception) {
                n3 = 1;
            }
            try {
                n4 = Integer.valueOf(this.m_numberRerunFLD.getText());
            }
            catch (Exception exception) {
                n4 = 30;
            }
            if (jFJobExceptionEvent != null) {
                try {
                    this.m_handler = new JFHandler((JFEvent)jFJobExceptionEvent, n2, n3, n4);
                    if (n2 == 2) {
                        this.m_handler.setAlarmJob(this.m_objAlarmJob);
                    }
                }
                catch (Exception exception) {
                    JFUtility.showAppErrorMsg(this, exception.getMessage());
                    Debug.printStackTrace(exception);
                    return;
                }
            }
        }
        this.setVisible(false);
        this.dispose();
    }

    private void m_cancelButtonActionPerformed(ActionEvent actionEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private void m_typeSelectorActionPerformed(ActionEvent actionEvent) {
        this.actionAgainstTypeSelector();
    }

    private void closeDialog(WindowEvent windowEvent) {
        this.setVisible(false);
        this.dispose();
    }

    private class BeanInputVerifier
    extends InputVerifier {
        private BeanInputVerifier() {
        }

        @Override
        public boolean verify(JComponent jComponent) {
            if (jComponent == JFExceptionHandlerDialog.this.m_valueFLD && JFExceptionHandlerDialog.this.m_valueFLD.isEditable()) {
                try {
                    JFExceptionHandlerDialog.this.m_value = Integer.parseInt(JFExceptionHandlerDialog.this.m_valueFLD.getText());
                }
                catch (Exception exception) {
                    JFExceptionHandlerDialog.this.showAppErrorMsg(JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_RequireNumber"));
                    return false;
                }
            }
            if (jComponent == JFExceptionHandlerDialog.this.m_minutesFLD && JFExceptionHandlerDialog.this.m_minutesFLD.isEditable()) {
                try {
                    JFExceptionHandlerDialog.this.m_value = Integer.parseInt(JFExceptionHandlerDialog.this.m_minutesFLD.getText());
                }
                catch (Exception exception) {
                    JFExceptionHandlerDialog.this.showAppErrorMsg(JFResourceBundle.getString("JFExceptionHandlerDialog$ERR_RequireNumber"));
                    return false;
                }
            }
            return true;
        }
    }
}

