/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import java.awt.Color;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTextPane;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.text.AttributeSet;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Element;
import javax.swing.text.Style;
import javax.swing.text.StyleConstants;
import javax.swing.text.StyleContext;

public class JFDescriptionPane
extends JTextPane
implements CaretListener,
MouseMotionListener,
MouseListener {
    private String tab = "\t";
    private String newline = "\n";
    private DescriptionDocument doc = new DescriptionDocument();
    private boolean m_isXMLdoc = true;
    protected JLabel actionLabel;

    public JFDescriptionPane(String string) {
        this.setDocument(this.doc);
        this.initStylesForTextPane(this);
        this.setText(string);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addCaretListener(this);
    }

    public JFDescriptionPane() {
        this.setDocument(this.doc);
        this.initStylesForTextPane(this);
        this.addMouseMotionListener(this);
        this.addMouseListener(this);
        this.addCaretListener(this);
    }

    public void setXMLdoc(boolean bl) {
        this.m_isXMLdoc = bl;
    }

    @Override
    public void setText(String string) {
        super.setText("");
        if (string == null || string.equals("null")) {
            return;
        }
        if (this.m_isXMLdoc) {
            string = this.convertToAttrString(string);
        }
        try {
            for (int i = 0; i < string.length(); ++i) {
                this.doc.insertString(i, String.valueOf(string.charAt(i)), this.getStyle("regular"));
            }
        }
        catch (BadLocationException badLocationException) {
            // empty catch block
        }
    }

    @Override
    public String getText() {
        if (super.getText() == null) {
            return "";
        }
        String string = super.getText();
        if (this.m_isXMLdoc) {
            string = this.convertToXMLAttrString(string);
        }
        return string;
    }

    private String convertToAttrString(String string) {
        String string2 = this.replaceString(string, "&amp;", "&");
        string2 = this.replaceString(string2, "&lt;", "<");
        string2 = this.replaceString(string2, "&gt;", ">");
        string2 = this.replaceString(string2, "&quot;", "\"");
        string2 = this.replaceString(string2, "&apos;", "'");
        string2 = this.replaceString(string2, "<newline>", this.newline);
        string2 = this.replaceString(string2, "<tab>", this.tab);
        return string2;
    }

    private String convertToXMLAttrString(String string) {
        String string2 = this.replaceString(string, this.newline, "<newline>");
        string2 = this.replaceString(string2, this.tab, "<tab>");
        string2 = this.replaceString(string2, "&", "&amp;");
        string2 = this.replaceString(string2, "<", "&lt;");
        string2 = this.replaceString(string2, ">", "&gt;");
        string2 = this.replaceString(string2, "\"", "&quot;");
        string2 = this.replaceString(string2, "'", "&apos;");
        return string2;
    }

    private String replaceString(String string, String string2, String string3) {
        if (string == null) {
            return null;
        }
        if (string2 == null || string2.length() <= 0 || string3 == null) {
            return string;
        }
        int n = string2.length();
        int n2 = string3.length();
        StringBuffer stringBuffer = new StringBuffer();
        int n3 = 0;
        for (String string4 = string; string4 != null; string4 = string4.substring(n3 + n)) {
            n3 = string4.indexOf(string2);
            if (n3 < 0) {
                stringBuffer.append(string4);
                break;
            }
            stringBuffer.append(string4.substring(0, n3));
            stringBuffer.append(string3);
        }
        return stringBuffer.toString();
    }

    private boolean isURL(String string) {
        if (string.startsWith("www.")) {
            return true;
        }
        return string.startsWith("http://");
    }

    private boolean checkHyperText(JTextPane jTextPane, int n) {
        Element element = jTextPane.getStyledDocument().getCharacterElement(n);
        Enumeration<?> enumeration = element.getAttributes().getAttributeNames();
        while (enumeration.hasMoreElements()) {
            if (!element.getAttributes().getAttribute(enumeration.nextElement()).equals("hypertext")) continue;
            return true;
        }
        return false;
    }

    @Override
    public void caretUpdate(CaretEvent caretEvent) {
    }

    @Override
    public void mousePressed(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseReleased(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseEntered(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseExited(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseClicked(MouseEvent mouseEvent) {
        JTextPane jTextPane = (JTextPane)mouseEvent.getComponent();
        int n = jTextPane.viewToModel(mouseEvent.getPoint());
        String string = null;
        if (this.checkHyperText(jTextPane, n)) {
            int n2 = 1;
            int n3 = n - n2;
            try {
                while (n - n2 >= 0 && !this.getDocument().getText(n - n2, 1).trim().equals("")) {
                    string = this.getText(n - n2, n2);
                    if (this.isURL(string)) {
                        n3 = n - n2;
                    }
                    ++n2;
                }
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    @Override
    public void mouseDragged(MouseEvent mouseEvent) {
    }

    @Override
    public void mouseMoved(MouseEvent mouseEvent) {
        int n;
        JTextPane jTextPane = (JTextPane)mouseEvent.getComponent();
        if (this.checkHyperText(jTextPane, n = jTextPane.viewToModel(mouseEvent.getPoint()))) {
            jTextPane.setCursor(Cursor.getPredefinedCursor(12));
            return;
        }
        jTextPane.setCursor(Cursor.getPredefinedCursor(2));
    }

    protected void initStylesForTextPane(JTextPane jTextPane) {
        Style style = StyleContext.getDefaultStyleContext().getStyle("default");
        Style style2 = jTextPane.addStyle("regular", style);
        StyleConstants.setFontFamily(style, "SansSerif");
        Style style3 = jTextPane.addStyle("underline", style2);
        StyleConstants.setUnderline(style3, true);
        Style style4 = jTextPane.addStyle("hypertext", style3);
        StyleConstants.setForeground(style4, Color.blue);
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame();
        JFDescriptionPane jFDescriptionPane = new JFDescriptionPane("ecfwww.ecf.ca i am amn\nwith www.utoronto.ca\nhttp://www.ecf.utoronto.ca s");
        JScrollPane jScrollPane = new JScrollPane(jFDescriptionPane);
        jScrollPane.setVerticalScrollBarPolicy(22);
        jScrollPane.setPreferredSize(new Dimension(400, 400));
        jFrame.getContentPane().add(jScrollPane);
        jFrame.addWindowListener(new WindowAdapter(){

            @Override
            public void windowClosing(WindowEvent windowEvent) {
                System.exit(0);
            }
        });
        jFrame.pack();
        jFrame.setVisible(true);
    }

    class DescriptionDocument
    extends DefaultStyledDocument {
        private String m_hyperText = null;
        int counter = 0;

        @Override
        public void insertString(int n, String string, AttributeSet attributeSet) throws BadLocationException {
            AttributeSet attributeSet2 = null;
            if (string == null) {
                return;
            }
            if (string.trim().equals("")) {
                this.underlineHyperText(n);
                attributeSet2 = this.getStyle("regular").copyAttributes();
            }
            super.insertString(n, string, attributeSet2);
        }

        private void underlineHyperText(int n) {
            int n2 = 1;
            String string = null;
            String string2 = null;
            int n3 = 0;
            try {
                if (n - n2 < 0) {
                    return;
                }
                while (!this.getText(n - n2, 1).trim().equals("")) {
                    string = this.getText(n - n2, n2);
                    if (JFDescriptionPane.this.isURL(string)) {
                        string2 = string;
                        n3 = n - n2;
                    }
                    if (n - ++n2 >= 0) continue;
                }
                if (string2 != null) {
                    this.remove(n3, string2.length());
                    super.insertString(n3, string2, this.getStyle("hypertext"));
                }
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }
}

