/*
 * Decompiled with CFR 0.152.
 */
package com.platform.LSFJobFlow.ui;

import com.platform.LSFJobFlow.api.JFUser;
import com.platform.LSFJobFlow.ui.Debug;
import com.platform.LSFJobFlow.ui.JFMessage;
import com.platform.LSFJobFlow.ui.JFParser;
import com.platform.LSFJobFlow.ui.JFRecurrenceParser;
import com.platform.LSFJobFlow.ui.ParseException;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Calendar;
import java.util.StringTokenizer;
import java.util.Vector;

public class JFCalendarDefinition {
    private static final String[] weekdayStr = JFMessage.DAY_OF_WEEK;
    private static final String[] monthStr = JFMessage.MONTHABBV;
    private static final String[] weeklyStr = JFMessage.ORDER;
    private static final int[] translate = new int[]{1, 2, 3, 4, -2, -1, 0};
    private static final String[] translateInExpression = new String[]{"1", "2", "3", "4", "-3", "-2", "-1"};
    private static final String[] keyWords = new String[]{"RANGE", "month", "week", "day"};
    private static final String[] punc = new String[]{"(", ")", ",", "*", "/", ":", "|"};
    private static final int OPENBRACKET = 0;
    private static final int CLOSEBRACKET = 1;
    private static final int COMMA = 2;
    private static final int STAR = 3;
    private static final int SLASH = 4;
    private static final int COLON = 5;
    private static final int STRAIGHT = 6;
    private static final int RANGE = 0;
    private static final int MONTH = 1;
    private static final int WEEK = 2;
    private static final int DAY = 3;
    private static final int SUNDAY = 0;
    private static final int MONDAY = 1;
    private static final int TUESDAY = 2;
    private static final int WEDNESDAY = 3;
    private static final int THURSDAY = 4;
    private static final int FRIDAY = 5;
    private static final int SATURDAY = 6;
    private static String expression;
    private static String day;
    private static String step;
    private Calendar beginDate;
    private Calendar endDate;
    private Calendar startOfYear;
    private Calendar endOfYear;
    private Vector listOfDates;
    private Vector periodField;
    private Vector dayField;
    private Vector range;
    private int year;
    private int errorCode;
    private InputStream stream;

    public JFCalendarDefinition(String string, int n) {
        expression = string;
        this.stream = new ByteArrayInputStream(string.getBytes());
        this.listOfDates = new Vector();
        this.beginDate = Calendar.getInstance();
        this.endDate = Calendar.getInstance();
        this.periodField = new Vector();
        this.dayField = new Vector();
        this.range = new Vector();
        this.year = n;
        this.startOfYear = Calendar.getInstance();
        this.endOfYear = Calendar.getInstance();
        this.startOfYear.set(1, n - 1);
        this.startOfYear.set(3, 52);
        this.startOfYear.set(7, 1);
        this.endOfYear.set(1, n + 1);
        this.endOfYear.set(3, 1);
        this.endOfYear.set(7, 7);
        this.errorCode = this.parsingOneExpression(string);
    }

    public int getErrorCode() {
        return this.errorCode;
    }

    public Vector getListOfDates() {
        return this.listOfDates;
    }

    public Vector getPeriodField() {
        return this.periodField;
    }

    public Vector getDayField() {
        return this.dayField;
    }

    public Vector getRange() {
        return this.range;
    }

    public String getStep() {
        return step;
    }

    public String getDay() {
        return day;
    }

    private int isCalendarExpressionValid(String string) {
        try {
            string = JFUser.formatString((String)string);
            for (int i = 0; i < string.length(); ++i) {
                if (string.charAt(i) != '\"' && string.charAt(i) != '\\') continue;
                return -1;
            }
            String string2 = string.substring(1, string.length() - 1) + "\n";
            Vector vector = new Vector();
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            JFParser.recurrenceParser.init();
            JFRecurrenceParser.ReInit(byteArrayInputStream);
            switch (JFParser.recurrenceParser.parse()) {
                case -1: {
                    return -1;
                }
                case 2: {
                    vector = JFParser.recurrenceParser.getDates();
                    if (vector.size() == 1) {
                        this.getBeginEndDate((String)vector.elementAt(0), null);
                    } else {
                        this.getBeginEndDate((String)vector.elementAt(0), (String)vector.elementAt(1));
                    }
                    if (JFParser.recurrenceParser.getOption() == 1) {
                        step = JFParser.recurrenceParser.getStep();
                        this.processDailyList(step);
                        return 2;
                    }
                    if (JFParser.recurrenceParser.getOption() == 2) {
                        step = JFParser.recurrenceParser.getStep();
                        day = JFParser.recurrenceParser.getDay();
                        this.processWeeklyList(step, day);
                        return 3;
                    }
                    if (JFParser.recurrenceParser.getOption() == 3) {
                        step = JFParser.recurrenceParser.getStep();
                        day = JFParser.recurrenceParser.getDay();
                        StringTokenizer stringTokenizer = new StringTokenizer(day, "(");
                        String string3 = stringTokenizer.nextToken();
                        this.processWeeklyList2(step, day);
                        return 7;
                    }
                    if (JFParser.recurrenceParser.getOption() == 4) {
                        step = JFParser.recurrenceParser.getStep();
                        day = JFParser.recurrenceParser.getDay();
                        this.processMonthlyList1(step, day);
                        return 4;
                    }
                    if (JFParser.recurrenceParser.getOption() == 5) {
                        step = JFParser.recurrenceParser.getStep();
                        day = JFParser.recurrenceParser.getDay();
                        this.processMonthlyList2(step, day);
                        return 5;
                    }
                    if (JFParser.recurrenceParser.getOption() == 6) {
                        step = JFParser.recurrenceParser.getStep();
                        day = JFParser.recurrenceParser.getDay();
                        StringTokenizer stringTokenizer = new StringTokenizer(day, "(");
                        String string4 = stringTokenizer.nextToken();
                        this.processMonthlyList3(step, day);
                        return 8;
                    }
                    if (JFParser.recurrenceParser.getOption() != 7) break;
                    step = JFParser.recurrenceParser.getStep();
                    day = JFParser.recurrenceParser.getDay();
                    StringTokenizer stringTokenizer = new StringTokenizer(step, ",");
                    StringTokenizer stringTokenizer2 = new StringTokenizer(day, ",");
                    int n = stringTokenizer.countTokens();
                    for (int i = 0; i < n; ++i) {
                        this.processYearlyList(stringTokenizer.nextToken(), stringTokenizer2.nextToken());
                    }
                    return 6;
                }
                case 1: {
                    return 1;
                }
                case 3: {
                    return 9;
                }
            }
            return -1;
        }
        catch (ParseException parseException) {
            Debug.printStackTrace(parseException);
            return -1;
        }
        catch (Exception exception) {
            Debug.printStackTrace(exception);
            return -1;
        }
    }

    public int parsingOneExpression(String string) {
        String string2 = string;
        this.periodField = new Vector();
        this.dayField = new Vector();
        this.range = new Vector();
        return this.isCalendarExpressionValid(string2);
    }

    public static boolean compareCalendar(Calendar calendar, Calendar calendar2) {
        if (calendar.get(1) < calendar2.get(1)) {
            return true;
        }
        if (calendar.get(1) > calendar2.get(1)) {
            return false;
        }
        if (calendar.get(2) < calendar2.get(2)) {
            return true;
        }
        if (calendar.get(2) > calendar2.get(2)) {
            return false;
        }
        return calendar.get(5) <= calendar2.get(5);
    }

    private void getBeginEndDate(String string, String string2) throws Exception {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, "/");
            this.beginDate.set(1, Integer.parseInt(stringTokenizer.nextToken()));
            this.beginDate.set(2, Integer.parseInt(stringTokenizer.nextToken()) - 1);
            this.beginDate.set(5, Integer.parseInt(stringTokenizer.nextToken()));
            this.range.add(this.beginDate);
            if (string2 != null) {
                StringTokenizer stringTokenizer2 = new StringTokenizer(string2, "/");
                this.endDate.set(1, Integer.parseInt(stringTokenizer2.nextToken()));
                this.endDate.set(2, Integer.parseInt(stringTokenizer2.nextToken()) - 1);
                this.endDate.set(5, Integer.parseInt(stringTokenizer2.nextToken()));
                this.range.add(this.endDate);
            } else {
                this.endDate = (Calendar)this.endOfYear.clone();
                this.range.add(null);
            }
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    private void processRandomList() throws Exception {
    }

    private void processAbsoluteList(String string) throws Exception {
    }

    private void processYearlyList(String string, String string2) throws Exception {
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            calendar2 = (Calendar)this.beginDate.clone();
            boolean bl = false;
            boolean bl2 = false;
            boolean bl3 = false;
            this.periodField.add(string);
            this.dayField.add(string2);
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    private void processMonthlyList2(String string, String string2) throws Exception {
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.periodField.add(String.valueOf(n));
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            int n2 = stringTokenizer2.countTokens();
            String string5 = "";
            String string6 = "";
            for (int i = 0; i < n2; ++i) {
                StringTokenizer stringTokenizer3 = new StringTokenizer(stringTokenizer2.nextToken());
                String string7 = stringTokenizer3.nextToken().trim();
                string5 = stringTokenizer3.nextToken().trim();
                for (int j = 0; j < 7; ++j) {
                    if (!weekdayStr[j].equals(string7)) continue;
                    this.dayField.add(string5);
                    this.dayField.add(String.valueOf(j));
                }
            }
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    private void processMonthlyList1(String string, String string2) throws Exception {
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.periodField.add(String.valueOf(n));
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            int n2 = stringTokenizer2.countTokens();
            for (int i = 0; i < n2; ++i) {
                String string5 = stringTokenizer2.nextToken().trim();
                for (int j = 0; j < 31; ++j) {
                    if (j != Integer.parseInt(string5) - 1) continue;
                    this.dayField.add(String.valueOf(j));
                }
            }
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    private void processMonthlyList3(String string, String string2) throws Exception {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.periodField.add(String.valueOf(n));
            String string5 = string2;
            string5 = string5.replace(')', ' ');
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "(");
            this.dayField.add(stringTokenizer2.nextToken().trim());
            this.dayField.add(stringTokenizer2.nextToken().trim());
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    private void processWeeklyList2(String string, String string2) throws Exception {
        try {
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.periodField.add(String.valueOf(n));
            String string5 = string2;
            string5 = string5.replace(')', ' ');
            StringTokenizer stringTokenizer2 = new StringTokenizer(string5, "(");
            this.dayField.add(stringTokenizer2.nextToken().trim());
            this.dayField.add(stringTokenizer2.nextToken().trim());
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    private void processWeeklyList(String string, String string2) throws Exception {
        try {
            Calendar calendar = Calendar.getInstance();
            Calendar calendar2 = Calendar.getInstance();
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string3 = stringTokenizer.nextToken();
            String string4 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.periodField.add(String.valueOf(n));
            StringTokenizer stringTokenizer2 = new StringTokenizer(string2, ",");
            int n2 = stringTokenizer2.countTokens();
            for (int i = 0; i < n2; ++i) {
                String string5 = stringTokenizer2.nextToken().trim();
                for (int j = 0; j < 7; ++j) {
                    if (!weekdayStr[j].equals(string5)) continue;
                    this.dayField.add(String.valueOf(j));
                }
            }
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    private void processDailyList(String string) throws Exception {
        try {
            Calendar calendar = Calendar.getInstance();
            boolean bl = false;
            StringTokenizer stringTokenizer = new StringTokenizer(string, ",");
            String string2 = stringTokenizer.nextToken();
            String string3 = stringTokenizer.nextToken();
            int n = Integer.parseInt(stringTokenizer.nextToken());
            this.periodField.add(String.valueOf(n));
        }
        catch (Exception exception) {
            throw new Exception();
        }
    }

    public static void main(String[] stringArray) {
        String string = "RANGE(2001/10/15,2002/10/15):month(1,*,1):5,10,15,20,25,30";
    }

    static {
        day = null;
        step = null;
    }
}

