/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message.mimb.response;

import MITI.mimb.bridge.Bridge;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.bridge.BridgeInfo;
import MITI.mimb.message.MessageObject;
import MITI.mimb.message.mimb.response.MimbResponse;
import java.util.ArrayList;
import java.util.Collection;

public class BridgeListResponse
extends MimbResponse {
    private Collection<Bridge> bridges = new ArrayList<Bridge>();
    private boolean isExport = false;
    private boolean withSpecification = false;

    public void setIsExport(boolean bl) {
        this.isExport = bl;
    }

    public boolean isExport() {
        return this.isExport;
    }

    public Collection<Bridge> getBridges() {
        return this.bridges;
    }

    public void addBridge(Bridge bridge) {
        this.bridges.add(bridge);
    }

    public void setWithSpecification(boolean bl) {
        this.withSpecification = bl;
    }

    public boolean getWithSpecification() {
        return this.withSpecification;
    }

    @Override
    protected void deserialize(MessageObject messageObject) {
        this.isExport = messageObject.getAttribute("direction").equals("EXPORT");
        for (MessageObject messageObject2 : messageObject.list("Bridge")) {
            Bridge bridge = new Bridge(new BridgeId(messageObject2.getAttribute("bridgeIdentifier"), this.isExport ? BridgeId.Direction.EXPORT : BridgeId.Direction.IMPORT));
            bridge.setDisplayName(messageObject2.getFirstChild("DisplayName").getAttribute("bridgeDisplayName"));
            bridge.setDescription("");
            MessageObject messageObject3 = messageObject2.getFirstChild("Specification");
            if (messageObject3 != null) {
                this.withSpecification = true;
                BridgeInfo bridgeInfo = new BridgeInfo();
                bridgeInfo.setVersion(messageObject3.getAttribute("version"));
                bridgeInfo.setMethodology(messageObject3.getAttribute("methodology"));
                bridgeInfo.setProductName(messageObject3.getAttribute("productName"));
                bridgeInfo.setProductVersion(messageObject3.getAttribute("productVersion"));
                bridgeInfo.setProductCompany(messageObject3.getAttribute("productCompany"));
                bridgeInfo.setProductWeb(messageObject3.getAttribute("productWeb"));
                bridgeInfo.setMultiModel(Boolean.parseBoolean(messageObject3.getAttribute("isMultiModel")));
            }
            this.bridges.add(bridge);
        }
    }

    @Override
    protected void serialize(MessageObject messageObject) {
        MessageObject messageObject2 = messageObject.addChild("GetBridgeListResponse");
        messageObject2.setAttribute("direction", this.isExport ? "EXPORT" : "IMPORT");
        for (Bridge bridge : this.bridges) {
            MessageObject messageObject3 = messageObject2.addChild("Bridge");
            messageObject3.setAttribute("bridgeIdentifier", bridge.getBridgeId().getId());
            MessageObject messageObject4 = messageObject3.addChild("DisplayName");
            messageObject4.setAttribute("bridgeDisplayName", bridge.getDisplayName());
            if (!this.withSpecification || bridge.getInfo() == null) continue;
            MessageObject messageObject5 = messageObject3.addChild("Specification");
            messageObject5.setAttribute("version", bridge.getInfo().getVersion());
            messageObject5.setAttribute("methodology", bridge.getInfo().getMethodology());
            messageObject5.setAttribute("productName", bridge.getInfo().getProductName());
            messageObject5.setAttribute("productVersion", bridge.getInfo().getProductVersion());
            messageObject5.setAttribute("productCompany", bridge.getInfo().getProductCompany());
            messageObject5.setAttribute("productWeb", bridge.getInfo().getProductWeb());
            messageObject5.setAttribute("isMultiModel", String.valueOf(bridge.getInfo().isMultiModel()));
        }
    }
}

