/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message.mimb.response;

import MITI.mimb.bridge.Bridge;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.bridge.BridgeInfo;
import MITI.mimb.bridge.BridgeParameter;
import MITI.mimb.bridge.BridgeParameterValue;
import MITI.mimb.message.MessageObject;
import MITI.mimb.message.mimb.response.MimbResponse;
import java.util.ArrayList;
import java.util.Collection;

public class BridgeInformationResponse
extends MimbResponse {
    private Bridge bridge;

    public Bridge getBridge() {
        return this.bridge;
    }

    public void setBridge(Bridge bridge) {
        this.bridge = bridge;
    }

    @Override
    protected void deserialize(MessageObject messageObject) {
        Object object;
        this.bridge = new Bridge(new BridgeId(messageObject.getAttribute("bridgeIdentifier"), BridgeId.Direction.valueOf(messageObject.getAttribute("direction"))));
        this.bridge.setDisplayName(messageObject.getAttribute("bridgeDisplayName"));
        this.bridge.setDescription(messageObject.getAttribute("description"));
        MessageObject messageObject2 = messageObject.getFirstChild("Specification");
        if (messageObject2 != null) {
            object = new BridgeInfo();
            ((BridgeInfo)object).setVersion(messageObject2.getAttribute("version"));
            ((BridgeInfo)object).setMethodology(messageObject2.getAttribute("methodology"));
            ((BridgeInfo)object).setProductName(messageObject2.getAttribute("productName"));
            ((BridgeInfo)object).setProductVersion(messageObject2.getAttribute("productVersion"));
            ((BridgeInfo)object).setProductCompany(messageObject2.getAttribute("productCompany"));
            ((BridgeInfo)object).setProductWeb(messageObject2.getAttribute("productWeb"));
            ((BridgeInfo)object).setMultiModel(Boolean.parseBoolean(messageObject2.getAttribute("isMultiModel")));
            this.bridge.setInfo((BridgeInfo)object);
        }
        object = new ArrayList();
        for (MessageObject messageObject3 : messageObject.list("BridgeParameter")) {
            MessageObject object32;
            BridgeParameter bridgeParameter = new BridgeParameter();
            bridgeParameter.setBridgeParameterIdentifier(messageObject3.getAttribute("bridgeParameterIdentifier"));
            bridgeParameter.setDisplayName(messageObject3.getAttribute("displayName"));
            bridgeParameter.setType(BridgeParameter.ParameterType.valueOf(messageObject3.getAttribute("type")));
            bridgeParameter.setMandatory(Boolean.parseBoolean(messageObject3.getAttribute("mandatory")));
            bridgeParameter.setDeprecated(Boolean.parseBoolean(messageObject3.getAttribute("deprecated")));
            bridgeParameter.setDescription(messageObject3.getAttribute("description"));
            bridgeParameter.setTransferable(Boolean.parseBoolean(messageObject3.getAttribute("transferable")));
            if (bridgeParameter.getType() == BridgeParameter.ParameterType.FILE || bridgeParameter.getType() == BridgeParameter.ParameterType.DIRECTORY) {
                bridgeParameter.setOpenMode(BridgeParameter.OpenMode.valueOf(messageObject3.getAttribute("openMode")));
            }
            ArrayList<BridgeParameterValue> arrayList = new ArrayList<BridgeParameterValue>();
            for (MessageObject messageObject4 : messageObject3.list("PossibleValue")) {
                Object object2 = messageObject4.getAttribute("identifier");
                String string = messageObject4.getText();
                arrayList.add(new BridgeParameterValue((String)object2, string));
            }
            if (!arrayList.isEmpty()) {
                bridgeParameter.setPossibleValues(arrayList);
            }
            ArrayList arrayList2 = new ArrayList();
            for (Object object2 : messageObject3.list("FileExtension")) {
                arrayList2.add(((MessageObject)object2).getText());
            }
            if (!arrayList2.isEmpty()) {
                bridgeParameter.setFileExtensions(arrayList2);
            }
            if ((object32 = messageObject3.getFirstChild("DefaultValue")) != null) {
                bridgeParameter.setDefaultValue(new BridgeParameterValue(object32.getText()));
            }
            ((ArrayList)object).add(bridgeParameter);
        }
        this.bridge.setBridgeParameters((Collection<BridgeParameter>)object);
    }

    @Override
    protected void serialize(MessageObject messageObject) {
        MessageObject messageObject2 = messageObject.addChild("GetBridgeInformationResponse");
        messageObject2.setAttribute("bridgeIdentifier", this.bridge.getBridgeId().getId());
        messageObject2.setAttribute("direction", this.bridge.getBridgeId().getDirection().name());
        messageObject2.setAttribute("bridgeDisplayName", this.bridge.getDisplayName());
        messageObject2.setAttribute("description", this.bridge.getDescription());
        if (this.bridge.getInfo() != null) {
            MessageObject messageObject3 = messageObject2.addChild("Specification");
            messageObject3.setAttribute("version", this.bridge.getInfo().getVersion());
            messageObject3.setAttribute("methodology", this.bridge.getInfo().getMethodology());
            messageObject3.setAttribute("productName", this.bridge.getInfo().getProductName());
            messageObject3.setAttribute("productVersion", this.bridge.getInfo().getProductVersion());
            messageObject3.setAttribute("productCompany", this.bridge.getInfo().getProductCompany());
            messageObject3.setAttribute("productWeb", this.bridge.getInfo().getProductWeb());
            messageObject3.setAttribute("isMultiModel", String.valueOf(this.bridge.getInfo().isMultiModel()));
        }
        for (BridgeParameter bridgeParameter : this.bridge.getBridgeParameters()) {
            MessageObject messageObject3;
            MessageObject messageObject5 = messageObject2.addChild("BridgeParameter");
            messageObject5.setAttribute("bridgeParameterIdentifier", bridgeParameter.getBridgeParameterIdentifier());
            messageObject5.setAttribute("displayName", bridgeParameter.getDisplayName());
            messageObject5.setAttribute("type", bridgeParameter.getType().name());
            messageObject5.setAttribute("mandatory", String.valueOf(bridgeParameter.isMandatory()));
            messageObject5.setAttribute("deprecated", String.valueOf(bridgeParameter.isDeprecated()));
            messageObject5.setAttribute("description", bridgeParameter.getDescription());
            messageObject5.setAttribute("transferable", String.valueOf(bridgeParameter.isTransferable()));
            if (bridgeParameter.getType() == BridgeParameter.ParameterType.FILE || bridgeParameter.getType() == BridgeParameter.ParameterType.DIRECTORY) {
                messageObject5.setAttribute("openMode", bridgeParameter.getOpenMode().name());
            }
            if (bridgeParameter.getPossibleValues() != null) {
                for (BridgeParameterValue bridgeParameterValue : bridgeParameter.getPossibleValues()) {
                    messageObject3 = messageObject5.addChild("PossibleValue");
                    messageObject3.setAttribute("identifier", bridgeParameterValue.getId());
                    messageObject3.setText(bridgeParameterValue.getValue());
                }
            }
            if (bridgeParameter.getFileExtensions() != null) {
                for (String string : bridgeParameter.getFileExtensions()) {
                    messageObject3 = messageObject5.addChild("FileExtension");
                    messageObject3.setText(string);
                }
            }
            if (bridgeParameter.getDefaultValue() == null) continue;
            MessageObject messageObject6 = messageObject5.addChild("DefaultValue");
            messageObject6.setText(bridgeParameter.getDefaultValue().getValue());
        }
    }
}

