/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message.file.response;

import MITI.mimb.message.MessageObject;
import MITI.mimb.message.file.response.FileResponse;
import java.util.ArrayList;
import java.util.Collection;

public class ListTemporaryFilesResponse
extends FileResponse {
    private ArrayList<FileItem> files = new ArrayList();

    public ArrayList<FileItem> getFiles() {
        return this.files;
    }

    public void setFiles(ArrayList<FileItem> arrayList) {
        this.files = arrayList;
    }

    @Override
    protected void deserialize(MessageObject messageObject) {
        this.parseFiles(messageObject, this.files);
    }

    private void parseFiles(MessageObject messageObject, Collection<FileItem> collection) {
        for (MessageObject messageObject2 : messageObject.list("FileItem")) {
            FileItem fileItem = this.parseFile(messageObject2);
            collection.add(fileItem);
        }
    }

    private FileItem parseFile(MessageObject messageObject) {
        FileItem fileItem = new FileItem();
        fileItem.fileHandle = messageObject.getAttribute("fileHandle");
        fileItem.name = messageObject.getAttribute("name");
        fileItem.isDirectory = Boolean.parseBoolean(messageObject.getAttribute("isDirectory"));
        if (!fileItem.isDirectory) {
            try {
                fileItem.size = Long.parseLong(messageObject.getAttribute("fileSize"));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            fileItem.checksum = messageObject.getAttribute("fileChecksum");
        } else {
            fileItem.children = new ArrayList();
            this.parseFiles(messageObject, fileItem.children);
        }
        return fileItem;
    }

    @Override
    protected void serialize(MessageObject messageObject) {
        MessageObject messageObject2 = messageObject.addChild("ListTemporaryFilesResponse");
        for (FileItem fileItem : this.files) {
            this.buildFile(messageObject2, fileItem);
        }
    }

    private void buildFile(MessageObject messageObject, FileItem fileItem) {
        MessageObject messageObject2 = messageObject.addChild("FileItem");
        messageObject2.setAttribute("fileHandle", fileItem.fileHandle);
        messageObject2.setAttribute("name", fileItem.name);
        messageObject2.setAttribute("isDirectory", String.valueOf(fileItem.isDirectory));
        if (fileItem.isDirectory) {
            if (fileItem.children != null) {
                for (FileItem fileItem2 : fileItem.children) {
                    this.buildFile(messageObject2, fileItem2);
                }
            }
        } else {
            messageObject2.setAttribute("fileSize", String.valueOf(fileItem.size));
            messageObject2.setAttribute("fileChecksum", fileItem.checksum);
        }
    }

    public static class FileItem {
        public String fileHandle;
        public String name;
        public boolean isDirectory;
        public ArrayList<FileItem> children;
        public long size;
        public String checksum;
    }
}

