/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message;

import MITI.mimb.driver.DriverError;
import MITI.mimb.message.ErrorResponse;
import MITI.mimb.message.Message;
import MITI.mimb.message.XmlMessageObject;
import MITI.mimb.message.XmlUtil;
import MITI.mimb.message.file.response.DeleteTemporaryDirectoryResponse;
import MITI.mimb.message.file.response.DeleteTemporaryFileResponse;
import MITI.mimb.message.file.response.DownloadTemporaryFileResponse;
import MITI.mimb.message.file.response.GenerateTemporaryDirectoryResponse;
import MITI.mimb.message.file.response.GenerateTemporaryFileResponse;
import MITI.mimb.message.file.response.ListTemporaryFilesResponse;
import MITI.mimb.message.file.response.UploadTemporaryFileResponse;
import MITI.mimb.message.license.response.GetOemLicenseTokenChallengeResponse;
import MITI.mimb.message.license.response.GetOemLicenseTokenResponse;
import MITI.mimb.message.mimb.response.BridgeInformationResponse;
import MITI.mimb.message.mimb.response.BridgeListResponse;
import MITI.mimb.message.mimb.response.BridgeSpecsResponse;
import MITI.mimb.message.mimb.response.CreateProcessResponse;
import MITI.mimb.message.mimb.response.GetMimbExecutionStatusResponse;
import MITI.mimb.message.mimb.response.MimbErrorResponse;
import MITI.mimb.message.mimb.response.RunMimbResponse;
import MITI.mimb.message.mimb.response.StartMimbResponse;
import MITI.mimb.message.mimb.response.StopMimbResponse;
import java.util.HashMap;
import org.w3c.dom.Element;

public abstract class Response
extends Message {
    private static HashMap<String, Class<? extends Response>> responses = new HashMap();

    protected static void addResponseType(String string, Class<? extends Response> clazz) {
        responses.put(string, clazz);
    }

    protected Response() {
    }

    public static Response fromXml(String string) throws DriverError {
        if (string == null) {
            throw new DriverError("MIMB failed with no response");
        }
        Element element = XmlUtil.parse(string);
        if (element == null) {
            throw new DriverError("MIMB failed with no response");
        }
        Response response = null;
        String string2 = XmlUtil.getNodeName(element);
        Class<? extends Response> clazz = responses.get(string2);
        if (clazz != null) {
            try {
                response = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                response.deserialize(new XmlMessageObject(element));
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                throw new DriverError(reflectiveOperationException);
            }
        }
        if (response == null) {
            throw new DriverError("Null response");
        }
        if (response instanceof ErrorResponse) {
            throw ((ErrorResponse)response).getError();
        }
        return response;
    }

    static {
        Response.addResponseType("Fault", ErrorResponse.class);
        Response.addResponseType("GenerateTemporaryDirectoryResponse", GenerateTemporaryDirectoryResponse.class);
        Response.addResponseType("GenerateTemporaryFileResponse", GenerateTemporaryFileResponse.class);
        Response.addResponseType("DeleteTemporaryDirectoryResponse", DeleteTemporaryDirectoryResponse.class);
        Response.addResponseType("DeleteTemporaryFileResponse", DeleteTemporaryFileResponse.class);
        Response.addResponseType("ListTemporaryFilesResponse", ListTemporaryFilesResponse.class);
        Response.addResponseType("DownloadTemporaryFileResponse", DownloadTemporaryFileResponse.class);
        Response.addResponseType("UploadTemporaryFileResponse", UploadTemporaryFileResponse.class);
        Response.addResponseType("GetOemLicenseTokenChallengeResponse", GetOemLicenseTokenChallengeResponse.class);
        Response.addResponseType("GetOemLicenseTokenResponse", GetOemLicenseTokenResponse.class);
        Response.addResponseType("GetBridgeListResponse", BridgeListResponse.class);
        Response.addResponseType("GetBridgeSpecsResponse", BridgeSpecsResponse.class);
        Response.addResponseType("GetBridgeInformationResponse", BridgeInformationResponse.class);
        Response.addResponseType("CreateProcessResponse", CreateProcessResponse.class);
        Response.addResponseType("GetMimbExecutionStatusResponse", GetMimbExecutionStatusResponse.class);
        Response.addResponseType("StartMimbResponse", StartMimbResponse.class);
        Response.addResponseType("StopMimbExecutionResponse", StopMimbResponse.class);
        Response.addResponseType("MimbErrorResponse", MimbErrorResponse.class);
        Response.addResponseType("RunMimbResponse", RunMimbResponse.class);
    }
}

