/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message;

import MITI.mimb.driver.DriverError;
import MITI.mimb.message.Message;
import MITI.mimb.message.MessageObject;
import MITI.mimb.message.XmlMessageObject;
import MITI.mimb.message.XmlUtil;
import MITI.mimb.message.file.request.DeleteTemporaryDirectoryRequest;
import MITI.mimb.message.file.request.DeleteTemporaryFileRequest;
import MITI.mimb.message.file.request.DownloadTemporaryFileRequest;
import MITI.mimb.message.file.request.GenerateTemporaryDirectoryRequest;
import MITI.mimb.message.file.request.GenerateTemporaryFileRequest;
import MITI.mimb.message.file.request.ListTemporaryFilesRequest;
import MITI.mimb.message.file.request.UploadTemporaryFileRequest;
import MITI.mimb.message.license.request.GetOemLicenseTokenChallengeRequest;
import MITI.mimb.message.license.request.GetOemLicenseTokenRequest;
import MITI.mimb.message.mimb.request.BrowseRequest;
import MITI.mimb.message.mimb.request.CreateProcessRequest;
import MITI.mimb.message.mimb.request.GetBridgeInformationRequest;
import MITI.mimb.message.mimb.request.GetBridgeListRequest;
import MITI.mimb.message.mimb.request.GetBridgeSpecsRequest;
import MITI.mimb.message.mimb.request.GetMimbExecutionStatusRequest;
import MITI.mimb.message.mimb.request.RunMimbExtendedRequest;
import MITI.mimb.message.mimb.request.RunMimbGenericOperationRequest;
import MITI.mimb.message.mimb.request.StopMimbRequest;
import MITI.mimb.message.mimb.request.TestRequest;
import java.util.HashMap;
import org.w3c.dom.Element;

public abstract class Request
extends Message {
    private static HashMap<String, Class<? extends Request>> requests = new HashMap();

    protected static void addRequestType(String string, Class<? extends Request> clazz) {
        requests.put(string, clazz);
    }

    public static Request fromXml(String string) throws DriverError {
        Element element = XmlUtil.parse(string);
        return Request.parse(element != null ? new XmlMessageObject(element) : null);
    }

    protected static Request parse(MessageObject messageObject) throws DriverError {
        if (messageObject == null) {
            throw new DriverError("MIMB failed with no response");
        }
        Request request = null;
        String string = messageObject.getName();
        Class<? extends Request> clazz = requests.get(string);
        if (clazz != null) {
            try {
                request = clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                request.deserialize(messageObject);
            }
            catch (ReflectiveOperationException reflectiveOperationException) {
                // empty catch block
            }
        }
        return request;
    }

    public abstract String getService();

    static {
        Request.addRequestType("GenerateTemporaryDirectoryRequest", GenerateTemporaryDirectoryRequest.class);
        Request.addRequestType("GenerateTemporaryFileRequest", GenerateTemporaryFileRequest.class);
        Request.addRequestType("DeleteTemporaryDirectoryRequest", DeleteTemporaryDirectoryRequest.class);
        Request.addRequestType("DeleteTemporaryFileRequest", DeleteTemporaryFileRequest.class);
        Request.addRequestType("ListTemporaryFilesRequest", ListTemporaryFilesRequest.class);
        Request.addRequestType("DownloadTemporaryFileRequest", DownloadTemporaryFileRequest.class);
        Request.addRequestType("UploadTemporaryFileRequest", UploadTemporaryFileRequest.class);
        Request.addRequestType("GetOemLicenseTokenChallengeRequest", GetOemLicenseTokenChallengeRequest.class);
        Request.addRequestType("GetOemLicenseTokenRequest", GetOemLicenseTokenRequest.class);
        Request.addRequestType("GetBridgeListRequest", GetBridgeListRequest.class);
        Request.addRequestType("GetBridgeSpecsRequest", GetBridgeSpecsRequest.class);
        Request.addRequestType("GetBridgeInformationRequest", GetBridgeInformationRequest.class);
        Request.addRequestType("GetMimbExecutionStatusRequest", GetMimbExecutionStatusRequest.class);
        Request.addRequestType("CreateProcessRequest", CreateProcessRequest.class);
        Request.addRequestType("BrowseRequest", BrowseRequest.class);
        Request.addRequestType("TestMimbRequest", TestRequest.class);
        Request.addRequestType("RunMimbExtendedRequest", RunMimbExtendedRequest.class);
        Request.addRequestType("RunMimbGenericOperationRequest", RunMimbGenericOperationRequest.class);
        Request.addRequestType("StopMimbExecutionRequest", StopMimbRequest.class);
        Request.addRequestType("RunMimbRequest", RunMimbExtendedRequest.class);
        Request.addRequestType("StartBrowseRequest", RunMimbExtendedRequest.class);
        Request.addRequestType("StartTestMimbRequest", TestRequest.class);
        Request.addRequestType("StartMimbRequest", RunMimbExtendedRequest.class);
        Request.addRequestType("StartMimbExtendedRequest", RunMimbExtendedRequest.class);
    }
}

