/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.message;

import MITI.mimb.driver.MimbError;
import MITI.mimb.message.MessageObject;
import MITI.mimb.message.mimb.response.MimbResponse;
import java.util.ArrayList;

public class ErrorResponse
extends MimbResponse {
    private MimbError error;

    public MimbError getError() {
        return this.error;
    }

    public void setError(MimbError mimbError) {
        this.error = mimbError;
    }

    @Override
    public void deserialize(MessageObject messageObject) {
        this.error = this.parseException(messageObject.getFirstChild("detail").getFirstChild("MimbAgentException"));
        if (this.error == null) {
            this.error = new MimbError("Unknown error");
        }
        this.error.setFaultString(messageObject.getFirstChild("faultstring").getText());
        this.error.setFaultCode(messageObject.getFirstChild("faultcode").getText());
    }

    private MimbError parseException(MessageObject messageObject) {
        MimbError mimbError = null;
        if (messageObject != null) {
            mimbError = new MimbError(messageObject.getAttribute("errorMessage"));
            mimbError.setStackTraceLines(this.parseStackTraceLines(messageObject.getFirstChild("StackTraceLines")));
            mimbError.setCause(this.parseException(messageObject.getFirstChild("CauseException")));
        }
        return mimbError;
    }

    private ArrayList<String> parseStackTraceLines(MessageObject messageObject) {
        ArrayList<String> arrayList = new ArrayList<String>();
        for (MessageObject messageObject2 : messageObject.list("StackTraceLine")) {
            String string = messageObject2.getText();
            if (string == null) continue;
            arrayList.add(string);
        }
        return arrayList;
    }

    @Override
    protected void serialize(MessageObject messageObject) {
        MessageObject messageObject2 = messageObject.addChild("Fault");
        messageObject2.addChild("faultcode").setText(this.error.getFaultCode());
        messageObject2.addChild("faultstring").setText(this.error.getFaultString());
        MessageObject messageObject3 = messageObject2.addChild("detail").addChild("MimbAgentException");
        this.printException(this.error, messageObject3);
    }

    private void printException(MimbError mimbError, MessageObject messageObject) {
        MessageObject messageObject2;
        messageObject.setAttribute("errorMessage", mimbError.getMessage());
        if (mimbError.getStackTraceLines() != null) {
            messageObject2 = messageObject.addChild("StackTraceLines");
            for (String string : mimbError.getStackTraceLines()) {
                messageObject2.addChild("StackTraceLine").setText(string);
            }
        }
        if (mimbError.getCause() != null) {
            messageObject2 = messageObject.addChild("CauseException");
            this.printException(mimbError.getCause(), messageObject2);
        }
    }
}

