/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.log;

import MITI.mimb.log.MimbLogLevel;
import MITI.mimb.message.XmlUtil;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.TimeZone;
import org.w3c.dom.Element;

public class MimbLogEvent {
    private String sessionId;
    private String threadId;
    private String code;
    private MimbLogLevel level;
    private long time;
    private String text;
    private String stackTrace;

    public MimbLogEvent(String string) {
        this.text = string;
        this.level = MimbLogLevel.NONE;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public void setSessionId(String string) {
        this.sessionId = string;
    }

    public String getThreadId() {
        return this.threadId;
    }

    public void setThreadId(String string) {
        this.threadId = string;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String string) {
        this.code = string;
    }

    public MimbLogLevel getLevel() {
        return this.level;
    }

    public void setLevel(MimbLogLevel mimbLogLevel) {
        this.level = mimbLogLevel;
    }

    public long getTime() {
        return this.time;
    }

    public void setTime(long l) {
        this.time = l;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String string) {
        this.text = string;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public void setStackTrace(String string) {
        this.stackTrace = string;
    }

    public void parseXml(Element element) {
        if (element != null) {
            this.threadId = element.getAttribute("threadId");
            this.code = element.getAttribute("code");
            this.level = MimbLogLevel.get(element.getAttribute("type"));
            if (this.level == null) {
                this.level = MimbLogLevel.NONE;
            }
            if (element.hasAttribute("stackTrace")) {
                this.stackTrace = element.getAttribute("stackTrace");
            }
            this.time = this.parseUtcDate(element.getAttribute("timestamp"));
            this.text = XmlUtil.getElementValue(element);
        }
    }

    public void buildXml(Element element) {
        if (element != null) {
            element.setAttribute("threadId", this.threadId);
            element.setAttribute("code", this.code);
            element.setAttribute("type", this.level.getName());
            if (this.stackTrace != null) {
                element.setAttribute("stackTrace", this.stackTrace);
            }
            element.setAttribute("timestamp", this.formatUtcDate(this.time));
            element.appendChild(element.getOwnerDocument().createTextNode(this.text));
        }
    }

    private String formatUtcDate(long l) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        return simpleDateFormat.format(new Date(l));
    }

    private long parseUtcDate(String string) {
        if (!string.isEmpty()) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
            simpleDateFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
            try {
                return simpleDateFormat.parse(string).getTime();
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return 0L;
    }
}

