/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.remote;

import MITI.mimb.bridge.BridgeParameter;
import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.impl.remote.MimbClient;
import MITI.mimb.driver.impl.remote.MimbFile;
import MITI.mimb.driver.impl.remote.OemToken;
import MITI.mimb.driver.impl.remote.RemoteClientProcess;
import MITI.mimb.log.MimbLog;
import MITI.mimb.log.MimbLogEvent;
import MITI.mimb.message.Response;
import MITI.mimb.message.mimb.request.GetMimbExecutionStatusRequest;
import MITI.mimb.message.mimb.response.GetMimbExecutionStatusResponse;
import java.util.Collection;

public class RemoteMimbProcess
extends RemoteClientProcess {
    private Collection<MimbFile> remoteFiles;

    RemoteMimbProcess(MimbClient mimbClient, MimbSession mimbSession, Collection<MimbFile> collection, MimbLog mimbLog, OemToken oemToken, RequestOptions requestOptions) {
        super(mimbClient, mimbSession, mimbLog, oemToken, requestOptions);
        this.remoteFiles = collection;
    }

    @Override
    protected boolean runInternal() {
        GetMimbExecutionStatusRequest getMimbExecutionStatusRequest = new GetMimbExecutionStatusRequest();
        getMimbExecutionStatusRequest.setSessionId(this.getSession().getSessionId());
        getMimbExecutionStatusRequest.setMaxLogLines(this.getLog() != null ? this.getLog().getLineCount() : 0);
        boolean bl = false;
        boolean bl2 = true;
        while (bl2) {
            try {
                Response response = this.call(getMimbExecutionStatusRequest);
                if (response instanceof GetMimbExecutionStatusResponse) {
                    GetMimbExecutionStatusResponse object = (GetMimbExecutionStatusResponse)response;
                    if (!object.isRunning()) {
                        bl = object.isSuccessful();
                        boolean bl3 = bl2 = this.getLog() != null ? object.isHasMoreLines() : false;
                    }
                    if (this.getLog() != null) {
                        for (MimbLogEvent mimbLogEvent : object.getLogEvents()) {
                            this.getLog().printEvent(mimbLogEvent);
                        }
                    }
                    try {
                        if (!bl2 || !object.getLogEvents().isEmpty()) continue;
                        Thread.sleep(500L);
                        continue;
                    }
                    catch (InterruptedException interruptedException) {}
                }
            }
            catch (DriverError driverError) {
                driverError.printStackTrace();
            }
            bl2 = false;
            break;
        }
        for (MimbFile mimbFile : this.remoteFiles) {
            if (!bl && !MimbFile.BACKUP.getParameterId().equals(mimbFile.getParameterId()) || mimbFile.getOpenMode() != BridgeParameter.OpenMode.READWRITE && mimbFile.getOpenMode() != BridgeParameter.OpenMode.WRITE) continue;
            try {
                this.download(mimbFile.getLocalFile().getFile(), mimbFile.getRemoteFile());
            }
            catch (DriverError driverError) {
                driverError.printStackTrace();
            }
        }
        return bl;
    }
}

