/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.remote;

import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.impl.MimbProcess;
import MITI.mimb.driver.impl.remote.MimbClient;
import MITI.mimb.driver.impl.remote.OemToken;
import MITI.mimb.driver.impl.remote.RemoteFile;
import MITI.mimb.log.MimbLog;
import MITI.mimb.message.Request;
import MITI.mimb.message.Response;
import MITI.mimb.message.file.request.DeleteTemporaryDirectoryRequest;
import MITI.mimb.message.file.request.DeleteTemporaryFileRequest;
import MITI.mimb.message.mimb.request.StopMimbRequest;
import java.io.File;

public abstract class RemoteClientProcess
extends MimbProcess {
    private MimbClient client;
    private OemToken token;
    private RequestOptions options;

    protected RemoteClientProcess(MimbClient mimbClient, MimbSession mimbSession, MimbLog mimbLog, OemToken oemToken, RequestOptions requestOptions) {
        super(mimbSession, mimbLog);
        this.client = mimbClient;
        this.token = oemToken;
        this.options = requestOptions;
    }

    @Override
    public void stop() throws DriverError {
        StopMimbRequest stopMimbRequest = new StopMimbRequest();
        stopMimbRequest.setSessionId(this.getSession().getSessionId());
        this.client.call(stopMimbRequest, this.token, this.options);
    }

    protected Response call(Request request) throws DriverError {
        return this.client.call(request, this.token, this.options);
    }

    protected void delete(RemoteFile remoteFile) throws DriverError {
        if (remoteFile != null) {
            if (remoteFile.isDirectory()) {
                DeleteTemporaryDirectoryRequest deleteTemporaryDirectoryRequest = new DeleteTemporaryDirectoryRequest();
                deleteTemporaryDirectoryRequest.setSessionId(this.getSession().getSessionId());
                deleteTemporaryDirectoryRequest.setFileHandle(remoteFile.getHandle());
                this.client.call(deleteTemporaryDirectoryRequest, this.token, this.options);
            } else {
                DeleteTemporaryFileRequest deleteTemporaryFileRequest = new DeleteTemporaryFileRequest();
                deleteTemporaryFileRequest.setSessionId(this.getSession().getSessionId());
                deleteTemporaryFileRequest.setFileHandle(remoteFile.getHandle());
                this.client.call(deleteTemporaryFileRequest, this.token, this.options);
            }
        }
    }

    protected void download(File file, RemoteFile remoteFile) throws DriverError {
        this.client.downloadFile(file, remoteFile, this.getSession().getSessionId(), this.token, this.options);
    }
}

