/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl.local;

import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.impl.MimbProcess;
import MITI.mimb.driver.impl.local.MimbLogOutputStream;
import MITI.mimb.driver.impl.local.ProcessMonitor;
import MITI.mimb.log.MimbLog;
import MITI.mimb.message.mimb.request.MimbRequest;
import MITI.mimb.message.mimb.response.MimbErrorResponse;
import MITI.mimb.message.mimb.response.MimbResponse;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Locale;
import java.util.concurrent.TimeUnit;

public class LocalMimbProcess
extends MimbProcess {
    private static final String UTF8 = "UTF-8";
    private static final boolean IS_WINDOWS = System.getProperty("os.name").toLowerCase(Locale.ENGLISH).contains("win");
    private File mimbHome;
    private String oemToken;
    private MimbRequest request;
    private MimbResponse response;
    private File tsDir;

    LocalMimbProcess(File file, String string, MimbRequest mimbRequest, MimbSession mimbSession, MimbLog mimbLog, File file2) {
        super(mimbSession, mimbLog);
        this.mimbHome = file;
        this.oemToken = string;
        this.request = mimbRequest;
        this.tsDir = file2;
    }

    MimbResponse getResponse() throws DriverError {
        if (this.response == null) {
            throw new DriverError("Null response");
        }
        return this.response;
    }

    protected static File getFile(File file) {
        return new File(file, "bin/MIMB." + (IS_WINDOWS ? "bat" : "sh"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected boolean runInternal() {
        int n = 1;
        try {
            File file = LocalMimbProcess.getFile(this.mimbHome);
            ProcessMonitor processMonitor = ProcessMonitor.create();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add(file.getAbsolutePath());
            arrayList.add("-r");
            arrayList.add("STDIN");
            if (!processMonitor.getPath().isEmpty()) {
                arrayList.add("-s");
                arrayList.add(processMonitor.getPath());
            }
            if (this.tsDir != null && this.tsDir.isDirectory()) {
                arrayList.add("-ts");
                arrayList.add(this.tsDir.getAbsolutePath());
            }
            ProcessBuilder processBuilder = new ProcessBuilder(arrayList);
            processBuilder.directory(this.mimbHome);
            if (this.oemToken != null) {
                processBuilder.environment().put("MITI_OEM_TOKEN", this.oemToken);
            }
            Process process = processBuilder.start();
            LocalMimbProcess.redirectStream(new BufferedReader(new StringReader(this.request.toXml())), new PrintStream(process.getOutputStream(), false, UTF8), true);
            LocalStream localStream = new LocalStream();
            Thread thread = LocalMimbProcess.redirectStream(new BufferedReader(new InputStreamReader(process.getInputStream(), UTF8)), localStream, false);
            PrintStream printStream = this.getLog() != null ? new MimbLogOutputStream(this.getLog()) : new LocalStream();
            Thread thread2 = LocalMimbProcess.redirectStream(new BufferedReader(new InputStreamReader(process.getErrorStream(), UTF8)), printStream, false);
            try {
                processMonitor.start();
                n = process.waitFor();
            }
            catch (InterruptedException interruptedException) {
                processMonitor.send();
                try {
                    process.waitFor(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException interruptedException2) {
                    // empty catch block
                }
                if (process.isAlive()) {
                    process.destroy();
                }
                thread.interrupt();
                if (thread2 != null) {
                    thread2.interrupt();
                }
            }
            finally {
                processMonitor.stop();
                try {
                    thread.join();
                }
                catch (InterruptedException interruptedException) {}
                try {
                    thread2.join();
                }
                catch (InterruptedException interruptedException) {}
            }
            ((PrintStream)localStream).flush();
            printStream.flush();
            this.response = MimbResponse.fromXml(((Object)localStream).toString());
        }
        catch (DriverError | IOException exception) {
            this.response = new MimbErrorResponse();
            ((MimbErrorResponse)this.response).setErrorCode(n);
            ((MimbErrorResponse)this.response).setErrorMessage(exception.getMessage());
        }
        return n == 0;
    }

    private static Thread redirectStream(final Reader reader, final PrintStream printStream, final boolean bl) throws IOException {
        Thread thread = new Thread(new Runnable(){

            @Override
            public void run() {
                int n = 0;
                char[] cArray = new char[1024];
                do {
                    try {
                        n = reader.read(cArray);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    if (n > 0) {
                        for (int i = 0; i < n; ++i) {
                            printStream.print(cArray[i]);
                        }
                    } else {
                        if (n != 0) continue;
                        try {
                            Thread.sleep(10L);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                } while (n != -1 && !Thread.currentThread().isInterrupted());
                if (bl) {
                    printStream.flush();
                    printStream.close();
                }
            }
        });
        thread.start();
        return thread;
    }

    private class LocalStream
    extends PrintStream {
        private StringBuilder sb;

        public LocalStream() {
            super(new ByteArrayOutputStream());
            this.sb = new StringBuilder();
        }

        @Override
        public void print(char c) {
            this.sb.append(c);
        }

        @Override
        public void flush() {
        }

        @Override
        public void close() {
        }

        public String toString() {
            return this.sb.toString();
        }
    }
}

