/*
 * Decompiled with CFR 0.152.
 */
package MITI.mimb.driver.impl;

import MITI.mimb.bridge.Bridge;
import MITI.mimb.bridge.BridgeId;
import MITI.mimb.bridge.BridgeSpecification;
import MITI.mimb.driver.BridgeConfiguration;
import MITI.mimb.driver.DriverError;
import MITI.mimb.driver.MimbDriver;
import MITI.mimb.driver.MimbError;
import MITI.mimb.driver.MimbSession;
import MITI.mimb.driver.MimbStatus;
import MITI.mimb.driver.RequestOptions;
import MITI.mimb.driver.ValidationLevel;
import MITI.mimb.driver.impl.MimbProcess;
import MITI.mimb.log.MimbLog;
import MITI.mimb.log.MimbLogLevel;
import MITI.mimb.message.ErrorResponse;
import MITI.mimb.message.mimb.request.BridgeConfig;
import MITI.mimb.message.mimb.request.BrowseRequest;
import MITI.mimb.message.mimb.request.GetBridgeInformationRequest;
import MITI.mimb.message.mimb.request.GetBridgeListRequest;
import MITI.mimb.message.mimb.request.GetBridgeSpecsRequest;
import MITI.mimb.message.mimb.request.MimbRequest;
import MITI.mimb.message.mimb.request.RunMimbExtendedRequest;
import MITI.mimb.message.mimb.request.StartMimbRequest;
import MITI.mimb.message.mimb.request.TestRequest;
import MITI.mimb.message.mimb.response.BridgeInformationResponse;
import MITI.mimb.message.mimb.response.BridgeListResponse;
import MITI.mimb.message.mimb.response.BridgeSpecsResponse;
import MITI.mimb.message.mimb.response.MimbErrorResponse;
import MITI.mimb.message.mimb.response.MimbResponse;
import java.io.File;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public abstract class MimbDriverImpl
implements MimbDriver {
    protected ConcurrentHashMap<MimbSession, MimbProcess> mimbSessions = new ConcurrentHashMap();

    @Override
    public Collection<Bridge> getBridgeList(BridgeId.Direction direction, RequestOptions requestOptions) throws DriverError {
        GetBridgeListRequest getBridgeListRequest = this.buildRequest(new GetBridgeListRequest(), requestOptions);
        getBridgeListRequest.setIsExport(direction == BridgeId.Direction.EXPORT);
        MimbResponse mimbResponse = this.run(getBridgeListRequest, requestOptions);
        if (mimbResponse instanceof BridgeListResponse) {
            return ((BridgeListResponse)mimbResponse).getBridges();
        }
        this.checkError(mimbResponse);
        return null;
    }

    @Override
    public BridgeSpecification getBridgeSpecification(BridgeId bridgeId, RequestOptions requestOptions) throws DriverError {
        GetBridgeSpecsRequest getBridgeSpecsRequest = this.buildRequest(new GetBridgeSpecsRequest(), requestOptions);
        getBridgeSpecsRequest.setBridgeId(bridgeId.getId());
        getBridgeSpecsRequest.setExport(bridgeId.getDirection() == BridgeId.Direction.EXPORT);
        MimbResponse mimbResponse = this.run(getBridgeSpecsRequest, requestOptions);
        if (mimbResponse instanceof BridgeSpecsResponse) {
            return ((BridgeSpecsResponse)mimbResponse).getBridgeSpec(bridgeId);
        }
        this.checkError(mimbResponse);
        return null;
    }

    @Override
    public Bridge getBridge(BridgeId bridgeId, RequestOptions requestOptions) throws DriverError {
        GetBridgeInformationRequest getBridgeInformationRequest = this.buildRequest(new GetBridgeInformationRequest(), requestOptions);
        getBridgeInformationRequest.setBridgeId(bridgeId);
        MimbResponse mimbResponse = this.run(getBridgeInformationRequest, requestOptions);
        if (mimbResponse instanceof BridgeInformationResponse) {
            return ((BridgeInformationResponse)mimbResponse).getBridge();
        }
        this.checkError(mimbResponse);
        return null;
    }

    protected void checkError(MimbResponse mimbResponse) throws DriverError {
        if (mimbResponse instanceof ErrorResponse) {
            MimbError mimbError = ((ErrorResponse)mimbResponse).getError();
            if (mimbError != null) {
                throw mimbError;
            }
            throw new DriverError("Failed with no error");
        }
        if (mimbResponse instanceof MimbErrorResponse) {
            throw new DriverError(((MimbErrorResponse)mimbResponse).getErrorMessage());
        }
    }

    @Override
    public MimbStatus getStatus(MimbSession mimbSession) throws DriverError {
        MimbProcess mimbProcess = this.mimbSessions.get(mimbSession);
        if (mimbProcess != null) {
            return mimbProcess.getStatus();
        }
        return MimbStatus.INVALID;
    }

    @Override
    public void waitFor(MimbSession mimbSession) throws DriverError {
        MimbProcess mimbProcess = this.mimbSessions.get(mimbSession);
        if (mimbProcess != null) {
            mimbProcess.waitFor();
        }
    }

    @Override
    public void stop(MimbSession mimbSession) throws DriverError {
        MimbProcess mimbProcess = this.mimbSessions.get(mimbSession);
        if (mimbProcess != null) {
            mimbProcess.stop();
        }
    }

    @Override
    public MimbSession startBrowse(BridgeConfiguration bridgeConfiguration, String string, File file, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        BrowseRequest browseRequest = this.buildRequest(new BrowseRequest(), requestOptions, mimbLog);
        browseRequest.setBridge(this.buildBridge(bridgeConfiguration));
        browseRequest.setBrowseParameterIdentifier(string);
        browseRequest.setBrowseFile(file.getPath());
        return this.start(browseRequest, requestOptions, mimbLog);
    }

    @Override
    public boolean browse(BridgeConfiguration bridgeConfiguration, String string, File file, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        MimbSession mimbSession = this.startBrowse(bridgeConfiguration, string, file, requestOptions, mimbLog);
        this.waitFor(mimbSession);
        return this.getStatus(mimbSession) == MimbStatus.SUCCESS;
    }

    @Override
    public MimbSession startTest(BridgeConfiguration bridgeConfiguration, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        TestRequest testRequest = this.buildRequest(new TestRequest(), requestOptions, mimbLog);
        testRequest.setBridge(this.buildBridge(bridgeConfiguration));
        return this.start(testRequest, requestOptions, mimbLog);
    }

    @Override
    public boolean test(BridgeConfiguration bridgeConfiguration, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        MimbSession mimbSession = this.startTest(bridgeConfiguration, requestOptions, mimbLog);
        this.waitFor(mimbSession);
        return this.getStatus(mimbSession) == MimbStatus.SUCCESS;
    }

    @Override
    public MimbSession startRun(BridgeConfiguration bridgeConfiguration, BridgeConfiguration bridgeConfiguration2, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        RunMimbExtendedRequest runMimbExtendedRequest = this.buildRequest(new RunMimbExtendedRequest(), requestOptions, mimbLog);
        runMimbExtendedRequest.setImportBridge(this.buildBridge(bridgeConfiguration));
        runMimbExtendedRequest.setExportBridge(this.buildBridge(bridgeConfiguration2));
        return this.start(runMimbExtendedRequest, requestOptions, mimbLog);
    }

    @Override
    public boolean run(BridgeConfiguration bridgeConfiguration, BridgeConfiguration bridgeConfiguration2, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        MimbSession mimbSession = this.startRun(bridgeConfiguration, bridgeConfiguration2, requestOptions, mimbLog);
        this.waitFor(mimbSession);
        return this.getStatus(mimbSession) == MimbStatus.SUCCESS;
    }

    protected <R extends MimbRequest> R buildRequest(R r, RequestOptions requestOptions) {
        if (requestOptions != null) {
            r.setLanguage(requestOptions.getLang());
        }
        return r;
    }

    protected <R extends StartMimbRequest> R buildRequest(R r, RequestOptions requestOptions, MimbLog mimbLog) {
        if (requestOptions != null) {
            r.setLanguage(requestOptions.getLang());
            r.setValidationLevel(requestOptions.getValidationLevel() != null ? requestOptions.getValidationLevel() : ValidationLevel.BASIC);
        }
        r.setLogLevel(mimbLog != null ? mimbLog.getLevel() : MimbLogLevel.INFO);
        return r;
    }

    protected BridgeConfig buildBridge(BridgeConfiguration bridgeConfiguration) {
        BridgeConfig bridgeConfig = new BridgeConfig();
        bridgeConfig.setBridgeId(bridgeConfiguration.getBridgeId());
        bridgeConfig.setBridgeDisplayName(bridgeConfiguration.getBridgeDisplayName());
        for (Map.Entry<String, String> entry : bridgeConfiguration.getBridgeOptions().entrySet()) {
            bridgeConfig.addBridgeOption(entry.getKey(), entry.getValue(), bridgeConfiguration.isAreFilesLocal() ? entry.getValue() : "");
        }
        return bridgeConfig;
    }

    protected abstract MimbResponse run(MimbRequest var1, RequestOptions var2) throws DriverError;

    private MimbSession start(StartMimbRequest startMimbRequest, RequestOptions requestOptions, MimbLog mimbLog) throws DriverError {
        MimbProcess mimbProcess = this.createSession(startMimbRequest, requestOptions, mimbLog);
        if (mimbProcess != null) {
            this.mimbSessions.put(mimbProcess.getSession(), mimbProcess);
            return mimbProcess.start();
        }
        return null;
    }

    protected abstract MimbProcess createSession(StartMimbRequest var1, RequestOptions var2, MimbLog var3) throws DriverError;
}

