/*
 * Decompiled with CFR 0.152.
 */
package org.springframework.ws.transport.xmpp;

import java.io.ByteArrayOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import org.jivesoftware.smack.packet.Message;
import org.springframework.util.Assert;

class MessageOutputStream
extends FilterOutputStream {
    private final Message message;
    private final String encoding;

    MessageOutputStream(Message message, String encoding) {
        super(new ByteArrayOutputStream());
        Assert.notNull((Object)message, (String)"'message' must not be null");
        Assert.notNull((Object)encoding, (String)"'encoding' must not be null");
        this.message = message;
        this.encoding = encoding;
    }

    @Override
    public void flush() throws IOException {
        super.flush();
        ByteArrayOutputStream bos = (ByteArrayOutputStream)this.out;
        String text = new String(bos.toByteArray(), this.encoding);
        this.message.setBody(text);
    }
}

