/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.util.build;

import com.sas.themeresources.util.build.BaseJavaClassFromXMLGenerator;

public class ComponentTemplatesGenerator
extends BaseJavaClassFromXMLGenerator {
    public ComponentTemplatesGenerator(String[] args) {
        super(args);
        this.xmlElementType = "Template";
    }

    public static void main(String[] args) {
        ComponentTemplatesGenerator cig = new ComponentTemplatesGenerator(args);
        BaseJavaClassFromXMLGenerator.ContentDocumentHandler cdh = cig.readThemeXMLIntoDocumentHandler(new String[]{"name", "description", "markup", "file"});
        cig.generateJavaClass(cdh);
    }

    @Override
    protected void writeClassHeaderToBuffer(StringBuffer sb, BaseJavaClassFromXMLGenerator.ContentDocumentHandler documentHandler, String[] args) {
        String fullyQualifiedPackage = args[2];
        String className = fullyQualifiedPackage.substring(fullyQualifiedPackage.lastIndexOf(46) + 1);
        String packageName = fullyQualifiedPackage.substring(0, fullyQualifiedPackage.lastIndexOf(46));
        sb.append("package " + packageName + ";" + "\r\n");
        sb.append("// Generated: " + this.getFormattedDate() + "\r\n");
        sb.append("import java.lang.reflect.Constructor;\r\n");
        sb.append("import java.lang.reflect.InvocationTargetException;\r\n");
        sb.append("import java.util.Map;\r\n");
        sb.append("import java.util.concurrent.ConcurrentHashMap;\r\n");
        sb.append("import com.sas.themeresources.keys.ComponentTemplateKeys;\r\n");
        sb.append("public class " + className + "\r\n");
        sb.append("{\r\n");
    }

    @Override
    protected void writeFileContentsToBuffer(StringBuffer sb, BaseJavaClassFromXMLGenerator.ContentDocumentHandler documentHandler, String[] args) {
        sb.append("\t/**\r\n");
        sb.append("\t * !!!!! WARNING: Before Editing This File !!!!\r\n");
        sb.append("\t * This file needs to be kept in sync with \r\n");
        sb.append("\t * " + args[0] + " and ComponentTemplateKeys.java." + "\r\n");
        sb.append("\t * Typically, you will want to edit the\r\n");
        sb.append("\t * .vtl manually and then run the build.xml in\r\n");
        sb.append("\t * com.sas.themeresources.util.build to generate the java files.\r\n");
        sb.append("\t */\r\n");
        sb.append("\tprivate static Map templates = null;\r\n");
        sb.append("\tprivate static ComponentTemplates _instance = new ComponentTemplates();\r\n\r\n");
        sb.append("\t// TODO: Should probably be populating this template cache\r\n");
        sb.append("\t// as individual templates are requested instead of all at once.\r\n");
        sb.append("\tstatic {\r\n");
        sb.append("\t\ttemplates = new ConcurrentHashMap();\r\n\r\n");
        for (String key : documentHandler.elementMap.keySet()) {
            String[] templateAttributes = (String[])documentHandler.elementMap.get(key);
            sb.append("\t\ttemplates.put(\r\n");
            sb.append("\t\t\tComponentTemplateKeys.");
            sb.append(key.toUpperCase().replace(this.specialReplaceChars, this.replacementStrings));
            sb.append(",\r\n\t\t\tnewTemplate(");
            for (int i = 0; i < templateAttributes.length; ++i) {
                if (templateAttributes[i] == null) {
                    sb.append(templateAttributes[i]).append(i != templateAttributes.length - 1 ? "," : "");
                } else {
                    sb.append("\"").append(templateAttributes[i]).append(i != templateAttributes.length - 1 ? "\"," : "\"");
                }
                if (i != 6) continue;
                sb.append("\r\n\t\t\t\t");
            }
            sb.append("));\r\n");
        }
        sb.append("\t}\r\n\r\n");
        sb.append("\tpublic static ComponentTemplates getInstance()\r\n");
        sb.append("\t{\r\n");
        sb.append("\t\treturn _instance;\r\n");
        sb.append("\t}\r\n\r\n");
        sb.append("\tpublic Object get(String componentTemplateKey)\r\n");
        sb.append("\t{\r\n");
        sb.append("\t\treturn templates.get(componentTemplateKey);\r\n");
        sb.append("\t}\r\n\r\n");
        sb.append("\tprivate static Object newTemplate(\r\n");
        sb.append("\t\tString name, String desc, String markup, String file)\r\n");
        sb.append("\t{\r\n");
        sb.append("\t\tClass templateClass = null;\r\n");
        sb.append("\t\tObject template = null;\r\n");
        sb.append("\t\tClass[] argTypes = new Class[] { String.class };\r\n");
        sb.append("\t\ttry {\r\n");
        sb.append("\t\t\ttemplateClass = Class.forName(\"com.sas.framework.themes.client.Template\");\r\n");
        sb.append("\t\t\tConstructor constructor =\r\n");
        sb.append("\t\t\t\ttemplateClass.getConstructor( new Class[0] );\r\n");
        sb.append("\t\t\ttemplate = constructor.newInstance(new Object[0]);\r\n\r\n");
        sb.append("\t\t\ttemplate.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setName\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\ttemplate, new Object[] {name});\r\n");
        sb.append("\t\t\ttemplate.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setDescription\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\ttemplate, new Object[] {desc});\r\n");
        sb.append("\t\t\ttemplate.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setMarkupLanguage\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\ttemplate, new Object[] {markup});\r\n");
        sb.append("\t\t\ttemplate.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setFile\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\ttemplate, new Object[] {file});\r\n");
        sb.append("\t\t}\r\n");
        sb.append("\t\tcatch(ClassNotFoundException cnfex) {throw new IllegalStateException(cnfex.getCause()); }\r\n");
        sb.append("\t\tcatch ( NoSuchMethodException nsme ) { throw new IllegalStateException(nsme.getCause()); }\r\n");
        sb.append("\t\tcatch ( IllegalAccessException iae ) { throw new IllegalStateException(iae.getCause());}\r\n");
        sb.append("\t\tcatch ( InvocationTargetException ite ) { throw new IllegalStateException(ite.getCause());}\r\n");
        sb.append("\t\tcatch ( InstantiationException ie ) { throw new IllegalStateException(ie.getCause());}\r\n");
        sb.append("\t\treturn template;\r\n");
        sb.append("\t}\r\n");
    }
}

