/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.util.build;

import com.sas.themeresources.util.build.BaseJavaClassFromXMLGenerator;

public class ComponentImagesGenerator
extends BaseJavaClassFromXMLGenerator {
    public ComponentImagesGenerator(String[] args) {
        super(args);
        this.xmlElementType = "Image";
    }

    public static void main(String[] args) {
        ComponentImagesGenerator cig = new ComponentImagesGenerator(args);
        BaseJavaClassFromXMLGenerator.ContentDocumentHandler cdh = cig.readThemeXMLIntoDocumentHandler(new String[]{"name", "description", "path", "appliesTo", "altTextKey", "width", "height", "file"});
        cig.generateJavaClass(cdh);
    }

    @Override
    protected void writeClassHeaderToBuffer(StringBuffer sb, BaseJavaClassFromXMLGenerator.ContentDocumentHandler documentHandler, String[] args) {
        String fullyQualifiedPackage = args[2];
        String className = fullyQualifiedPackage.substring(fullyQualifiedPackage.lastIndexOf(46) + 1);
        String packageName = fullyQualifiedPackage.substring(0, fullyQualifiedPackage.lastIndexOf(46));
        sb.append("package " + packageName + ";" + "\r\n");
        sb.append("// Generated: " + this.getFormattedDate() + "\r\n");
        sb.append("import java.lang.reflect.Constructor;\r\n");
        sb.append("import java.lang.reflect.InvocationTargetException;\r\n");
        sb.append("import java.util.Map;\r\n");
        sb.append("import java.util.concurrent.ConcurrentHashMap;\r\n");
        sb.append("import com.sas.themeresources.keys.ComponentImageKeys;\r\n");
        sb.append("public class " + className + "\r\n");
        sb.append("{\r\n");
    }

    @Override
    protected void writeFileContentsToBuffer(StringBuffer sb, BaseJavaClassFromXMLGenerator.ContentDocumentHandler documentHandler, String[] args) {
        sb.append("\t/**\r\n");
        sb.append("\t * !!!!! WARNING: Before Editing This File !!!!\r\n");
        sb.append("\t * This file needs to be kept in sync with \r\n");
        sb.append("\t * " + args[0] + " and ComponentImageKeys.java." + "\r\n");
        sb.append("\t * Typically, you will want to edit the\r\n");
        sb.append("\t * .vtl manually and then run the build.xml in\r\n");
        sb.append("\t * com.sas.themeresources.util.build to generate the java files.\r\n");
        sb.append("\t */\r\n\r\n");
        sb.append("\tpublic final static String GIF_FILE_EXTENSION = \".gif\";\r\n");
        sb.append("\tprivate static Map images = null;\r\n");
        sb.append("\tprivate static ComponentImages _instance = new ComponentImages();\r\n\r\n");
        sb.append("\t// TODO: Should probably be populating this image cache\r\n");
        sb.append("\t// as individual images are requested instead of all at once.\r\n");
        sb.append("\tstatic {\r\n");
        sb.append("\t\timages = new ConcurrentHashMap();\r\n\r\n");
        for (String key : documentHandler.elementMap.keySet()) {
            String[] imageAttributes = (String[])documentHandler.elementMap.get(key);
            sb.append("\t\timages.put(\r\n");
            sb.append("\t\t\tComponentImageKeys.");
            sb.append(key.toUpperCase().replace(this.specialReplaceChars, this.replacementStrings));
            sb.append(",\r\n\t\t\tnewImage(");
            for (int i = 0; i < imageAttributes.length; ++i) {
                if (imageAttributes[i] == null) {
                    sb.append(imageAttributes[i]).append(i != imageAttributes.length - 1 ? "," : "");
                } else {
                    sb.append("\"").append(imageAttributes[i]).append(i != imageAttributes.length - 1 ? "\"," : "\"");
                }
                if (i != 6) continue;
                sb.append("\r\n\t\t\t\t");
            }
            sb.append("));\r\n");
        }
        sb.append("\t}\r\n\r\n");
        sb.append("\tpublic static ComponentImages getInstance()\r\n");
        sb.append("\t{\r\n");
        sb.append("\t\treturn _instance;\r\n");
        sb.append("\t}\r\n\r\n");
        sb.append("\tpublic Object get(String componentImageKey)\r\n");
        sb.append("\t{\r\n");
        sb.append("\t\treturn images.get(componentImageKey);\r\n");
        sb.append("\t}\r\n\r\n");
        sb.append("\tprivate static Object newImage(\r\n");
        sb.append("\t\tString name, String desc, String path,\r\n");
        sb.append("\t\tString appliesTo,String altTextKey,\r\n");
        sb.append("\t\tString width, String height, String file /*, String rtlFile*/)\r\n");
        sb.append("\t{\r\n");
        sb.append("\t\tClass imageClass = null;\r\n");
        sb.append("\t\tObject image = null;\r\n");
        sb.append("\t\tClass[] argTypes = new Class[] { String.class };\r\n");
        sb.append("\t\ttry {\r\n");
        sb.append("\t\t\timageClass = Class.forName(\"com.sas.framework.themes.client.Image\");\r\n");
        sb.append("\t\t\tConstructor constructor =\r\n");
        sb.append("\t\t\t\timageClass.getConstructor( new Class[0] );\r\n");
        sb.append("\t\t\timage = constructor.newInstance(new Object[0]);\r\n\r\n");
        sb.append("\t\t\timage.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setName\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\timage, new Object[] {name});\r\n");
        sb.append("\t\t\timage.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setDescription\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\timage, new Object[] {desc});\r\n");
        sb.append("\t\t\timage.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setPath\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\timage, new Object[] {path});\r\n");
        sb.append("\t\t\timage.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setAppliesTo\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\timage, new Object[] {appliesTo});\r\n");
        sb.append("\t\t\timage.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setAltTextKey\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\timage, new Object[] {altTextKey});\r\n");
        sb.append("\t\t\timage.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setWidth\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\timage, new Object[] {width});\r\n");
        sb.append("\t\t\timage.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setHeight\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\timage, new Object[] {height});\r\n");
        sb.append("\t\t\timage.getClass().getMethod(\r\n");
        sb.append("\t\t\t\t\"setFile\", argTypes ).invoke(\r\n");
        sb.append("\t\t\t\t\timage, new Object[] {file});\r\n");
        sb.append("//\t\t\timage.getClass().getMethod(\r\n");
        sb.append("//\t\t\t\t\"setRTLFile\", argTypes ).invoke(\r\n");
        sb.append("//\t\t\t\t\timage, new Object[] {rtlFile});\r\n");
        sb.append("\t\t}\r\n");
        sb.append("\t\tcatch(ClassNotFoundException cnfex) {throw new IllegalStateException(cnfex.getCause()); }\r\n");
        sb.append("\t\tcatch ( NoSuchMethodException nsme ) { throw new IllegalStateException(nsme.getCause()); }\r\n");
        sb.append("\t\tcatch ( IllegalAccessException iae ) { throw new IllegalStateException(iae.getCause());}\r\n");
        sb.append("\t\tcatch ( InvocationTargetException ite ) { throw new IllegalStateException(ite.getCause());}\r\n");
        sb.append("\t\tcatch ( InstantiationException ie ) { throw new IllegalStateException(ie.getCause());}\r\n");
        sb.append("\t\treturn image;\r\n");
        sb.append("\t}\r\n");
    }
}

