/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.util.build;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.text.Collator;
import java.util.Calendar;
import java.util.Collections;
import java.util.GregorianCalendar;
import java.util.Locale;
import java.util.Map;
import java.util.TreeMap;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class BaseJavaClassFromXMLGenerator {
    protected String[] args = null;
    protected String specialReplaceChars = "-";
    protected String replacementStrings = "_";
    protected String xmlElementType = null;
    protected static final String NEWLINE = "\r\n";

    public BaseJavaClassFromXMLGenerator(String[] args) {
        this.args = args;
    }

    public ContentDocumentHandler readThemeXMLIntoDocumentHandler(String[] elementAttributes) {
        File xmlFile = new File(this.args[0]);
        String uri = xmlFile.getAbsolutePath();
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(uri);
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        ContentDocumentHandler documentHandler = this.getDocumentHandler(new InputSource(new BufferedInputStream(fis)), null, elementAttributes);
        try {
            fis.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return documentHandler;
    }

    protected void generateJavaClass(ContentDocumentHandler documentHandler) {
        String fullyQualifiedPackage = this.args[2];
        String className = fullyQualifiedPackage.substring(fullyQualifiedPackage.lastIndexOf(46) + 1);
        File javaFile = new File(this.args[1] + "\\" + className + ".java");
        String pathToJavaFile = javaFile.getAbsolutePath();
        System.out.println("Generating " + className + ".java from theme descriptor " + this.args[0].substring(this.args[0].lastIndexOf("/") + 1));
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(pathToJavaFile);
            FileInputStream fis = new FileInputStream(pathToJavaFile);
            BufferedInputStream bis = new BufferedInputStream(fis);
            byte[] bytes = new byte[10000];
            bis.read(bytes);
            for (int i = 0; i < bytes.length; ++i) {
                System.out.print(bytes[i] + " ");
            }
            System.out.println("");
        }
        catch (FileNotFoundException fnfe) {
            fnfe.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        StringBuffer sb = new StringBuffer();
        this.writeToBuffer(sb, documentHandler, this.args);
        BufferedOutputStream bos = new BufferedOutputStream(fos);
        try {
            bos.write(sb.toString().getBytes("UTF-8"));
            bos.flush();
            bos.close();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    protected void writeToBuffer(StringBuffer sb, ContentDocumentHandler documentHandler, String[] args) {
        this.writeClassHeaderToBuffer(sb, documentHandler, args);
        this.writeFileContentsToBuffer(sb, documentHandler, args);
        sb.append("}\r\n");
    }

    protected void writeClassHeaderToBuffer(StringBuffer sb, ContentDocumentHandler documentHandler, String[] args) {
        String fullyQualifiedPackage = args[2];
        String className = fullyQualifiedPackage.substring(fullyQualifiedPackage.lastIndexOf(46) + 1);
        String packageName = fullyQualifiedPackage.substring(0, fullyQualifiedPackage.lastIndexOf(46));
        sb.append("package " + packageName + ";" + NEWLINE);
        sb.append("public class " + className + NEWLINE);
        sb.append("{\r\n");
    }

    protected void writeFileContentsToBuffer(StringBuffer sb, ContentDocumentHandler documentHandler, String[] args) {
        for (String key : documentHandler.elementMap.keySet()) {
            if (!this.isJavaIdentifier(key.toUpperCase())) {
                System.out.println("   !!! WARNING: Unable to create java key for " + key);
                sb.append("// invalid key name!!");
            }
            sb.append("\tpublic final static String ");
            sb.append(key.toUpperCase().replace(this.specialReplaceChars, this.replacementStrings));
            sb.append(" = \"").append(key).append("\";\r\n");
        }
    }

    protected synchronized ContentDocumentHandler getDocumentHandler(InputSource source, String urlPrefix, String[] elementAttributes) {
        ContentDocumentHandler handler = null;
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            factory.setValidating(true);
            factory.setNamespaceAware(true);
            SAXParser parser = factory.newSAXParser();
            handler = new ContentDocumentHandler(urlPrefix, elementAttributes);
            parser.parse(source, (DefaultHandler)handler);
        }
        catch (FactoryConfigurationError fce) {
            System.err.println(fce.getMessage());
        }
        catch (ParserConfigurationException pce) {
            pce.printStackTrace();
        }
        catch (SAXException se) {
            se.printStackTrace();
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return handler;
    }

    protected static Map getSortedMap() {
        return Collections.synchronizedMap(new TreeMap(Collator.getInstance(Locale.getDefault())));
    }

    protected String getFormattedDate() {
        Calendar c = GregorianCalendar.getInstance();
        StringBuffer sb = new StringBuffer();
        sb.append(c.get(2) + "." + c.get(5) + "." + c.get(1) + " at ");
        sb.append(c.get(10) + ":" + c.get(12) + ":" + c.get(13) + " " + (c.get(9) == 1 ? "PM" : "AM"));
        return sb.toString();
    }

    protected boolean isJavaIdentifier(String s) {
        if (s.length() == 0 || !Character.isJavaIdentifierStart(s.charAt(0))) {
            return false;
        }
        for (int i = 1; i < s.length(); ++i) {
            if (Character.isJavaIdentifierPart(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    protected class ContentDocumentHandler
    extends DefaultHandler {
        protected Map elementMap = BaseJavaClassFromXMLGenerator.getSortedMap();
        protected String[] elementArray = null;
        private String[] elementAttributes;

        ContentDocumentHandler(String urlPrefix, String[] elementAttributes) {
            this.elementAttributes = elementAttributes;
        }

        @Override
        public InputSource resolveEntity(String publicId, String systemId) {
            if ("http://www.sas.com/webapp/themes.dtd".equals(systemId)) {
                return new InputSource(new ByteArrayInputStream("".getBytes()));
            }
            return null;
        }

        @Override
        public void startElement(String namespaceURI, String localName, String rawName, Attributes atts) throws SAXException {
            String elementName = BaseJavaClassFromXMLGenerator.this.xmlElementType;
            if (!localName.equals(elementName)) {
                return;
            }
            this.elementArray = new String[this.elementAttributes.length];
            for (int i = 0; i < atts.getLength(); ++i) {
                String attValue = atts.getValue(i);
                String attName = atts.getLocalName(i);
                for (int j = 0; j < this.elementAttributes.length; ++j) {
                    if (!attName.equalsIgnoreCase(this.elementAttributes[j])) continue;
                    this.elementArray[j] = attValue.trim();
                }
            }
            this.elementMap.put(this.elementArray[0], this.elementArray);
        }

        public void setElementAttributes(String[] elementAttributes) {
            this.elementAttributes = elementAttributes;
        }
    }
}

