/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.validation.util;

import com.sas.themeresources.css.util.CSSParser;
import java.io.File;
import java.util.Iterator;
import java.util.Map;

public class FindDirectColors
extends CSSParser {
    private static boolean verbose;

    public static void main(String[] args) {
        verbose = args[0].trim().equalsIgnoreCase("true");
        for (int i = 1; i < args.length; ++i) {
            String vtlFileName = args[i];
            String[] killLinePattern = new String[]{"theme-ok"};
            Map styles = FindDirectColors.loadCSS(new File(vtlFileName), false, killLinePattern);
            Iterator it = styles.keySet().iterator();
            int count = 0;
            while (it.hasNext()) {
                String key = (String)it.next();
                String style = (String)styles.get(key);
                if (!style.contains("#") || style.contains("#opacity") || style.contains("#gradient")) continue;
                if (count == 0) {
                    FindDirectColors.error("Searching " + vtlFileName + " for direct color references.");
                }
                ++count;
                FindDirectColors.logStyleName(styles, key, false);
            }
            if (count <= 0) continue;
            FindDirectColors.error("Found " + count + " styles with color references.");
            FindDirectColors.error("");
        }
    }

    private static void log(String message) {
        if (verbose) {
            System.out.println(message);
        }
    }

    private static void error(String message) {
        System.out.println(message);
    }
}

