/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.validation.util;

import java.io.File;
import java.io.FileInputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class CompareSpecToThemeUtil {
    public static final String HTML_EXTENSION = ".html";
    public static final String CONTEXT_TABLE = "contextTable";
    public static final String IMAGE_KEY_TABLE = "imageKeyTable";
    public static final String IMAGE_KEY_TABLE2 = "imageKeyTable2";
    public static final String COLOR_TABLE = "colorTable";

    public static void main(String[] args) {
        if (args == null || args.length < 2) {
            System.out.println("ERROR-BAD ARGUMENTS!!! Exiting.");
            System.exit(1);
        }
        String specificationDirectory = args[0];
        LinkedHashMap contextKeysMap = new LinkedHashMap();
        for (int i = 1; i < args.length; ++i) {
            contextKeysMap.putAll(CompareSpecToThemeUtil.getContextKeysMap(args[i]));
        }
        Map contextSpecMap = CompareSpecToThemeUtil.getContextSpecMap(specificationDirectory + "/html");
        Map imageSpecMap = CompareSpecToThemeUtil.getImageSpecMap(specificationDirectory + "/html");
        List productionImageList = CompareSpecToThemeUtil.getProductionImageList(specificationDirectory + "/productionImages");
        List colorList = CompareSpecToThemeUtil.getColorList(specificationDirectory + "/../html/colorPalette.html");
        for (String contextKeyName : contextKeysMap.keySet()) {
            String contextKeyValue = (String)contextKeysMap.get(contextKeyName);
            Object o = contextSpecMap.get(contextKeyName);
            if (o == null) {
                System.out.println("ERROR-Context key not found in specification html files:" + contextKeyName);
                continue;
            }
            if (!((String)o).equalsIgnoreCase(contextKeyValue)) {
                System.out.println("ERROR-Context key '" + contextKeyName + "' value (" + contextKeyValue + ") not equal to specification value (" + o + ").");
            }
            if (!contextKeyValue.startsWith("#") || colorList.contains(contextKeyValue)) continue;
            System.out.println("ERROR-Color " + contextKeyValue + " not defined in colorPalette.html");
        }
        for (String specKeyName : contextSpecMap.keySet()) {
            Object o = contextKeysMap.get(specKeyName);
            if (o != null) continue;
            System.out.println("ERROR-Spec context key not found in context keys:" + specKeyName);
        }
        for (String imageKeyName : imageSpecMap.keySet()) {
            String imageFilename = (String)imageSpecMap.get(imageKeyName);
            if (productionImageList.contains(imageFilename)) continue;
            System.out.println("ERROR-Image key '" + imageKeyName + "' with filename '" + imageFilename + "' not found in productionImages dir.");
        }
        for (int i = 0; i < productionImageList.size(); ++i) {
            String productionImageFilename = (String)productionImageList.get(i);
            if (imageSpecMap.containsValue(productionImageFilename)) continue;
            System.out.println("ERROR-Production image file '" + productionImageFilename + "' not in spec files.");
        }
        System.exit(0);
    }

    public static Map getContextKeysMap(String vtlContextFile) {
        Properties contextKeys = new Properties();
        try {
            contextKeys.load(new FileInputStream(vtlContextFile));
        }
        catch (Exception e) {
            System.out.println("ERROR-" + e.getMessage());
        }
        return contextKeys;
    }

    public static List getColorList(String cp) {
        File colorPalette = new File(cp);
        ArrayList<String> colorList = new ArrayList<String>();
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document document = db.parse(colorPalette);
            Element tableNode = document.getElementById(COLOR_TABLE);
            if (tableNode == null) {
                System.out.println("ERROR-Could not find 'colorTable' in file " + colorPalette.getName());
            } else {
                Node trNode = tableNode.getFirstChild();
                while (trNode.getNextSibling() != null) {
                    trNode = trNode.getNextSibling();
                    Node colorNode = trNode.getFirstChild().getNextSibling();
                    colorList.add(colorNode.getTextContent());
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR-:" + e.getMessage());
        }
        return colorList;
    }

    public static Map getContextSpecMap(String specDir) {
        File HTMLSpecDir = new File(specDir);
        if (!HTMLSpecDir.isDirectory()) {
            System.out.println("ERROR-Unable to locate theme spec at: " + HTMLSpecDir);
            System.exit(1);
        }
        HashMap<String, String> contextTables = null;
        try {
            File[] HTMLFiles = HTMLSpecDir.listFiles();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            contextTables = new HashMap<String, String>();
            for (int i = 0; i < HTMLFiles.length; ++i) {
                File file = HTMLFiles[i];
                if (!file.getName().endsWith(HTML_EXTENSION)) continue;
                try {
                    Document htmlDocument = db.parse(file);
                    Element tableNode = htmlDocument.getElementById(CONTEXT_TABLE);
                    if (tableNode == null) {
                        System.out.println("ERROR-Could not find 'contextTable' in file " + file.getName());
                        continue;
                    }
                    Node trNode = tableNode.getFirstChild();
                    if (trNode == null) continue;
                    while (trNode.getNextSibling() != null) {
                        trNode = trNode.getNextSibling();
                        Node keyNode = trNode.getFirstChild().getNextSibling();
                        Node valueNode = keyNode.getNextSibling();
                        String key = keyNode.getTextContent();
                        String value = valueNode.getTextContent();
                        if (contextTables.containsKey(key)) {
                            System.out.println("ERROR-Key already defined. " + file.getName() + ":" + key);
                            continue;
                        }
                        contextTables.put(key, value);
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ERROR-Parsing error " + file.getName() + " :" + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR-:" + e.getMessage());
        }
        return contextTables;
    }

    public static List getProductionImageList(String imageDirString) {
        File imageDir = new File(imageDirString);
        if (!imageDir.isDirectory()) {
            System.out.println("ERROR-NOT A DIRECTORY:" + imageDirString);
            System.exit(1);
        }
        ArrayList<String> imageList = new ArrayList<String>();
        File[] imageFiles = imageDir.listFiles();
        imageList = new ArrayList(imageFiles.length);
        for (int i = 0; i < imageFiles.length; ++i) {
            File image = imageFiles[i];
            if (!image.isFile()) continue;
            imageList.add(imageFiles[i].getName());
        }
        return imageList;
    }

    public static void writeEnumerationToSystemOut(Enumeration e) {
        while (e.hasMoreElements()) {
            System.out.println((String)e.nextElement());
        }
    }

    public static Map getImageSpecMap(String specDir) {
        return CompareSpecToThemeUtil.getImageSpecMap(specDir, true);
    }

    public static Map getImageSpecMap(String specDir, boolean stripDir) {
        File HTMLSpecDir = new File(specDir);
        if (!HTMLSpecDir.isDirectory()) {
            System.out.println("ERROR-NOT A DIRECTORY:" + HTMLSpecDir);
            System.exit(1);
        }
        HashMap<String, String> imageSpecMap = null;
        try {
            File[] HTMLFiles = HTMLSpecDir.listFiles();
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setIgnoringElementContentWhitespace(true);
            DocumentBuilder db = dbf.newDocumentBuilder();
            imageSpecMap = new HashMap<String, String>();
            for (int i = 0; i < HTMLFiles.length; ++i) {
                File file = HTMLFiles[i];
                if (!file.getName().endsWith(HTML_EXTENSION)) continue;
                try {
                    int slash;
                    String imageName;
                    String key;
                    Node valueNode;
                    Node keyNode;
                    Node trNode;
                    Document htmlDocument = db.parse(file);
                    Element tableNode = htmlDocument.getElementById(IMAGE_KEY_TABLE);
                    if (tableNode != null) {
                        trNode = tableNode.getFirstChild();
                        while (trNode.getNextSibling() != null) {
                            trNode = trNode.getNextSibling();
                            keyNode = trNode.getFirstChild().getNextSibling();
                            valueNode = keyNode.getNextSibling();
                            key = keyNode.getTextContent();
                            imageName = valueNode.getTextContent();
                            if (stripDir && (slash = imageName.indexOf("/")) != -1) {
                                imageName = imageName.substring(slash + 1);
                            }
                            imageSpecMap.put(key, imageName);
                        }
                    }
                    if ((tableNode = htmlDocument.getElementById(IMAGE_KEY_TABLE2)) == null) continue;
                    trNode = tableNode.getFirstChild();
                    while (trNode.getNextSibling() != null) {
                        trNode = trNode.getNextSibling();
                        keyNode = trNode.getFirstChild().getNextSibling();
                        valueNode = keyNode.getNextSibling();
                        key = keyNode.getTextContent();
                        imageName = valueNode.getTextContent();
                        slash = imageName.indexOf("/");
                        if (stripDir && slash != -1) {
                            imageName = imageName.substring(slash + 1);
                        }
                        imageSpecMap.put(key, imageName);
                    }
                    continue;
                }
                catch (Exception e) {
                    System.out.println("ERROR-Parsing error " + file.getName() + " :" + e.getMessage());
                }
            }
        }
        catch (Exception e) {
            System.out.println("ERROR-:" + e.getMessage());
        }
        return imageSpecMap;
    }
}

