/*
 * Decompiled with CFR 0.152.
 */
package com.sas.themeresources.css.validation.util;

import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Properties;

public class CompareContextFiles {
    private static boolean verbose;

    public static void main(String[] args) {
        verbose = args[0].trim().equalsIgnoreCase("true");
        String context1FileName = args[1];
        String context2FileName = args[2];
        Properties context1 = new Properties();
        Properties context2 = new Properties();
        try {
            context1.load(new FileInputStream(context1FileName));
            context2.load(new FileInputStream(context2FileName));
            CompareContextFiles.compareContexts(context1, context1FileName, context2, context2FileName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void compareContexts(Properties context1, String context1Description, Properties context2, String context2Description) {
        boolean printedHeader = false;
        for (String string : context1.keySet()) {
            if (context2.containsKey(string)) continue;
            if (!printedHeader) {
                CompareContextFiles.error("The following context keys exist in " + context1Description + " but are not in " + context2Description);
                printedHeader = true;
            }
            CompareContextFiles.error("-------> " + string);
        }
        printedHeader = false;
        for (String string : context2.keySet()) {
            if (context1.containsKey(string)) continue;
            if (!printedHeader) {
                CompareContextFiles.error("The following context keys exist in " + context2Description + " but are not in " + context1Description);
                printedHeader = true;
            }
            CompareContextFiles.error("-------> " + string);
        }
    }

    private static void log(String message) {
        if (verbose) {
            System.out.println(message);
        }
    }

    private static void error(String message) {
        System.out.println(message);
    }
}

