/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.groups;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.groups.ModalChoiceGroupInterface;
import com.sas.prompts.groups.PromptGroup;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupV2Interface;
import com.sas.prompts.groups.TransparentGroupInterface;
import java.util.List;

@SASScope(value="ALL")
public class TransparentGroup
extends PromptGroup
implements TransparentGroupInterface {
    public TransparentGroup() {
    }

    public TransparentGroup(List promptDefinitionsAndSubgroups) {
        super(promptDefinitionsAndSubgroups);
    }

    @SASScope
    protected boolean allowSubgroup(PromptGroupInterface promptSubgroup) {
        if (promptSubgroup instanceof ModalChoiceGroupInterface) {
            return false;
        }
        if (promptSubgroup instanceof TransparentGroupInterface) {
            return true;
        }
        return promptSubgroup instanceof PromptGroupV2Interface && ((PromptGroupV2Interface)promptSubgroup).isTransparent();
    }

    @Override
    @SASScope
    public String getDefinitionElementName() {
        return "TransparentGroup";
    }

    @Override
    public void addPromptSubgroup(PromptGroupInterface promptSubgroup) {
        if (this.allowSubgroup(promptSubgroup)) {
            super.addPromptSubgroup(promptSubgroup);
            return;
        }
        throw new IllegalArgumentException("Subgroup type not allowed in TransparentGroup '" + promptSubgroup + "'");
    }

    @Override
    public void addPromptSubgroup(PromptGroupInterface promptSubgroup, int index) {
        if (this.allowSubgroup(promptSubgroup)) {
            super.addPromptSubgroup(promptSubgroup, index);
            return;
        }
        throw new IllegalArgumentException("Subgroup type not allowed in TransparentGroup '" + promptSubgroup + "'");
    }

    @Override
    @SASScope
    public PromptGroupInterface copy(PromptGroupInterface newGroup) {
        if (newGroup == null) {
            newGroup = new TransparentGroup();
        }
        return super.copy(newGroup);
    }

    @Override
    public boolean isTransparent() {
        return true;
    }
}

