/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.groups;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.groups.PromptGroupGridLayoutInfo;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.prompts.groups.PromptGroupLayoutInterface;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.BaseAbstractPersistence;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public class PromptGroupGridLayout
extends BaseAbstractPersistence
implements PromptGroupLayoutInterface {
    private static final long serialVersionUID = -2957294675027127452L;
    private int columns = -1;
    private int rows = -1;
    private Map<Object, PromptGroupGridLayoutInfo> spans = new LinkedHashMap<Object, PromptGroupGridLayoutInfo>();

    public String getDefinitionElementName() {
        return "GridLayout";
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setIntAttr((Element)element, (String)"rows", (int)this.rows, (int)-1);
        XmlUtil.setIntAttr((Element)element, (String)"columns", (int)this.columns, (int)-1);
        if (!this.spans.isEmpty()) {
            this.getLogger2().debug("Writing LayoutInfos.");
            ArrayList<PromptGroupGridLayoutInfo> list = new ArrayList<PromptGroupGridLayoutInfo>(this.spans.values());
            PromptGroupGridLayout.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"LayoutInfos");
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("LayoutInfos");
        if (!list.isEmpty()) {
            for (PromptGroupGridLayoutInfo info : list) {
                this.spans.put(info.getObject(), info);
            }
        }
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setRows(provider.consumeIntAttr("rows", -1));
        this.setColumns(provider.consumeIntAttr("columns", -1));
    }

    public int getColumns() {
        return this.columns;
    }

    public int getRows() {
        return this.rows;
    }

    public void setColumns(int cols) {
        this.columns = cols;
    }

    public void setRows(int rows) {
        this.rows = rows;
    }

    private void updateSpan(Object o, Integer rowSpan, Integer colSpan) {
        if (o != null) {
            if (this.spans.containsKey(o)) {
                PromptGroupGridLayoutInfo info = this.spans.get(o);
                if (rowSpan != null) {
                    info.setRowSpan(rowSpan);
                }
                if (colSpan != null) {
                    info.setColumnSpan(colSpan);
                }
                this.spans.put(o, info);
            } else {
                this.spans.put(o, new PromptGroupGridLayoutInfo(o, rowSpan != null ? rowSpan : 1, colSpan != null ? colSpan : 1));
            }
        }
    }

    public void setPromptRowSpan(PromptDefinitionInterface promptDefinition, int rowSpan) {
        this.updateSpan(promptDefinition, rowSpan, null);
    }

    public void setPromptColumnSpan(PromptDefinitionInterface promptDefinition, int colSpan) {
        this.updateSpan(promptDefinition, null, colSpan);
    }

    public void setPromptSpan(PromptDefinitionInterface promptDefinition, int rowSpan, int colSpan) {
        this.updateSpan(promptDefinition, rowSpan, colSpan);
    }

    public void setPromptGroupRowSpan(PromptGroupInterface promptGroup, int rowSpan) {
        this.updateSpan(promptGroup, rowSpan, null);
    }

    public void setPromptGroupColumnSpan(PromptGroupInterface promptGroup, int colSpan) {
        this.updateSpan(promptGroup, null, colSpan);
    }

    public void setPromptGroupSpan(PromptGroupInterface promptGroup, int rowSpan, int colSpan) {
        this.updateSpan(promptGroup, rowSpan, colSpan);
    }

    public int getPromptRowSpan(PromptDefinitionInterface promptDefinition) {
        if (this.spans.containsKey(promptDefinition)) {
            return this.spans.get(promptDefinition).getRowSpan();
        }
        return 1;
    }

    public int getPromptColumnSpan(PromptDefinitionInterface promptDefinition) {
        if (this.spans.containsKey(promptDefinition)) {
            return this.spans.get(promptDefinition).getColumnSpan();
        }
        return 1;
    }

    public int getPromptGroupRowSpan(PromptGroupInterface promptGroup) {
        if (this.spans.containsKey(promptGroup)) {
            return this.spans.get(promptGroup).getRowSpan();
        }
        return 1;
    }

    public int getPromptGroupColumnSpan(PromptGroupInterface promptGroup) {
        if (this.spans.containsKey(promptGroup)) {
            return this.spans.get(promptGroup).getColumnSpan();
        }
        return 1;
    }

    public boolean containsLayoutInfoFor(Object obj) {
        return this.spans.containsKey(obj);
    }

    public PromptGroupGridLayoutInfo getLayoutInfoFor(Object obj) {
        if (this.spans.containsKey(obj)) {
            return this.spans.get(obj);
        }
        return null;
    }

    public Collection<PromptGroupGridLayoutInfo> getLayoutInfo() {
        return this.spans.values();
    }

    public void setLayoutInfo(Collection<PromptGroupGridLayoutInfo> infos) {
        this.spans.clear();
        for (PromptGroupGridLayoutInfo info : infos) {
            this.spans.put(info.getObject(), info);
        }
    }
}

