/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.prompts.definitions.vr.PersistableQueryItemSearchCriteria;
import com.sas.storage.vr.dto.QueryItemSearchCriteria;
import com.sas.storage.vr.dto.Search;
import com.sas.storage.vr.dto.SearchOperatorEnum;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.List;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class PersistableSearch
extends AbstractPersistence {
    private static final long serialVersionUID = 1L;
    private static final String SearchCriteriaList = "SearchCriteriaList";
    private Search search = new Search();

    public Search getSearch() {
        return this.search;
    }

    public void setSearch(@NotNull Search search) {
        ValidateArg.notNull((Object)search, (String)"search");
        this.search = search;
    }

    public String getDefinitionElementName() {
        return "Search";
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        String dt = provider.consumeAttr("operator");
        if (null != dt && dt.length() > 0) {
            this.search.setOperator(SearchOperatorEnum.valueOf((String)dt));
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects(SearchCriteriaList);
        for (PersistableQueryItemSearchCriteria pqis : list) {
            this.search.getSearchCriteriaList().add(pqis.getQueryItemSearchCriteria());
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setAttr((Element)element, (String)"operator", (String)this.search.getOperator().toString());
        if (!this.search.getSearchCriteriaList().isEmpty()) {
            this.getLogger2().debug("writeDefinition() writing the QueryItemSearchCriteria");
            List out = this.search.getSearchCriteriaList();
            ArrayList<PersistableQueryItemSearchCriteria> list = new ArrayList<PersistableQueryItemSearchCriteria>();
            for (QueryItemSearchCriteria qi : out) {
                PersistableQueryItemSearchCriteria pqi = new PersistableQueryItemSearchCriteria();
                pqi.setQueryItemSearchCriteria(qi);
                list.add(pqi);
            }
            PersistableSearch.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)SearchCriteriaList);
        }
    }
}

