/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.prompts.definitions.vr.PersistableQueryItem;
import com.sas.prompts.simplesqlmodel.PromptValueOperand;
import com.sas.storage.vr.dto.QueryItem;
import com.sas.storage.vr.dto.QueryItemSearchCriteria;
import com.sas.storage.vr.dto.SearchOperatorEnum;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class PersistableQueryItemSearchCriteria
extends AbstractPersistence {
    private static final long serialVersionUID = 1L;
    private static final String caseSensitive = "caseSensitive";
    private static final String RightExpression = "RightExpression";
    private static final String LeftExpression = "LeftExpression";
    private QueryItemSearchCriteria queryItemSearchCriteria = new QueryItemSearchCriteria();

    public QueryItemSearchCriteria getQueryItemSearchCriteria() {
        return this.queryItemSearchCriteria;
    }

    public void setQueryItemSearchCriteria(@NotNull QueryItemSearchCriteria queryItemSearchCriteria) {
        ValidateArg.notNull((Object)queryItemSearchCriteria, (String)"queryItemSearchCriteria");
        Object obj = queryItemSearchCriteria.getRightExpression();
        if (null == obj || !(obj instanceof PromptValueOperand)) {
            throw new IllegalArgumentException("The right expression must be a non-null PromptValueOperand.");
        }
        this.queryItemSearchCriteria = queryItemSearchCriteria;
    }

    public String getDefinitionElementName() {
        return "QueryItemSearchCriteria";
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.queryItemSearchCriteria.setCaseSensitive(provider.consumeBooleanAttr(caseSensitive, false));
        String dt = provider.consumeAttr("operator");
        if (null != dt && dt.length() > 0) {
            this.queryItemSearchCriteria.setOperator(SearchOperatorEnum.valueOf((String)dt));
        }
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        PersistableQueryItem pqi = (PersistableQueryItem)roHolder.consumeObject(LeftExpression);
        if (null != pqi) {
            QueryItem item = pqi.getQueryItem();
            this.queryItemSearchCriteria.setLeftExpression(item);
            this.getLogger2().debug("consumeRelatedObject, set the left expression.");
        }
        PromptValueOperand operand = (PromptValueOperand)roHolder.consumeObject(RightExpression);
        this.queryItemSearchCriteria.setRightExpression((Object)operand);
        if (null != operand) {
            this.getLogger2().debug("setting right expression to prompt named", operand.getPromptDefinition().getPromptName());
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        if (null != this.queryItemSearchCriteria.getLeftExpression()) {
            this.getLogger2().debug("writing left expression");
            PersistableQueryItem pqi = new PersistableQueryItem();
            pqi.setQueryItem(this.queryItemSearchCriteria.getLeftExpression());
            ArrayList<PersistableQueryItem> list = new ArrayList<PersistableQueryItem>();
            list.add(pqi);
            PersistableQueryItemSearchCriteria.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)LeftExpression);
        }
        if (null != this.queryItemSearchCriteria.getOperator()) {
            XmlUtil.setAttr((Element)element, (String)"operator", (String)this.queryItemSearchCriteria.getOperator().toString());
        }
        if (null != this.queryItemSearchCriteria.getRightExpression()) {
            this.getLogger2().debug("writing right expression");
            ArrayList<PromptValueOperand> list = new ArrayList<PromptValueOperand>();
            list.add((PromptValueOperand)((Object)this.queryItemSearchCriteria.getRightExpression()));
            PersistableQueryItemSearchCriteria.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)RightExpression);
        }
        XmlUtil.setBooleanAttr((Element)element, (String)caseSensitive, (boolean)this.queryItemSearchCriteria.isCaseSensitive(), (boolean)false);
    }
}

