/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions.vr;

import com.sas.models.datasources.BaseDataSource;
import com.sas.prompts.datatypes.values.DataSourceValue;
import com.sas.storage.vr.dto.DataSource;
import com.sas.storage.vr.dto.QueryItem;
import com.sas.storage.vr.dto.ValueDataTypeEnum;
import com.sas.util.ValidateArg;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

public final class PersistableQueryItem
extends AbstractPersistence {
    private static final long serialVersionUID = 1L;
    private static final String format = "format";
    public static final String searchable = "searchable";
    private static final String vrConfigId = "vrConfigId";
    private QueryItem queryItem = new QueryItem();

    public QueryItem getQueryItem() {
        return this.queryItem;
    }

    public void setQueryItem(@NotNull QueryItem queryItem) {
        ValidateArg.notNull((Object)queryItem, (String)"queryItem");
        this.queryItem = queryItem;
    }

    public String getDefinitionElementName() {
        return "QueryItem";
    }

    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.queryItem.setFormattedValues(provider.consumeBooleanAttr("formattedValues", false));
        this.queryItem.setSearchable(provider.consumeBooleanAttr(searchable, false));
        this.queryItem.setTrimValues(provider.consumeBooleanAttr("trimValues", false));
        String dt = provider.consumeAttr("dataType");
        if (null != dt && dt.length() > 0) {
            this.queryItem.setDataType(ValueDataTypeEnum.valueOf((String)dt));
        }
        this.queryItem.setFormat(provider.consumeAttr(format));
        this.queryItem.setLabel(provider.consumeAttr("label"));
        this.queryItem.setSortDirection(provider.consumeAttr("sortOrder"));
        this.queryItem.setUniqueName(provider.consumeAttr("name"));
        this.queryItem.setVRConfigId(provider.consumeAttr(vrConfigId));
        this.getLogger2().debug("consumeAttributes(),unique name was set to:", this.queryItem.getUniqueName());
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        DataSourceValue dsv = (DataSourceValue)roHolder.consumeObject("DataSources");
        if (null != dsv) {
            DataSource source = new DataSource();
            BaseDataSource newDataSource = (BaseDataSource)dsv.getValue();
            if (null != newDataSource) {
                this.getLogger2().debug("consumed new BaseDataSource with location:", newDataSource.getDataSourceLocation());
                source.setDataSourceLocation(newDataSource.getDataSourceLocation());
                source.setDataSourceType(newDataSource.getDataSourceType());
                this.queryItem.setDataSource(source);
            }
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("writing item named:", this.queryItem.getUniqueName());
        if (null != this.queryItem.getDataSource()) {
            BaseDataSource value = new BaseDataSource();
            value.setDataSourceLocation(this.queryItem.getDataSource().getDataSourceLocation());
            value.setDataSourceType(this.queryItem.getDataSource().getDataSourceType());
            DataSourceValue dsv = new DataSourceValue();
            dsv.setValue((Object)value);
            ArrayList<DataSourceValue> list = new ArrayList<DataSourceValue>();
            list.add(dsv);
            PersistableQueryItem.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"DataSources");
        }
        if (null != this.queryItem.getDataType()) {
            XmlUtil.setAttr((Element)element, (String)"dataType", (String)this.queryItem.getDataType().toString());
        }
        XmlUtil.setAttr((Element)element, (String)"label", (String)this.queryItem.getLabel());
        XmlUtil.setAttr((Element)element, (String)"sortOrder", (String)this.queryItem.getSortDirection());
        XmlUtil.setAttr((Element)element, (String)format, (String)this.queryItem.getFormat());
        XmlUtil.setAttr((Element)element, (String)"name", (String)this.queryItem.getUniqueName());
        XmlUtil.setAttr((Element)element, (String)vrConfigId, (String)this.queryItem.getVRConfigId());
        XmlUtil.setBooleanAttr((Element)element, (String)"formattedValues", (boolean)this.queryItem.isFormattedValues(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)searchable, (boolean)this.queryItem.isSearchable(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"trimValues", (boolean)this.queryItem.isTrimValues(), (boolean)false);
    }
}

