/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.datatypes.MaskedType;
import com.sas.datatypes.StringType;
import com.sas.models.EncodingInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.DynamicValueProviderInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.definitions.MutableTextDefinitionV2Interface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.SelectableDefinitionSupport;
import com.sas.prompts.definitions.SupportedSpecialValuesDefinitionSupport;
import com.sas.prompts.definitions.ValueProviderDefinitionSupport;
import com.sas.prompts.definitions.ValueRetrieverDefinitionSupport;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.valueprovider.StaticValueProvider;
import com.sas.storage.valueprovider.ValueProviderException;
import com.sas.storage.valueprovider.ValueProviderInterface;
import com.sas.storage.vr.dto.ValueRetrieverConfiguration;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.AttributeUtil;
import com.sas.util.ListFactory;
import com.sas.util.LocalizableString;
import com.sas.util.Strings;
import com.sas.util.SupportedSpecialValues;
import com.sas.util.ValidateArg;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.prefs.BackingStoreException;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class TextDefinition
extends PromptDefinition
implements MutableTextDefinitionV2Interface {
    public static final String RB_KEY = "TextDefinition.";
    private static final long serialVersionUID = 1275684780181707360L;
    private static final String MASKED_TEXT_NO_ENCODING_XML = "None";
    private int minimumLength;
    private int maximumLength;
    private boolean allowMultipleLines;
    private List valueTransforms;
    private boolean masked;
    private String maskedEncoding;
    private int maximumLines;
    private int displayedLines;
    private SelectableDefinitionSupport selectableSupport;
    private ValueProviderDefinitionSupport valueProviderSupport;
    private SupportedSpecialValuesDefinitionSupport specialValueSupport;
    private ValueRetrieverDefinitionSupport vrDefSupport;
    private List<LocalizablePersistableString> inputPatterns;

    public TextDefinition() {
        this.init();
    }

    public TextDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.minimumLength = -1;
        this.maximumLength = -1;
        this.allowMultipleLines = false;
        this.maximumLines = -1;
        this.displayedLines = -1;
        this.masked = false;
        this.maskedEncoding = "sas001";
        this.inputPatterns = new LinkedList<LocalizablePersistableString>();
        this.selectableSupport = new SelectableDefinitionSupport(this);
        this.valueProviderSupport = new ValueProviderDefinitionSupport();
        this.specialValueSupport = new SupportedSpecialValuesDefinitionSupport();
        this.vrDefSupport = new ValueRetrieverDefinitionSupport();
    }

    @SASScope
    public String getDefinitionElementName() {
        return "TextDefinition";
    }

    @Override
    @SASScope
    public int getPageSize() {
        return this.valueProviderSupport.getPageSize();
    }

    @Override
    @SASScope
    public void setPageSize(int pageSize) {
        this.valueProviderSupport.setPageSize(pageSize);
    }

    @Override
    public boolean isMasked() {
        return this.masked;
    }

    @Override
    public void setMasked(boolean masked) {
        this.masked = masked;
    }

    @Override
    public boolean isAllowMultipleLines() {
        return this.allowMultipleLines;
    }

    @Override
    public void setAllowMultipleLines(boolean allowMultipleLines) {
        this.allowMultipleLines = allowMultipleLines;
    }

    @Override
    public int getDisplayedLines() {
        return this.isAllowMultipleLines() ? this.displayedLines : -1;
    }

    @Override
    public void setDisplayedLines(int displayedLines) {
        this.displayedLines = displayedLines;
    }

    @Override
    public int getMaximumLines() {
        return this.isAllowMultipleLines() ? this.maximumLines : -1;
    }

    @Override
    public void setMaximumLines(int maximumLines) {
        this.maximumLines = maximumLines;
    }

    @Override
    public int getMinimumLength() {
        return this.minimumLength;
    }

    @Override
    public void setMinimumLength(int minimumLength) {
        this.minimumLength = minimumLength;
    }

    @Override
    public int getMaximumLength() {
        return this.maximumLength;
    }

    @Override
    public void setMaximumLength(int maximumLength) {
        this.maximumLength = maximumLength;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        return super.isPromptValueValid(value, locale) && this.specialValueSupport.isPromptValueValid(value) && this.selectableSupport.isPromptValueValid(value) && this.isPromptValueValidAgainstInputPattern(value, locale);
    }

    private boolean isPromptValueValidAgainstInputPattern(Object value, Locale locale) {
        long returnCode = this.validateIndividualValueAgainstInputPatterns(0L, value, locale);
        if (returnCode == 0L) {
            if (null == value) {
                this.getLogger2().debug("isPromptValueValidAgainstInputPattern() value is null");
            } else {
                if (value instanceof EncodingInterface) {
                    value = ((EncodingInterface)value).getEncodedValue();
                }
                this.getLogger2().debug("isPromptValueValidAgainstInputPattern() value is valid ", value.toString());
            }
            return true;
        }
        if (value instanceof EncodingInterface) {
            value = ((EncodingInterface)value).getEncodedValue();
        }
        this.getLogger2().debug("isPromptValueValidAgainstInputPattern() value is not valid ", value.toString());
        return false;
    }

    @Override
    @SASScope
    public boolean validIndividualValue(Object value) {
        return this.validIndividualValue(value, Locale.getDefault());
    }

    @Override
    public boolean validIndividualValue(Object value, Locale locale) {
        long returnValue = this.validateLinesLengthIndividualValue(this.getMaximumLines(), this.getMinimumLength(), this.getMaximumLength(), value);
        if (returnValue != 1L) {
            returnValue = this.validateIndividualValueAgainstInputPatterns(returnValue, value, locale);
        }
        return returnValue == 0L ? this.specialValueSupport.isPromptValueValid(value) : false;
    }

    @Override
    @SASScope
    public Collection<ValidationEntry> getIndivdualPromptValueValidationErrors(Object value, Locale locale) {
        long returnValue = this.validateLinesLengthIndividualValue(this.getMaximumLines(), this.getMinimumLength(), this.getMaximumLength(), value);
        if ((returnValue = this.validateIndividualValueAgainstInputPatterns(returnValue, value, locale)) == 0L) {
            return this.specialValueSupport.getPromptValueValidationErrors(value, locale);
        }
        return this.populateMapWithErrors(null, returnValue, value, false, locale);
    }

    private long validateIndividualValueAgainstInputPatterns(long returnValue, Object value, Locale locale) {
        if (!this.inputPatterns.isEmpty() && value != null && value instanceof String) {
            boolean match = false;
            String text = (String)value;
            for (LocalizablePersistableString lps : this.inputPatterns) {
                String pattern = lps.getText(locale);
                if (!text.matches(pattern)) continue;
                match = true;
                this.getLogger2().debug("Pattern " + pattern + " matched text:", text);
            }
            if (!match) {
                this.getLogger2().debug("No pattern matched text:", text);
                returnValue |= 0x80000000000L;
            }
        }
        return returnValue;
    }

    private long validateLinesLengthIndividualValue(int maxLines, int minLength, int maxLength, Object value) {
        long returnValue = 0L;
        String text = null;
        if (value != null) {
            if (value instanceof String) {
                text = (String)value;
            } else if (this.isMasked() && value instanceof EncodingInterface) {
                text = ((EncodingInterface)value).getValue();
            } else if (!PromptUtil.isValueSupported(this, value)) {
                returnValue |= 1L;
            }
        }
        if (text != null) {
            int lines;
            int length;
            if (minLength > 0 && (length = text.length()) < minLength) {
                returnValue |= 0x200L;
            }
            if (maxLength >= 0 && (length = text.length()) > maxLength) {
                returnValue |= 0x80L;
            }
            if (maxLines >= 1 && (lines = Strings.count((String)text, (int)0, (int)-1, (char)'\n') + 1) > maxLines) {
                returnValue |= 0x100L;
            }
        }
        return returnValue;
    }

    private long validateLinesLengthValue(int maxLines, int minLength, int maxLength, Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateLinesLengthIndividualValue(maxLines, minLength, maxLength, array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateLinesLengthIndividualValue(maxLines, minLength, maxLength, element);
            }
        } else {
            returnValue |= this.validateLinesLengthIndividualValue(maxLines, minLength, maxLength, value);
        }
        return returnValue;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        errors = PromptUtil.addErrors(errors, this.selectableSupport.getPromptValueValidationErrors(value, locale));
        errors = PromptUtil.addErrors(errors, this.specialValueSupport.getPromptValueValidationErrors(value, locale));
        long returnValue = this.validateLinesLengthValue(this.getMaximumLines(), this.getMinimumLength(), this.getMaximumLength(), value);
        if (null == (errors = this.populateMapWithErrors(errors, returnValue = this.validateIndividualValueAgainstInputPatterns(returnValue, value, locale), value, false, locale))) {
            errors = Collections.emptyList();
        }
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        if (this.isMasked() && this.isHidden() && this.isRequired()) {
            if (!errors.isEmpty()) {
                for (ValidationEntry elem : errors) {
                    if (elem.getErrorCode() != 0x2000000L) continue;
                    errors.remove(elem);
                    break;
                }
            }
            errors = PromptUtil.addError(errors, 0x8000000000L, RB.getStringResource("TextDefinition.maskedHiddenRequired.txt", locale));
        }
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        errors = PromptUtil.addErrors(errors, this.selectableSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors(errors, this.specialValueSupport.validateDefinition(dv, locale));
        errors = PromptUtil.addErrors(errors, this.valueProviderSupport.validateDefinition(this, null, locale));
        errors = PromptUtil.addErrors(errors, this.vrDefSupport.validateDefinitionWithDefinition(this, locale));
        int minLength = this.getMinimumLength();
        int maxLength = this.getMaximumLength();
        long returnValue = 0L;
        if (minLength >= 0 && maxLength > 0 && minLength > maxLength) {
            returnValue |= 0x400L;
        }
        if ((returnValue & 0x400L) == 1024L) {
            errors = PromptUtil.addError(errors, 1024L, RB.getStringResource(RB_KEY, "minLengthAboveMax.txt", locale));
        }
        if (returnValue == 0L) {
            returnValue = this.validateLinesLengthValue(this.getMaximumLines(), minLength, maxLength, dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        errors = this.validateAllInputPatterns(errors, locale);
        return errors;
    }

    private Collection<ValidationEntry> validateAllInputPatterns(Collection<ValidationEntry> errors, Locale locale) {
        if (!this.inputPatterns.isEmpty()) {
            for (LocalizablePersistableString lps : this.inputPatterns) {
                if (this.isInputPatternValid((LocalizableString)lps)) continue;
                errors = PromptUtil.addError(errors, 0x40000000000L, RB.getStringResource(RB_KEY, "inputPattern.notValid.txt", locale));
            }
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotAString.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notAString.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 0x80L) == 128L) {
            errors = defaultValue ? PromptUtil.addError(errors, 128L, Message.format((String)RB.getStringResource("TextDefinition.defaultMaxLength.fmt.txt", locale), (Object)Integer.toString(this.getMaximumLength()))) : PromptUtil.addError(errors, 128L, Message.format((String)RB.getStringResource("TextDefinition.maxLength.fmt.txt", locale), (Object)Integer.toString(this.getMaximumLength())));
        }
        if ((errorCode & 0x100L) == 256L) {
            errors = defaultValue ? PromptUtil.addError(errors, 256L, Message.format((String)RB.getStringResource("TextDefinition.defaultLineCount.fmt.txt", locale), (Object)Integer.toString(this.getMaximumLines()))) : PromptUtil.addError(errors, 256L, Message.format((String)RB.getStringResource("TextDefinition.lineCount.fmt.txt", locale), (Object)Integer.toString(this.getMaximumLines())));
        }
        if ((errorCode & 0x200L) == 512L) {
            errors = defaultValue ? PromptUtil.addError(errors, 512L, Message.format((String)RB.getStringResource("TextDefinition.defaultMinLength.fmt.txt", locale), (Object)Integer.toString(this.getMinimumLength()))) : PromptUtil.addError(errors, 512L, Message.format((String)RB.getStringResource("TextDefinition.minLength.fmt.txt", locale), (Object)Integer.toString(this.getMinimumLength())));
        }
        if ((errorCode & 0x80000000000L) == 0x80000000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x80000000000L, RB.getStringResource("TextDefinition.inputPattern.notValidDefaultValue.txt", locale)) : PromptUtil.addError(errors, 0x80000000000L, RB.getStringResource("TextDefinition.inputPattern.notValidValue.txt", locale));
        }
        return errors;
    }

    @Override
    @SASScope
    public Object clone() throws CloneNotSupportedException {
        TextDefinition clone = (TextDefinition)super.clone();
        this.getLogger2().debug("clone() called on text defn.");
        if (null != this.vrDefSupport) {
            clone.vrDefSupport = (ValueRetrieverDefinitionSupport)((Object)this.vrDefSupport.clone());
        }
        return clone;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        if (this.getSelectionType() == 300) {
            if (!this.isMasked()) {
                return StringType.DEFAULT_INSTANCE;
            }
            if (this.maskedEncoding == null) {
                return MaskedType.DEFAULT_INSTANCE_NONE;
            }
            if ("sas002".equals(this.maskedEncoding)) {
                return MaskedType.DEFAULT_INSTANCE_SAS002;
            }
            return MaskedType.DEFAULT_INSTANCE_SAS001;
        }
        if (!this.isMasked()) {
            return CollectionType.DEFAULT_INSTANCE_STRING;
        }
        return CollectionType.DEFAULT_INSTANCE_MASKED;
    }

    @Override
    @SASScope
    public List getValueTransforms() {
        if (this.valueTransforms == null) {
            return this.valueTransforms;
        }
        return ListFactory.newList((Collection)this.valueTransforms);
    }

    @Override
    @SASScope
    public void setValueTransforms(List valueTransforms) {
        if (valueTransforms == null) {
            this.valueTransforms = null;
            return;
        }
        boolean lowercaseSet = false;
        boolean uppercaseSet = false;
        int n = valueTransforms.size();
        for (int i = 0; i < n; ++i) {
            String transform = (String)valueTransforms.get(i);
            if (transform.equals("UPPERCASE")) {
                if (lowercaseSet) {
                    throw new IllegalArgumentException("Uppercase and lowercase transforms may not both be set");
                }
                uppercaseSet = true;
                continue;
            }
            if (transform.equals("LOWERCASE")) {
                if (uppercaseSet) {
                    throw new IllegalArgumentException("Uppercase and lowercase transforms may not both be set");
                }
                lowercaseSet = true;
                continue;
            }
            if (transform.equals("TRIM")) continue;
            throw new IllegalArgumentException("Invalid case transform");
        }
        this.valueTransforms = ListFactory.newList((Collection)valueTransforms);
    }

    private String getValueTransformAttributeValue() {
        if (this.valueTransforms == null || this.valueTransforms.size() == 0) {
            return null;
        }
        StringBuffer attrValue = new StringBuffer();
        int n = this.valueTransforms.size();
        for (int i = 0; i < n; ++i) {
            attrValue.append(this.valueTransforms.get(i));
            if (i >= n - 1) continue;
            attrValue.append(",");
        }
        return attrValue.toString();
    }

    private void setCaseTransformAttributeValue(String valueTransformsAttr) {
        if (valueTransformsAttr == null) {
            return;
        }
        String[] transforms = valueTransformsAttr.split(",");
        if (transforms.length != 0) {
            this.setValueTransforms(Arrays.asList(transforms));
        }
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList patterns;
        super.consumeRelatedObjects(roHolder);
        this.valueProviderSupport.consumeRelatedObjects(roHolder);
        this.selectableSupport.consumeRelatedObjects(roHolder);
        this.specialValueSupport.consumeRelatedObjects(roHolder);
        ValueRetrieverDefinitionSupport temp = ValueRetrieverDefinitionSupport.newInstanceFromPersistence(roHolder);
        if (null != temp) {
            this.vrDefSupport = temp;
        }
        this.specialValueSupport.setAllowMissing(false);
        if (this.vrDefSupport != null && this.vrDefSupport.getValueRetrieverConfiguration() != null && this.vrDefSupport.getValueRetrieverConfiguration().isDynamicSource()) {
            this.specialValueSupport.setAllowMissing(true);
        }
        if (this.valueProviderSupport.getValueProvider() != null && !(this.valueProviderSupport.getValueProvider() instanceof StaticValueProvider)) {
            this.specialValueSupport.setAllowMissing(true);
        }
        if (!(patterns = roHolder.consumeObjects("InputPatterns")).isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, for input patterns in ", this.getPromptName());
        }
        for (LocalizablePersistableString text : patterns) {
            if (null == text) continue;
            this.addInputPattern((LocalizableString)text);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.valueProviderSupport.consumeAttributes(provider);
        this.selectableSupport.consumeAttributes(provider);
        this.specialValueSupport.consumeAttributes(provider);
        this.setMaximumLength(provider.consumeIntAttr("maxLength", -1));
        this.setMaximumLines(provider.consumeIntAttr("maxLines", -1));
        this.setDisplayedLines(provider.consumeIntAttr("displayedLines", -1));
        this.setAllowMultipleLines(provider.consumeBooleanAttr("allowMultipleLines", false));
        this.setMasked(provider.consumeBooleanAttr("masked", false));
        this.setMinimumLength(provider.consumeIntAttr("minLength", -1));
        String valueTransformsAttr = provider.consumeAttr("valueTransforms");
        this.setCaseTransformAttributeValue(valueTransformsAttr);
        String encoding = provider.consumeAttr("maskedTextEncoding");
        if (encoding == null) {
            this.setMaskedTextEncoding("sas001");
        } else if (encoding.equals(MASKED_TEXT_NO_ENCODING_XML)) {
            this.setMaskedTextEncoding(null);
        } else {
            this.setMaskedTextEncoding(encoding);
        }
    }

    @Override
    public String toString() {
        return "Version: " + this.getVersion() + " " + super.toString();
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        Map localizations;
        this.selectableSupport.configurePrompt(this, options, context);
        this.specialValueSupport.configurePrompt(this, options, context);
        super.configureAttributes(options, context);
        if (options.containsKey("localizations") && (localizations = (Map)options.get("localizations")) != null) {
            Set entries = localizations.entrySet();
            for (Map.Entry entry : entries) {
                if (entry.getKey() == null || !"inputPatterns".equals(entry.getKey())) continue;
                Object value = entry.getValue();
                if (value instanceof Map) {
                    Set entries2 = ((Map)value).entrySet();
                    LocalizableString ls = new LocalizableString();
                    for (Map.Entry entry2 : entries2) {
                        Locale l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                        ls.setText((String)entry2.getValue(), l);
                    }
                    this.addInputPattern(ls);
                    continue;
                }
                if (value instanceof LocalizableString) {
                    this.addInputPattern((LocalizableString)value);
                    continue;
                }
                if (!(value instanceof Collection)) continue;
                Collection col = (Collection)value;
                for (Object object : col) {
                    if (!(object instanceof LocalizableString)) continue;
                    this.addInputPattern((LocalizableString)object);
                }
            }
        }
        if (options.containsKey("maxLength")) {
            this.setMaximumLength(PromptConfigurationFactory.getIntOption((String)"maxLength", options, context));
        }
        if (options.containsKey("maxLines")) {
            this.setMaximumLines(PromptConfigurationFactory.getIntOption((String)"maxLines", options, context));
        }
        if (options.containsKey("displayedLines")) {
            this.setDisplayedLines(PromptConfigurationFactory.getIntOption((String)"displayedLines", options, context));
        }
        if (options.containsKey("allowMultipleLines")) {
            this.setAllowMultipleLines(PromptConfigurationFactory.getBoolOption((String)"allowMultipleLines", options, context));
        }
        if (options.containsKey("masked")) {
            this.setMasked(PromptConfigurationFactory.getBoolOption((String)"masked", options, context));
        }
        if (options.containsKey("minLength")) {
            this.setMinimumLength(PromptConfigurationFactory.getIntOption((String)"minLength", options, context));
        }
        if (options.containsKey("valueTransforms")) {
            Object valueTransformValue = options.get("valueTransforms");
            if (valueTransformValue instanceof String) {
                this.setCaseTransformAttributeValue((String)valueTransformValue);
            } else if (valueTransformValue instanceof List) {
                this.setValueTransforms((List)valueTransformValue);
            }
        }
        if (options.containsKey("maskedTextEncoding")) {
            String encoding = PromptConfigurationFactory.getStringOption((String)"maskedTextEncoding", options, context);
            if (encoding.equals(MASKED_TEXT_NO_ENCODING_XML)) {
                this.setMaskedTextEncoding(null);
            } else {
                this.setMaskedTextEncoding(encoding);
            }
        }
        this.valueProviderSupport.configurePrompt(this, options, context);
        this.vrDefSupport = ValueRetrieverDefinitionSupport.changeInstanceType(this.vrDefSupport, options);
        this.vrDefSupport.configureAttributes(options, context);
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        this.writeValueProvider(element, writingContext);
        this.selectableSupport.writeDefinition(element, writingContext);
        this.specialValueSupport.writeDefinition(element, writingContext);
        if (null != this.vrDefSupport.getValueRetrieverConfiguration()) {
            ArrayList<ValueRetrieverDefinitionSupport> list = new ArrayList<ValueRetrieverDefinitionSupport>();
            list.add(this.vrDefSupport);
            this.getLogger2().debug("Writing value retriever element.");
            TextDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"ValueRetrieverConfiguration");
        }
        XmlUtil.setBooleanAttr((Element)element, (String)"allowMultipleLines", (boolean)this.isAllowMultipleLines(), (boolean)false);
        XmlUtil.setIntAttr((Element)element, (String)"displayedLines", (int)this.getDisplayedLines(), (int)-1);
        XmlUtil.setBooleanAttr((Element)element, (String)"masked", (boolean)this.isMasked(), (boolean)false);
        XmlUtil.setIntAttr((Element)element, (String)"maxLength", (int)this.getMaximumLength(), (int)-1);
        XmlUtil.setIntAttr((Element)element, (String)"minLength", (int)this.getMinimumLength(), (int)-1);
        XmlUtil.setIntAttr((Element)element, (String)"maxLines", (int)this.getMaximumLines(), (int)-1);
        XmlUtil.setAttr((Element)element, (String)"valueTransforms", (String)this.getValueTransformAttributeValue());
        String encoding = this.getMaskedTextEncoding();
        if (encoding == null) {
            XmlUtil.setAttr((Element)element, (String)"maskedTextEncoding", (String)MASKED_TEXT_NO_ENCODING_XML);
        } else if (!encoding.equals("sas001")) {
            XmlUtil.setAttr((Element)element, (String)"maskedTextEncoding", (String)encoding);
        }
        if (!this.inputPatterns.isEmpty()) {
            this.getLogger2().debug("Writing input patterns");
            ArrayList<LocalizablePersistableString> temp = new ArrayList<LocalizablePersistableString>();
            for (LocalizablePersistableString x : this.inputPatterns) {
                temp.add(x);
            }
            TextDefinition.writeRelatedObjects(temp, (Node)element, (PromptsWritingContext)writingContext, (String)"InputPatterns");
        }
    }

    @SASScope
    protected void writeValueProvider(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        this.valueProviderSupport.writeDefinition(element, writingContext);
    }

    @Override
    @SASScope
    public List getReferencedResources(Class type, boolean recursive) {
        List list1 = this.vrDefSupport.getReferencedResources(type, recursive);
        if (list1.isEmpty()) {
            List list2 = this.valueProviderSupport.getReferencedResources(type, recursive);
            return list2;
        }
        return list1;
    }

    @Override
    public boolean isRequired() {
        return this.selectableSupport.isRequired();
    }

    @Override
    public int getMaximumValueCount() {
        return this.selectableSupport.getMaximumValueCount();
    }

    @Override
    public int getMinimumValueCount() {
        return this.selectableSupport.getMinimumValueCount();
    }

    @Override
    public int getSelectionType() {
        return this.selectableSupport.getSelectionType();
    }

    @Override
    public boolean isSelectionOrdered() {
        return this.selectableSupport.isSelectionOrdered();
    }

    @Override
    public void setMaximumValueCount(int maximumValueCount) {
        this.selectableSupport.setMaximumValueCount(maximumValueCount);
    }

    @Override
    public void setMinimumValueCount(int minimumValueCount) {
        this.selectableSupport.setMinimumValueCount(minimumValueCount);
    }

    @Override
    public void setSelectionOrdered(boolean selectionOrdered) {
        this.selectableSupport.setSelectionOrdered(selectionOrdered);
    }

    @SASScope
    public int getMacroVariableListFormat() {
        return this.selectableSupport.getMacroVariableListFormat();
    }

    @SASScope
    public String getMacroVariableQuote() {
        return this.selectableSupport.getMacroVariableQuote();
    }

    @SASScope
    public String getMacroVariableListDelimiter() {
        return this.selectableSupport.getMacroVariableListDelimiter();
    }

    @SASScope
    public void setMacroVariableListFormat(int listFormat) {
        this.selectableSupport.setMacroVariableListFormat(listFormat);
    }

    @SASScope
    public void setMacroVariableQuote(String quote) {
        this.selectableSupport.setMacroVariableQuote(quote);
    }

    @SASScope
    public void setMacroVariableListDelimiter(String delimiter) {
        this.selectableSupport.setMacroVariableListDelimiter(delimiter);
    }

    @Override
    public ValueProviderInterface getValueProvider() {
        return this.valueProviderSupport.getValueProvider();
    }

    public boolean isAllowUserValues() {
        return this.valueProviderSupport.isAllowUserValues();
    }

    @Override
    public void setValueProvider(ValueProviderInterface valueProvider) {
        this.valueProviderSupport.setValueProvider(valueProvider);
        if (valueProvider != null && !(valueProvider instanceof StaticValueProvider)) {
            this.specialValueSupport.setAllowMissing(true);
        } else if (this.vrDefSupport == null) {
            this.specialValueSupport.setAllowMissing(false);
        }
    }

    @Override
    public void setAllowUserValues(boolean allowValues) {
        this.valueProviderSupport.setAllowUserValues(allowValues);
    }

    @Override
    @SASScope
    public Collection<PromptDefinitionInterface> getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        try {
            if (this.valueProviderSupport.getValueProvider() instanceof DynamicValueProviderInterface) {
                return ((DynamicValueProviderInterface)this.valueProviderSupport.getValueProvider()).getDependentPrompts(locale, dynamicValueContext);
            }
        }
        catch (ValueProviderException ve) {
            this.getLogger2().error(ve.getMessage(), (Throwable)ve);
        }
        return this.vrDefSupport.getDependentPrompts(locale, dynamicValueContext);
    }

    public SupportedSpecialValues getSupportedSpecialValues() {
        return this.specialValueSupport.getSupportedSpecialValues();
    }

    public void setSupportedSpecialValues(SupportedSpecialValues specialValuesSupported) {
        this.specialValueSupport.setSupportedSpecialValues(specialValuesSupported);
    }

    @Override
    public void setMaskedTextEncoding(String encoding) {
        if (encoding == null || encoding.equals("base64") || encoding.equals("sas001") || encoding.equals("sas002")) {
            this.maskedEncoding = encoding;
            return;
        }
        throw new IllegalArgumentException("Invalid masked text encoding.  See encodings in com.sas.util.SasPasswordString.");
    }

    @Override
    public String getMaskedTextEncoding() {
        return this.maskedEncoding;
    }

    @Override
    @SASScope
    public PropertyList getLocalizableProperties(Locale locale) {
        PropertyList list = super.getLocalizableProperties(locale);
        PromptUtil.addLocalizedPropertiesFromValueProvider(list, this.valueProviderSupport, locale);
        this.vrDefSupport.addLocalizedPropertiesFromValueRetriever(locale, list);
        if (!this.inputPatterns.isEmpty()) {
            this.getLogger2().debug("adding inputPatterns to localizableProperties.");
            PropertyList subList = new PropertyList();
            for (int i = 0; i < this.inputPatterns.size(); ++i) {
                subList.addProperty("LocalizablePersistableString", i, this.inputPatterns.get(i).getLocalizableProperties(locale));
            }
            list.addProperty("InputPatterns", subList);
        }
        return list;
    }

    @Override
    @SASScope
    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        super.setLocalizableProperties(locale, map);
        if (null != map) {
            PromptUtil.setLocalizedPropertiesOnValueProvider(map, this.valueProviderSupport, locale);
            this.vrDefSupport.setLocalizedPropertiesOnValueRetriever(locale, map);
            if (map.containsNestedProperty("InputPatterns")) {
                PropertyMap nMap = map.getNestedProperties("InputPatterns");
                int[] array = nMap.getNestedPropertyIndexes("LocalizablePersistableString");
                if (null != array && array.length <= this.inputPatterns.size()) {
                    this.getLogger2().debug("setLocalizableProps(),applying inputPatterns #", Integer.toString(array.length));
                    for (int i = 0; i < array.length; ++i) {
                        LocalizablePersistableString s = this.inputPatterns.get(i);
                        s.setLocalizableProperties(locale, nMap.getNestedProperties("LocalizablePersistableString", i));
                    }
                } else {
                    this.getLogger2().info("setLocalizableProperties: No properties were applied to input patterns. Either no patterns exist or more properties than patterns.");
                }
            }
        }
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        AttributeGroup constraints = AttributeUtil.getAttributeGroup((String)"Constraints", attributeList, (boolean)true);
        AttributeGroup hidden = AttributeUtil.getAttributeGroup((String)"Hidden", attributeList, (boolean)true);
        hidden.setVisible(false);
        AttributeGroup multiLine = AttributeUtil.getAttributeGroup((String)"Multi-line", attributeList, (boolean)true);
        AttributeGroup masked1 = AttributeUtil.getAttributeGroup((String)"Masked", attributeList, (boolean)true);
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        hidden.getAttributes().add(typeAttribute);
        constraints.getAttributes().add(new AttributeDescriptor("minLength", "minLength", "int", (Object)this.getMinimumLength(), (Object)-1, true, true));
        constraints.getAttributes().add(new AttributeDescriptor("maxLength", "maxLength", "int", (Object)this.getMaximumLength(), (Object)-1, true, true));
        AttributeDescriptor allowMultipleLinesAttribute = new AttributeDescriptor("allowMultipleLines", "allowMultipleLines", "boolean", (Object)this.isAllowMultipleLines(), (Object)false, true, true);
        AttributeDescriptor maximumLinesAttribute = new AttributeDescriptor("maxLines", "maxLines", "int", (Object)this.getMaximumLines(), (Object)-1, this.isAllowMultipleLines(), true);
        AttributeDescriptor displayedLinesAttribute = new AttributeDescriptor("displayedLines", "displayedLines", "int", (Object)this.getDisplayedLines(), (Object)-1, this.isAllowMultipleLines(), true);
        allowMultipleLinesAttribute.setDependentAttributes(new AttributeDescriptor[]{maximumLinesAttribute, displayedLinesAttribute});
        multiLine.getAttributes().add(allowMultipleLinesAttribute);
        multiLine.getAttributes().add(maximumLinesAttribute);
        multiLine.getAttributes().add(displayedLinesAttribute);
        hidden.getAttributes().add(new AttributeDescriptor("valueTransforms", "valueTransforms", "String", (Object)this.getValueTransformAttributeValue(), null, true, true));
        AttributeDescriptor maskedAttribute = new AttributeDescriptor("masked", "masked", "boolean", (Object)this.isMasked(), (Object)false, true, true);
        AttributeDescriptor maskedTextEncodingAttribute = new AttributeDescriptor("maskedTextEncoding", "maskedTextEncoding", "String", (Object)this.getMaskedTextEncoding(), null, this.isMasked(), true);
        maskedAttribute.setDependentAttributes(new AttributeDescriptor[]{maskedTextEncodingAttribute});
        masked1.getAttributes().add(maskedAttribute);
        masked1.getAttributes().add(maskedTextEncodingAttribute);
        attributeList.addAll(this.valueProviderSupport.getAttributeDescriptors(locale));
        attributeList.addAll(this.selectableSupport.getAttributeDescriptors(locale));
        attributeList.addAll(this.vrDefSupport.getAttributeDescriptors(locale));
        return attributeList;
    }

    @Override
    public final void addInputPattern(LocalizableString inputPattern) {
        ValidateArg.notNull((Object)inputPattern, (String)"inputPattern");
        LocalizablePersistableString lps = new LocalizablePersistableString(inputPattern);
        this.inputPatterns.add(lps);
    }

    @Override
    public List<LocalizableString> getInputPatterns() {
        ArrayList<LocalizableString> list = new ArrayList<LocalizableString>(this.inputPatterns.size());
        list.addAll(this.inputPatterns);
        return list;
    }

    @Override
    public final List<String> getInputPatternsAsText(Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ArrayList<String> retVal = new ArrayList<String>();
        for (LocalizablePersistableString ls : this.inputPatterns) {
            retVal.add(ls.getText(locale));
        }
        return retVal;
    }

    @Override
    public final int getNumberOfInputPatterns() {
        return this.inputPatterns.size();
    }

    @Override
    public final boolean isInputPatternValid(LocalizableString inputPattern) {
        ValidateArg.notNull((Object)inputPattern, (String)"inputPattern");
        List locales = inputPattern.getLocales();
        if (locales.isEmpty()) {
            return false;
        }
        for (Locale locale : locales) {
            String pattern = inputPattern.getText(locale);
            try {
                if (null == pattern) continue;
                Pattern.compile(pattern);
            }
            catch (PatternSyntaxException e) {
                return false;
            }
        }
        return true;
    }

    @Override
    public final boolean removeInputPattern(LocalizableString inputPattern) {
        ValidateArg.notNull((Object)inputPattern, (String)"inputPattern");
        for (LocalizablePersistableString lps : this.inputPatterns) {
            if (!lps.equals((Object)inputPattern)) continue;
            this.getLogger2().debug("removeInputPattern() removed:", inputPattern.toString());
            return this.inputPatterns.remove(inputPattern);
        }
        return false;
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        NumberFormat numFormat = DecimalFormat.getInstance(locale);
        Map<String, String> retVal = super.getConstraints(locale);
        retVal.put("MINIMUM_LENGTH", numFormat.format(this.getMinimumLength()));
        retVal.put("MAXIMUM_LENGTH", numFormat.format(this.getMaximumLength()));
        retVal.put("MAXIMUM_LINES", numFormat.format(this.getMaximumLines()));
        this.selectableSupport.addConstraints(retVal, numFormat);
        return retVal;
    }

    @Override
    public void setValueRetrieverConfiguration(ValueRetrieverConfiguration config) {
        this.vrDefSupport = ValueRetrieverDefinitionSupport.newInstance(config);
        if (config != null && config.isDynamicSource()) {
            this.specialValueSupport.setAllowMissing(true);
        } else {
            this.specialValueSupport.setAllowMissing(false);
        }
    }

    @Override
    public ValueRetrieverConfiguration getValueRetrieverConfiguration() {
        this.vrDefSupport.setApplicationContext(this.getApplicationContext());
        ValueRetrieverConfiguration vrc = this.vrDefSupport.getValueRetrieverConfiguration();
        return vrc;
    }

    @Override
    public String getVersion() {
        String tempVersion = super.getVersion();
        if (null != this.getValueRetrieverConfiguration() || !this.inputPatterns.isEmpty()) {
            try {
                if (XmlUtil.compareVersionStrings((String)tempVersion, (String)"2.0") <= 0) {
                    tempVersion = "2.0";
                }
            }
            catch (ParseException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        this.getLogger2().debug("version is:", tempVersion);
        return tempVersion;
    }
}

