/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.PublicClonable;
import com.sas.codepolicy.SASScope;
import com.sas.datatypes.DataTypeInterface;
import com.sas.prompts.AttributeDependencyInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.HintPlacement;
import com.sas.prompts.LabelPlacement;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptHelp;
import com.sas.prompts.PromptIdentifierFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.prompts.definitions.MutablePromptDefinitionV3Interface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.ValueProviderDefinitionInterface;
import com.sas.prompts.script.PromptAction;
import com.sas.prompts.script.ScriptHolder;
import com.sas.prompts.uiconfig.BaseUIConfiguration;
import com.sas.prompts.uiconfig.UIConfigurationFactory;
import com.sas.prompts.util.MapText;
import com.sas.storage.editableproperties.MultiLocaleProperties;
import com.sas.storage.editableproperties.PropertyList;
import com.sas.storage.editableproperties.PropertyMap;
import com.sas.storage.valueprovider.ValueProviderValueRetrievalInterface;
import com.sas.uiconfig.ApplicationContext;
import com.sas.uiconfig.ContextEnabledObject;
import com.sas.uiconfig.UIConfigurationInterface;
import com.sas.util.AttributeDescriptor;
import com.sas.util.AttributeGroup;
import com.sas.util.LocalizableString;
import com.sas.util.MutableUserInfoInterface;
import com.sas.util.SimpleTemplate2;
import com.sas.util.UserInfo;
import com.sas.util.UserInfoInterface;
import com.sas.util.ValidateArg;
import com.sas.util.ValueItem;
import com.sas.util.anno.NotNull;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsReadingContext;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import com.sas.util.xmlpersist.impl.LocalizablePersistableString;
import com.sas.util.xmlpersist.impl.LocalizedText;
import com.sas.util.xmlpersist.impl.PersistHelper;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public abstract class PromptDefinition
extends AbstractPersistence
implements MutablePromptDefinitionV3Interface,
Cloneable,
PublicClonable,
MultiLocaleProperties,
ContextEnabledObject {
    public static final String RB_KEY = "PromptDefinition.";
    private static final long serialVersionUID = 6900750110209844626L;
    private static final String NO_DEFAULT_VALUE_SET = "NO_DEFAULT_VALUE_SET";
    private String promptName;
    private LocalizableString promptLabel = new LocalizableString();
    private LocalizableString promptDescription = new LocalizableString();
    private LocalizableString hint = new LocalizableString();
    private LocalizableString inlineHint = new LocalizableString();
    private Object defaultValue = "NO_DEFAULT_VALUE_SET";
    private Collection<PromptDefinitionInterface> additionalCascadeDependencies;
    private Map<PromptAction, ScriptHolder> scripts;
    private boolean hidden = false;
    private boolean fixed = false;
    private boolean stickyDefault = false;
    private boolean displayDefaultValueAsBlank;
    private boolean clearValueInModalChoiceGroup = true;
    private LabelPlacement labelPlacement;
    private HintPlacement hintPlacement;
    private MutableUserInfoInterface mutableUserInfo;
    private String promptID;
    private int outputLevel = 1;
    private List<AttributeDependencyInterface> attributeDependencies;
    private LocalizablePersistableString customErrorMessage;
    private UIConfigurationInterface uiConfig;
    private transient ApplicationContext applicationContext;
    private PromptHelp _promptHelp;

    public PromptDefinition() {
    }

    public PromptDefinition(String promptName) {
        this();
        this.setPromptName(promptName);
    }

    @Override
    public synchronized String getPromptID() {
        if (this.promptID == null) {
            this.promptID = PromptIdentifierFactory.getPromptIdentifier("PromptDef");
        }
        return this.promptID;
    }

    @Override
    @SASScope
    public synchronized void setPromptID(String promptID) {
        if ("_SAS_PROMPT_ID_RESET".equals(promptID)) {
            this.promptID = null;
        } else if (this.promptID == null) {
            this.promptID = promptID;
        }
    }

    @Override
    public String getPromptName() {
        return this.promptName;
    }

    @Override
    public void setPromptName(String promptName) {
        this.promptName = promptName;
    }

    @Override
    public String getPromptLabel(Locale locale) {
        return PromptUtil.getDelegatedText(this.promptLabel, locale, this.getApplicationContext());
    }

    @Override
    public void setPromptLabel(String promptLabel, Locale locale) {
        this.promptLabel.setText(promptLabel, locale);
    }

    @Override
    public String getPromptDescription(Locale locale) {
        return PromptUtil.getDelegatedText(this.promptDescription, locale, this.getApplicationContext());
    }

    @Override
    public void setPromptDescription(String promptDescription, Locale locale) {
        this.promptDescription.setText(promptDescription, locale);
    }

    @Override
    public LocalizableString getPromptLabels() {
        try {
            return (LocalizableString)this.promptLabel.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setPromptLabels(LocalizableString labels) {
        try {
            this.promptLabel = (LocalizableString)labels.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public LocalizableString getPromptDescriptions() {
        try {
            return (LocalizableString)this.promptDescription.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setPromptDescriptions(LocalizableString descriptions) {
        try {
            this.promptDescription = (LocalizableString)descriptions.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public Object getDefaultValue() {
        if (this.defaultValue == NO_DEFAULT_VALUE_SET) {
            throw new IllegalStateException(RB.getStringResource("PromptDefinition.noDefaultValue.log"));
        }
        return this.getPromptDataType().copyValue(this.defaultValue, Locale.getDefault());
    }

    @Override
    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = this.getPromptDataType().copyValue(defaultValue, Locale.getDefault());
    }

    @Override
    public void clearDefaultValue() {
        this.defaultValue = NO_DEFAULT_VALUE_SET;
    }

    @Override
    public boolean isDefaultValueSet() {
        return this.defaultValue != NO_DEFAULT_VALUE_SET;
    }

    @Override
    public PromptHelp getPromptHelp() {
        return this._promptHelp;
    }

    @Override
    public void setPromptHelp(PromptHelp promptHelp) {
        this._promptHelp = promptHelp;
    }

    @Override
    public abstract DataTypeInterface getPromptDataType();

    @Override
    public abstract boolean isRequired();

    @Override
    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    @Override
    @SASScope
    public Collection<PromptDefinitionInterface> getDependentPrompts(Locale locale, DynamicPromptValueContextInterface dynamicValueContext) {
        return Collections.emptyList();
    }

    @Override
    @Deprecated
    public boolean isPromptValueValid(Object value) {
        return this.isPromptValueValid(value, Locale.getDefault());
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        return !PromptUtil.isPromptValuesEqual(value, null) || !this.isRequired();
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        if (this.isRequired() && PromptUtil.isPromptValuesEqual(value, null)) {
            Collection<ValidationEntry> errors = PromptUtil.addError(null, 1L, RB.getStringResource(RB_KEY, "nullIsNotValidForRequired.txt", locale));
            return errors;
        }
        return new ArrayList<ValidationEntry>(1);
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = new ArrayList<ValidationEntry>();
        if ((this.isHidden() || this.isFixed()) && this.isRequired() && !this.isDefaultValueSet()) {
            if (this instanceof ValueProviderDefinitionInterface) {
                ValueProviderDefinitionInterface vpdi = (ValueProviderDefinitionInterface)((Object)this);
                if (vpdi.getValueProvider() == null || !(vpdi.getValueProvider() instanceof ValueProviderValueRetrievalInterface)) {
                    errors = PromptUtil.addError(errors, 0x2000000L, RB.getStringResource(RB_KEY, "nonEditableRequiredWithNoDefaultNotAllowed.txt", locale));
                }
            } else {
                errors = PromptUtil.addError(errors, 0x2000000L, RB.getStringResource(RB_KEY, "nonEditableRequiredWithNoDefaultNotAllowed.txt", locale));
            }
        }
        return errors;
    }

    @Override
    public MutableUserInfoInterface getMutableUserInfo() {
        if (this.mutableUserInfo == null) {
            this.mutableUserInfo = new UserInfo();
        }
        return this.mutableUserInfo;
    }

    @Override
    public UserInfoInterface getUserInfo() {
        if (this.mutableUserInfo == null) {
            this.mutableUserInfo = new UserInfo();
        }
        if (this.mutableUserInfo instanceof UserInfo) {
            try {
                return (UserInfoInterface)((UserInfo)this.mutableUserInfo).clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return this.mutableUserInfo;
    }

    @Override
    public void setUserInfo(UserInfoInterface userInfo) {
        if (null == this.mutableUserInfo) {
            this.mutableUserInfo = new UserInfo();
        }
        if (null != userInfo && !userInfo.isEmpty()) {
            for (String key : userInfo.getKeys()) {
                String text = userInfo.get(key);
                this.mutableUserInfo.put(key, text);
            }
        }
    }

    @Override
    public void addUserInfo(String key, String value) {
        if (this.mutableUserInfo == null) {
            this.mutableUserInfo = new UserInfo();
        }
        this.mutableUserInfo.put(key, value);
    }

    @Override
    public void removeUserInfo(String key) {
        if (this.mutableUserInfo.contains(key)) {
            this.mutableUserInfo.remove(key);
        }
    }

    @Override
    public boolean isFixed() {
        return this.fixed;
    }

    @Override
    public void setFixed(boolean fixed) {
        this.fixed = fixed;
    }

    @Override
    @SASScope
    public boolean isStickyDefaultAllowed() {
        return this.stickyDefault;
    }

    @Override
    @SASScope
    public void setStickyDefaultAllowed(boolean stickyDefault) {
        this.stickyDefault = stickyDefault;
    }

    @SASScope
    public List getReferencedResources(Class type, boolean recursive) {
        return Collections.EMPTY_LIST;
    }

    @Override
    @SASScope
    public Collection<PromptDefinitionInterface> getAdditionalCascadeDependencies() {
        if (this.additionalCascadeDependencies != null) {
            return Collections.unmodifiableCollection(this.additionalCascadeDependencies);
        }
        return Collections.emptyList();
    }

    @Override
    public void setAdditionalCascadeDependencies(Collection<PromptDefinitionInterface> dependencies) {
        this.additionalCascadeDependencies = dependencies;
    }

    @SASScope
    public String getMacroVariableBaseName() {
        return this.getPromptName();
    }

    @SASScope
    public void setMacroVariableBaseName(String baseName) {
        this.setPromptName(baseName);
    }

    @SASScope
    public int getMacroVariableOutputLevel() {
        return this.outputLevel;
    }

    @SASScope
    public void setMacroVariableOutputLevel(int outputLevel) {
        this.outputLevel = outputLevel;
    }

    public String toString() {
        return this.getClass().getName() + " named: " + this.getPromptName();
    }

    @SASScope
    public Object clone() throws CloneNotSupportedException {
        this.getLogger2().debug("clone started.");
        PromptDefinition clone = (PromptDefinition)super.clone();
        clone.promptLabel = (LocalizableString)this.promptLabel.clone();
        clone.promptDescription = (LocalizableString)this.promptDescription.clone();
        if (this.defaultValue != null) {
            this.getLogger2().debug("cloning default value.");
            if (this.defaultValue instanceof Date) {
                clone.defaultValue = ((Date)this.defaultValue).clone();
            } else if (this.defaultValue instanceof Object[]) {
                clone.defaultValue = ((Object[])this.defaultValue).clone();
                Object[] cloneDefValueArray = (Object[])clone.defaultValue;
                int n = cloneDefValueArray.length;
                for (int i = 0; i < n; ++i) {
                    if (!(cloneDefValueArray[i] instanceof Date)) continue;
                    cloneDefValueArray[i] = ((Date)cloneDefValueArray[i]).clone();
                }
            }
        }
        if (this.mutableUserInfo instanceof UserInfo) {
            clone.mutableUserInfo = (MutableUserInfoInterface)((UserInfo)this.mutableUserInfo).clone();
        } else if (this.mutableUserInfo != null) {
            List keys = this.mutableUserInfo.getKeys();
            UserInfo newUserInfo = new UserInfo();
            for (String key : keys) {
                newUserInfo.put(key, this.mutableUserInfo.get(key));
            }
            clone.mutableUserInfo = newUserInfo;
        }
        if (null != this.customErrorMessage) {
            clone.customErrorMessage = (LocalizablePersistableString)this.customErrorMessage.clone();
        }
        if (null != this.scripts && !this.scripts.isEmpty()) {
            this.getLogger2().debug("cloning scripts.");
            ConcurrentHashMap<PromptAction, ScriptHolder> clonedScripts = new ConcurrentHashMap<PromptAction, ScriptHolder>();
            for (Map.Entry<PromptAction, ScriptHolder> entry : this.scripts.entrySet()) {
                ScriptHolder holder = (ScriptHolder)entry.getValue().clone();
                clonedScripts.put(entry.getKey(), holder);
            }
            clone.scripts = clonedScripts;
        }
        if (this._promptHelp != null) {
            clone._promptHelp = (PromptHelp)this._promptHelp.clone();
        }
        return clone;
    }

    @Override
    public String getHint(Locale locale) {
        return PromptUtil.getDelegatedText(this.hint, locale, this.getApplicationContext());
    }

    @Override
    public void setHint(String hint, Locale locale) {
        this.hint.setText(hint, locale);
    }

    @Override
    public LocalizableString getHints() {
        try {
            return (LocalizableString)this.hint.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setHints(LocalizableString hints) {
        try {
            this.hint = (LocalizableString)hints.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public boolean isDisplayDefaultValueAsBlank() {
        return this.displayDefaultValueAsBlank;
    }

    @Override
    public void setDisplayDefaultValueAsBlank(boolean isBlank) {
        this.displayDefaultValueAsBlank = isBlank;
    }

    @Override
    public boolean isValueClearedForNonSelectedModalChoiceGroup() {
        return this.clearValueInModalChoiceGroup;
    }

    @Override
    public void setValueClearedForNonSelectedModalChoiceGroup(boolean value) {
        this.clearValueInModalChoiceGroup = value;
    }

    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        Map map;
        String hp;
        super.consumeAttributes(provider);
        this.setPromptID(provider.consumeAttr("promptId"));
        this.setPromptName(provider.consumeAttr("name"));
        this.setHidden(provider.consumeBooleanAttr("hidden", false));
        this.setStickyDefaultAllowed(provider.consumeBooleanAttr("stickyDefault", false));
        this.setFixed(provider.consumeBooleanAttr("fixed", false));
        this.setMacroVariableOutputLevel(provider.consumeIntAttr("macroVarOutputLevel", 1));
        this.setDisplayDefaultValueAsBlank(provider.consumeBooleanAttr("displayDefaultValueAsBlank", false));
        this.setValueClearedForNonSelectedModalChoiceGroup(provider.consumeBooleanAttr("valueClearedForNonSelectedModalChoiceGroup", true));
        String lp = provider.consumeAttr("labelPlacement");
        if (lp != null) {
            this.setLabelPlacement(LabelPlacement.valueOf(lp));
        }
        if ((hp = provider.consumeAttr("hintPlacement")) != null) {
            this.setHintPlacement(HintPlacement.valueOf(hp));
        }
        this.getLogger2().debug("consumeAttributes ran for ", this.getPromptName());
        PromptsReadingContext prContext = provider.getReadingContext();
        if (null != prContext && null != prContext.getOptionsMap() && (map = prContext.getOptionsMap()).containsKey("com.sas.uiconfig.ApplicationContext")) {
            this.setApplicationContext((ApplicationContext)map.get("com.sas.uiconfig.ApplicationContext"));
        }
    }

    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList uiConfigList;
        ArrayList scriptList;
        ArrayList list0;
        ArrayList msgList;
        ArrayList attrDependencyList;
        ArrayList promptDefList;
        ArrayList list3;
        super.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("DefaultValue");
        this.consumeDefaultValue(list);
        ArrayList list2 = roHolder.consumeObjects("Label");
        if (!list2.isEmpty()) {
            Iterator iter = list2.iterator();
            this.getLogger2().debug("consumeRelObjects, setPromptLabel() on", this.getPromptName());
            while (iter.hasNext()) {
                LocalizedText text = (LocalizedText)iter.next();
                this.setPromptLabel(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, setting label to:", text.getText());
            }
        }
        if (!(list3 = roHolder.consumeObjects("Description")).isEmpty()) {
            Iterator iter = list3.iterator();
            this.getLogger2().debug("consumeRelObjects, setPromptDescrp() on", this.getPromptName());
            while (iter.hasNext()) {
                LocalizedText text = (LocalizedText)iter.next();
                this.setPromptDescription(text.getText(), text.getLocale());
                this.getLogger2().debug("consumeRelObjects, setting descrip to:", text.getText());
            }
        }
        ArrayList hints = roHolder.consumeObjects("Hint");
        for (LocalizedText text : hints) {
            if (null != text) {
                this.setHint(text.getText(), text.getLocale());
            }
            this.getLogger2().debug("consumeRelObjects, setHint() on ", this.getPromptName());
        }
        ArrayList inlineHints = roHolder.consumeObjects("InlineHint");
        for (LocalizedText text : inlineHints) {
            if (null != text) {
                this.setInlineHint(text.getText(), text.getLocale());
            }
            this.getLogger2().debug("consumeRelObjects, setInlineHint() on ", this.getPromptName());
        }
        ArrayList userInfoList = roHolder.consumeObjects("UserInfo");
        Map map = MapText.convertMapTextListToMap((List)userInfoList);
        if (map != null) {
            this.mutableUserInfo = new UserInfo(map);
        }
        if ((promptDefList = roHolder.consumeObjects("AdditionalCascades")).size() != 0) {
            this.setAdditionalCascadeDependencies(promptDefList);
            this.getLogger2().debug("consumeRelObjects, setAdditionalCascadeDependencies() has size:", Integer.toString(this.getAdditionalCascadeDependencies().size()));
        }
        if ((attrDependencyList = roHolder.consumeObjects("AttributeDependencies")).size() != 0) {
            this.setDependentPromptsForAttributes(attrDependencyList);
            this.getLogger2().debug("consumeRelObjects, setDependentPromptsForAttributes() has size:", Integer.toString(attrDependencyList.size()));
        }
        if (!(msgList = roHolder.consumeObjects("CustomErrorMessage")).isEmpty()) {
            LocalizablePersistableString ls;
            this.customErrorMessage = ls = (LocalizablePersistableString)msgList.get(0);
            this.getLogger2().debug("consumeRelObjects, set a custom error message.");
        }
        if (!(list0 = roHolder.consumeObjects("PromptHelp")).isEmpty()) {
            Iterator iter = list0.iterator();
            this.getLogger2().debug("consumeRelObjects, setPromptHelp() on", this.getPromptName());
            while (iter.hasNext()) {
                PromptHelp ph = (PromptHelp)iter.next();
                this.setPromptHelp(ph);
                this.getLogger2().debug("consumeRelObjects, setting label to:", ph.toString());
            }
        }
        if (!(scriptList = roHolder.consumeObjects("Scripts")).isEmpty()) {
            for (ScriptHolder holder : scriptList) {
                this.setScript(holder);
            }
            this.getLogger2().debug("consumeRelObjects, set some scripts.");
        }
        if (!(uiConfigList = roHolder.consumeObjects("UIConfig")).isEmpty()) {
            for (UIConfigurationInterface tempUIConfig : uiConfigList) {
                this.setUIConfiguration(tempUIConfig);
            }
            this.getLogger2().debug("consumeRelObjects, set ui config");
        }
    }

    @SASScope
    protected void consumeDefaultValue(List list) {
        if (!list.isEmpty()) {
            BasePersistedValue value = (BasePersistedValue)list.get(0);
            Object obj = value.getValue();
            this.setDefaultValue(obj);
        }
    }

    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        Object deps;
        Object scripts;
        Map localizations;
        Locale locale = PromptConfigurationFactory.getLocaleOption(context);
        if (options.containsKey("localizations") && (localizations = (Map)options.get("localizations")) != null) {
            Set entries = localizations.entrySet();
            for (Map.Entry entry : entries) {
                Locale l;
                Set entries2;
                Object value;
                if (entry.getKey() == null) continue;
                if ("label".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value instanceof Map) {
                        entries2 = ((Map)value).entrySet();
                        for (Map.Entry entry2 : entries2) {
                            l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                            this.setPromptLabel((String)entry2.getValue(), l);
                        }
                        continue;
                    }
                    if (!(value instanceof LocalizableString)) continue;
                    this.setPromptLabels((LocalizableString)value);
                    continue;
                }
                if ("description".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value instanceof Map) {
                        entries2 = ((Map)value).entrySet();
                        for (Map.Entry entry2 : entries2) {
                            l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                            this.setPromptDescription((String)entry2.getValue(), l);
                        }
                        continue;
                    }
                    if (!(value instanceof LocalizableString)) continue;
                    this.setPromptDescriptions((LocalizableString)value);
                    continue;
                }
                if ("hint".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value instanceof Map) {
                        entries2 = ((Map)value).entrySet();
                        for (Map.Entry entry2 : entries2) {
                            l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                            this.setHint((String)entry2.getValue(), l);
                        }
                        continue;
                    }
                    if (!(value instanceof LocalizableString)) continue;
                    this.setHints((LocalizableString)value);
                    continue;
                }
                if ("inlineHint".equals(entry.getKey())) {
                    value = entry.getValue();
                    if (value instanceof Map) {
                        entries2 = ((Map)value).entrySet();
                        for (Map.Entry entry2 : entries2) {
                            l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                            this.setInlineHint((String)entry2.getValue(), l);
                        }
                        continue;
                    }
                    if (!(value instanceof LocalizableString)) continue;
                    this.setInlineHints((LocalizableString)value);
                    continue;
                }
                if (!"customErrorMessage".equals(entry.getKey())) continue;
                value = entry.getValue();
                if (value instanceof Map) {
                    entries2 = ((Map)value).entrySet();
                    for (Map.Entry entry2 : entries2) {
                        l = XmlUtil.xmlToLocale((String)((String)entry2.getKey()));
                        this.setCustomErrorMessage((String)entry2.getValue(), l);
                    }
                    continue;
                }
                if (!(value instanceof LocalizableString)) continue;
                this.setCustomErrorMessages((LocalizableString)value);
            }
        }
        if (options.containsKey("promptId")) {
            this.setPromptID(PromptConfigurationFactory.getStringOption((String)"promptId", options, context));
        }
        if (options.containsKey("name")) {
            this.setPromptName(PromptConfigurationFactory.getStringOption((String)"name", options, context));
        }
        if (options.containsKey("hidden")) {
            this.setHidden(PromptConfigurationFactory.getBoolOption((String)"hidden", options, context));
        }
        if (options.containsKey("stickyDefault")) {
            this.setStickyDefaultAllowed(PromptConfigurationFactory.getBoolOption((String)"stickyDefault", options, context));
        }
        if (options.containsKey("fixed")) {
            this.setFixed(PromptConfigurationFactory.getBoolOption((String)"fixed", options, context));
        }
        if (options.containsKey("macroVarOutputLevel")) {
            this.setMacroVariableOutputLevel(PromptConfigurationFactory.getIntOption((String)"macroVarOutputLevel", options, context));
        }
        if (options.containsKey("displayDefaultValueAsBlank")) {
            this.setDisplayDefaultValueAsBlank(PromptConfigurationFactory.getBoolOption((String)"displayDefaultValueAsBlank", options, context));
        }
        if (options.containsKey("valueClearedForNonSelectedModalChoiceGroup")) {
            this.setValueClearedForNonSelectedModalChoiceGroup(PromptConfigurationFactory.getBoolOption((String)"valueClearedForNonSelectedModalChoiceGroup", options, context));
        }
        if (options.containsKey("label")) {
            this.setPromptLabel(PromptConfigurationFactory.getStringOption((String)"label", options, context), locale);
        }
        if (options.containsKey("description")) {
            this.setPromptDescription(PromptConfigurationFactory.getStringOption((String)"description", options, context), locale);
        }
        if (options.containsKey("hint")) {
            this.setHint(PromptConfigurationFactory.getStringOption((String)"hint", options, context), locale);
        }
        if (options.containsKey("inlineHint")) {
            this.setInlineHint(PromptConfigurationFactory.getStringOption((String)"inlineHint", options, context), locale);
        }
        if (options.containsKey("UIConfig")) {
            Object uiConfig = options.get("UIConfig");
            if (uiConfig instanceof String) {
                String config = (String)uiConfig;
                this.setUIConfiguration(UIConfigurationFactory.newUIConfiguration(config));
            } else if (uiConfig instanceof UIConfigurationInterface) {
                this.setUIConfiguration((UIConfigurationInterface)uiConfig);
            } else {
                this.setUIConfiguration(null);
            }
        }
        if (options.containsKey("labelPlacement")) {
            String lp = (String)options.get("labelPlacement");
            this.setLabelPlacement(lp != null ? LabelPlacement.valueOf(lp.toUpperCase()) : null);
        }
        if (options.containsKey("hintPlacement")) {
            String hp = (String)options.get("hintPlacement");
            this.setHintPlacement(hp != null ? HintPlacement.valueOf(hp.toUpperCase()) : null);
        }
        if (options.containsKey("defaultValue")) {
            this.setDefaultValue(options.get("defaultValue"));
        }
        if (options.containsKey("UserInfo")) {
            Object info = options.get("UserInfo");
            this.getMutableUserInfo().clear();
            if (info instanceof Map) {
                Map userInfoMap = (Map)info;
                Set entries = userInfoMap.entrySet();
                for (Map.Entry entry : entries) {
                    this.addUserInfo((String)entry.getKey(), (String)entry.getValue());
                }
            }
        }
        if (options.containsKey("scripts") && (scripts = options.get("scripts")) instanceof Collection) {
            Collection scriptCollection = (Collection)scripts;
            for (Map.Entry script : scriptCollection) {
                if (!(script instanceof ScriptHolder)) continue;
                this.setScript((ScriptHolder)((Object)script));
            }
        }
        if (options.containsKey("attributeDependencies") && (deps = options.get("attributeDependencies")) instanceof Collection && !((Collection)deps).isEmpty()) {
            Collection depsCollection = (Collection)deps;
            ArrayList<AttributeDependencyInterface> newAttDeps = new ArrayList<AttributeDependencyInterface>();
            for (Map.Entry attDep : depsCollection) {
                if (!(attDep instanceof AttributeDependencyInterface)) continue;
                newAttDeps.add((AttributeDependencyInterface)((Object)attDep));
            }
            this.setDependentPromptsForAttributes(newAttDeps);
        }
        if (options.containsKey("PromptHelp")) {
            Object promptHelp = options.get("PromptHelp");
            this.setPromptHelp((PromptHelp)promptHelp);
        }
        this.getLogger2().debug("configurePrompt ran for ", this.getPromptID());
    }

    @SASScope
    private List<PersistenceInterface> writeDefaultValue() {
        Object defValue;
        ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>();
        if (this.isDefaultValueSet() && (defValue = this.getDefaultValue()) != null) {
            PersistenceInterface value = ValueUtil.getPersistableValue((Object)defValue);
            if (value == null) {
                this.getLogger2().error("writeDefaultValue(): Unable to get persistable value for " + defValue, "class=" + defValue.getClass().getName());
                this.getLogger2().error("writeDefaultValue(): " + this.getPromptName());
            }
            list.add(value);
        }
        return list;
    }

    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        ArrayList<Object> list0;
        List<PersistenceInterface> list;
        super.writeDefinition(element, writingContext);
        this.getLogger2().debug("Writing to DOM for definition:", this.getPromptName());
        XmlUtil.setAttr((Element)element, (String)"promptId", (String)this.getPromptID());
        XmlUtil.setAttr((Element)element, (String)"name", (String)this.getPromptName());
        XmlUtil.setBooleanAttr((Element)element, (String)"hidden", (boolean)this.isHidden(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"stickyDefault", (boolean)this.isStickyDefaultAllowed(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"fixed", (boolean)this.isFixed(), (boolean)false);
        XmlUtil.setIntAttr((Element)element, (String)"macroVarOutputLevel", (int)this.getMacroVariableOutputLevel(), (int)1);
        XmlUtil.setBooleanAttr((Element)element, (String)"displayDefaultValueAsBlank", (boolean)this.isDisplayDefaultValueAsBlank(), (boolean)false);
        XmlUtil.setBooleanAttr((Element)element, (String)"valueClearedForNonSelectedModalChoiceGroup", (boolean)this.isValueClearedForNonSelectedModalChoiceGroup(), (boolean)true);
        if (null != this.getLabelPlacement()) {
            XmlUtil.setAttr((Element)element, (String)"labelPlacement", (String)this.getLabelPlacement().toString());
        }
        if (null != this.getHintPlacement()) {
            XmlUtil.setAttr((Element)element, (String)"hintPlacement", (String)this.getHintPlacement().toString());
        }
        if (!(list = PersistHelper.getAllText((LocalizableString)this.promptLabel, null)).isEmpty()) {
            this.getLogger2().debug("Writing labels.");
            PromptDefinition.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"Label");
        }
        if (!(list = PersistHelper.getAllText((LocalizableString)this.promptDescription, null)).isEmpty()) {
            this.getLogger2().debug("Writing descriptions.");
            PromptDefinition.writeRelatedObjects((List)list, (Node)element, (PromptsWritingContext)writingContext, (String)"Description");
        }
        if (this.hint != null && !(list = PersistHelper.getAllText((LocalizableString)this.hint, null)).isEmpty()) {
            this.getLogger2().debug("Writing hint.");
            PromptDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"Hint");
        }
        if (this.inlineHint != null && !(list = PersistHelper.getAllText((LocalizableString)this.inlineHint, null)).isEmpty()) {
            this.getLogger2().debug("Writing inline hint.");
            PromptDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"InlineHint");
        }
        if (this.isDefaultValueSet()) {
            this.getLogger2().debug("Writing defaultValue.");
            PromptDefinition.writeRelatedObjects(this.writeDefaultValue(), (Node)element, (PromptsWritingContext)writingContext, (String)"DefaultValue");
        }
        if (null != (list = this.getUserInfoAsText(this.mutableUserInfo)) && !list.isEmpty()) {
            this.getLogger2().debug("Writing userInfo.");
            PromptDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"UserInfo");
        }
        if (!this.getAdditionalCascadeDependencies().isEmpty()) {
            list0 = new ArrayList<Object>();
            list0.addAll(this.getAdditionalCascadeDependencies());
            PromptDefinition.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"AdditionalCascades");
        }
        if (this.getDependentPromptsForAttributes() != null && this.getDependentPromptsForAttributes().size() > 0) {
            list0 = new ArrayList();
            list0.addAll(this.getDependentPromptsForAttributes());
            PromptDefinition.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"AttributeDependencies");
        }
        if (null != this.customErrorMessage) {
            this.getLogger2().debug("writing custom error message");
            list0 = new ArrayList();
            list0.add(this.customErrorMessage);
            PromptDefinition.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"CustomErrorMessage");
        }
        if (null != this.scripts && !this.scripts.isEmpty()) {
            this.getLogger2().debug("writing script holders.");
            list0 = new ArrayList();
            for (ScriptHolder sh : this.scripts.values()) {
                list0.add(sh);
            }
            PromptDefinition.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"Scripts");
        }
        if (this.uiConfig != null) {
            list0 = new ArrayList(1);
            list0.add((PersistenceInterface)this.uiConfig);
            PromptDefinition.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"UIConfig");
        }
        if (this._promptHelp != null) {
            list0 = new ArrayList(1);
            list0.add(this._promptHelp);
            PromptDefinition.writeRelatedObjects(list0, (Node)element, (PromptsWritingContext)writingContext, (String)"PromptHelp");
        }
    }

    protected final List<PersistenceInterface> getUserInfoAsText(MutableUserInfoInterface uii) {
        return PromptUtil.getUserInfoAsText(uii);
    }

    @SASScope
    public Collection getLocales() {
        return this.promptLabel.getLocales();
    }

    @SASScope
    public PropertyList getLocalizableProperties(Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        PropertyList propertyList = new PropertyList();
        this.getLogger2().debug("getLocalizableProperties for prompt", this.getPromptName());
        propertyList.addProperty("Label", this.getPromptLabel(locale));
        propertyList.addProperty("Description", this.getPromptDescription(locale));
        if (null != this.getHint(locale)) {
            this.getLogger2().debug("adding hint to localizableProperties");
            propertyList.addProperty("Hint", this.getHint(locale));
        }
        if (null != this.getInlineHint(locale)) {
            this.getLogger2().debug("adding inline hint to localizableProperties");
            propertyList.addProperty("InlineHint", this.getInlineHint(locale));
        }
        if (this.getCustomErrorMessage(locale).length() > 0) {
            this.getLogger2().debug("adding custom error msg to localizableProperties");
            propertyList.addProperty("CustomErrorMessage", this.getCustomErrorMessage(locale));
        }
        if (null != this.getPromptHelp()) {
            this.getLogger2().debug("adding Prompt help to localizableProperties");
            PropertyList pl = this.getPromptHelp().getLocalizableProperties(locale);
            propertyList.addProperty("PromptHelp", pl);
        }
        return propertyList;
    }

    @SASScope
    public void setLocalizableProperties(Locale locale, PropertyMap map) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        ValidateArg.notNull((Object)map, (String)"property map");
        this.getLogger2().debug("setLocalizableProperties on prompt:", this.getPromptName());
        if (map.containsProperty("Label")) {
            this.setPromptLabel(map.getProperty("Label"), locale);
        }
        if (map.containsProperty("Description")) {
            this.setPromptDescription(map.getProperty("Description"), locale);
        }
        if (map.containsProperty("Hint")) {
            this.setHint(map.getProperty("Hint"), locale);
        }
        if (map.containsProperty("InlineHint")) {
            this.setInlineHint(map.getProperty("InlineHint"), locale);
        }
        if (map.containsProperty("CustomErrorMessage")) {
            this.getLogger2().debug("setting custom error msg from localizableProperties");
            this.setCustomErrorMessage(map.getProperty("CustomErrorMessage"), locale);
        }
        if (null != this.getPromptHelp()) {
            this.getLogger2().debug("setting prompthelp  from localizableProperties");
            this.getPromptHelp().setLocalizableProperties(locale, map);
        }
    }

    public PropertyList getLocalizableProperties() {
        return this.getLocalizableProperties(Locale.getDefault());
    }

    public void setLocalizableProperties(PropertyMap map) {
        this.setLocalizableProperties(Locale.getDefault(), map);
    }

    @SASScope
    public void beginLocalization() {
    }

    @SASScope
    public void endLocalization() {
    }

    public List<?> getAttributeDescriptors(Locale myLocale) {
        Locale locale = null;
        locale = myLocale != null ? myLocale : Locale.getDefault();
        AttributeGroup general = new AttributeGroup("General");
        AttributeGroup hiddenGroup = new AttributeGroup("Hidden");
        hiddenGroup.setVisible(false);
        AttributeGroup presentation = new AttributeGroup("Presentation");
        AttributeGroup value = new AttributeGroup("Value");
        ArrayList<AttributeGroup> attributeList = new ArrayList<AttributeGroup>();
        general.getAttributes().add(new AttributeDescriptor("Label".toLowerCase(), "Label".toLowerCase(), "String", (Object)this.getPromptLabel(locale), null, true, true));
        general.getAttributes().add(new AttributeDescriptor("InlineHint".toLowerCase(), "InlineHint".toLowerCase(), "String", (Object)this.getInlineHint(locale), null, true, true));
        general.getAttributes().add(new AttributeDescriptor("Description".toLowerCase(), "Description".toLowerCase(), "String", (Object)this.getPromptDescription(locale), null, true, true));
        hiddenGroup.getAttributes().add(new AttributeDescriptor("promptId", "promptId", "String", (Object)this.getPromptID(), null, false, false));
        general.getAttributes().add(new AttributeDescriptor("name", "name", "String", (Object)this.getPromptName(), null, true, true));
        general.getAttributes().add(new AttributeDescriptor("hidden", "hidden", "boolean", (Object)this.isHidden(), (Object)false, true, true));
        hiddenGroup.getAttributes().add(new AttributeDescriptor("stickyDefault", "stickyDefault", "boolean", (Object)this.isStickyDefaultAllowed(), (Object)false, true, true));
        general.getAttributes().add(new AttributeDescriptor("fixed", "fixed", "boolean", (Object)this.isFixed(), (Object)false, true, true));
        hiddenGroup.getAttributes().add(new AttributeDescriptor("displayDefaultValueAsBlank", "displayDefaultValueAsBlank", "boolean", (Object)this.isDisplayDefaultValueAsBlank(), (Object)false, true, true));
        hiddenGroup.getAttributes().add(new AttributeDescriptor("valueClearedForNonSelectedModalChoiceGroup", "valueClearedForNonSelectedModalChoiceGroup", "boolean", (Object)this.isValueClearedForNonSelectedModalChoiceGroup(), (Object)true, true, true));
        AttributeDescriptor attribute = new AttributeDescriptor("macroVarOutputLevel", "macroVarOutputLevel", "int", (Object)this.getMacroVariableOutputLevel(), (Object)1, true, true);
        ArrayList<ValueItem> possibleValues = new ArrayList<ValueItem>();
        possibleValues.add(new ValueItem((Object)"outputLevelDetails", (Object)2));
        possibleValues.add(new ValueItem((Object)"outputLevelNoDetails", (Object)1));
        attribute.setPossibleValues(possibleValues);
        hiddenGroup.getAttributes().add(attribute);
        if (this.isDefaultValueSet()) {
            value.getAttributes().add(new AttributeDescriptor("DefaultValue", "DefaultValue", "Object", this.getDefaultValue(), null, true, true));
        }
        String hintString = Character.toLowerCase("Hint".charAt(0)) + "Hint".substring(1);
        general.getAttributes().add(new AttributeDescriptor(hintString, hintString, "String", (Object)this.getHint(locale), null, true, true));
        presentation.getAttributes().add(new AttributeDescriptor("labelPlacement", "labelPlacement", "String", (Object)(this.getLabelPlacement() != null ? this.getLabelPlacement().toString() : null), null, true, true));
        presentation.getAttributes().add(new AttributeDescriptor("hintPlacement", "hintPlacement", "String", (Object)(this.getHintPlacement() != null ? this.getHintPlacement().toString() : null), null, true, true));
        attributeList.add(general);
        attributeList.add(presentation);
        if (!value.getAttributes().isEmpty()) {
            attributeList.add(value);
        }
        attributeList.add(hiddenGroup);
        return attributeList;
    }

    @Override
    public List<AttributeDependencyInterface> getDependentPromptsForAttributes() {
        if (this.attributeDependencies == null) {
            return Collections.emptyList();
        }
        return new CopyOnWriteArrayList<AttributeDependencyInterface>(this.attributeDependencies);
    }

    @Override
    public void setDependentPromptsForAttributes(List<AttributeDependencyInterface> dependencies) {
        this.attributeDependencies = dependencies;
    }

    protected Map<String, String> getConstraints(Locale locale) {
        HashMap<String, String> retVal = new HashMap<String, String>();
        retVal.put("NAME", this.getPromptName());
        retVal.put("LABEL", this.getPromptLabel(locale));
        return retVal;
    }

    @Override
    public String getCustomErrorMessage(Locale locale) {
        String retVal = "";
        if (null != this.customErrorMessage) {
            ValidateArg.notNull((Object)locale, (String)"locale");
            String msg = PromptUtil.getDelegatedText((LocalizableString)this.customErrorMessage, locale, this.getApplicationContext());
            SimpleTemplate2 template = new SimpleTemplate2(msg, this.getConstraints(locale));
            template.setMarker('^');
            retVal = template.format();
        }
        this.getLogger2().debug("getCustomErrorMessage() returns:", retVal);
        return retVal;
    }

    public LocalizableString getCustomErrorMessages() {
        if (this.customErrorMessage != null) {
            try {
                return (LocalizableString)this.customErrorMessage.clone();
            }
            catch (CloneNotSupportedException e) {
                this.getLogger2().error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    @Override
    public void setCustomErrorMessage(String errorMessage, @NotNull Locale locale) {
        ValidateArg.notNull((Object)locale, (String)"locale");
        if (null == this.customErrorMessage) {
            this.customErrorMessage = new LocalizablePersistableString();
        }
        if (null == errorMessage) {
            this.customErrorMessage.clearText(locale);
        }
        this.customErrorMessage.setText(errorMessage, locale);
    }

    public void setCustomErrorMessages(LocalizableString customErrorMessages) {
        this.customErrorMessage = new LocalizablePersistableString(customErrorMessages);
    }

    @Override
    public ScriptHolder getScript(PromptAction promptAction) {
        ValidateArg.notNull((Object)((Object)promptAction), (String)"promptAction");
        if (null == this.scripts) {
            this.scripts = new HashMap<PromptAction, ScriptHolder>();
        }
        return this.scripts.get((Object)promptAction);
    }

    @Override
    public void setScript(ScriptHolder scriptHolder) {
        ValidateArg.notNull((Object)scriptHolder, (String)"scriptHolder");
        ValidateArg.notNull((Object)((Object)scriptHolder.getAction()), (String)"scriptHolder.getAction()");
        ValidateArg.notNull((Object)scriptHolder.getType(), (String)"scriptHolder.getType()");
        if (null == this.scripts) {
            this.scripts = new ConcurrentHashMap<PromptAction, ScriptHolder>();
        }
        this.scripts.put(scriptHolder.getAction(), scriptHolder);
    }

    @Override
    public void removeScript(PromptAction promptAction) {
        if (null != this.scripts) {
            this.scripts.remove((Object)promptAction);
        }
    }

    @Override
    public Collection<ScriptHolder> getScripts() {
        if (null != this.scripts) {
            return Collections.unmodifiableCollection(this.scripts.values());
        }
        return Collections.emptyList();
    }

    @Override
    public UIConfigurationInterface getUIConfiguration() {
        return this.uiConfig;
    }

    @Override
    public void setUIConfiguration(UIConfigurationInterface uiConfig) {
        this.uiConfig = uiConfig;
    }

    @Override
    public String getInlineHint(Locale locale) {
        return PromptUtil.getDelegatedText(this.inlineHint, locale, this.getApplicationContext());
    }

    @Override
    public LocalizableString getInlineHints() {
        try {
            return (LocalizableString)this.inlineHint.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    @Override
    public void setInlineHint(String inlineHint, Locale locale) {
        this.inlineHint.setText(inlineHint, locale);
    }

    @Override
    public void setInlineHints(LocalizableString inlineHint) {
        try {
            this.inlineHint = (LocalizableString)inlineHint.clone();
        }
        catch (CloneNotSupportedException e) {
            this.getLogger2().error(e.getMessage(), (Throwable)e);
        }
    }

    @Override
    public LabelPlacement getLabelPlacement() {
        return this.labelPlacement;
    }

    @Override
    public void setLabelPlacement(LabelPlacement labelPlacement) {
        this.labelPlacement = labelPlacement;
    }

    @Override
    public HintPlacement getHintPlacement() {
        return this.hintPlacement;
    }

    @Override
    public void setHintPlacement(HintPlacement hintPlacement) {
        this.hintPlacement = hintPlacement;
    }

    public String getVersion() {
        String tempVersion = super.getVersion();
        this.getLogger2().debug("super's version is", tempVersion);
        if (this.getUIConfiguration() instanceof BaseUIConfiguration && !((BaseUIConfiguration)this.getUIConfiguration()).getOptions().isEmpty()) {
            tempVersion = "2.2";
        } else if (null != this.getHintPlacement() || null != this.getPromptHelp()) {
            tempVersion = "2.1";
        } else if (!(this.getScripts().isEmpty() && this.getDependentPromptsForAttributes().isEmpty() && this.isValueClearedForNonSelectedModalChoiceGroup())) {
            tempVersion = "2.0";
        } else if (null != this.getUIConfiguration() || null != this.customErrorMessage || !this.getInlineHints().getLocales().isEmpty() || this.isDisplayDefaultValueAsBlank()) {
            tempVersion = "1.1";
        }
        this.getLogger2().debug("version is", tempVersion);
        return tempVersion;
    }

    public final ApplicationContext getApplicationContext() {
        return this.applicationContext;
    }

    public final void setApplicationContext(ApplicationContext applicationContext) {
        this.applicationContext = applicationContext;
        this.getLogger2().debug("setApplicationContext on", this.getPromptName());
    }
}

