/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts.definitions;

import com.sas.codepolicy.SASScope;
import com.sas.datatypes.CollectionType;
import com.sas.datatypes.DataSourceColumnType;
import com.sas.datatypes.DataSourceType;
import com.sas.datatypes.DataTypeInterface;
import com.sas.models.datasources.DataSourceColumnInterface;
import com.sas.models.datasources.DataSourceInterface;
import com.sas.prompts.PromptConfigurationFactory;
import com.sas.prompts.PromptUtil;
import com.sas.prompts.ValidationEntry;
import com.sas.prompts.datatypes.values.BasePersistedValue;
import com.sas.prompts.datatypes.values.ValueUtil;
import com.sas.prompts.definitions.MutableDataSourceColumnDefinitionInterface;
import com.sas.prompts.definitions.PromptDefinition;
import com.sas.prompts.definitions.RB;
import com.sas.prompts.definitions.SelectableDefinitionSupport;
import com.sas.text.Message;
import com.sas.util.AttributeDescriptor;
import com.sas.util.ListFactory;
import com.sas.util.ValueItem;
import com.sas.util.xmlpersist.AttributesProvider;
import com.sas.util.xmlpersist.PersistenceInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.XmlUtil;
import java.text.DecimalFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope(value="ALL")
public class DataSourceColumnDefinition
extends PromptDefinition
implements MutableDataSourceColumnDefinitionInterface {
    public static final String RB_KEY = "DataSourceColumnDefinition.";
    private static final long serialVersionUID = 6895906435577334224L;
    private long allowedDataSourceTypes;
    private long allowedColumnTypes;
    private boolean allowMultipleDataSources;
    private List dataSources;
    private SelectableDefinitionSupport selectableSupport;

    public DataSourceColumnDefinition() {
        this.init();
    }

    public DataSourceColumnDefinition(String promptName) {
        super(promptName);
        this.init();
    }

    private void init() {
        this.allowMultipleDataSources = false;
        this.allowedDataSourceTypes = -1L;
        this.allowedColumnTypes = -1L;
        this.selectableSupport = new SelectableDefinitionSupport(this);
    }

    @Override
    public boolean isRequired() {
        return this.selectableSupport.isRequired();
    }

    @Override
    public boolean validIndividualValue(Object value) {
        long returnValue = this.validateIndividualValue(value);
        return returnValue == 0L;
    }

    @Override
    @SASScope
    public Collection<ValidationEntry> getIndivdualPromptValueValidationErrors(Object value, Locale locale) {
        long returnValue = this.validateIndividualValue(value);
        return this.populateMapWithErrors(null, returnValue, value, false, locale);
    }

    private long validateIndividualValue(Object value) {
        long returnValue = 0L;
        if (value != null && !(value instanceof DataSourceColumnInterface)) {
            returnValue |= 1L;
        } else if (value instanceof DataSourceColumnInterface) {
            DataSourceColumnInterface dsc = (DataSourceColumnInterface)value;
            if (this.dataSources != null && !this.dataSources.isEmpty() && !this.dataSources.contains(dsc.getDataSource())) {
                returnValue |= 0x20000000L;
            }
            if (dsc.getDataSource() == null || !this.isDataSourceTypeAllowed(dsc.getDataSource().getDataSourceType())) {
                returnValue |= 0x40000000L;
            }
            if (!this.isColumnTypeAllowed(dsc.getColumnType())) {
                returnValue |= 0x80000000L;
            }
        }
        return returnValue;
    }

    private long validateValue(Object value) {
        long returnValue = 0L;
        if (value instanceof Object[]) {
            Object[] array = (Object[])value;
            for (int i = 0; i < array.length; ++i) {
                returnValue |= this.validateIndividualValue(array[i]);
            }
        } else if (value instanceof Collection) {
            Collection collection = (Collection)value;
            for (Object element : collection) {
                returnValue |= this.validateIndividualValue(element);
            }
        } else {
            returnValue |= this.validateIndividualValue(value);
        }
        return returnValue;
    }

    private boolean isColumnTypeAllowed(long columnType) {
        if (this.allowedColumnTypes == -1L) {
            return true;
        }
        return (this.allowedColumnTypes & columnType) == columnType;
    }

    @Override
    public boolean isPromptValueValid(Object value, Locale locale) {
        return super.isPromptValueValid(value, locale) && this.selectableSupport.isPromptValueValid(value) && this.validValueForDataSources(value);
    }

    private boolean validValueForDataSources(Object value) {
        if (!this.allowMultipleDataSources && value instanceof Collection) {
            Collection c = (Collection)value;
            DataSourceInterface ds = null;
            for (DataSourceColumnInterface dsc : c) {
                if (ds == null) {
                    ds = dsc.getDataSource();
                    continue;
                }
                if (ds.equals(dsc.getDataSource())) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Collection<ValidationEntry> getPromptValueValidationErrors(Object value, Locale locale) {
        Collection<ValidationEntry> errors = super.getPromptValueValidationErrors(value, locale);
        errors = PromptUtil.addErrors(errors, this.selectableSupport.getPromptValueValidationErrors(value, locale));
        long returnValue = 0L;
        if (!this.validValueForDataSources(value)) {
            returnValue |= 0x100000000L;
            errors = PromptUtil.addError(errors, 0x100000000L, RB.getStringResource(RB_KEY, "multipleDataSourcesNotAllowedForValue.txt"));
        }
        if (returnValue == 0L) {
            returnValue = this.validateValue(value);
            errors = this.populateMapWithErrors(errors, returnValue, value, false, locale);
        }
        if (null == errors) {
            errors = Collections.emptyList();
        }
        return errors;
    }

    @Override
    public Collection<ValidationEntry> validateDefinition(Locale locale) {
        Collection<ValidationEntry> errors = super.validateDefinition(locale);
        Object dv = this.isDefaultValueSet() ? this.getDefaultValue() : null;
        errors = PromptUtil.addErrors(errors, this.selectableSupport.validateDefinition(dv, locale));
        long returnValue = 0L;
        if (this.dataSources != null && !this.dataSources.isEmpty()) {
            for (DataSourceInterface dataSource : this.dataSources) {
                if (this.isDataSourceTypeAllowed(dataSource.getDataSourceType())) continue;
                returnValue |= 0x40000000L;
                errors = PromptUtil.addError(errors, 0x40000000L, RB.getStringResource(RB_KEY, "dataSourcesContainsDisallowedType.txt"));
            }
        }
        if (returnValue == 0L && !this.validValueForDataSources(dv)) {
            returnValue |= 0x100000000L;
            errors = PromptUtil.addError(errors, 0x100000000L, RB.getStringResource(RB_KEY, "multipleDataSourcesNotAllowedForDefaultValue.txt"));
        }
        if (returnValue == 0L) {
            returnValue = this.validateValue(dv);
            errors = this.populateMapWithErrors(errors, returnValue, dv, true, locale);
        }
        return errors;
    }

    private Collection<ValidationEntry> populateMapWithErrors(Collection<ValidationEntry> errors, long errorCode, Object value, boolean defaultValue, Locale locale) {
        if ((errorCode & 1L) == 1L) {
            errors = defaultValue ? PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueNotADataSourceColumn.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 1L, Message.format((String)RB.getStringResource(RB_KEY, "notADataSourceColumn.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 0x20000000L) == 0x20000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x20000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueContainsUnavailableDataSource.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x20000000L, Message.format((String)RB.getStringResource(RB_KEY, "containsUnavailableDataSource.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 0x40000000L) == 0x40000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x40000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueContainsDisallowedDataSourceType.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x40000000L, Message.format((String)RB.getStringResource(RB_KEY, "containsDisallowedDataSourceType.fmt.txt", locale), (Object)value));
        }
        if ((errorCode & 0x80000000L) == 0x80000000L) {
            errors = defaultValue ? PromptUtil.addError(errors, 0x80000000L, Message.format((String)RB.getStringResource(RB_KEY, "defaultValueContainsDisallowedColumnType.fmt.txt", locale), (Object)value)) : PromptUtil.addError(errors, 0x80000000L, Message.format((String)RB.getStringResource(RB_KEY, "containsDisallowedColumnType.fmt.txt", locale), (Object)value));
        }
        return errors;
    }

    @Override
    public DataTypeInterface getPromptDataType() {
        if (this.getSelectionType() == 300) {
            return DataSourceColumnType.DEFAULT_INSTANCE;
        }
        return CollectionType.DEFAULT_INSTANCE_DATASOURCECOLUMN;
    }

    @Override
    public long getAllowedDataSourceTypes() {
        return this.allowedDataSourceTypes;
    }

    @Override
    public void setAllowedDataSourceTypes(long allowedDataSourceTypes) {
        this.allowedDataSourceTypes = allowedDataSourceTypes;
    }

    public boolean isDataSourceTypeAllowed(long dataSourceType) {
        if (dataSourceType == 8L || dataSourceType == 2L) {
            return false;
        }
        if (this.allowedDataSourceTypes == -1L) {
            return true;
        }
        return (this.allowedDataSourceTypes & dataSourceType) == dataSourceType;
    }

    @Override
    public List getDataSources() {
        if (this.dataSources != null) {
            return ListFactory.newList((Collection)this.dataSources);
        }
        return this.dataSources;
    }

    @Override
    public void setDataSources(List dataSources) {
        this.dataSources = dataSources != null ? ListFactory.newList((Collection)dataSources) : null;
    }

    @Override
    @SASScope
    public DataSourceInterface getDataSource() {
        if (this.dataSources != null && this.getDataSources().size() != 0) {
            return (DataSourceInterface)this.getDataSources().get(0);
        }
        return null;
    }

    @Override
    @SASScope
    public void setDataSource(DataSourceInterface dataSource) {
        List list = ListFactory.newList((int)1);
        if (dataSource != null) {
            list.add(dataSource);
        }
        this.setDataSources(list);
    }

    @Override
    public long getAllowedColumnTypes() {
        return this.allowedColumnTypes;
    }

    @Override
    public void setAllowedColumnTypes(long allowedColumnTypes) {
        this.allowedColumnTypes = allowedColumnTypes;
    }

    @Override
    public void setAllowMultipleDataSources(boolean allowMultipleDataSources) {
        this.allowMultipleDataSources = allowMultipleDataSources;
    }

    @Override
    public boolean isAllowMultipleDataSources() {
        return this.allowMultipleDataSources;
    }

    @Override
    public int getMaximumValueCount() {
        return this.selectableSupport.getMaximumValueCount();
    }

    @Override
    public int getMinimumValueCount() {
        return this.selectableSupport.getMinimumValueCount();
    }

    @Override
    public int getSelectionType() {
        return this.selectableSupport.getSelectionType();
    }

    @Override
    public boolean isSelectionOrdered() {
        return this.selectableSupport.isSelectionOrdered();
    }

    @Override
    public void setMaximumValueCount(int maximumValueCount) {
        this.selectableSupport.setMaximumValueCount(maximumValueCount);
    }

    @Override
    public void setMinimumValueCount(int minimumValueCount) {
        this.selectableSupport.setMinimumValueCount(minimumValueCount);
    }

    @Override
    public void setSelectionOrdered(boolean selectionOrdered) {
        this.selectableSupport.setSelectionOrdered(selectionOrdered);
    }

    @SASScope
    public int getMacroVariableListFormat() {
        return this.selectableSupport.getMacroVariableListFormat();
    }

    @SASScope
    public String getMacroVariableQuote() {
        return this.selectableSupport.getMacroVariableQuote();
    }

    @SASScope
    public String getMacroVariableListDelimiter() {
        return this.selectableSupport.getMacroVariableListDelimiter();
    }

    @SASScope
    public void setMacroVariableListFormat(int listFormat) {
        this.selectableSupport.setMacroVariableListFormat(listFormat);
    }

    @SASScope
    public void setMacroVariableQuote(String quote) {
        this.selectableSupport.setMacroVariableQuote(quote);
    }

    @SASScope
    public void setMacroVariableListDelimiter(String delimiter) {
        this.selectableSupport.setMacroVariableListDelimiter(delimiter);
    }

    @Override
    @SASScope
    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        super.consumeRelatedObjects(roHolder);
        this.selectableSupport.consumeRelatedObjects(roHolder);
        ArrayList list = roHolder.consumeObjects("DataSources");
        if (!list.isEmpty()) {
            this.getLogger2().debug("consumeRelObjects, setDataSources() ");
            List newDataSourceList = ListFactory.newList((int)list.size());
            for (BasePersistedValue value : list) {
                newDataSourceList.add(value.getValue());
            }
            this.setDataSources(newDataSourceList);
        }
    }

    @Override
    @SASScope
    public void consumeAttributes(AttributesProvider provider) {
        super.consumeAttributes(provider);
        this.setAllowMultipleDataSources(provider.consumeBooleanAttr("allowMultipleDataSources", false));
        this.setAllowedDataSourceTypes(provider.consumeLongAttr("allowedDataSources", new Long(-1L)));
        this.setAllowedColumnTypes(provider.consumeLongAttr("allowedColumnTypes", new Long(-1L)));
        this.selectableSupport.consumeAttributes(provider);
    }

    @Override
    @SASScope
    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        super.writeDefinition(element, writingContext);
        XmlUtil.setBooleanAttr((Element)element, (String)"allowMultipleDataSources", (boolean)this.isAllowMultipleDataSources(), (boolean)false);
        XmlUtil.setLongAttr((Element)element, (String)"allowedDataSources", (long)this.getAllowedDataSourceTypes(), (long)-1L);
        XmlUtil.setLongAttr((Element)element, (String)"allowedColumnTypes", (long)this.getAllowedColumnTypes(), (long)-1L);
        this.selectableSupport.writeDefinition(element, writingContext);
        if (this.dataSources != null && !this.dataSources.isEmpty()) {
            ArrayList<PersistenceInterface> list = new ArrayList<PersistenceInterface>(this.dataSources.size());
            for (DataSourceInterface ds : this.dataSources) {
                list.add(ValueUtil.getPersistableValue((Object)ds));
            }
            this.getLogger2().debug("Writing data sources element.");
            DataSourceColumnDefinition.writeRelatedObjects(list, (Node)element, (PromptsWritingContext)writingContext, (String)"DataSources");
        }
    }

    @SASScope
    public String getDefinitionElementName() {
        return "DataSourceColumnDefinition";
    }

    @Override
    public void configureAttributes(Map<String, ?> options, Map<String, ?> context) {
        Iterator iterator;
        this.selectableSupport.configurePrompt(this, options, context);
        super.configureAttributes(options, context);
        if (options.containsKey("allowMultipleDataSources")) {
            this.setAllowMultipleDataSources(PromptConfigurationFactory.getBoolOption((String)"allowMultipleDataSources", options, context));
        }
        if (options.containsKey("allowedDataSourceTypes")) {
            long allowedDataSources = 0L;
            Collection allowedDataSourcesList = (Collection)PromptConfigurationFactory.getIntCollectionOption((String)"allowedDataSourceTypes", options, context);
            iterator = allowedDataSourcesList.iterator();
            while (iterator.hasNext()) {
                allowedDataSources |= (long)((Integer)iterator.next()).intValue();
            }
            this.setAllowedDataSourceTypes(allowedDataSources);
        }
        if (options.containsKey("allowedColumnTypes")) {
            long allowedColumnTypes1 = 0L;
            Collection allowedColumnTypesList = (Collection)PromptConfigurationFactory.getIntCollectionOption((String)"allowedColumnTypes", options, context);
            iterator = allowedColumnTypesList.iterator();
            while (iterator.hasNext()) {
                allowedColumnTypes1 |= (long)((Integer)iterator.next()).intValue();
            }
            this.setAllowedColumnTypes(allowedColumnTypes1);
        }
        if (options.containsKey("dataSources")) {
            Object value = options.get("dataSources");
            ArrayList<Object> list = new ArrayList<Object>();
            if (value instanceof Collection) {
                Collection col = (Collection)value;
                for (Object object : col) {
                    list.add(DataSourceType.DEFAULT_INSTANCE.coerceValue(object, Locale.US));
                }
            } else {
                list.add(DataSourceType.DEFAULT_INSTANCE.coerceValue(value, Locale.US));
            }
            this.setDataSources(list);
        }
    }

    public List getAttributeDescriptors(Locale locale) {
        List<?> attributeList = super.getAttributeDescriptors(locale);
        if (attributeList == null) {
            attributeList = new ArrayList();
        }
        if (locale == null) {
            locale = Locale.getDefault();
        }
        AttributeDescriptor typeAttribute = new AttributeDescriptor("promptType", "promptType", "String", (Object)this.getDefinitionElementName(), null, false, false);
        typeAttribute.setVisible(false);
        attributeList.add(typeAttribute);
        ArrayList<Long> allowedDataSources = new ArrayList<Long>();
        if ((this.getAllowedDataSourceTypes() & 4L) > 0L) {
            allowedDataSources.add(4L);
        }
        if ((this.getAllowedDataSourceTypes() & 1L) > 0L) {
            allowedDataSources.add(1L);
        }
        AttributeDescriptor allowedDataSourceTypesAttribute = new AttributeDescriptor("allowedDataSourceTypes", "allowedDataSourceTypes", "int", allowedDataSources, null, true, true);
        ArrayList<ValueItem> possibleValues = new ArrayList<ValueItem>();
        possibleValues.add(new ValueItem((Object)"Information Map", (Object)4L));
        possibleValues.add(new ValueItem((Object)"Table", (Object)1L));
        allowedDataSourceTypesAttribute.setPossibleValues(possibleValues);
        allowedDataSourceTypesAttribute.setMultiSelect(true);
        attributeList.add(allowedDataSourceTypesAttribute);
        ArrayList<Long> allowedColumnTypes = new ArrayList<Long>();
        if ((this.getAllowedColumnTypes() & 1L) > 0L) {
            allowedColumnTypes.add(1L);
        }
        if ((this.getAllowedColumnTypes() & 2L) > 0L) {
            allowedColumnTypes.add(2L);
        }
        if ((this.getAllowedColumnTypes() & 4L) > 0L) {
            allowedColumnTypes.add(4L);
        }
        if ((this.getAllowedColumnTypes() & 8L) > 0L) {
            allowedColumnTypes.add(8L);
        }
        if ((this.getAllowedColumnTypes() & 0x10L) > 0L) {
            allowedColumnTypes.add(16L);
        }
        AttributeDescriptor allowedColumnTypesAttribute = new AttributeDescriptor("allowedColumnTypes", "allowedColumnTypes", "int", allowedColumnTypes, null, true, true);
        ArrayList<ValueItem> possibleColumnTypeValues = new ArrayList<ValueItem>();
        possibleColumnTypeValues.add(new ValueItem((Object)"Character", (Object)1L));
        possibleColumnTypeValues.add(new ValueItem((Object)"Numeric", (Object)2L));
        possibleColumnTypeValues.add(new ValueItem((Object)"Date", (Object)4L));
        possibleColumnTypeValues.add(new ValueItem((Object)"Time", (Object)8L));
        possibleColumnTypeValues.add(new ValueItem((Object)"Timestamp", (Object)16L));
        allowedColumnTypesAttribute.setPossibleValues(possibleColumnTypeValues);
        allowedColumnTypesAttribute.setMultiSelect(true);
        attributeList.add(allowedColumnTypesAttribute);
        attributeList.addAll(this.selectableSupport.getAttributeDescriptors(locale));
        return attributeList;
    }

    @Override
    protected Map<String, String> getConstraints(Locale locale) {
        NumberFormat numFormat = DecimalFormat.getInstance(locale);
        Map<String, String> retVal = super.getConstraints(locale);
        this.selectableSupport.addConstraints(retVal, numFormat);
        return retVal;
    }

    public boolean validIndividualValue(Object value, Locale locale) {
        return this.selectableSupport.validIndividualValue(value, locale);
    }
}

