/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.PromptDefinitionReference;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import com.sas.util.xmlpersist.PromptsWritingContext;
import com.sas.util.xmlpersist.RelatedObjectListsHolder;
import com.sas.util.xmlpersist.impl.AbstractPersistence;
import java.util.ArrayList;
import java.util.prefs.BackingStoreException;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.SAXException;

@SASScope
public class PromptDefinitionCombination
extends AbstractPersistence {
    private PromptDefinitionInterface promptDef1;
    private PromptDefinitionInterface promptDef2;
    private static final long serialVersionUID = 8054931539012249385L;

    public PromptDefinitionCombination() {
    }

    public PromptDefinitionCombination(PromptDefinitionInterface promptDef1, PromptDefinitionInterface promptDef2) {
        this.promptDef1 = promptDef1;
        this.promptDef2 = promptDef2;
    }

    public boolean isCombinedWith(PromptDefinitionInterface promptDef) {
        return promptDef == this.promptDef1 || promptDef == this.promptDef2;
    }

    public PromptDefinitionInterface getOtherDefinition(PromptDefinitionInterface promptDef) {
        if (promptDef == this.promptDef1) {
            return this.promptDef2;
        }
        if (promptDef == this.promptDef2) {
            return this.promptDef1;
        }
        throw new IllegalArgumentException("Specified prompt definition was not found");
    }

    public boolean equals(Object otherObject) {
        if (!(otherObject instanceof PromptDefinitionCombination)) {
            return false;
        }
        PromptDefinitionCombination otherCombination = (PromptDefinitionCombination)((Object)otherObject);
        return this.promptDef1 == otherCombination.promptDef1 && this.promptDef2 == otherCombination.promptDef2 || this.promptDef1 == otherCombination.promptDef2 && this.promptDef2 == otherCombination.promptDef1;
    }

    public String getDefinitionElementName() {
        return "PromptDefinitionCombination";
    }

    public void consumeRelatedObjects(RelatedObjectListsHolder roHolder) throws SAXException {
        ArrayList targetDefinitionReferenceList;
        super.consumeRelatedObjects(roHolder);
        ArrayList sourceDefinitionReferenceList = roHolder.consumeObjects("Source");
        if (sourceDefinitionReferenceList != null && sourceDefinitionReferenceList.size() > 0) {
            PromptDefinitionReference sourceDefinitionRef = (PromptDefinitionReference)((Object)sourceDefinitionReferenceList.get(0));
            this.promptDef1 = sourceDefinitionRef.getPromptDefinition();
        }
        if ((targetDefinitionReferenceList = roHolder.consumeObjects("Target")) != null && targetDefinitionReferenceList.size() > 0) {
            PromptDefinitionReference targetDefinitionRef = (PromptDefinitionReference)((Object)targetDefinitionReferenceList.get(0));
            this.promptDef2 = targetDefinitionRef.getPromptDefinition();
        }
    }

    protected void writeDefinition(Element element, PromptsWritingContext writingContext) throws BackingStoreException {
        PromptDefinitionReference ref;
        ArrayList<PromptDefinitionReference> referenceList;
        super.writeDefinition(element, writingContext);
        if (this.promptDef1 != null) {
            referenceList = new ArrayList<PromptDefinitionReference>(1);
            ref = new PromptDefinitionReference(this.promptDef1, "DO_NOT_PERSIST_VALUE");
            referenceList.add(ref);
            PromptDefinitionCombination.writeRelatedObjects(referenceList, (Node)element, (PromptsWritingContext)writingContext, (String)"Source");
        }
        if (this.promptDef2 != null) {
            referenceList = new ArrayList(1);
            ref = new PromptDefinitionReference(this.promptDef2, "DO_NOT_PERSIST_VALUE");
            referenceList.add(ref);
            PromptDefinitionCombination.writeRelatedObjects(referenceList, (Node)element, (PromptsWritingContext)writingContext, (String)"Target");
        }
    }
}

