/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.DataProviderInterface;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.PromptUserContextInterface;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.PromptViewInterface;
import com.sas.prompts.groups.PromptGroupInterface;
import com.sas.storage.olap.MetadataInterface;
import com.sas.util.ListFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;

@SASScope(value="ALL")
public class DynamicPromptValueContext
implements DynamicPromptValueContextInterface {
    private PromptValuesInterface promptValues;
    private PromptGroupInterface promptGroup;
    private PromptUserContextInterface promptUserContext;
    private Map dependencyMap;
    private Collection dependentMap;
    private DataProviderInterface dataProvider;
    private MetadataInterface metadata;

    public DynamicPromptValueContext(MetadataInterface metadata) {
        this.metadata = metadata;
    }

    public DynamicPromptValueContext(PromptValuesInterface promptValues, PromptGroupInterface promptGroup, PromptUserContextInterface promptUserContext, DataProviderInterface dataProvider) {
        this.promptValues = promptValues;
        this.promptGroup = promptGroup;
        this.promptUserContext = promptUserContext;
        this.dataProvider = dataProvider;
    }

    public DynamicPromptValueContext(PromptValuesInterface promptValues, PromptGroupInterface promptGroup, PromptUserContextInterface promptUserContext) {
        this(promptValues, promptGroup, promptUserContext, null);
    }

    @Override
    public PromptValuesInterface getPromptValues() {
        return this.promptValues;
    }

    @Override
    public PromptGroupInterface getPromptGroup() {
        return this.promptGroup;
    }

    @Override
    public PromptUserContextInterface getPromptUserContext() {
        return this.promptUserContext;
    }

    @Override
    public DataProviderInterface getDataProvider() {
        return this.dataProvider;
    }

    @Override
    @SASScope
    public Collection getDependentPromptViews(PromptViewInterface promptView) {
        Collection dep = (Collection)this.getDependencyMapNotNull().get(promptView);
        if (dep == null) {
            return new ArrayList();
        }
        return dep;
    }

    @Override
    @SASScope
    public boolean hasDependent(PromptViewInterface promptView) {
        return this.dependentMap.contains(promptView);
    }

    @Override
    @SASScope
    public boolean isValueSetForAllDependentPromptViews(PromptViewInterface promptView) {
        Collection dependentViews = this.getDependentPromptViews(promptView);
        if (dependentViews != null) {
            for (PromptViewInterface view : dependentViews) {
                if (view.getPromptValue() != null) continue;
                return false;
            }
        }
        return true;
    }

    @SASScope
    public void add(PromptViewInterface view, Collection dep) {
        this.dependencyMap = this.getDependencyMapNotNull();
        ArrayList item = (ArrayList)this.dependencyMap.get(view);
        if (item == null) {
            item = new ArrayList();
            this.dependencyMap.put(view, item);
        }
        this.dependentMap = this.getDependetMapNotNull();
        for (Object obj : dep) {
            if (this.dependentMap.contains(obj)) continue;
            this.dependentMap.add(obj);
        }
        item.addAll(dep);
    }

    private Map getDependencyMapNotNull() {
        if (this.dependencyMap == null) {
            this.dependencyMap = new HashMap();
        }
        return this.dependencyMap;
    }

    private Collection getDependetMapNotNull() {
        if (this.dependentMap == null) {
            this.dependentMap = ListFactory.newList();
        }
        return this.dependentMap;
    }

    public MetadataInterface getMetadata() {
        return this.metadata;
    }
}

