/*
 * Decompiled with CFR 0.152.
 */
package com.sas.prompts;

import com.sas.codepolicy.SASScope;
import com.sas.prompts.DynamicPromptValueContextInterface;
import com.sas.prompts.InvalidPromptValueException;
import com.sas.prompts.PromptComponentModelInterface;
import com.sas.prompts.PromptValueChangeEventInterface;
import com.sas.prompts.PromptValueChangeListener;
import com.sas.prompts.PromptValueNotFoundException;
import com.sas.prompts.PromptValueViewChangeEvent;
import com.sas.prompts.PromptValuesInterface;
import com.sas.prompts.definitions.PromptDefinitionInterface;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Locale;
import javax.swing.event.EventListenerList;

@SASScope
public class DefaultPromptComponentModel
implements PromptComponentModelInterface {
    private PromptDefinitionInterface _promptDefinition;
    private PromptValuesInterface _persistentValueStore;
    private Collection _promptViewFilterExpressions;
    private Locale _locale;
    private DynamicPromptValueContextInterface _dynamicValueContext;
    private PromptValueChangeListener listener;
    private EventListenerList listenerList = new EventListenerList();

    public DefaultPromptComponentModel(PromptDefinitionInterface prompt, PromptValuesInterface persistentValueStore, Locale locale) {
        this(prompt, persistentValueStore, null, locale);
    }

    public DefaultPromptComponentModel(PromptDefinitionInterface prompt, PromptValuesInterface persistentValueStore, DynamicPromptValueContextInterface dynamicValueContext, Locale locale) {
        this._promptDefinition = prompt;
        this._persistentValueStore = persistentValueStore;
        this._locale = locale;
        this._dynamicValueContext = dynamicValueContext;
        this.listener = new PromptValueChangeListener(){

            @Override
            public void promptValueChanged(PromptValueChangeEventInterface event) {
                if (event.getPromptDefinition() == DefaultPromptComponentModel.this._promptDefinition) {
                    DefaultPromptComponentModel.this.firePromptValueChanged(event.getOldValue(), event.getNewValue());
                }
            }
        };
        this._persistentValueStore.addPromptValueChangeListener(this.listener);
    }

    @Override
    public Locale getLocale() {
        return this._locale;
    }

    protected void initialize() throws Exception {
        Object persistentValue = this.getPersistentValue();
        if (persistentValue != null) {
            // empty if block
        }
    }

    protected Object getPersistentValue() {
        try {
            if (this.getPromptValues() == null) {
                return null;
            }
            return this.getPromptValues().getPromptValue(this.getPromptDefinition());
        }
        catch (PromptValueNotFoundException pe) {
            return null;
        }
    }

    protected PromptValuesInterface getPromptValues() {
        return this._persistentValueStore;
    }

    @Override
    public PromptDefinitionInterface getPromptDefinition() {
        return this._promptDefinition;
    }

    @Override
    public Object getPromptValue() {
        try {
            Object value;
            if (this.getPromptValues().isPromptValueAvailable(this.getPromptDefinition()) && (value = this.getPromptValues().getPromptValue(this.getPromptDefinition())) != null) {
                return value;
            }
        }
        catch (PromptValueNotFoundException promptValueNotFoundException) {
            // empty catch block
        }
        return null;
    }

    @Override
    public void resetToDefaultValues() throws InvalidPromptValueException {
        PromptDefinitionInterface promptDef = this.getPromptDefinition();
        this.getPromptValues().clearPromptValue(promptDef);
    }

    @Override
    public void setPromptValue(Object value) throws InvalidPromptValueException {
        this.getPromptValues().setPromptValue(this.getPromptDefinition(), value, this.getLocale());
    }

    @Override
    public void clearPromptValue() {
        this.getPromptValues().clearPromptValue(this.getPromptDefinition());
    }

    @Override
    public String getPromptValueAsString() {
        if (this.getPromptValues() != null && this.getPromptValues().isPromptValueAvailable(this.getPromptDefinition())) {
            try {
                return this.getPromptValues().getPromptValueAsString(this.getPromptDefinition(), this.getLocale());
            }
            catch (PromptValueNotFoundException e) {
                return null;
            }
        }
        return null;
    }

    @Override
    public DynamicPromptValueContextInterface getDynamicPromptValuesContext() {
        return this._dynamicValueContext;
    }

    public void setDynamicPromptValuesContext(DynamicPromptValueContextInterface context) {
        this._dynamicValueContext = context;
    }

    @Override
    public Collection getPromptViewFilterExpressions() {
        if (this._promptViewFilterExpressions == null) {
            this._promptViewFilterExpressions = new ArrayList();
        }
        return this._promptViewFilterExpressions;
    }

    public void setPromptViewFilterList(Collection filterList) {
        this._promptViewFilterExpressions = filterList;
    }

    @Override
    public boolean isPromptValueAvailable() {
        if (this.getPromptValues() != null) {
            return this.getPromptValues().isPromptValueAvailable(this.getPromptDefinition());
        }
        return false;
    }

    @Override
    public void addPromptValueChangeListener(PromptValueChangeListener listener) {
        this.listenerList.add(PromptValueChangeListener.class, listener);
    }

    @Override
    public void removePromptValueChangeListener(PromptValueChangeListener listener) {
        this.listenerList.remove(PromptValueChangeListener.class, listener);
    }

    private void firePromptValueChanged(Object oldValue, Object newValue) {
        Object[] listeners = this.listenerList.getListenerList();
        PromptValueViewChangeEvent event = new PromptValueViewChangeEvent(this, oldValue, newValue);
        for (int i = listeners.length - 2; i >= 0; i -= 2) {
            if (listeners[i] != PromptValueChangeListener.class) continue;
            ((PromptValueChangeListener)listeners[i + 1]).promptValueChanged(event);
        }
    }
}

