/*
 * Decompiled with CFR 0.152.
 */
package com.sas.deploymntreg;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.io.StringReader;
import java.nio.channels.FileLock;
import java.util.LinkedList;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class Database {
    private static FileInputStream registryFIS = null;
    private static FileOutputStream registryFOS = null;
    private static final String KEY = "Key";
    private static final String VALUE = "Value";
    private static final String VERSION = "version";
    private static final String NAME = "name";
    private static final String DATA = "data";
    private static File registryFile = null;
    private static String xslContent = null;
    private static RandomAccessFile raf = null;
    private static FileLock lock = null;
    private static Document doc = null;
    private static Element root = null;
    private static boolean locked = false;
    private static boolean writable = false;
    private static boolean modified = false;

    private static LinkedList getElements(Node parent, String type) {
        LinkedList<Node> list = new LinkedList<Node>();
        if (parent != null) {
            NodeList children = parent.getChildNodes();
            int length = children.getLength();
            for (int i = 0; i < length; ++i) {
                if (!children.item(i).getNodeName().equals(type)) continue;
                list.add(children.item(i));
            }
        }
        return list;
    }

    private static String[] getElementsAsStrings(String key, String type) {
        Element parent = Database.getKeyElement(root, key, false);
        LinkedList children = Database.getElements(parent, type);
        String[] list = new String[children.size()];
        int length = children.size();
        for (int i = 0; i < length; ++i) {
            list[i] = ((Element)children.get(i)).getAttribute(NAME);
        }
        return list;
    }

    private static Element getElement(Node parent, String name, String type) {
        Element current = null;
        if (parent != null && name != null) {
            if (parent instanceof Document) {
                current = ((Document)parent).getDocumentElement();
            } else {
                LinkedList children = Database.getElements(parent, type);
                int length = children.size();
                for (int i = 0; current == null && i < length; ++i) {
                    if (!((Element)children.get(i)).getAttribute(NAME).equals(name)) continue;
                    current = (Element)children.get(i);
                }
            }
        }
        return current;
    }

    private static Element getKeyElement(Element parent, String key, boolean create) {
        Element current = null;
        Element retVal = parent;
        if (key.trim().length() != 0) {
            String name = key;
            int index = name.indexOf("/");
            if (index > 0) {
                name = name.substring(0, index);
            }
            current = parent != null ? Database.getElement(parent, name, KEY) : Database.getElement(doc, name, KEY);
            if (create && writable && current == null) {
                current = doc.createElement(KEY);
                current.setAttribute(NAME, name);
                try {
                    if (parent != null) {
                        parent.appendChild(current);
                    } else {
                        doc.appendChild(current);
                    }
                    modified = true;
                }
                catch (Exception e) {
                    current = null;
                }
            }
            retVal = current != null && index > 0 ? Database.getKeyElement(current, key.substring(index + 1, key.length()), create) : current;
        }
        return retVal;
    }

    private static boolean lock(File lockFile) {
        if (!locked) {
            try {
                if (lockFile == null) {
                    writable = true;
                    locked = true;
                } else {
                    if (!lockFile.isFile()) {
                        lockFile.createNewFile();
                    }
                    if (lockFile.canWrite()) {
                        raf = new RandomAccessFile(lockFile, "rw");
                        lock = raf.getChannel().lock(0L, Long.MAX_VALUE, false);
                    } else if (lockFile.canRead()) {
                        raf = new RandomAccessFile(lockFile, "r");
                        lock = raf.getChannel().lock(0L, Long.MAX_VALUE, true);
                    }
                    if (lock != null) {
                        writable = lockFile.canWrite();
                        locked = true;
                    }
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return locked;
    }

    private static boolean unlock() {
        boolean retVal = false;
        if (locked) {
            try {
                if (lock != null) {
                    lock.release();
                    raf.close();
                    lock = null;
                }
                locked = false;
                writable = false;
                retVal = true;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        return retVal;
    }

    public static boolean open(String rootName, String defaultVersion, String registryFilename, String lockFilename) {
        boolean retVal = false;
        if (!(locked || rootName == null || registryFilename == null || defaultVersion == null || rootName.trim().equals("") || registryFilename.trim().equals(""))) {
            Database.lock(new File(lockFilename));
            if (locked) {
                try {
                    registryFile = new File(registryFilename);
                    if (!registryFile.isFile()) {
                        if (registryFile.createNewFile() && (doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().newDocument()) != null) {
                            root = doc.createElement(rootName);
                            doc.appendChild(root);
                            root.setAttribute(VERSION, defaultVersion);
                            modified = true;
                            retVal = true;
                        }
                    } else {
                        if (registryFIS != null) {
                            registryFIS.close();
                            registryFIS = null;
                        }
                        registryFIS = new FileInputStream(registryFile);
                        doc = DocumentBuilderFactory.newInstance().newDocumentBuilder().parse(new FileInputStream(registryFile));
                        root = doc.getDocumentElement();
                        if (root.getNodeName().equals(rootName)) {
                            retVal = true;
                        }
                    }
                }
                catch (Exception e) {
                    System.err.println(e);
                }
                if (retVal) {
                    if (writable) {
                        writable = registryFile.canWrite();
                    }
                } else {
                    doc = null;
                    root = null;
                    Database.unlock();
                }
            }
        }
        return retVal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean close(boolean write) {
        boolean retVal = false;
        if (locked) {
            Transformer transformer = null;
            try {
                if (write && modified) {
                    if (xslContent == null) {
                        xslContent = Database.getXlsContent();
                    }
                    StreamSource source = new StreamSource(new StringReader(xslContent));
                    transformer = TransformerFactory.newInstance().newTransformer(source);
                    if (registryFIS != null) {
                        registryFIS.close();
                        registryFIS = null;
                    }
                    registryFOS = new FileOutputStream(registryFile);
                    transformer.transform(new DOMSource(doc), new StreamResult(registryFOS));
                }
            }
            catch (Exception e) {
                System.err.println(e);
            }
            finally {
                modified = false;
                doc = null;
                root = null;
                retVal = Database.unlock();
                if (registryFOS != null) {
                    try {
                        registryFOS.close();
                        registryFOS = null;
                    }
                    catch (IOException iOException) {}
                }
            }
        }
        return retVal;
    }

    private static String getXlsContent() {
        String newLine = System.getProperty("line.separator");
        return String.join((CharSequence)newLine, "<?xml version=\"1.0\" ?>", "<xsl:stylesheet xmlns:xsl=\"http://www.w3.org/1999/XSL/Transform\" version=\"1.0\">", "<xsl:output omit-xml-declaration=\"yes\" indent=\"yes\" />", "<xsl:template match=\"node()|SDLT\">", "<xsl:if test=\"count(descendant::text()[string-length(normalize-space(.))>0] | @*[string-length(.)>0])\">", "<xsl:copy>", "<xsl:apply-templates select=\"@*|node()\" />", "</xsl:copy>", "</xsl:if>", "</xsl:template>", "<xsl:template match=\"@*\">", "<xsl:copy />", "</xsl:template>", "<xsl:template match=\"text()\">", "<xsl:value-of select=\"normalize-space(.)\" />", "</xsl:template>", "</xsl:stylesheet>");
    }

    public static boolean createKey(String key) {
        boolean retVal = false;
        if (locked && writable) {
            retVal = Database.getKeyElement(root, key, true) != null;
        }
        return retVal;
    }

    public static boolean moveKey(String sourceKey, String targetKey) {
        Element source;
        boolean retVal = false;
        if (locked && writable && (source = Database.getKeyElement(root, sourceKey, false)) != null) {
            Element target;
            Node sourceParent = source.getParentNode();
            if (sourceParent.removeChild(source) != null && (target = Database.getKeyElement(root, targetKey, true)) != null) {
                source.setAttribute(NAME, target.getAttribute(NAME));
                Node targetParent = target.getParentNode();
                boolean bl = retVal = targetParent.replaceChild(source, target) != null;
            }
            if (retVal) {
                modified = true;
            }
        }
        return retVal;
    }

    public static boolean deleteKey(String key) {
        boolean retVal = false;
        if (locked && writable) {
            Element child = null;
            if (key != null && !key.trim().equals("") && (child = Database.getKeyElement(root, key, false)) != null) {
                Node parent = child.getParentNode();
                boolean bl = retVal = parent.removeChild(child) != null;
                if (retVal) {
                    modified = true;
                }
            }
        }
        return retVal;
    }

    public static boolean setValue(String key, String name, String data) {
        boolean retVal = false;
        if (locked && writable && name != null && data != null) {
            Element parent = Database.getKeyElement(root, key, true);
            Element oldNode = Database.getElement(parent, name, VALUE);
            Element entry = doc.createElement(VALUE);
            entry.setAttribute(NAME, name);
            entry.setAttribute(DATA, data);
            if (oldNode != null) {
                retVal = parent.replaceChild(entry, oldNode) != null;
            } else {
                boolean bl = retVal = parent.appendChild(entry) != null;
            }
            if (retVal) {
                modified = true;
            }
        }
        return retVal;
    }

    public static boolean deleteValue(String key, String name) {
        Element parent;
        Element child;
        boolean retVal = false;
        if (locked && writable && name != null && (child = Database.getElement(parent = Database.getKeyElement(root, key, false), name, VALUE)) != null) {
            boolean bl = retVal = parent.removeChild(child) != null;
            if (retVal) {
                modified = true;
            }
        }
        return retVal;
    }

    public static String getValue(String key, String name) {
        String retVal = null;
        if (locked) {
            Element parent = Database.getKeyElement(root, key, false);
            Element child = Database.getElement(parent, name, VALUE);
            retVal = child == null ? null : child.getAttribute(DATA);
        }
        return retVal;
    }

    public static String[] enumKey(String key) {
        String[] retVal = null;
        if (locked) {
            retVal = Database.getElementsAsStrings(key, KEY);
        }
        return retVal;
    }

    public static String[] enumValue(String key) {
        String[] retVal = null;
        if (locked) {
            retVal = Database.getElementsAsStrings(key, VALUE);
        }
        return retVal;
    }

    public static boolean setVersion(String version) {
        boolean retVal = false;
        if (locked && writable) {
            doc.getDocumentElement().setAttribute(VERSION, version);
            retVal = true;
        }
        return retVal;
    }

    public static String getVersion() {
        String retVal = null;
        if (locked) {
            retVal = doc.getDocumentElement().getAttribute(VERSION);
        }
        return retVal;
    }
}

