/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.security.wss4j;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.validate.UsernameTokenValidator;
import org.apache.xml.security.utils.XMLUtils;

public class SASUsernameTokenValidator
extends UsernameTokenValidator {
    private static final Logger LOG = LogManager.getLogger(SASUsernameTokenValidator.class);

    protected void verifyPlaintextPassword(UsernameToken usernameToken, RequestData data) throws WSSecurityException {
        if (data.getCallbackHandler() == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noCallback");
        }
        String user = usernameToken.getName();
        String password = usernameToken.getPassword();
        String nonce = usernameToken.getNonce();
        String createdTime = usernameToken.getCreated();
        String pwType = usernameToken.getPasswordType();
        boolean passwordsAreEncoded = usernameToken.getPasswordsAreEncoded();
        WSPasswordCallback pwCb = new WSPasswordCallback(user, password, pwType, 2);
        try {
            data.getCallbackHandler().handle(new Callback[]{pwCb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            LOG.debug(e.getMessage(), (Throwable)e);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION, e);
        }
        String origPassword = pwCb.getPassword();
        if (origPassword == null) {
            LOG.warn("Callback supplied no password for: {}", (Object)user);
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
        }
        if (usernameToken.isHashed()) {
            byte[] passDigest;
            byte[] decodedNonce = XMLUtils.decode((String)nonce);
            byte[] decodedPassword = XMLUtils.decode((String)password);
            if (!MessageDigest.isEqual(decodedPassword, passDigest = passwordsAreEncoded ? UsernameTokenUtil.doRawPasswordDigest((byte[])decodedNonce, (String)createdTime, (byte[])XMLUtils.decode((String)origPassword)) : UsernameTokenUtil.doRawPasswordDigest((byte[])decodedNonce, (String)createdTime, (byte[])origPassword.getBytes(StandardCharsets.UTF_8)))) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
        } else {
            byte[] passwordBytes;
            byte[] origPasswordBytes = origPassword.getBytes(StandardCharsets.UTF_8);
            if (!MessageDigest.isEqual(origPasswordBytes, passwordBytes = password.getBytes(StandardCharsets.UTF_8))) {
                throw new WSSecurityException(WSSecurityException.ErrorCode.FAILED_AUTHENTICATION);
            }
        }
    }
}

