/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.security.wss4j;

import com.sas.services.session.SessionServiceInterface;
import com.sas.services.user.UserContextInterface;
import com.sas.svcs.authentication.client.AuthenticationServiceInterface;
import java.io.IOException;
import java.net.URISyntaxException;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.ServiceProperties;
import org.springframework.security.cas.authentication.CasAuthenticationProvider;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.wss4j2.callback.AbstractWsPasswordCallbackHandler;
import org.springframework.ws.transport.context.TransportContextHolder;

public abstract class SASTokenValidationCallbackHandlerBase
extends AbstractWsPasswordCallbackHandler
implements InitializingBean {
    private static final Logger logger = LogManager.getLogger(SASTokenValidationCallbackHandlerBase.class);
    @Autowired
    @Qualifier(value="statelessTicketCache")
    protected CasAuthenticationProvider authProvider;

    public void setSessionService(SessionServiceInterface s) {
    }

    public void setSecuredUser(UserContextInterface u) {
    }

    public void setAuthenticationService(AuthenticationServiceInterface authenticationService) {
    }

    public void afterPropertiesSet() throws Exception {
    }

    protected void handleCleanup(CleanupCallback callback) throws IOException, UnsupportedCallbackException {
        logger.debug("Unlocking Session Context");
        this.disconnect();
    }

    protected void checkTokenExpiry(String key) {
        String serviceUrl = null;
        try {
            serviceUrl = TransportContextHolder.getTransportContext().getConnection().getUri().toString();
        }
        catch (URISyntaxException e) {
            throw new RuntimeException("Unexpected exception obtaining URI for current soap request while processing WS-Security", e);
        }
        UsernamePasswordAuthenticationToken authRequest = new UsernamePasswordAuthenticationToken((Object)"_cas_stateless_", (Object)key);
        ServiceProperties serviceProperties = new ServiceProperties();
        serviceProperties.setService(serviceUrl);
        this.authProvider.setServiceProperties(serviceProperties);
        Authentication authentication = this.authProvider.authenticate((Authentication)authRequest);
        SecurityContextImpl securityContext = new SecurityContextImpl();
        securityContext.setAuthentication(authentication);
        SecurityContextHolder.setContext((SecurityContext)securityContext);
    }

    protected boolean reconnect(String key) {
        logger.debug("reconnect in " + SASTokenValidationCallbackHandlerBase.class.getName() + " for ticket " + key);
        return true;
    }

    protected void disconnect() {
        logger.debug("disconnect in " + SASTokenValidationCallbackHandlerBase.class.getName());
    }
}

