/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.security.wss4j;

import com.sas.svcs.commons.webservice.impl.security.SsoClientHolder;
import com.sas.svcs.config.client.UrlGeneratorInterface;
import com.sas.svcs.security.authentication.client.AuthenticationClient;
import java.io.IOException;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.jasig.cas.client.validation.Assertion;
import org.jasig.cas.client.validation.AssertionImpl;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.security.authentication.UsernamePasswordAuthenticationToken;
import org.springframework.security.cas.authentication.CasAuthenticationToken;
import org.springframework.security.core.Authentication;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.security.core.context.SecurityContextImpl;
import org.springframework.security.core.userdetails.AuthenticationUserDetailsService;
import org.springframework.security.core.userdetails.UserDetails;
import org.springframework.util.Assert;
import org.springframework.ws.soap.security.callback.CleanupCallback;
import org.springframework.ws.soap.security.wss4j2.callback.AbstractWsPasswordCallbackHandler;
import org.springframework.ws.transport.context.TransportContextHolder;

@Deprecated
public class SASPlainTextUsernameTokenValidationCallbackHandler
extends AbstractWsPasswordCallbackHandler
implements InitializingBean {
    @Autowired
    protected UrlGeneratorInterface urlGenerator;
    @Autowired
    protected AuthenticationUserDetailsService<Authentication> authenticationUserDetailsService;
    String logonUrl;
    private static final Logger logger = LogManager.getLogger(SASPlainTextUsernameTokenValidationCallbackHandler.class);

    public void afterPropertiesSet() throws Exception {
        Assert.notNull((Object)this.urlGenerator, (String)"urlGenerator is required");
        Assert.notNull(this.authenticationUserDetailsService, (String)"authenticationUserDetailsService is required");
        this.logonUrl = this.urlGenerator.generateInternalUrl("Logon Manager 9.4", "", "");
    }

    protected void handleUsernameToken(WSPasswordCallback callback) throws IOException, UnsupportedCallbackException {
        String username = callback.getIdentifier();
        String password = callback.getPassword();
        if (logger.isDebugEnabled()) {
            logger.debug("logon user");
        }
        try {
            String serviceUrl = TransportContextHolder.getTransportContext().getConnection().getUri().toString();
            AuthenticationClient ssoClient = new AuthenticationClient(this.logonUrl);
            ssoClient.logon(username, password);
            SsoClientHolder.set(ssoClient);
            String ticket = ssoClient.acquireTicket(serviceUrl);
            UsernamePasswordAuthenticationToken preAuthToken = new UsernamePasswordAuthenticationToken((Object)username, (Object)"");
            UserDetails userDetails = this.authenticationUserDetailsService.loadUserDetails((Authentication)preAuthToken);
            CasAuthenticationToken authToken = new CasAuthenticationToken("/UsernameTokenSoapInterceptor", (Object)userDetails, (Object)ticket, userDetails.getAuthorities(), userDetails, (Assertion)new AssertionImpl(username));
            SecurityContextImpl securityContext = new SecurityContextImpl();
            securityContext.setAuthentication((Authentication)authToken);
            SecurityContextHolder.setContext((SecurityContext)securityContext);
        }
        catch (Exception e) {
            throw new IOException("Failed");
        }
        if (logger.isDebugEnabled()) {
            logger.debug("login successful");
        }
    }

    protected void handleCleanup(CleanupCallback callback) throws IOException, UnsupportedCallbackException {
        AuthenticationClient ssoClient = SsoClientHolder.get();
        if (null != ssoClient) {
            try {
                ssoClient.logout();
            }
            catch (Exception e) {
                logger.error("Exception occurred during security cleanup.", (Throwable)e);
            }
            SsoClientHolder.clear();
        }
        SecurityContextHolder.clearContext();
    }
}

