/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.mapping;

import java.util.Iterator;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMResult;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.soap.SoapHeader;
import org.springframework.ws.soap.SoapHeaderElement;
import org.springframework.ws.soap.SoapMessage;
import org.springframework.ws.soap.server.endpoint.mapping.SoapActionEndpointMapping;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WsAddressingActionHeaderEndpointMapping
extends SoapActionEndpointMapping {
    private static final String WS_ADDRESSING_NS = "http://schemas.xmlsoap.org/ws/2004/08/addressing";
    private static final String WS_ADDRESSING_ACTION_ELEMENT = "Action";
    private DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
    private TransformerFactory transformerFactory = TransformerFactory.newInstance();

    public WsAddressingActionHeaderEndpointMapping() {
        this.docBuilderFactory.setValidating(false);
        this.docBuilderFactory.setNamespaceAware(true);
    }

    protected String getLookupKeyForMessage(MessageContext messageContext) throws Exception {
        if (messageContext.getRequest() instanceof SoapMessage) {
            SoapMessage request = (SoapMessage)messageContext.getRequest();
            SoapHeader header = request.getSoapHeader();
            if (null != header) {
                String actionHeader = this.getActionHeader(header);
                return actionHeader;
            }
            return null;
        }
        return null;
    }

    private String getActionHeader(SoapHeader header) throws ParserConfigurationException, TransformerException {
        Iterator iter = header.examineAllHeaderElements();
        while (iter.hasNext()) {
            SoapHeaderElement headerElement = (SoapHeaderElement)iter.next();
            Source source = headerElement.getSource();
            Document doc = this.docBuilderFactory.newDocumentBuilder().newDocument();
            DOMResult domResult = new DOMResult(doc);
            this.transformerFactory.newTransformer().transform(source, domResult);
            NodeList nodeList = doc.getElementsByTagNameNS(WS_ADDRESSING_NS, WS_ADDRESSING_ACTION_ELEMENT);
            if (nodeList == null || nodeList.getLength() != 1) continue;
            Node node = nodeList.item(0);
            NodeList children = node.getChildNodes();
            for (int i = 0; i < children.getLength(); ++i) {
                Node child = children.item(i);
                if (child.getNodeType() != 3) continue;
                return child.getNodeValue();
            }
        }
        return null;
    }
}

