/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.endpoint;

import java.io.IOException;
import java.util.ArrayList;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.support.MarshallingUtils;
import org.springframework.xml.transform.TransformerObjectSupport;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public abstract class AbstractMarshallingSplitPayloadEndpoint
extends TransformerObjectSupport
implements MessageEndpoint {
    private static final Logger logger = LogManager.getLogger(AbstractMarshallingSplitPayloadEndpoint.class);
    private DocumentBuilderFactory documentBuilderFactory;
    private boolean validating = false;
    private boolean namespaceAware = true;
    private Marshaller marshaller;
    private Unmarshaller[] unmarshallers;
    private String encInElem;
    private String encOutElem;
    private String statefulElem;

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    public void setMarshaller(Marshaller marshaller) {
        this.marshaller = marshaller;
    }

    public void setUnmarshallers(Unmarshaller[] unmarshallers) {
        this.unmarshallers = unmarshallers;
    }

    public void setUnmarshaller(Unmarshaller unmarshaller) {
        this.setUnmarshallers(new Unmarshaller[]{unmarshaller});
    }

    public void setEncInElem(String encInElem) {
        this.encInElem = encInElem;
    }

    public void setEncOutElem(String encOutElem) {
        this.encOutElem = encOutElem;
    }

    public void setStatefulElem(String statefulElem) {
        this.statefulElem = statefulElem;
    }

    public void invoke(MessageContext messageContext) throws Exception {
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setValidating(this.validating);
            this.documentBuilderFactory.setNamespaceAware(this.namespaceAware);
        }
        Object[] requestObjects = this.processRequest(messageContext.getRequest());
        Object responseObject = this.invokeInternal(requestObjects);
        this.processResponse(messageContext.getResponse(), responseObject);
    }

    private Object[] processRequest(WebServiceMessage message) throws IOException, ParserConfigurationException, TransformerException {
        Object[] requestObjects;
        if (this.encInElem == null) {
            Object requestObject;
            if (logger.isDebugEnabled()) {
                logger.debug("encInElem is null");
            }
            if ((requestObject = MarshallingUtils.unmarshal((Unmarshaller)this.unmarshallers[0], (WebServiceMessage)message)) != null) {
                requestObjects = new Object[]{requestObject};
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("request object is null");
                }
                requestObjects = new Object[]{};
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("encInElem is NOT null");
            }
            if (message.getPayloadSource() != null) {
                Node child;
                int i;
                Document requestDoc = this.documentBuilderFactory.newDocumentBuilder().newDocument();
                this.transform(message.getPayloadSource(), new DOMResult(requestDoc));
                Node request = requestDoc.getFirstChild();
                NodeList allChildren = request.getChildNodes();
                ArrayList<Node> children = new ArrayList<Node>();
                for (i = 0; i < allChildren.getLength(); ++i) {
                    child = allChildren.item(i);
                    if (child instanceof Text) continue;
                    children.add(child);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("number of children in request: " + children.size());
                }
                requestObjects = new Object[children.size()];
                block1: for (i = 0; i < children.size(); ++i) {
                    child = (Node)children.get(i);
                    if (this.statefulElem != null && i == 0 && new QName(child.getNamespaceURI(), child.getLocalName()).toString().equals(this.statefulElem)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("processing stateful id child");
                        }
                        NodeList childNodes = child.getChildNodes();
                        for (int j = 0; j < childNodes.getLength(); ++j) {
                            Node childNode = childNodes.item(j);
                            if (!(childNode instanceof Text)) continue;
                            requestObjects[i] = ((Text)childNode).getNodeValue();
                            continue block1;
                        }
                        continue;
                    }
                    requestObjects[i] = this.unmarshallers[i].unmarshal((Source)new DOMSource(child));
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("request object is null");
                }
                requestObjects = new Object[]{};
            }
        }
        return requestObjects;
    }

    private void processResponse(WebServiceMessage message, Object responseObject) throws IOException, ParserConfigurationException, TransformerException {
        if (this.encOutElem == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("encOutElem is null");
            }
            if (responseObject != null) {
                MarshallingUtils.marshal((Marshaller)this.marshaller, (Object)responseObject, (WebServiceMessage)message);
            } else if (logger.isDebugEnabled()) {
                logger.debug("response object is null");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("encOutElem is NOT null");
            }
            Document responseDoc = this.documentBuilderFactory.newDocumentBuilder().newDocument();
            QName encElemQName = QName.valueOf(this.encOutElem);
            Element response = responseDoc.createElementNS(encElemQName.getNamespaceURI(), encElemQName.getLocalPart());
            responseDoc.appendChild(response);
            if (responseObject != null) {
                DocumentFragment docFrag = responseDoc.createDocumentFragment();
                this.marshaller.marshal(responseObject, (Result)new DOMResult(docFrag));
                response.appendChild(docFrag);
            } else if (logger.isDebugEnabled()) {
                logger.debug("response object is null");
            }
            this.transform(new DOMSource(responseDoc), message.getPayloadResult());
        }
    }

    protected abstract Object invokeInternal(Object[] var1) throws Exception;
}

