/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.endpoint;

import com.sas.svcs.commons.webservice.impl.endpoint.MessageContextHolder;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPMessage;
import org.springframework.util.Assert;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MessageEndpoint;
import org.springframework.ws.soap.axiom.AxiomSoapMessage;

public abstract class AbstractAxiomEndpoint
implements MessageEndpoint {
    public final void invoke(MessageContext messageContext) throws Exception {
        WebServiceMessage webServiceMessage = messageContext.getRequest();
        Assert.isInstanceOf(AxiomSoapMessage.class, (Object)webServiceMessage);
        AxiomSoapMessage axiomSoapMessage = (AxiomSoapMessage)webServiceMessage;
        MessageContextHolder.setMessageContext(messageContext);
        OMElement payloadElement = this.getPayloadElement(axiomSoapMessage);
        OMElement responseElement = this.invokeInternal(payloadElement);
        if (responseElement != null) {
            axiomSoapMessage = (AxiomSoapMessage)messageContext.getResponse();
            this.setPayloadElement(axiomSoapMessage, responseElement);
        }
    }

    protected abstract OMElement invokeInternal(OMElement var1) throws Exception;

    private OMElement getPayloadElement(AxiomSoapMessage axiomSoapMessage) {
        SOAPMessage axiomMessage = axiomSoapMessage.getAxiomMessage();
        return axiomMessage.getSOAPEnvelope().getBody().getFirstElement();
    }

    private void setPayloadElement(AxiomSoapMessage axiomSoapMessage, OMElement responseElement) {
        SOAPMessage axiomMessage = axiomSoapMessage.getAxiomMessage();
        axiomMessage.getSOAPEnvelope().getBody().addChild((OMNode)responseElement);
    }
}

