/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.commons.webservice.impl.adapter;

import com.sas.svcs.commons.webservice.impl.annotation.RequestSchemaElement;
import com.sas.svcs.commons.webservice.impl.annotation.ResponseSchemaElement;
import com.sas.svcs.commons.webservice.impl.annotation.StatefulSchemaElement;
import com.sas.svcs.commons.webservice.impl.annotation.SupportAttachment;
import com.sas.svcs.commons.webservice.util.SASMarshallingUtils;
import java.io.IOException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.ArrayList;
import javax.xml.bind.attachment.AttachmentMarshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Result;
import javax.xml.transform.Source;
import javax.xml.transform.TransformerException;
import javax.xml.transform.dom.DOMResult;
import javax.xml.transform.dom.DOMSource;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.oxm.GenericMarshaller;
import org.springframework.oxm.GenericUnmarshaller;
import org.springframework.oxm.Marshaller;
import org.springframework.oxm.Unmarshaller;
import org.springframework.util.StringUtils;
import org.springframework.ws.WebServiceMessage;
import org.springframework.ws.context.MessageContext;
import org.springframework.ws.server.endpoint.MethodEndpoint;
import org.springframework.ws.server.endpoint.adapter.GenericMarshallingMethodEndpointAdapter;
import org.springframework.ws.support.MarshallingUtils;
import org.w3c.dom.Document;
import org.w3c.dom.DocumentFragment;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class GenericMarshallingSplitPayloadMethodEndpointAdapter
extends GenericMarshallingMethodEndpointAdapter {
    private static final Logger logger = LogManager.getLogger(GenericMarshallingSplitPayloadMethodEndpointAdapter.class);
    private DocumentBuilderFactory documentBuilderFactory;
    private boolean validating = false;
    private boolean namespaceAware = true;

    public GenericMarshallingSplitPayloadMethodEndpointAdapter(Marshaller marshaller) {
        super(marshaller);
    }

    public void setValidating(boolean validating) {
        this.validating = validating;
    }

    public void setNamespaceAware(boolean namespaceAware) {
        this.namespaceAware = namespaceAware;
    }

    protected boolean supportsInternal(MethodEndpoint methodEndpoint) {
        boolean supportAttachment = false;
        Method method = methodEndpoint.getMethod();
        if (method.getAnnotation(SupportAttachment.class) != null) {
            supportAttachment = true;
        }
        if (supportAttachment && !(this.getMarshaller() instanceof AttachmentMarshaller)) {
            return false;
        }
        return this.supportsSplitPayload(methodEndpoint);
    }

    protected boolean supportsSplitPayload(MethodEndpoint methodEndpoint) {
        Method method = methodEndpoint.getMethod();
        return this.supportsReturnType(method) && this.supportsParameters(method);
    }

    private boolean supportsReturnType(Method method) {
        if (Void.TYPE.equals(method.getReturnType())) {
            return true;
        }
        if (this.getMarshaller() instanceof GenericMarshaller) {
            return ((GenericMarshaller)this.getMarshaller()).supports(method.getGenericReturnType());
        }
        return this.getMarshaller().supports(method.getReturnType());
    }

    private boolean supportsParameters(Method method) {
        String statefulElem = null;
        StatefulSchemaElement reqStatefulElem = method.getAnnotation(StatefulSchemaElement.class);
        if (reqStatefulElem != null && StringUtils.hasText((String)reqStatefulElem.value())) {
            statefulElem = reqStatefulElem.value();
        }
        if (this.getUnmarshaller() instanceof GenericUnmarshaller) {
            GenericUnmarshaller genericUnmarshaller = (GenericUnmarshaller)this.getUnmarshaller();
            int i = -1;
            for (Type genericParameterType : method.getGenericParameterTypes()) {
                if (statefulElem != null && ++i == 0 || genericUnmarshaller.supports(genericParameterType)) continue;
                return false;
            }
            return true;
        }
        int i = -1;
        for (Class<?> parameterType : method.getParameterTypes()) {
            if (statefulElem != null && ++i == 0 || this.getUnmarshaller().supports(parameterType)) continue;
            return false;
        }
        return true;
    }

    protected void invokeInternal(MessageContext messageContext, MethodEndpoint methodEndpoint) throws Exception {
        WebServiceMessage request;
        Object[] requestObjects;
        Object responseObject;
        if (this.documentBuilderFactory == null) {
            this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
            this.documentBuilderFactory.setValidating(this.validating);
            this.documentBuilderFactory.setNamespaceAware(this.namespaceAware);
        }
        Method method = methodEndpoint.getMethod();
        String encInElem = null;
        RequestSchemaElement reqElem = method.getAnnotation(RequestSchemaElement.class);
        if (reqElem != null && StringUtils.hasText((String)reqElem.value())) {
            encInElem = reqElem.value();
        }
        String statefulElem = null;
        StatefulSchemaElement reqStatefulElem = method.getAnnotation(StatefulSchemaElement.class);
        if (reqStatefulElem != null && StringUtils.hasText((String)reqStatefulElem.value())) {
            statefulElem = reqStatefulElem.value();
        }
        String encOutElem = null;
        ResponseSchemaElement resElem = method.getAnnotation(ResponseSchemaElement.class);
        if (resElem != null && StringUtils.hasText((String)resElem.value())) {
            encOutElem = resElem.value();
        }
        if ((responseObject = methodEndpoint.invoke(requestObjects = this.unmarshalRequest(request = messageContext.getRequest(), encInElem, statefulElem))) != null) {
            WebServiceMessage response = messageContext.getResponse();
            this.marshalResponse(responseObject, response, encOutElem);
        }
    }

    private Object[] unmarshalRequest(WebServiceMessage request, String encInElem, String statefulElem) throws IOException, ParserConfigurationException, TransformerException {
        Object[] requestObjects;
        if (encInElem == null) {
            Object requestObject;
            if (logger.isDebugEnabled()) {
                logger.debug("encInElem is null");
            }
            if ((requestObject = MarshallingUtils.unmarshal((Unmarshaller)this.getUnmarshaller(), (WebServiceMessage)request)) != null) {
                requestObjects = new Object[]{requestObject};
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("request object is null");
                }
                requestObjects = new Object[]{};
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("encInElem is NOT null");
            }
            if (request.getPayloadSource() != null) {
                Node child;
                int i;
                Document requestDoc = this.documentBuilderFactory.newDocumentBuilder().newDocument();
                this.transform(request.getPayloadSource(), new DOMResult(requestDoc));
                NodeList allChildren = requestDoc.getFirstChild().getChildNodes();
                ArrayList<Node> children = new ArrayList<Node>();
                for (i = 0; i < allChildren.getLength(); ++i) {
                    child = allChildren.item(i);
                    if (child instanceof Text) continue;
                    children.add(child);
                }
                if (logger.isDebugEnabled()) {
                    logger.debug("number of children in request: " + children.size());
                }
                requestObjects = new Object[children.size()];
                block1: for (i = 0; i < children.size(); ++i) {
                    child = (Node)children.get(i);
                    if (statefulElem != null && i == 0 && new QName(child.getNamespaceURI(), child.getLocalName()).toString().equals(statefulElem)) {
                        if (logger.isDebugEnabled()) {
                            logger.debug("processing stateful id child");
                        }
                        NodeList childNodes = child.getChildNodes();
                        for (int j = 0; j < childNodes.getLength(); ++j) {
                            Node childNode = childNodes.item(j);
                            if (!(childNode instanceof Text)) continue;
                            requestObjects[i] = ((Text)childNode).getNodeValue();
                            continue block1;
                        }
                        continue;
                    }
                    requestObjects[i] = SASMarshallingUtils.unmarshal((Unmarshaller)this.getUnmarshaller(), (Source)new DOMSource(child), (WebServiceMessage)request);
                }
            } else {
                if (logger.isDebugEnabled()) {
                    logger.debug("request object is null");
                }
                requestObjects = new Object[]{};
            }
        }
        return requestObjects;
    }

    private void marshalResponse(Object responseObject, WebServiceMessage response, String encOutElem) throws IOException, ParserConfigurationException, TransformerException {
        if (encOutElem == null) {
            if (logger.isDebugEnabled()) {
                logger.debug("encOutElem is null");
            }
            if (responseObject != null) {
                MarshallingUtils.marshal((Marshaller)this.getMarshaller(), (Object)responseObject, (WebServiceMessage)response);
            } else if (logger.isDebugEnabled()) {
                logger.debug("response object is null");
            }
        } else {
            if (logger.isDebugEnabled()) {
                logger.debug("encOutElem is NOT null");
            }
            Document responseDoc = this.documentBuilderFactory.newDocumentBuilder().newDocument();
            QName encElemQName = QName.valueOf(encOutElem);
            Element responseElem = responseDoc.createElementNS(encElemQName.getNamespaceURI(), encElemQName.getLocalPart());
            responseDoc.appendChild(responseElem);
            if (responseObject != null) {
                DocumentFragment docFrag = responseDoc.createDocumentFragment();
                SASMarshallingUtils.marshal((Marshaller)this.getMarshaller(), (Object)responseObject, (Result)new DOMResult(docFrag), (WebServiceMessage)response);
                responseElem.appendChild(docFrag);
            } else if (logger.isDebugEnabled()) {
                logger.debug("response object is null");
            }
            this.transform(new DOMSource(responseDoc), response.getPayloadResult());
        }
    }
}

