/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.stateful;

import com.sas.svcs.cluster.balance.StickyRandomPolicy;
import com.sas.svcs.remoting.RemoteInvocationProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.SessionUtils;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceIdHolder;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.remoting.support.RemoteInvocation;

public class ServerRemoteInvocationStatefulServiceURIProcessor
implements RemoteInvocationProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ServerRemoteInvocationStatefulServiceURIProcessor.class);
    private Set<String> deleteStatefulMethodNames = new HashSet<String>(1);

    public void process(RemoteInvocation ri) {
        String uriStr;
        String id;
        String selectedUriStr = (String)((Object)ri.getAttribute("sasStatefulServiceURI"));
        if (selectedUriStr != null) {
            try {
                URI selectedUri = new URI(selectedUriStr);
                if (selectedUri != null) {
                    StickyRandomPolicy.setSelectedURI(selectedUri);
                    if (LOGGER.isDebugEnabled()) {
                        LOGGER.debug("set selected uri: " + selectedUri);
                    }
                }
            }
            catch (URISyntaxException e) {
                LOGGER.error("Syntax error in selected URI: " + selectedUriStr, (Throwable)e);
                throw new RuntimeException("Syntax error in selected URI: " + selectedUriStr, e);
            }
        }
        if ((id = StatefulServiceIdHolder.getId()) == null) {
            id = (String)((Object)ri.getAttribute("sasStatefulServiceId"));
        }
        if (id != null && (uriStr = (String)SessionUtils.getObjectFromSession((String)id)) != null) {
            try {
                URI uri = new URI(uriStr);
                StickyRandomPolicy.setSelectionTarget(uri);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("set selection target uri: " + uri);
                }
            }
            catch (URISyntaxException e) {
                LOGGER.error("Syntax error in URI: " + uriStr, (Throwable)e);
                throw new RuntimeException("Syntax error in selection target URI: " + uriStr, e);
            }
        }
    }

    public void finish(RemoteInvocation ri) {
        StickyRandomPolicy.clearSelectionTarget();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("cleared selection target of StickyRandomPolicy");
        }
        if (this.deleteStatefulMethodNames != null && this.deleteStatefulMethodNames.contains(ri.getMethodName())) {
            String id = StatefulServiceIdHolder.getId();
            if (id == null) {
                id = (String)((Object)ri.getAttribute("sasStatefulServiceId"));
            }
            if (SessionUtils.getObjectFromSession((String)id) != null) {
                SessionUtils.removeObjectFromSession((String)id);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("removed id: " + id);
                }
            }
        }
        StickyRandomPolicy.clearSelectedURI();
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("cleared selected uri of StickyRandomPolicy");
        }
    }

    public void setDeleteStatefulMethodName(String deleteStatefulMethodName) {
        this.deleteStatefulMethodNames.add(deleteStatefulMethodName);
    }

    public void setDeleteStatefulMethodNames(Set<String> deleteStatefulMethodNames) {
        this.deleteStatefulMethodNames = deleteStatefulMethodNames;
    }
}

