/*
 * Decompiled with CFR 0.152.
 */
package com.sas.svcs.cluster.httpinvoker.stateful;

import com.sas.svcs.cluster.balance.StickyRandomPolicy;
import com.sas.svcs.remoting.MutableRemoteInvocationAttributeResult;
import com.sas.svcs.remoting.RemoteInvocationResultProcessor;
import com.sas.svcs.remoting.httpinvoker.stateful.SessionUtils;
import com.sas.svcs.remoting.httpinvoker.stateful.StatefulServiceResultIdHolder;
import java.net.URI;
import java.util.HashSet;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.remoting.support.RemoteInvocation;
import org.springframework.remoting.support.RemoteInvocationResult;

public class ServerRemoteInvocationStatefulServiceResultURIProcessor
implements RemoteInvocationResultProcessor {
    private static final Logger LOGGER = LogManager.getLogger(ServerRemoteInvocationStatefulServiceResultURIProcessor.class);
    private Set<String> returnsStatefulMethodNamesSet = new HashSet<String>(1);

    public void process(RemoteInvocationResult rir) {
        if (rir instanceof MutableRemoteInvocationAttributeResult && this.returnsStatefulMethodNamesSet != null) {
            URI uri;
            String methodName;
            MutableRemoteInvocationAttributeResult riar = (MutableRemoteInvocationAttributeResult)rir;
            RemoteInvocation ri = riar.getRemoteInvocation();
            String string = methodName = ri != null ? ri.getMethodName() : null;
            if (this.returnsStatefulMethodNamesSet.contains(methodName) && (uri = StickyRandomPolicy.getRandomChoice()) != null) {
                StickyRandomPolicy.clearRandomChoice();
                String uriStr = uri.toString();
                String id = StatefulServiceResultIdHolder.getId();
                if (id == null) {
                    id = (String)((Object)riar.getAttribute("sasStatefulServiceResultId"));
                }
                SessionUtils.putObjectInSession((String)id, (Object)uriStr);
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("mapped id to uri: " + id + "=" + uriStr);
                }
            }
        }
    }

    public void setReturnsStatefulMethodName(String returnsStatefulMethodName) {
        this.returnsStatefulMethodNamesSet.add(returnsStatefulMethodName);
    }

    public void setReturnsStatefulMethodNames(Set<String> returnsStatefulMethodNamesSet) {
        this.returnsStatefulMethodNamesSet = returnsStatefulMethodNamesSet;
    }
}

